/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.schedule;

import com.google.inject.Injector;
import com.google.inject.servlet.RequestScoper;
import com.google.inject.servlet.ServletScopes;
import jakarta.inject.Inject;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.fortuna.ical4j.model.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.helper.LogAction;
import org.traccar.model.BaseModel;
import org.traccar.model.Calendar;
import org.traccar.model.Device;
import org.traccar.model.Group;
import org.traccar.model.Report;
import org.traccar.model.User;
import org.traccar.reports.EventsReportProvider;
import org.traccar.reports.RouteReportProvider;
import org.traccar.reports.StopsReportProvider;
import org.traccar.reports.SummaryReportProvider;
import org.traccar.reports.TripsReportProvider;
import org.traccar.reports.common.ReportMailer;
import org.traccar.schedule.SingleScheduleTask;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

public class TaskReports
extends SingleScheduleTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskReports.class);
    private static final long CHECK_PERIOD_MINUTES = 15L;
    private final LogAction actionLogger;
    private final Storage storage;
    private final Injector injector;

    @Inject
    public TaskReports(LogAction actionLogger, Storage storage, Injector injector) {
        this.actionLogger = actionLogger;
        this.storage = storage;
        this.injector = injector;
    }

    @Override
    public void schedule(ScheduledExecutorService executor) {
        executor.scheduleAtFixedRate(this, 15L, 15L, TimeUnit.MINUTES);
    }

    @Override
    public void run() {
        Date currentCheck = new Date();
        Date lastCheck = new Date(System.currentTimeMillis() - TimeUnit.MINUTES.toMillis(15L));
        try {
            for (Report report : this.storage.getObjects(Report.class, new Request(new Columns.All()))) {
                Calendar calendar = this.storage.getObject(Calendar.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", report.getCalendarId())));
                Set<Period<Instant>> lastEvents = calendar.findPeriods(lastCheck);
                Set<Period<Instant>> currentEvents = calendar.findPeriods(currentCheck);
                HashSet<Period<Instant>> finishedEvents = new HashSet<Period<Instant>>(lastEvents);
                finishedEvents.removeAll(currentEvents);
                for (Period period : finishedEvents) {
                    RequestScoper scope = ServletScopes.scopeRequest(Collections.emptyMap());
                    RequestScoper.CloseableScope ignored = scope.open();
                    try {
                        this.executeReport(report, Date.from((Instant)period.getStart()), Date.from((Instant)period.getEnd()));
                    }
                    finally {
                        if (ignored == null) continue;
                        ignored.close();
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Scheduled reports error", (Throwable)e);
        }
    }

    private void executeReport(Report report, Date from, Date to) throws StorageException {
        List<Long> deviceIds = this.storage.getObjects(Device.class, new Request((Columns)new Columns.Include("id"), new Condition.Permission(Device.class, Report.class, report.getId()))).stream().map(BaseModel::getId).collect(Collectors.toList());
        List<Long> groupIds = this.storage.getObjects(Group.class, new Request((Columns)new Columns.Include("id"), new Condition.Permission(Group.class, Report.class, report.getId()))).stream().map(BaseModel::getId).collect(Collectors.toList());
        List<User> users = this.storage.getObjects(User.class, new Request((Columns)new Columns.Include("id"), new Condition.Permission(User.class, Report.class, report.getId())));
        ReportMailer reportMailer = (ReportMailer)this.injector.getInstance(ReportMailer.class);
        block14: for (User user : users) {
            this.actionLogger.report(null, user.getId(), true, report.getType(), from, to, deviceIds, groupIds);
            switch (report.getType()) {
                case "events": {
                    EventsReportProvider eventsReportProvider = (EventsReportProvider)this.injector.getInstance(EventsReportProvider.class);
                    reportMailer.sendAsync(user.getId(), stream -> eventsReportProvider.getExcel(stream, user.getId(), deviceIds, groupIds, List.of(), List.of(), from, to));
                    continue block14;
                }
                case "route": {
                    RouteReportProvider routeReportProvider = (RouteReportProvider)this.injector.getInstance(RouteReportProvider.class);
                    reportMailer.sendAsync(user.getId(), stream -> routeReportProvider.getExcel(stream, user.getId(), deviceIds, groupIds, from, to));
                    continue block14;
                }
                case "summary": {
                    SummaryReportProvider summaryReportProvider = (SummaryReportProvider)this.injector.getInstance(SummaryReportProvider.class);
                    reportMailer.sendAsync(user.getId(), stream -> summaryReportProvider.getExcel(stream, user.getId(), deviceIds, groupIds, from, to, false));
                    continue block14;
                }
                case "trips": {
                    TripsReportProvider tripsReportProvider = (TripsReportProvider)this.injector.getInstance(TripsReportProvider.class);
                    reportMailer.sendAsync(user.getId(), stream -> tripsReportProvider.getExcel(stream, user.getId(), deviceIds, groupIds, from, to));
                    continue block14;
                }
                case "stops": {
                    StopsReportProvider stopsReportProvider = (StopsReportProvider)this.injector.getInstance(StopsReportProvider.class);
                    reportMailer.sendAsync(user.getId(), stream -> stopsReportProvider.getExcel(stream, user.getId(), deviceIds, groupIds, from, to));
                    continue block14;
                }
            }
            LOGGER.warn("Unsupported report type {}", (Object)report.getType());
        }
    }
}

