/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class PacificTrackProtocolDecoder
extends BaseProtocolDecoder {
    public PacificTrackProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    public static int readBitExt(ByteBuf buf) {
        int result = 0;
        while (buf.isReadable()) {
            short b = buf.readUnsignedByte();
            result <<= 7;
            result += BitUtil.to(b, 7);
            if (!BitUtil.check(b, 7)) continue;
            break;
        }
        return result;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.readByte();
        PacificTrackProtocolDecoder.readBitExt(buf);
        PacificTrackProtocolDecoder.readBitExt(buf);
        DeviceSession deviceSession = null;
        Position position = new Position(this.getProtocolName());
        block40: while (buf.isReadable()) {
            int segmentId = PacificTrackProtocolDecoder.readBitExt(buf);
            int segmentEnd = PacificTrackProtocolDecoder.readBitExt(buf) + buf.readerIndex();
            switch (segmentId) {
                case 1: {
                    position.set("event", PacificTrackProtocolDecoder.readBitExt(buf));
                    continue block40;
                }
                case 16: {
                    position.setValid(BitUtil.check(buf.readUnsignedByte(), 4));
                    short date = buf.readUnsignedByte();
                    DateBuilder dateBuilder = new DateBuilder().setDate(2020 + BitUtil.from(date, 4), BitUtil.to(date, 4), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
                    position.setTime(dateBuilder.getDate());
                    position.setLatitude((double)buf.readUnsignedInt() / 1000000.0 - 90.0);
                    position.setLongitude((double)buf.readUnsignedInt() / 1000000.0 - 180.0);
                    int speedAndCourse = buf.readUnsignedMedium();
                    position.setCourse(BitUtil.from(speedAndCourse, 12));
                    position.setSpeed(UnitsConverter.knotsFromKph((double)BitUtil.to(speedAndCourse, 12) * 0.1));
                    position.set("index", buf.readUnsignedShort());
                    continue block40;
                }
                case 32: {
                    int voltage = buf.readUnsignedMedium();
                    position.set("battery", (double)BitUtil.between(voltage, 0, 12) * 0.01);
                    position.set("power", (double)BitUtil.between(voltage, 12, 24) * 0.01);
                    continue block40;
                }
                case 146: {
                    block41: while (buf.readerIndex() < segmentEnd) {
                        short field = buf.readUnsignedByte();
                        int fieldPrefix = BitUtil.from(field, 5);
                        if (fieldPrefix < 4) {
                            switch (BitUtil.between(field, 2, 5)) {
                                case 0: {
                                    position.set("bus", BitUtil.to(field, 2));
                                    break;
                                }
                                case 1: {
                                    position.set("currentGear", BitUtil.to(field, 2));
                                }
                            }
                            continue;
                        }
                        if (fieldPrefix < 5) {
                            switch (BitUtil.to(field, 5)) {
                                case 0: {
                                    position.set("obdSpeed", buf.readUnsignedByte());
                                    continue block41;
                                }
                                case 1: {
                                    position.set("rpm", buf.readUnsignedByte() * 32);
                                    continue block41;
                                }
                                case 3: {
                                    position.set("oilPressure", buf.readUnsignedByte() * 4);
                                    continue block41;
                                }
                                case 4: {
                                    position.set("oilLevel", (double)buf.readUnsignedByte() * 0.4);
                                    continue block41;
                                }
                                case 5: {
                                    position.set("oilTemp", buf.readUnsignedByte() - 40);
                                    continue block41;
                                }
                                case 6: {
                                    position.set("coolantLevel", (double)buf.readUnsignedByte() * 0.4);
                                    continue block41;
                                }
                                case 7: {
                                    position.set("coolantTemp", buf.readUnsignedByte() - 40);
                                    continue block41;
                                }
                                case 8: {
                                    position.set("fuel", (double)buf.readUnsignedByte() * 0.4);
                                    continue block41;
                                }
                                case 9: {
                                    position.set("defLevel", (double)buf.readUnsignedByte() * 0.4);
                                    continue block41;
                                }
                                case 10: {
                                    position.set("engineLoad", buf.readUnsignedByte());
                                    continue block41;
                                }
                                case 11: {
                                    position.set("barometer", (double)buf.readUnsignedByte() * 0.5);
                                    continue block41;
                                }
                                case 12: {
                                    position.set("intakeManifoldTemp", buf.readUnsignedByte() - 40);
                                    continue block41;
                                }
                                case 13: {
                                    position.set("fuelTankTemp", buf.readUnsignedByte() - 40);
                                    continue block41;
                                }
                                case 14: {
                                    position.set("intercoolerTemp", buf.readUnsignedByte() - 40);
                                    continue block41;
                                }
                                case 15: {
                                    position.set("turboOilTemp", buf.readUnsignedByte() - 40);
                                    continue block41;
                                }
                                case 16: {
                                    position.set("transOilTemp", buf.readUnsignedByte() - 40);
                                    continue block41;
                                }
                            }
                            buf.readUnsignedByte();
                            continue;
                        }
                        if (fieldPrefix < 6) {
                            switch (BitUtil.to(field, 5)) {
                                case 2: {
                                    position.set("fuelConsumption", (double)buf.readUnsignedShort() / 512.0);
                                    continue block41;
                                }
                                case 3: {
                                    position.set("temp1", (double)buf.readUnsignedShort() * 0.03125 - 273.0);
                                    continue block41;
                                }
                            }
                            buf.readUnsignedShort();
                            continue;
                        }
                        if (fieldPrefix < 7) {
                            switch (BitUtil.to(field, 5)) {
                                case 0: {
                                    position.set("odometer", buf.readUnsignedInt() * 100L);
                                    continue block41;
                                }
                                case 1: {
                                    position.set("hours", buf.readUnsignedInt() * 180L);
                                    continue block41;
                                }
                                case 2: {
                                    position.set("idleHours", buf.readUnsignedInt() * 180L);
                                    continue block41;
                                }
                                case 4: {
                                    position.set("fuelUsed", (double)buf.readUnsignedInt() * 0.5);
                                    continue block41;
                                }
                                case 5: {
                                    position.set("fuelUsedIdle", (double)buf.readUnsignedInt() * 0.5);
                                    continue block41;
                                }
                            }
                            buf.readUnsignedInt();
                            continue;
                        }
                        buf.skipBytes((int)buf.readUnsignedByte());
                    }
                    continue block40;
                }
                case 256: {
                    String imei = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8)).substring(0, 15);
                    deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
                    continue block40;
                }
            }
            buf.readerIndex(segmentEnd);
        }
        if (deviceSession == null) {
            deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        }
        if (deviceSession != null) {
            position.setDeviceId(deviceSession.getDeviceId());
            if (position.getFixTime() == null) {
                this.getLastLocation(position, null);
            }
            return position;
        }
        return null;
    }
}

