/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (12 | (~ ivec4(-64, 72, 88, -76))) => ivec4(63, -65, -81, 79)
 * (12 | (~ ivec4(64, 72, 88, 76))) => ivec4(-65, -65, -81, -65)
 * (12 | (~ ivec4(-24, 40, -23, 64))) => ivec4(31, -33, 30, -65)
 * (12 | (~ ivec4(24, 40, 23, 64))) => ivec4(-17, -33, -20, -65)
 * (-6 | (~ ivec4(-64, 72, 88, -76))) => ivec4(-1, -1, -1, -5)
 * (-6 | (~ ivec4(64, 72, 88, 76))) => ivec4(-1, -1, -1, -5)
 * (-6 | (~ ivec4(-24, 40, -23, 64))) => ivec4(-1, -1, -2, -1)
 * (-6 | (~ ivec4(24, 40, 23, 64))) => ivec4(-1, -1, -6, -1)
 * (76 | (~ ivec4(-64, 72, 88, -76))) => ivec4(127, -1, -17, 79)
 * (76 | (~ ivec4(64, 72, 88, 76))) => ivec4(-1, -1, -17, -1)
 * (76 | (~ ivec4(-24, 40, -23, 64))) => ivec4(95, -33, 94, -1)
 * (76 | (~ ivec4(24, 40, 23, 64))) => ivec4(-17, -33, -20, -1)
 * (-32 | (~ ivec4(-64, 72, 88, -76))) => ivec4(-1, -9, -25, -21)
 * (-32 | (~ ivec4(64, 72, 88, 76))) => ivec4(-1, -9, -25, -13)
 * (-32 | (~ ivec4(-24, 40, -23, 64))) => ivec4(-9, -9, -10, -1)
 * (-32 | (~ ivec4(24, 40, 23, 64))) => ivec4(-25, -9, -24, -1)
 * (0 | (~ ivec4(-64, 72, 88, -76))) => ivec4(63, -73, -89, 75)
 * (0 | (~ ivec4(64, 72, 88, 76))) => ivec4(-65, -73, -89, -77)
 * (0 | (~ ivec4(-24, 40, -23, 64))) => ivec4(23, -41, 22, -65)
 * (0 | (~ ivec4(24, 40, 23, 64))) => ivec4(-25, -41, -24, -65)
 */
#version 150

void main()
{
  float[all(equal((12 | (~ ivec4(-64, 72, 88, -76))), ivec4(63, -65, -81, 79))) ? 1 : -1] array0;
  float[all(equal((12 | (~ ivec4(64, 72, 88, 76))), ivec4(-65, -65, -81, -65))) ? 1 : -1] array1;
  float[all(equal((12 | (~ ivec4(-24, 40, -23, 64))), ivec4(31, -33, 30, -65))) ? 1 : -1] array2;
  float[all(equal((12 | (~ ivec4(24, 40, 23, 64))), ivec4(-17, -33, -20, -65))) ? 1 : -1] array3;
  float[all(equal((-6 | (~ ivec4(-64, 72, 88, -76))), ivec4(-1, -1, -1, -5))) ? 1 : -1] array4;
  float[all(equal((-6 | (~ ivec4(64, 72, 88, 76))), ivec4(-1, -1, -1, -5))) ? 1 : -1] array5;
  float[all(equal((-6 | (~ ivec4(-24, 40, -23, 64))), ivec4(-1, -1, -2, -1))) ? 1 : -1] array6;
  float[all(equal((-6 | (~ ivec4(24, 40, 23, 64))), ivec4(-1, -1, -6, -1))) ? 1 : -1] array7;
  float[all(equal((76 | (~ ivec4(-64, 72, 88, -76))), ivec4(127, -1, -17, 79))) ? 1 : -1] array8;
  float[all(equal((76 | (~ ivec4(64, 72, 88, 76))), ivec4(-1, -1, -17, -1))) ? 1 : -1] array9;
  float[all(equal((76 | (~ ivec4(-24, 40, -23, 64))), ivec4(95, -33, 94, -1))) ? 1 : -1] array10;
  float[all(equal((76 | (~ ivec4(24, 40, 23, 64))), ivec4(-17, -33, -20, -1))) ? 1 : -1] array11;
  float[all(equal((-32 | (~ ivec4(-64, 72, 88, -76))), ivec4(-1, -9, -25, -21))) ? 1 : -1] array12;
  float[all(equal((-32 | (~ ivec4(64, 72, 88, 76))), ivec4(-1, -9, -25, -13))) ? 1 : -1] array13;
  float[all(equal((-32 | (~ ivec4(-24, 40, -23, 64))), ivec4(-9, -9, -10, -1))) ? 1 : -1] array14;
  float[all(equal((-32 | (~ ivec4(24, 40, 23, 64))), ivec4(-25, -9, -24, -1))) ? 1 : -1] array15;
  float[all(equal((0 | (~ ivec4(-64, 72, 88, -76))), ivec4(63, -73, -89, 75))) ? 1 : -1] array16;
  float[all(equal((0 | (~ ivec4(64, 72, 88, 76))), ivec4(-65, -73, -89, -77))) ? 1 : -1] array17;
  float[all(equal((0 | (~ ivec4(-24, 40, -23, 64))), ivec4(23, -41, 22, -65))) ? 1 : -1] array18;
  float[all(equal((0 | (~ ivec4(24, 40, 23, 64))), ivec4(-25, -41, -24, -65))) ? 1 : -1] array19;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
