/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console.commands.help;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.karaf.shell.api.console.Command;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.impl.console.commands.help.HelpProvider;
import org.apache.karaf.shell.support.ansi.SimpleAnsi;

public class CommandsHelpProvider
implements HelpProvider {
    @Override
    public String getHelp(Session session, String path) {
        if (path.indexOf(124) > 0) {
            if (path.startsWith("commands|")) {
                path = path.substring("commands|".length());
            } else {
                return null;
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ps.println(SimpleAnsi.INTENSITY_BOLD + "COMMANDS" + SimpleAnsi.INTENSITY_NORMAL);
        ps.println("${command-list|" + path + "}");
        return baos.toString();
    }

    private Set<Command> getCommands(Session session, String path) {
        List<Command> commands = session.getRegistry().getCommands();
        String subshell = (String)session.get("SUBSHELL");
        String completionMode = (String)session.get("karaf.completionMode");
        HashSet<Command> matchingCommands = new HashSet<Command>();
        for (Command command : commands) {
            String name = command.getScope() + ":" + command.getName();
            if (command != null && !name.startsWith(path) || completionMode != null && completionMode.equalsIgnoreCase("subshell") && (subshell == null || subshell.trim().isEmpty()) && !name.startsWith("*") || completionMode != null && (completionMode.equalsIgnoreCase("subshell") || completionMode.equalsIgnoreCase("first")) && !name.startsWith(subshell)) continue;
            matchingCommands.add(command);
        }
        return matchingCommands;
    }
}

