/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc.util;

import com.mysql.cj.jdbc.Driver;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class BaseBugReport {
    private Connection conn;
    private Driver driver;
    private final Lock lock = new ReentrantLock();

    public BaseBugReport() {
        try {
            this.driver = new Driver();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    public abstract void setUp() throws Exception;

    public abstract void tearDown() throws Exception;

    public abstract void runTest() throws Exception;

    public final void run() throws Exception {
        try {
            this.setUp();
            this.runTest();
        }
        finally {
            this.tearDown();
        }
    }

    protected final void assertTrue(String message, boolean condition) throws Exception {
        if (!condition) {
            throw new Exception("Assertion failed: " + message);
        }
    }

    protected final void assertTrue(boolean condition) throws Exception {
        this.assertTrue("(no message given)", condition);
    }

    public String getUrl() {
        return "jdbc:mysql:///test";
    }

    public final Connection getConnection() throws SQLException {
        this.lock.lock();
        try {
            if (this.conn == null || this.conn.isClosed()) {
                this.conn = this.getNewConnection();
            }
            Connection connection = this.conn;
            return connection;
        }
        finally {
            this.lock.unlock();
        }
    }

    public final Connection getNewConnection() throws SQLException {
        this.lock.lock();
        try {
            Connection connection = this.getConnection(this.getUrl());
            return connection;
        }
        finally {
            this.lock.unlock();
        }
    }

    public final Connection getConnection(String url) throws SQLException {
        this.lock.lock();
        try {
            Connection connection = this.getConnection(url, null);
            return connection;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Connection getConnection(String url, Properties props) throws SQLException {
        this.lock.lock();
        try {
            Connection connection = this.driver.connect(url, props);
            return connection;
        }
        finally {
            this.lock.unlock();
        }
    }
}

