/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.util.GeomUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphPinScene<N, E, P>
extends ObjectScene {
    private HashSet<N> nodes = new HashSet();
    private Set<N> nodesUm = Collections.unmodifiableSet(this.nodes);
    private HashSet<E> edges = new HashSet();
    private Set<E> edgesUm = Collections.unmodifiableSet(this.edges);
    private HashSet<P> pins = new HashSet();
    private Set<P> pinsUm = Collections.unmodifiableSet(this.pins);
    private HashMap<N, HashSet<P>> nodePins = new HashMap();
    private HashMap<P, N> pinNodes = new HashMap();
    private HashMap<E, P> edgeSourcePins = new HashMap();
    private HashMap<E, P> edgeTargetPins = new HashMap();
    private HashMap<P, List<E>> pinInputEdges = new HashMap();
    private HashMap<P, List<E>> pinOutputEdges = new HashMap();

    public final Widget addNode(N n) {
        assert (n != null) : "Null parameter";
        assert (!this.nodes.contains(n)) : "Node (" + n + ") already added";
        Widget widget = this.attachNodeWidget(n);
        this.nodes.add(n);
        this.nodePins.put(n, new HashSet());
        this.addObject(n, widget);
        this.notifyNodeAdded(n, widget);
        return widget;
    }

    public final void removeNode(N n) {
        assert (n != null && this.nodes.contains(n));
        for (Object e : new HashSet(this.nodePins.get(n))) {
            this.removePin(e);
        }
        this.nodes.remove(n);
        this.nodePins.remove(n);
        Widget widget = this.findWidget(n);
        this.detachNodeWidget(n, widget);
        this.removeObject(n);
    }

    public final void removeNodeWithEdges(N n) {
        assert (n != null && this.nodes.contains(n));
        for (P p : this.nodePins.get(n)) {
            for (E e : this.findPinEdges(p, true, true)) {
                if (!this.isEdge(e)) continue;
                this.removeEdge(e);
            }
        }
        this.removeNode(n);
    }

    public final Collection<N> getNodes() {
        return this.nodesUm;
    }

    public final Widget addEdge(E e) {
        assert (e != null && !this.edges.contains(e));
        Widget widget = this.attachEdgeWidget(e);
        this.edges.add(e);
        this.addObject(e, widget);
        this.notifyEdgeAdded(e, widget);
        return widget;
    }

    public final void removeEdge(E e) {
        assert (e != null && this.edges.contains(e));
        this.setEdgeSource(e, null);
        this.setEdgeTarget(e, null);
        this.edges.remove(e);
        this.edgeSourcePins.remove(e);
        this.edgeTargetPins.remove(e);
        Widget widget = this.findWidget(e);
        this.detachEdgeWidget(e, widget);
        this.removeObject(e);
    }

    public final Collection<E> getEdges() {
        return this.edgesUm;
    }

    public final Widget addPin(N n, P p) {
        assert (n != null && p != null && !this.pins.contains(p));
        Widget widget = this.attachPinWidget(n, p);
        this.pins.add(p);
        this.nodePins.get(n).add(p);
        this.pinNodes.put(p, n);
        this.pinInputEdges.put(p, new ArrayList());
        this.pinOutputEdges.put(p, new ArrayList());
        this.addObject(p, widget);
        this.notifyPinAdded(n, p, widget);
        return widget;
    }

    public final void removePin(P p) {
        Object object2;
        assert (p != null && this.pins.contains(p));
        for (Object object2 : this.findPinEdges(p, true, false)) {
            this.setEdgeSource(object2, null);
        }
        for (Object object2 : this.findPinEdges(p, false, true)) {
            this.setEdgeTarget(object2, null);
        }
        this.pins.remove(p);
        Iterator<Object> iterator = this.pinNodes.remove(p);
        this.nodePins.get(iterator).remove(p);
        this.pinInputEdges.remove(p);
        this.pinOutputEdges.remove(p);
        object2 = this.findWidget(p);
        this.detachPinWidget(p, (Widget)object2);
        this.removeObject(p);
    }

    public final void removePinWithEdges(P p) {
        assert (p != null && this.pins.contains(p));
        for (E e : this.findPinEdges(p, true, true)) {
            if (!this.isEdge(e)) continue;
            this.removeEdge(e);
        }
        this.removePin(p);
    }

    public final N getPinNode(P p) {
        return this.pinNodes.get(p);
    }

    public final Collection<P> getPins() {
        return this.pinsUm;
    }

    public final Collection<P> getNodePins(N n) {
        if (n == null) {
            return null;
        }
        HashSet<P> hashSet = this.nodePins.get(n);
        if (hashSet == null) {
            return null;
        }
        return Collections.unmodifiableCollection(hashSet);
    }

    public final void setEdgeSource(E e, P p) {
        assert (e != null && this.edges.contains(e));
        if (p != null) assert (this.pins.contains(p));
        P p2 = this.edgeSourcePins.put(e, p);
        if (GeomUtil.equals(p2, p)) {
            return;
        }
        if (p2 != null) {
            this.pinOutputEdges.get(p2).remove(e);
        }
        if (p != null) {
            this.pinOutputEdges.get(p).add(e);
        }
        this.attachEdgeSourceAnchor(e, p2, p);
    }

    public final void setEdgeTarget(E e, P p) {
        assert (e != null && this.edges.contains(e));
        if (p != null) assert (this.pins.contains(p));
        P p2 = this.edgeTargetPins.put(e, p);
        if (GeomUtil.equals(p2, p)) {
            return;
        }
        if (p2 != null) {
            this.pinInputEdges.get(p2).remove(e);
        }
        if (p != null) {
            this.pinInputEdges.get(p).add(e);
        }
        this.attachEdgeTargetAnchor(e, p2, p);
    }

    public final P getEdgeSource(E e) {
        return this.edgeSourcePins.get(e);
    }

    public final P getEdgeTarget(E e) {
        return this.edgeTargetPins.get(e);
    }

    public final Collection<E> findPinEdges(P p, boolean bl, boolean bl2) {
        assert (this.isPin(p)) : "Pin " + p + " is not in the scene";
        ArrayList arrayList = new ArrayList();
        if (bl2) {
            arrayList.addAll(this.pinInputEdges.get(p));
        }
        if (bl) {
            arrayList.addAll(this.pinOutputEdges.get(p));
        }
        return arrayList;
    }

    public final Collection<E> findEdgesBetween(P p, P p2) {
        assert (this.isPin(p)) : "Source pin " + p + " is not in the scene";
        assert (this.isPin(p2)) : "Target pin " + p2 + " is not in the scene";
        HashSet<E> hashSet = new HashSet<E>();
        List<E> list = this.pinInputEdges.get(p2);
        List<E> list2 = this.pinOutputEdges.get(p);
        for (E e : list) {
            if (!list2.contains(e)) continue;
            hashSet.add(e);
        }
        return hashSet;
    }

    public boolean isNode(Object object) {
        assert (!(object instanceof Widget)) : "Use findObject method for getting an object assigned to a specific Widget";
        return this.nodes.contains(object);
    }

    public boolean isEdge(Object object) {
        assert (!(object instanceof Widget)) : "Use findObject method for getting an object assigned to a specific Widget";
        return this.edges.contains(object);
    }

    public boolean isPin(Object object) {
        assert (!(object instanceof Widget)) : "Use findObject method for getting an object assigned to a specific Widget";
        return this.pins.contains(object);
    }

    protected void notifyNodeAdded(N n, Widget widget) {
    }

    protected void notifyEdgeAdded(E e, Widget widget) {
    }

    protected void notifyPinAdded(N n, P p, Widget widget) {
    }

    protected void detachNodeWidget(N n, Widget widget) {
        if (widget != null) {
            widget.removeFromParent();
        }
    }

    protected void detachEdgeWidget(E e, Widget widget) {
        if (widget != null) {
            widget.removeFromParent();
        }
    }

    protected void detachPinWidget(P p, Widget widget) {
        if (widget != null) {
            widget.removeFromParent();
        }
    }

    protected abstract Widget attachNodeWidget(N var1);

    protected abstract Widget attachEdgeWidget(E var1);

    protected abstract Widget attachPinWidget(N var1, P var2);

    protected abstract void attachEdgeSourceAnchor(E var1, P var2, P var3);

    protected abstract void attachEdgeTargetAnchor(E var1, P var2, P var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class StringGraph
    extends GraphPinScene<String, String, String> {
    }
}

