/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec3(36u, 32u, 88u) | (~ uvec3(36u, 32u, 88u))) => uvec3(4294967295u, 4294967295u, 4294967295u)
 * (uvec3(36u, 32u, 88u) | (~ uvec3(59u, 77u, 68u))) => uvec3(4294967268u, 4294967218u, 4294967291u)
 * (uvec3(59u, 77u, 68u) | (~ uvec3(36u, 32u, 88u))) => uvec3(4294967291u, 4294967263u, 4294967271u)
 * (uvec3(59u, 77u, 68u) | (~ uvec3(59u, 77u, 68u))) => uvec3(4294967295u, 4294967295u, 4294967295u)
 */
#version 130

void main()
{
  float[all(equal((uvec3(36u, 32u, 88u) | (~ uvec3(36u, 32u, 88u))), uvec3(4294967295u, 4294967295u, 4294967295u))) ? 1 : -1] array0;
  float[all(equal((uvec3(36u, 32u, 88u) | (~ uvec3(59u, 77u, 68u))), uvec3(4294967268u, 4294967218u, 4294967291u))) ? 1 : -1] array1;
  float[all(equal((uvec3(59u, 77u, 68u) | (~ uvec3(36u, 32u, 88u))), uvec3(4294967291u, 4294967263u, 4294967271u))) ? 1 : -1] array2;
  float[all(equal((uvec3(59u, 77u, 68u) | (~ uvec3(59u, 77u, 68u))), uvec3(4294967295u, 4294967295u, 4294967295u))) ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
