/*
 * Decompiled with CFR 0.152.
 */
package org.almworks.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.almworks.util.Failure;
import org.almworks.util.RuntimeInterruptedException;

public class ExceptionUtil {
    public static String getStacktrace(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    public static RuntimeException wrapUnchecked(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        if (throwable instanceof InterruptedException) {
            return new RuntimeInterruptedException((InterruptedException)throwable);
        }
        return new Failure(throwable);
    }

    public static RuntimeException rethrow(Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw ExceptionUtil.wrapUnchecked(throwable);
    }

    public static void rethrowNullable(Throwable throwable) {
        if (throwable != null) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    public static Throwable unwrapInvocationException(Throwable throwable) {
        while (throwable instanceof InvocationTargetException) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    public static Throwable unwrapCause(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        Throwable throwable2 = throwable.getCause();
        while (throwable2 != null && throwable2 != throwable) {
            throwable = throwable2;
        }
        return throwable;
    }
}

