# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("winspool.dll")
prototypes = \
    {
        #
        'EnumPrintersA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Flags", "Name", "Level", "pPrinterEnum", "cbBuf", "pcbNeeded", "pcReturned"]),
        #
        'EnumPrintersW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Flags", "Name", "Level", "pPrinterEnum", "cbBuf", "pcbNeeded", "pcReturned"]),
        #
        'GetSpoolFileHandle': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hPrinter"]),
        #
        'CommitSpoolData': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hPrinter", "hSpoolFile", "cbCommit"]),
        #
        'CloseSpoolFileHandle': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "hSpoolFile"]),
        #
        'OpenPrinterA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimStruct({"pDatatype": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pDevMode": SimTypePointer(SimTypeBottom(label="DEVMODEA"), offset=0), "DesiredAccess": SimTypeInt(signed=False, label="UInt32")}, name="PRINTER_DEFAULTSA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pPrinterName", "phPrinter", "pDefault"]),
        #
        'OpenPrinterW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimStruct({"pDatatype": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pDevMode": SimTypePointer(SimTypeBottom(label="DEVMODEW"), offset=0), "DesiredAccess": SimTypeInt(signed=False, label="UInt32")}, name="PRINTER_DEFAULTSW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pPrinterName", "phPrinter", "pDefault"]),
        #
        'ResetPrinterA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"pDatatype": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pDevMode": SimTypePointer(SimTypeBottom(label="DEVMODEA"), offset=0), "DesiredAccess": SimTypeInt(signed=False, label="UInt32")}, name="PRINTER_DEFAULTSA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "pDefault"]),
        #
        'ResetPrinterW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"pDatatype": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pDevMode": SimTypePointer(SimTypeBottom(label="DEVMODEW"), offset=0), "DesiredAccess": SimTypeInt(signed=False, label="UInt32")}, name="PRINTER_DEFAULTSW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "pDefault"]),
        #
        'SetJobA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "JobId", "Level", "pJob", "Command"]),
        #
        'SetJobW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "JobId", "Level", "pJob", "Command"]),
        #
        'GetJobA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "JobId", "Level", "pJob", "cbBuf", "pcbNeeded"]),
        #
        'GetJobW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "JobId", "Level", "pJob", "cbBuf", "pcbNeeded"]),
        #
        'EnumJobsA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "FirstJob", "NoJobs", "Level", "pJob", "cbBuf", "pcbNeeded", "pcReturned"]),
        #
        'EnumJobsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "FirstJob", "NoJobs", "Level", "pJob", "cbBuf", "pcbNeeded", "pcReturned"]),
        #
        'AddPrinterA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pName", "Level", "pPrinter"]),
        #
        'AddPrinterW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pName", "Level", "pPrinter"]),
        #
        'DeletePrinter': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter"]),
        #
        'SetPrinterA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "Level", "pPrinter", "Command"]),
        #
        'SetPrinterW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "Level", "pPrinter", "Command"]),
        #
        'GetPrinterA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "Level", "pPrinter", "cbBuf", "pcbNeeded"]),
        #
        'GetPrinterW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "Level", "pPrinter", "cbBuf", "pcbNeeded"]),
        #
        'AddPrinterDriverA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "Level", "pDriverInfo"]),
        #
        'AddPrinterDriverW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "Level", "pDriverInfo"]),
        #
        'AddPrinterDriverExA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "Level", "lpbDriverInfo", "dwFileCopyFlags"]),
        #
        'AddPrinterDriverExW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "Level", "lpbDriverInfo", "dwFileCopyFlags"]),
        #
        'EnumPrinterDriversA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "pEnvironment", "Level", "pDriverInfo", "cbBuf", "pcbNeeded", "pcReturned"]),
        #
        'EnumPrinterDriversW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "pEnvironment", "Level", "pDriverInfo", "cbBuf", "pcbNeeded", "pcReturned"]),
        #
        'GetPrinterDriverA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "pEnvironment", "Level", "pDriverInfo", "cbBuf", "pcbNeeded"]),
        #
        'GetPrinterDriverW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "pEnvironment", "Level", "pDriverInfo", "cbBuf", "pcbNeeded"]),
        #
        'GetPrinterDriverDirectoryA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "pEnvironment", "Level", "pDriverDirectory", "cbBuf", "pcbNeeded"]),
        #
        'GetPrinterDriverDirectoryW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "pEnvironment", "Level", "pDriverDirectory", "cbBuf", "pcbNeeded"]),
        #
        'DeletePrinterDriverA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "pEnvironment", "pDriverName"]),
        #
        'DeletePrinterDriverW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "pEnvironment", "pDriverName"]),
        #
        'DeletePrinterDriverExA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "pEnvironment", "pDriverName", "dwDeleteFlag", "dwVersionFlag"]),
        #
        'DeletePrinterDriverExW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "pEnvironment", "pDriverName", "dwDeleteFlag", "dwVersionFlag"]),
        #
        'AddPrintProcessorA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "pEnvironment", "pPathName", "pPrintProcessorName"]),
        #
        'AddPrintProcessorW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "pEnvironment", "pPathName", "pPrintProcessorName"]),
        #
        'EnumPrintProcessorsA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "pEnvironment", "Level", "pPrintProcessorInfo", "cbBuf", "pcbNeeded", "pcReturned"]),
        #
        'EnumPrintProcessorsW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "pEnvironment", "Level", "pPrintProcessorInfo", "cbBuf", "pcbNeeded", "pcReturned"]),
        #
        'GetPrintProcessorDirectoryA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "pEnvironment", "Level", "pPrintProcessorInfo", "cbBuf", "pcbNeeded"]),
        #
        'GetPrintProcessorDirectoryW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "pEnvironment", "Level", "pPrintProcessorInfo", "cbBuf", "pcbNeeded"]),
        #
        'EnumPrintProcessorDatatypesA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "pPrintProcessorName", "Level", "pDatatypes", "cbBuf", "pcbNeeded", "pcReturned"]),
        #
        'EnumPrintProcessorDatatypesW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "pPrintProcessorName", "Level", "pDatatypes", "cbBuf", "pcbNeeded", "pcReturned"]),
        #
        'DeletePrintProcessorA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "pEnvironment", "pPrintProcessorName"]),
        #
        'DeletePrintProcessorW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "pEnvironment", "pPrintProcessorName"]),
        #
        'StartDocPrinterA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"pDocName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOutputFile": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pDatatype": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DOC_INFO_1A", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hPrinter", "Level", "pDocInfo"]),
        #
        'StartDocPrinterW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"pDocName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pOutputFile": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pDatatype": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DOC_INFO_1W", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hPrinter", "Level", "pDocInfo"]),
        #
        'StartPagePrinter': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter"]),
        #
        'WritePrinter': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "pBuf", "cbBuf", "pcWritten"]),
        #
        'FlushPrinter': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "pBuf", "cbBuf", "pcWritten", "cSleep"]),
        #
        'EndPagePrinter': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter"]),
        #
        'AbortPrinter': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter"]),
        #
        'ReadPrinter': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "pBuf", "cbBuf", "pNoBytesRead"]),
        #
        'EndDocPrinter': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter"]),
        #
        'AddJobA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "Level", "pData", "cbBuf", "pcbNeeded"]),
        #
        'AddJobW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "Level", "pData", "cbBuf", "pcbNeeded"]),
        #
        'ScheduleJob': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "JobId"]),
        #
        'PrinterProperties': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hWnd", "hPrinter"]),
        #
        'DocumentPropertiesA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"dmDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "dmSpecVersion": SimTypeShort(signed=False, label="UInt16"), "dmDriverVersion": SimTypeShort(signed=False, label="UInt16"), "dmSize": SimTypeShort(signed=False, label="UInt16"), "dmDriverExtra": SimTypeShort(signed=False, label="UInt16"), "dmFields": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"dmOrientation": SimTypeShort(signed=True, label="Int16"), "dmPaperSize": SimTypeShort(signed=True, label="Int16"), "dmPaperLength": SimTypeShort(signed=True, label="Int16"), "dmPaperWidth": SimTypeShort(signed=True, label="Int16"), "dmScale": SimTypeShort(signed=True, label="Int16"), "dmCopies": SimTypeShort(signed=True, label="Int16"), "dmDefaultSource": SimTypeShort(signed=True, label="Int16"), "dmPrintQuality": SimTypeShort(signed=True, label="Int16")}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"dmPosition": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "dmDisplayOrientation": SimTypeInt(signed=False, label="UInt32"), "dmDisplayFixedOutput": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "dmColor": SimTypeShort(signed=True, label="Int16"), "dmDuplex": SimTypeShort(signed=True, label="Int16"), "dmYResolution": SimTypeShort(signed=True, label="Int16"), "dmTTOption": SimTypeShort(signed=True, label="Int16"), "dmCollate": SimTypeShort(signed=True, label="Int16"), "dmFormName": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "dmLogPixels": SimTypeShort(signed=False, label="UInt16"), "dmBitsPerPel": SimTypeInt(signed=False, label="UInt32"), "dmPelsWidth": SimTypeInt(signed=False, label="UInt32"), "dmPelsHeight": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"dmDisplayFlags": SimTypeInt(signed=False, label="UInt32"), "dmNup": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "dmDisplayFrequency": SimTypeInt(signed=False, label="UInt32"), "dmICMMethod": SimTypeInt(signed=False, label="UInt32"), "dmICMIntent": SimTypeInt(signed=False, label="UInt32"), "dmMediaType": SimTypeInt(signed=False, label="UInt32"), "dmDitherType": SimTypeInt(signed=False, label="UInt32"), "dmReserved1": SimTypeInt(signed=False, label="UInt32"), "dmReserved2": SimTypeInt(signed=False, label="UInt32"), "dmPanningWidth": SimTypeInt(signed=False, label="UInt32"), "dmPanningHeight": SimTypeInt(signed=False, label="UInt32")}, name="DEVMODEA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dmDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "dmSpecVersion": SimTypeShort(signed=False, label="UInt16"), "dmDriverVersion": SimTypeShort(signed=False, label="UInt16"), "dmSize": SimTypeShort(signed=False, label="UInt16"), "dmDriverExtra": SimTypeShort(signed=False, label="UInt16"), "dmFields": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"dmOrientation": SimTypeShort(signed=True, label="Int16"), "dmPaperSize": SimTypeShort(signed=True, label="Int16"), "dmPaperLength": SimTypeShort(signed=True, label="Int16"), "dmPaperWidth": SimTypeShort(signed=True, label="Int16"), "dmScale": SimTypeShort(signed=True, label="Int16"), "dmCopies": SimTypeShort(signed=True, label="Int16"), "dmDefaultSource": SimTypeShort(signed=True, label="Int16"), "dmPrintQuality": SimTypeShort(signed=True, label="Int16")}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"dmPosition": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "dmDisplayOrientation": SimTypeInt(signed=False, label="UInt32"), "dmDisplayFixedOutput": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "dmColor": SimTypeShort(signed=True, label="Int16"), "dmDuplex": SimTypeShort(signed=True, label="Int16"), "dmYResolution": SimTypeShort(signed=True, label="Int16"), "dmTTOption": SimTypeShort(signed=True, label="Int16"), "dmCollate": SimTypeShort(signed=True, label="Int16"), "dmFormName": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "dmLogPixels": SimTypeShort(signed=False, label="UInt16"), "dmBitsPerPel": SimTypeInt(signed=False, label="UInt32"), "dmPelsWidth": SimTypeInt(signed=False, label="UInt32"), "dmPelsHeight": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"dmDisplayFlags": SimTypeInt(signed=False, label="UInt32"), "dmNup": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "dmDisplayFrequency": SimTypeInt(signed=False, label="UInt32"), "dmICMMethod": SimTypeInt(signed=False, label="UInt32"), "dmICMIntent": SimTypeInt(signed=False, label="UInt32"), "dmMediaType": SimTypeInt(signed=False, label="UInt32"), "dmDitherType": SimTypeInt(signed=False, label="UInt32"), "dmReserved1": SimTypeInt(signed=False, label="UInt32"), "dmReserved2": SimTypeInt(signed=False, label="UInt32"), "dmPanningWidth": SimTypeInt(signed=False, label="UInt32"), "dmPanningHeight": SimTypeInt(signed=False, label="UInt32")}, name="DEVMODEA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hWnd", "hPrinter", "pDeviceName", "pDevModeOutput", "pDevModeInput", "fMode"]),
        #
        'DocumentPropertiesW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dmDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dmSpecVersion": SimTypeShort(signed=False, label="UInt16"), "dmDriverVersion": SimTypeShort(signed=False, label="UInt16"), "dmSize": SimTypeShort(signed=False, label="UInt16"), "dmDriverExtra": SimTypeShort(signed=False, label="UInt16"), "dmFields": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"dmOrientation": SimTypeShort(signed=True, label="Int16"), "dmPaperSize": SimTypeShort(signed=True, label="Int16"), "dmPaperLength": SimTypeShort(signed=True, label="Int16"), "dmPaperWidth": SimTypeShort(signed=True, label="Int16"), "dmScale": SimTypeShort(signed=True, label="Int16"), "dmCopies": SimTypeShort(signed=True, label="Int16"), "dmDefaultSource": SimTypeShort(signed=True, label="Int16"), "dmPrintQuality": SimTypeShort(signed=True, label="Int16")}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"dmPosition": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "dmDisplayOrientation": SimTypeInt(signed=False, label="UInt32"), "dmDisplayFixedOutput": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "dmColor": SimTypeShort(signed=True, label="Int16"), "dmDuplex": SimTypeShort(signed=True, label="Int16"), "dmYResolution": SimTypeShort(signed=True, label="Int16"), "dmTTOption": SimTypeShort(signed=True, label="Int16"), "dmCollate": SimTypeShort(signed=True, label="Int16"), "dmFormName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dmLogPixels": SimTypeShort(signed=False, label="UInt16"), "dmBitsPerPel": SimTypeInt(signed=False, label="UInt32"), "dmPelsWidth": SimTypeInt(signed=False, label="UInt32"), "dmPelsHeight": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"dmDisplayFlags": SimTypeInt(signed=False, label="UInt32"), "dmNup": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "dmDisplayFrequency": SimTypeInt(signed=False, label="UInt32"), "dmICMMethod": SimTypeInt(signed=False, label="UInt32"), "dmICMIntent": SimTypeInt(signed=False, label="UInt32"), "dmMediaType": SimTypeInt(signed=False, label="UInt32"), "dmDitherType": SimTypeInt(signed=False, label="UInt32"), "dmReserved1": SimTypeInt(signed=False, label="UInt32"), "dmReserved2": SimTypeInt(signed=False, label="UInt32"), "dmPanningWidth": SimTypeInt(signed=False, label="UInt32"), "dmPanningHeight": SimTypeInt(signed=False, label="UInt32")}, name="DEVMODEW", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dmDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dmSpecVersion": SimTypeShort(signed=False, label="UInt16"), "dmDriverVersion": SimTypeShort(signed=False, label="UInt16"), "dmSize": SimTypeShort(signed=False, label="UInt16"), "dmDriverExtra": SimTypeShort(signed=False, label="UInt16"), "dmFields": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"dmOrientation": SimTypeShort(signed=True, label="Int16"), "dmPaperSize": SimTypeShort(signed=True, label="Int16"), "dmPaperLength": SimTypeShort(signed=True, label="Int16"), "dmPaperWidth": SimTypeShort(signed=True, label="Int16"), "dmScale": SimTypeShort(signed=True, label="Int16"), "dmCopies": SimTypeShort(signed=True, label="Int16"), "dmDefaultSource": SimTypeShort(signed=True, label="Int16"), "dmPrintQuality": SimTypeShort(signed=True, label="Int16")}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"dmPosition": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "dmDisplayOrientation": SimTypeInt(signed=False, label="UInt32"), "dmDisplayFixedOutput": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "dmColor": SimTypeShort(signed=True, label="Int16"), "dmDuplex": SimTypeShort(signed=True, label="Int16"), "dmYResolution": SimTypeShort(signed=True, label="Int16"), "dmTTOption": SimTypeShort(signed=True, label="Int16"), "dmCollate": SimTypeShort(signed=True, label="Int16"), "dmFormName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dmLogPixels": SimTypeShort(signed=False, label="UInt16"), "dmBitsPerPel": SimTypeInt(signed=False, label="UInt32"), "dmPelsWidth": SimTypeInt(signed=False, label="UInt32"), "dmPelsHeight": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"dmDisplayFlags": SimTypeInt(signed=False, label="UInt32"), "dmNup": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "dmDisplayFrequency": SimTypeInt(signed=False, label="UInt32"), "dmICMMethod": SimTypeInt(signed=False, label="UInt32"), "dmICMIntent": SimTypeInt(signed=False, label="UInt32"), "dmMediaType": SimTypeInt(signed=False, label="UInt32"), "dmDitherType": SimTypeInt(signed=False, label="UInt32"), "dmReserved1": SimTypeInt(signed=False, label="UInt32"), "dmReserved2": SimTypeInt(signed=False, label="UInt32"), "dmPanningWidth": SimTypeInt(signed=False, label="UInt32"), "dmPanningHeight": SimTypeInt(signed=False, label="UInt32")}, name="DEVMODEW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hWnd", "hPrinter", "pDeviceName", "pDevModeOutput", "pDevModeInput", "fMode"]),
        #
        'AdvancedDocumentPropertiesA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"dmDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "dmSpecVersion": SimTypeShort(signed=False, label="UInt16"), "dmDriverVersion": SimTypeShort(signed=False, label="UInt16"), "dmSize": SimTypeShort(signed=False, label="UInt16"), "dmDriverExtra": SimTypeShort(signed=False, label="UInt16"), "dmFields": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"dmOrientation": SimTypeShort(signed=True, label="Int16"), "dmPaperSize": SimTypeShort(signed=True, label="Int16"), "dmPaperLength": SimTypeShort(signed=True, label="Int16"), "dmPaperWidth": SimTypeShort(signed=True, label="Int16"), "dmScale": SimTypeShort(signed=True, label="Int16"), "dmCopies": SimTypeShort(signed=True, label="Int16"), "dmDefaultSource": SimTypeShort(signed=True, label="Int16"), "dmPrintQuality": SimTypeShort(signed=True, label="Int16")}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"dmPosition": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "dmDisplayOrientation": SimTypeInt(signed=False, label="UInt32"), "dmDisplayFixedOutput": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "dmColor": SimTypeShort(signed=True, label="Int16"), "dmDuplex": SimTypeShort(signed=True, label="Int16"), "dmYResolution": SimTypeShort(signed=True, label="Int16"), "dmTTOption": SimTypeShort(signed=True, label="Int16"), "dmCollate": SimTypeShort(signed=True, label="Int16"), "dmFormName": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "dmLogPixels": SimTypeShort(signed=False, label="UInt16"), "dmBitsPerPel": SimTypeInt(signed=False, label="UInt32"), "dmPelsWidth": SimTypeInt(signed=False, label="UInt32"), "dmPelsHeight": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"dmDisplayFlags": SimTypeInt(signed=False, label="UInt32"), "dmNup": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "dmDisplayFrequency": SimTypeInt(signed=False, label="UInt32"), "dmICMMethod": SimTypeInt(signed=False, label="UInt32"), "dmICMIntent": SimTypeInt(signed=False, label="UInt32"), "dmMediaType": SimTypeInt(signed=False, label="UInt32"), "dmDitherType": SimTypeInt(signed=False, label="UInt32"), "dmReserved1": SimTypeInt(signed=False, label="UInt32"), "dmReserved2": SimTypeInt(signed=False, label="UInt32"), "dmPanningWidth": SimTypeInt(signed=False, label="UInt32"), "dmPanningHeight": SimTypeInt(signed=False, label="UInt32")}, name="DEVMODEA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dmDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "dmSpecVersion": SimTypeShort(signed=False, label="UInt16"), "dmDriverVersion": SimTypeShort(signed=False, label="UInt16"), "dmSize": SimTypeShort(signed=False, label="UInt16"), "dmDriverExtra": SimTypeShort(signed=False, label="UInt16"), "dmFields": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"dmOrientation": SimTypeShort(signed=True, label="Int16"), "dmPaperSize": SimTypeShort(signed=True, label="Int16"), "dmPaperLength": SimTypeShort(signed=True, label="Int16"), "dmPaperWidth": SimTypeShort(signed=True, label="Int16"), "dmScale": SimTypeShort(signed=True, label="Int16"), "dmCopies": SimTypeShort(signed=True, label="Int16"), "dmDefaultSource": SimTypeShort(signed=True, label="Int16"), "dmPrintQuality": SimTypeShort(signed=True, label="Int16")}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"dmPosition": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "dmDisplayOrientation": SimTypeInt(signed=False, label="UInt32"), "dmDisplayFixedOutput": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "dmColor": SimTypeShort(signed=True, label="Int16"), "dmDuplex": SimTypeShort(signed=True, label="Int16"), "dmYResolution": SimTypeShort(signed=True, label="Int16"), "dmTTOption": SimTypeShort(signed=True, label="Int16"), "dmCollate": SimTypeShort(signed=True, label="Int16"), "dmFormName": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "dmLogPixels": SimTypeShort(signed=False, label="UInt16"), "dmBitsPerPel": SimTypeInt(signed=False, label="UInt32"), "dmPelsWidth": SimTypeInt(signed=False, label="UInt32"), "dmPelsHeight": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"dmDisplayFlags": SimTypeInt(signed=False, label="UInt32"), "dmNup": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "dmDisplayFrequency": SimTypeInt(signed=False, label="UInt32"), "dmICMMethod": SimTypeInt(signed=False, label="UInt32"), "dmICMIntent": SimTypeInt(signed=False, label="UInt32"), "dmMediaType": SimTypeInt(signed=False, label="UInt32"), "dmDitherType": SimTypeInt(signed=False, label="UInt32"), "dmReserved1": SimTypeInt(signed=False, label="UInt32"), "dmReserved2": SimTypeInt(signed=False, label="UInt32"), "dmPanningWidth": SimTypeInt(signed=False, label="UInt32"), "dmPanningHeight": SimTypeInt(signed=False, label="UInt32")}, name="DEVMODEA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hWnd", "hPrinter", "pDeviceName", "pDevModeOutput", "pDevModeInput"]),
        #
        'AdvancedDocumentPropertiesW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dmDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dmSpecVersion": SimTypeShort(signed=False, label="UInt16"), "dmDriverVersion": SimTypeShort(signed=False, label="UInt16"), "dmSize": SimTypeShort(signed=False, label="UInt16"), "dmDriverExtra": SimTypeShort(signed=False, label="UInt16"), "dmFields": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"dmOrientation": SimTypeShort(signed=True, label="Int16"), "dmPaperSize": SimTypeShort(signed=True, label="Int16"), "dmPaperLength": SimTypeShort(signed=True, label="Int16"), "dmPaperWidth": SimTypeShort(signed=True, label="Int16"), "dmScale": SimTypeShort(signed=True, label="Int16"), "dmCopies": SimTypeShort(signed=True, label="Int16"), "dmDefaultSource": SimTypeShort(signed=True, label="Int16"), "dmPrintQuality": SimTypeShort(signed=True, label="Int16")}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"dmPosition": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "dmDisplayOrientation": SimTypeInt(signed=False, label="UInt32"), "dmDisplayFixedOutput": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "dmColor": SimTypeShort(signed=True, label="Int16"), "dmDuplex": SimTypeShort(signed=True, label="Int16"), "dmYResolution": SimTypeShort(signed=True, label="Int16"), "dmTTOption": SimTypeShort(signed=True, label="Int16"), "dmCollate": SimTypeShort(signed=True, label="Int16"), "dmFormName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dmLogPixels": SimTypeShort(signed=False, label="UInt16"), "dmBitsPerPel": SimTypeInt(signed=False, label="UInt32"), "dmPelsWidth": SimTypeInt(signed=False, label="UInt32"), "dmPelsHeight": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"dmDisplayFlags": SimTypeInt(signed=False, label="UInt32"), "dmNup": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "dmDisplayFrequency": SimTypeInt(signed=False, label="UInt32"), "dmICMMethod": SimTypeInt(signed=False, label="UInt32"), "dmICMIntent": SimTypeInt(signed=False, label="UInt32"), "dmMediaType": SimTypeInt(signed=False, label="UInt32"), "dmDitherType": SimTypeInt(signed=False, label="UInt32"), "dmReserved1": SimTypeInt(signed=False, label="UInt32"), "dmReserved2": SimTypeInt(signed=False, label="UInt32"), "dmPanningWidth": SimTypeInt(signed=False, label="UInt32"), "dmPanningHeight": SimTypeInt(signed=False, label="UInt32")}, name="DEVMODEW", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dmDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dmSpecVersion": SimTypeShort(signed=False, label="UInt16"), "dmDriverVersion": SimTypeShort(signed=False, label="UInt16"), "dmSize": SimTypeShort(signed=False, label="UInt16"), "dmDriverExtra": SimTypeShort(signed=False, label="UInt16"), "dmFields": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"dmOrientation": SimTypeShort(signed=True, label="Int16"), "dmPaperSize": SimTypeShort(signed=True, label="Int16"), "dmPaperLength": SimTypeShort(signed=True, label="Int16"), "dmPaperWidth": SimTypeShort(signed=True, label="Int16"), "dmScale": SimTypeShort(signed=True, label="Int16"), "dmCopies": SimTypeShort(signed=True, label="Int16"), "dmDefaultSource": SimTypeShort(signed=True, label="Int16"), "dmPrintQuality": SimTypeShort(signed=True, label="Int16")}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"dmPosition": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "dmDisplayOrientation": SimTypeInt(signed=False, label="UInt32"), "dmDisplayFixedOutput": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "dmColor": SimTypeShort(signed=True, label="Int16"), "dmDuplex": SimTypeShort(signed=True, label="Int16"), "dmYResolution": SimTypeShort(signed=True, label="Int16"), "dmTTOption": SimTypeShort(signed=True, label="Int16"), "dmCollate": SimTypeShort(signed=True, label="Int16"), "dmFormName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dmLogPixels": SimTypeShort(signed=False, label="UInt16"), "dmBitsPerPel": SimTypeInt(signed=False, label="UInt32"), "dmPelsWidth": SimTypeInt(signed=False, label="UInt32"), "dmPelsHeight": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"dmDisplayFlags": SimTypeInt(signed=False, label="UInt32"), "dmNup": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "dmDisplayFrequency": SimTypeInt(signed=False, label="UInt32"), "dmICMMethod": SimTypeInt(signed=False, label="UInt32"), "dmICMIntent": SimTypeInt(signed=False, label="UInt32"), "dmMediaType": SimTypeInt(signed=False, label="UInt32"), "dmDitherType": SimTypeInt(signed=False, label="UInt32"), "dmReserved1": SimTypeInt(signed=False, label="UInt32"), "dmReserved2": SimTypeInt(signed=False, label="UInt32"), "dmPanningWidth": SimTypeInt(signed=False, label="UInt32"), "dmPanningHeight": SimTypeInt(signed=False, label="UInt32")}, name="DEVMODEW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hWnd", "hPrinter", "pDeviceName", "pDevModeOutput", "pDevModeInput"]),
        #
        'GetPrinterDataA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hPrinter", "pValueName", "pType", "pData", "nSize", "pcbNeeded"]),
        #
        'GetPrinterDataW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hPrinter", "pValueName", "pType", "pData", "nSize", "pcbNeeded"]),
        #
        'GetPrinterDataExA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hPrinter", "pKeyName", "pValueName", "pType", "pData", "nSize", "pcbNeeded"]),
        #
        'GetPrinterDataExW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hPrinter", "pKeyName", "pValueName", "pType", "pData", "nSize", "pcbNeeded"]),
        #
        'EnumPrinterDataA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hPrinter", "dwIndex", "pValueName", "cbValueName", "pcbValueName", "pType", "pData", "cbData", "pcbData"]),
        #
        'EnumPrinterDataW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hPrinter", "dwIndex", "pValueName", "cbValueName", "pcbValueName", "pType", "pData", "cbData", "pcbData"]),
        #
        'EnumPrinterDataExA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hPrinter", "pKeyName", "pEnumValues", "cbEnumValues", "pcbEnumValues", "pnEnumValues"]),
        #
        'EnumPrinterDataExW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hPrinter", "pKeyName", "pEnumValues", "cbEnumValues", "pcbEnumValues", "pnEnumValues"]),
        #
        'EnumPrinterKeyA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hPrinter", "pKeyName", "pSubkey", "cbSubkey", "pcbSubkey"]),
        #
        'EnumPrinterKeyW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hPrinter", "pKeyName", "pSubkey", "cbSubkey", "pcbSubkey"]),
        #
        'SetPrinterDataA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hPrinter", "pValueName", "Type", "pData", "cbData"]),
        #
        'SetPrinterDataW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hPrinter", "pValueName", "Type", "pData", "cbData"]),
        #
        'SetPrinterDataExA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hPrinter", "pKeyName", "pValueName", "Type", "pData", "cbData"]),
        #
        'SetPrinterDataExW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hPrinter", "pKeyName", "pValueName", "Type", "pData", "cbData"]),
        #
        'DeletePrinterDataA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hPrinter", "pValueName"]),
        #
        'DeletePrinterDataW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hPrinter", "pValueName"]),
        #
        'DeletePrinterDataExA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hPrinter", "pKeyName", "pValueName"]),
        #
        'DeletePrinterDataExW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hPrinter", "pKeyName", "pValueName"]),
        #
        'DeletePrinterKeyA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hPrinter", "pKeyName"]),
        #
        'DeletePrinterKeyW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hPrinter", "pKeyName"]),
        #
        'WaitForPrinterChange': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hPrinter", "Flags"]),
        #
        'FindFirstPrinterChangeNotification': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hPrinter", "fdwFilter", "fdwOptions", "pPrinterNotifyOptions"]),
        #
        'FindNextPrinterChangeNotification': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hChange", "pdwChange", "pvReserved", "ppPrinterNotifyInfo"]),
        #
        'FreePrinterNotifyInfo': SimTypeFunction([SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "Count": SimTypeInt(signed=False, label="UInt32"), "aData": SimTypePointer(SimStruct({"Type": SimTypeShort(signed=False, label="UInt16"), "Field": SimTypeShort(signed=False, label="UInt16"), "Reserved": SimTypeInt(signed=False, label="UInt32"), "Id": SimTypeInt(signed=False, label="UInt32"), "NotifyData": SimUnion({"adwData": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 2), "Data": SimStruct({"cbBuf": SimTypeInt(signed=False, label="UInt32"), "pBuf": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="_Data_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="PRINTER_NOTIFY_INFO_DATA", pack=False, align=None), offset=0)}, name="PRINTER_NOTIFY_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pPrinterNotifyInfo"]),
        #
        'FindClosePrinterChangeNotification': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hChange"]),
        #
        'PrinterMessageBoxA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hPrinter", "Error", "hWnd", "pText", "pCaption", "dwType"]),
        #
        'PrinterMessageBoxW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hPrinter", "Error", "hWnd", "pText", "pCaption", "dwType"]),
        #
        'ClosePrinter': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter"]),
        #
        'AddFormA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "Level", "pForm"]),
        #
        'AddFormW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "Level", "pForm"]),
        #
        'DeleteFormA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "pFormName"]),
        #
        'DeleteFormW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "pFormName"]),
        #
        'GetFormA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "pFormName", "Level", "pForm", "cbBuf", "pcbNeeded"]),
        #
        'GetFormW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "pFormName", "Level", "pForm", "cbBuf", "pcbNeeded"]),
        #
        'SetFormA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "pFormName", "Level", "pForm"]),
        #
        'SetFormW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "pFormName", "Level", "pForm"]),
        #
        'EnumFormsA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "Level", "pForm", "cbBuf", "pcbNeeded", "pcReturned"]),
        #
        'EnumFormsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "Level", "pForm", "cbBuf", "pcbNeeded", "pcReturned"]),
        #
        'EnumMonitorsA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "Level", "pMonitor", "cbBuf", "pcbNeeded", "pcReturned"]),
        #
        'EnumMonitorsW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "Level", "pMonitor", "cbBuf", "pcbNeeded", "pcReturned"]),
        #
        'AddMonitorA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "Level", "pMonitors"]),
        #
        'AddMonitorW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "Level", "pMonitors"]),
        #
        'DeleteMonitorA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "pEnvironment", "pMonitorName"]),
        #
        'DeleteMonitorW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "pEnvironment", "pMonitorName"]),
        #
        'EnumPortsA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "Level", "pPort", "cbBuf", "pcbNeeded", "pcReturned"]),
        #
        'EnumPortsW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "Level", "pPort", "cbBuf", "pcbNeeded", "pcReturned"]),
        #
        'AddPortA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "hWnd", "pMonitorName"]),
        #
        'AddPortW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "hWnd", "pMonitorName"]),
        #
        'ConfigurePortA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "hWnd", "pPortName"]),
        #
        'ConfigurePortW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "hWnd", "pPortName"]),
        #
        'DeletePortA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "hWnd", "pPortName"]),
        #
        'DeletePortW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "hWnd", "pPortName"]),
        #
        'XcvDataW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hXcv", "pszDataName", "pInputData", "cbInputData", "pOutputData", "cbOutputData", "pcbOutputNeeded", "pdwStatus"]),
        #
        'GetDefaultPrinterA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszBuffer", "pcchBuffer"]),
        #
        'GetDefaultPrinterW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszBuffer", "pcchBuffer"]),
        #
        'SetDefaultPrinterA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszPrinter"]),
        #
        'SetDefaultPrinterW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszPrinter"]),
        #
        'SetPortA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "pPortName", "dwLevel", "pPortInfo"]),
        #
        'SetPortW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "pPortName", "dwLevel", "pPortInfo"]),
        #
        'AddPrinterConnectionA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName"]),
        #
        'AddPrinterConnectionW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName"]),
        #
        'DeletePrinterConnectionA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName"]),
        #
        'DeletePrinterConnectionW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName"]),
        #
        'ConnectToPrinterDlg': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hwnd", "Flags"]),
        #
        'AddPrintProvidorA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "Level", "pProvidorInfo"]),
        #
        'AddPrintProvidorW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "Level", "pProvidorInfo"]),
        #
        'DeletePrintProvidorA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "pEnvironment", "pPrintProvidorName"]),
        #
        'DeletePrintProvidorW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "pEnvironment", "pPrintProvidorName"]),
        #
        'IsValidDevmodeA': SimTypeFunction([SimTypePointer(SimStruct({"dmDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "dmSpecVersion": SimTypeShort(signed=False, label="UInt16"), "dmDriverVersion": SimTypeShort(signed=False, label="UInt16"), "dmSize": SimTypeShort(signed=False, label="UInt16"), "dmDriverExtra": SimTypeShort(signed=False, label="UInt16"), "dmFields": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"dmOrientation": SimTypeShort(signed=True, label="Int16"), "dmPaperSize": SimTypeShort(signed=True, label="Int16"), "dmPaperLength": SimTypeShort(signed=True, label="Int16"), "dmPaperWidth": SimTypeShort(signed=True, label="Int16"), "dmScale": SimTypeShort(signed=True, label="Int16"), "dmCopies": SimTypeShort(signed=True, label="Int16"), "dmDefaultSource": SimTypeShort(signed=True, label="Int16"), "dmPrintQuality": SimTypeShort(signed=True, label="Int16")}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"dmPosition": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "dmDisplayOrientation": SimTypeInt(signed=False, label="UInt32"), "dmDisplayFixedOutput": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "dmColor": SimTypeShort(signed=True, label="Int16"), "dmDuplex": SimTypeShort(signed=True, label="Int16"), "dmYResolution": SimTypeShort(signed=True, label="Int16"), "dmTTOption": SimTypeShort(signed=True, label="Int16"), "dmCollate": SimTypeShort(signed=True, label="Int16"), "dmFormName": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "dmLogPixels": SimTypeShort(signed=False, label="UInt16"), "dmBitsPerPel": SimTypeInt(signed=False, label="UInt32"), "dmPelsWidth": SimTypeInt(signed=False, label="UInt32"), "dmPelsHeight": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"dmDisplayFlags": SimTypeInt(signed=False, label="UInt32"), "dmNup": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "dmDisplayFrequency": SimTypeInt(signed=False, label="UInt32"), "dmICMMethod": SimTypeInt(signed=False, label="UInt32"), "dmICMIntent": SimTypeInt(signed=False, label="UInt32"), "dmMediaType": SimTypeInt(signed=False, label="UInt32"), "dmDitherType": SimTypeInt(signed=False, label="UInt32"), "dmReserved1": SimTypeInt(signed=False, label="UInt32"), "dmReserved2": SimTypeInt(signed=False, label="UInt32"), "dmPanningWidth": SimTypeInt(signed=False, label="UInt32"), "dmPanningHeight": SimTypeInt(signed=False, label="UInt32")}, name="DEVMODEA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pDevmode", "DevmodeSize"]),
        #
        'IsValidDevmodeW': SimTypeFunction([SimTypePointer(SimStruct({"dmDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dmSpecVersion": SimTypeShort(signed=False, label="UInt16"), "dmDriverVersion": SimTypeShort(signed=False, label="UInt16"), "dmSize": SimTypeShort(signed=False, label="UInt16"), "dmDriverExtra": SimTypeShort(signed=False, label="UInt16"), "dmFields": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"dmOrientation": SimTypeShort(signed=True, label="Int16"), "dmPaperSize": SimTypeShort(signed=True, label="Int16"), "dmPaperLength": SimTypeShort(signed=True, label="Int16"), "dmPaperWidth": SimTypeShort(signed=True, label="Int16"), "dmScale": SimTypeShort(signed=True, label="Int16"), "dmCopies": SimTypeShort(signed=True, label="Int16"), "dmDefaultSource": SimTypeShort(signed=True, label="Int16"), "dmPrintQuality": SimTypeShort(signed=True, label="Int16")}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"dmPosition": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "dmDisplayOrientation": SimTypeInt(signed=False, label="UInt32"), "dmDisplayFixedOutput": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "dmColor": SimTypeShort(signed=True, label="Int16"), "dmDuplex": SimTypeShort(signed=True, label="Int16"), "dmYResolution": SimTypeShort(signed=True, label="Int16"), "dmTTOption": SimTypeShort(signed=True, label="Int16"), "dmCollate": SimTypeShort(signed=True, label="Int16"), "dmFormName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dmLogPixels": SimTypeShort(signed=False, label="UInt16"), "dmBitsPerPel": SimTypeInt(signed=False, label="UInt32"), "dmPelsWidth": SimTypeInt(signed=False, label="UInt32"), "dmPelsHeight": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"dmDisplayFlags": SimTypeInt(signed=False, label="UInt32"), "dmNup": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "dmDisplayFrequency": SimTypeInt(signed=False, label="UInt32"), "dmICMMethod": SimTypeInt(signed=False, label="UInt32"), "dmICMIntent": SimTypeInt(signed=False, label="UInt32"), "dmMediaType": SimTypeInt(signed=False, label="UInt32"), "dmDitherType": SimTypeInt(signed=False, label="UInt32"), "dmReserved1": SimTypeInt(signed=False, label="UInt32"), "dmReserved2": SimTypeInt(signed=False, label="UInt32"), "dmPanningWidth": SimTypeInt(signed=False, label="UInt32"), "dmPanningHeight": SimTypeInt(signed=False, label="UInt32")}, name="DEVMODEW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pDevmode", "DevmodeSize"]),
        #
        'OpenPrinter2A': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimStruct({"pDatatype": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pDevMode": SimTypePointer(SimTypeBottom(label="DEVMODEA"), offset=0), "DesiredAccess": SimTypeInt(signed=False, label="UInt32")}, name="PRINTER_DEFAULTSA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32")}, name="PRINTER_OPTIONSA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pPrinterName", "phPrinter", "pDefault", "pOptions"]),
        #
        'OpenPrinter2W': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimStruct({"pDatatype": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pDevMode": SimTypePointer(SimTypeBottom(label="DEVMODEW"), offset=0), "DesiredAccess": SimTypeInt(signed=False, label="UInt32")}, name="PRINTER_DEFAULTSW", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32")}, name="PRINTER_OPTIONSW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pPrinterName", "phPrinter", "pDefault", "pOptions"]),
        #
        'AddPrinterConnection2A': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hWnd", "pszName", "dwLevel", "pConnectionInfo"]),
        #
        'AddPrinterConnection2W': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hWnd", "pszName", "dwLevel", "pConnectionInfo"]),
        #
        'InstallPrinterDriverFromPackageA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszServer", "pszInfPath", "pszDriverName", "pszEnvironment", "dwFlags"]),
        #
        'InstallPrinterDriverFromPackageW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszServer", "pszInfPath", "pszDriverName", "pszEnvironment", "dwFlags"]),
        #
        'UploadPrinterDriverPackageA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszServer", "pszInfPath", "pszEnvironment", "dwFlags", "hwnd", "pszDestInfPath", "pcchDestInfPath"]),
        #
        'UploadPrinterDriverPackageW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszServer", "pszInfPath", "pszEnvironment", "dwFlags", "hwnd", "pszDestInfPath", "pcchDestInfPath"]),
        #
        'GetCorePrinterDriversA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"CoreDriverGUID": SimTypeBottom(label="Guid"), "ftDriverDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "dwlDriverVersion": SimTypeLongLong(signed=False, label="UInt64"), "szPackageID": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 260)}, name="CORE_PRINTER_DRIVERA", pack=False, align=None), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszServer", "pszEnvironment", "pszzCoreDriverDependencies", "cCorePrinterDrivers", "pCorePrinterDrivers"]),
        #
        'GetCorePrinterDriversW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"CoreDriverGUID": SimTypeBottom(label="Guid"), "ftDriverDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "dwlDriverVersion": SimTypeLongLong(signed=False, label="UInt64"), "szPackageID": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260)}, name="CORE_PRINTER_DRIVERW", pack=False, align=None), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszServer", "pszEnvironment", "pszzCoreDriverDependencies", "cCorePrinterDrivers", "pCorePrinterDrivers"]),
        #
        'CorePrinterDriverInstalledA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeBottom(label="Guid"), SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszServer", "pszEnvironment", "CoreDriverGUID", "ftDriverDate", "dwlDriverVersion", "pbDriverInstalled"]),
        #
        'CorePrinterDriverInstalledW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeBottom(label="Guid"), SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszServer", "pszEnvironment", "CoreDriverGUID", "ftDriverDate", "dwlDriverVersion", "pbDriverInstalled"]),
        #
        'GetPrinterDriverPackagePathA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszServer", "pszEnvironment", "pszLanguage", "pszPackageID", "pszDriverPackageCab", "cchDriverPackageCab", "pcchRequiredSize"]),
        #
        'GetPrinterDriverPackagePathW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszServer", "pszEnvironment", "pszLanguage", "pszPackageID", "pszDriverPackageCab", "cchDriverPackageCab", "pcchRequiredSize"]),
        #
        'DeletePrinterDriverPackageA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszServer", "pszInfPath", "pszEnvironment"]),
        #
        'DeletePrinterDriverPackageW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszServer", "pszInfPath", "pszEnvironment"]),
        #
        'ReportJobProcessingProgress': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="EPrintXPSJobOperation"), SimTypeInt(signed=False, label="EPrintXPSJobProgress")], SimTypeInt(signed=True, label="Int32"), arg_names=["printerHandle", "jobId", "jobOperation", "jobProgress"]),
        #
        'GetPrinterDriver2A': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hWnd", "hPrinter", "pEnvironment", "Level", "pDriverInfo", "cbBuf", "pcbNeeded"]),
        #
        'GetPrinterDriver2W': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hWnd", "hPrinter", "pEnvironment", "Level", "pDriverInfo", "cbBuf", "pcbNeeded"]),
        #
        'GetPrintExecutionData': SimTypeFunction([SimTypePointer(SimStruct({"context": SimTypeInt(signed=False, label="PRINT_EXECUTION_CONTEXT"), "clientAppPID": SimTypeInt(signed=False, label="UInt32")}, name="PRINT_EXECUTION_DATA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pData"]),
        #
        'GetJobNamedPropertyValue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ePropertyType": SimTypeInt(signed=False, label="EPrintPropertyType"), "value": SimUnion({"propertyByte": SimTypeChar(label="Byte"), "propertyString": SimTypePointer(SimTypeChar(label="Char"), offset=0), "propertyInt32": SimTypeInt(signed=True, label="Int32"), "propertyInt64": SimTypeLongLong(signed=True, label="Int64"), "propertyBlob": SimStruct({"cbBuf": SimTypeInt(signed=False, label="UInt32"), "pBuf": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="_propertyBlob_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="PrintPropertyValue", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hPrinter", "JobId", "pszName", "pValue"]),
        #
        'FreePrintPropertyValue': SimTypeFunction([SimTypePointer(SimStruct({"ePropertyType": SimTypeInt(signed=False, label="EPrintPropertyType"), "value": SimUnion({"propertyByte": SimTypeChar(label="Byte"), "propertyString": SimTypePointer(SimTypeChar(label="Char"), offset=0), "propertyInt32": SimTypeInt(signed=True, label="Int32"), "propertyInt64": SimTypeLongLong(signed=True, label="Int64"), "propertyBlob": SimStruct({"cbBuf": SimTypeInt(signed=False, label="UInt32"), "pBuf": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="_propertyBlob_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="PrintPropertyValue", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pValue"]),
        #
        'FreePrintNamedPropertyArray': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"propertyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "propertyValue": SimStruct({"ePropertyType": SimTypeInt(signed=False, label="EPrintPropertyType"), "value": SimUnion({"propertyByte": SimTypeChar(label="Byte"), "propertyString": SimTypePointer(SimTypeChar(label="Char"), offset=0), "propertyInt32": SimTypeInt(signed=True, label="Int32"), "propertyInt64": SimTypeLongLong(signed=True, label="Int64"), "propertyBlob": SimStruct({"cbBuf": SimTypeInt(signed=False, label="UInt32"), "pBuf": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="_propertyBlob_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="PrintPropertyValue", pack=False, align=None)}, name="PrintNamedProperty", pack=False, align=None), offset=0), label="LPArray", offset=0)], SimTypeBottom(label="Void"), arg_names=["cProperties", "ppProperties"]),
        #
        'SetJobNamedProperty': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"propertyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "propertyValue": SimStruct({"ePropertyType": SimTypeInt(signed=False, label="EPrintPropertyType"), "value": SimUnion({"propertyByte": SimTypeChar(label="Byte"), "propertyString": SimTypePointer(SimTypeChar(label="Char"), offset=0), "propertyInt32": SimTypeInt(signed=True, label="Int32"), "propertyInt64": SimTypeLongLong(signed=True, label="Int64"), "propertyBlob": SimStruct({"cbBuf": SimTypeInt(signed=False, label="UInt32"), "pBuf": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="_propertyBlob_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="PrintPropertyValue", pack=False, align=None)}, name="PrintNamedProperty", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hPrinter", "JobId", "pProperty"]),
        #
        'DeleteJobNamedProperty': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hPrinter", "JobId", "pszName"]),
        #
        'EnumJobNamedProperties': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"propertyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "propertyValue": SimStruct({"ePropertyType": SimTypeInt(signed=False, label="EPrintPropertyType"), "value": SimUnion({"propertyByte": SimTypeChar(label="Byte"), "propertyString": SimTypePointer(SimTypeChar(label="Char"), offset=0), "propertyInt32": SimTypeInt(signed=True, label="Int32"), "propertyInt64": SimTypeLongLong(signed=True, label="Int64"), "propertyBlob": SimStruct({"cbBuf": SimTypeInt(signed=False, label="UInt32"), "pBuf": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="_propertyBlob_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="PrintPropertyValue", pack=False, align=None)}, name="PrintNamedProperty", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hPrinter", "JobId", "pcProperties", "ppProperties"]),
        #
        'GetPrintOutputInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hWnd", "pszPrinter", "phFile", "ppszOutputFile"]),
        #
        'DevQueryPrintEx': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeShort(signed=False, label="UInt16"), "Level": SimTypeShort(signed=False, label="UInt16"), "hPrinter": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pDevMode": SimTypePointer(SimTypeBottom(label="DEVMODEA"), offset=0), "pszErrorStr": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cchErrorStr": SimTypeInt(signed=False, label="UInt32"), "cchNeeded": SimTypeInt(signed=False, label="UInt32")}, name="DEVQUERYPRINT_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pDQPInfo"]),
        #
        'RegisterForPrintAsyncNotifications': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="PrintAsyncNotifyUserFilter"), SimTypeInt(signed=False, label="PrintAsyncNotifyConversationStyle"), SimTypeBottom(label="IPrintAsyncNotifyCallback"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszName", "pNotificationType", "eUserFilter", "eConversationStyle", "pCallback", "phNotify"]),
        #
        'UnRegisterForPrintAsyncNotifications': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]),
        #
        'CreatePrintAsyncNotifyChannel': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="PrintAsyncNotifyUserFilter"), SimTypeInt(signed=False, label="PrintAsyncNotifyConversationStyle"), SimTypeBottom(label="IPrintAsyncNotifyCallback"), SimTypePointer(SimTypeBottom(label="IPrintAsyncNotifyChannel"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszName", "pNotificationType", "eUserFilter", "eConversationStyle", "pCallback", "ppIAsynchNotification"]),
        #
        'CreatePrinterIC': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"dmDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dmSpecVersion": SimTypeShort(signed=False, label="UInt16"), "dmDriverVersion": SimTypeShort(signed=False, label="UInt16"), "dmSize": SimTypeShort(signed=False, label="UInt16"), "dmDriverExtra": SimTypeShort(signed=False, label="UInt16"), "dmFields": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"dmOrientation": SimTypeShort(signed=True, label="Int16"), "dmPaperSize": SimTypeShort(signed=True, label="Int16"), "dmPaperLength": SimTypeShort(signed=True, label="Int16"), "dmPaperWidth": SimTypeShort(signed=True, label="Int16"), "dmScale": SimTypeShort(signed=True, label="Int16"), "dmCopies": SimTypeShort(signed=True, label="Int16"), "dmDefaultSource": SimTypeShort(signed=True, label="Int16"), "dmPrintQuality": SimTypeShort(signed=True, label="Int16")}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"dmPosition": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "dmDisplayOrientation": SimTypeInt(signed=False, label="UInt32"), "dmDisplayFixedOutput": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "dmColor": SimTypeShort(signed=True, label="Int16"), "dmDuplex": SimTypeShort(signed=True, label="Int16"), "dmYResolution": SimTypeShort(signed=True, label="Int16"), "dmTTOption": SimTypeShort(signed=True, label="Int16"), "dmCollate": SimTypeShort(signed=True, label="Int16"), "dmFormName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dmLogPixels": SimTypeShort(signed=False, label="UInt16"), "dmBitsPerPel": SimTypeInt(signed=False, label="UInt32"), "dmPelsWidth": SimTypeInt(signed=False, label="UInt32"), "dmPelsHeight": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"dmDisplayFlags": SimTypeInt(signed=False, label="UInt32"), "dmNup": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "dmDisplayFrequency": SimTypeInt(signed=False, label="UInt32"), "dmICMMethod": SimTypeInt(signed=False, label="UInt32"), "dmICMIntent": SimTypeInt(signed=False, label="UInt32"), "dmMediaType": SimTypeInt(signed=False, label="UInt32"), "dmDitherType": SimTypeInt(signed=False, label="UInt32"), "dmReserved1": SimTypeInt(signed=False, label="UInt32"), "dmReserved2": SimTypeInt(signed=False, label="UInt32"), "dmPanningWidth": SimTypeInt(signed=False, label="UInt32"), "dmPanningHeight": SimTypeInt(signed=False, label="UInt32")}, name="DEVMODEW", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hPrinter", "pDevMode"]),
        #
        'PlayGdiScriptOnPrinterIC': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinterIC", "pIn", "cIn", "pOut", "cOut", "ul"]),
        #
        'DeletePrinterIC': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinterIC"]),
        #
        'DevQueryPrint': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"dmDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "dmSpecVersion": SimTypeShort(signed=False, label="UInt16"), "dmDriverVersion": SimTypeShort(signed=False, label="UInt16"), "dmSize": SimTypeShort(signed=False, label="UInt16"), "dmDriverExtra": SimTypeShort(signed=False, label="UInt16"), "dmFields": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"dmOrientation": SimTypeShort(signed=True, label="Int16"), "dmPaperSize": SimTypeShort(signed=True, label="Int16"), "dmPaperLength": SimTypeShort(signed=True, label="Int16"), "dmPaperWidth": SimTypeShort(signed=True, label="Int16"), "dmScale": SimTypeShort(signed=True, label="Int16"), "dmCopies": SimTypeShort(signed=True, label="Int16"), "dmDefaultSource": SimTypeShort(signed=True, label="Int16"), "dmPrintQuality": SimTypeShort(signed=True, label="Int16")}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"dmPosition": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "dmDisplayOrientation": SimTypeInt(signed=False, label="UInt32"), "dmDisplayFixedOutput": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "dmColor": SimTypeShort(signed=True, label="Int16"), "dmDuplex": SimTypeShort(signed=True, label="Int16"), "dmYResolution": SimTypeShort(signed=True, label="Int16"), "dmTTOption": SimTypeShort(signed=True, label="Int16"), "dmCollate": SimTypeShort(signed=True, label="Int16"), "dmFormName": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "dmLogPixels": SimTypeShort(signed=False, label="UInt16"), "dmBitsPerPel": SimTypeInt(signed=False, label="UInt32"), "dmPelsWidth": SimTypeInt(signed=False, label="UInt32"), "dmPelsHeight": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"dmDisplayFlags": SimTypeInt(signed=False, label="UInt32"), "dmNup": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "dmDisplayFrequency": SimTypeInt(signed=False, label="UInt32"), "dmICMMethod": SimTypeInt(signed=False, label="UInt32"), "dmICMIntent": SimTypeInt(signed=False, label="UInt32"), "dmMediaType": SimTypeInt(signed=False, label="UInt32"), "dmDitherType": SimTypeInt(signed=False, label="UInt32"), "dmReserved1": SimTypeInt(signed=False, label="UInt32"), "dmReserved2": SimTypeInt(signed=False, label="UInt32"), "dmPanningWidth": SimTypeInt(signed=False, label="UInt32"), "dmPanningHeight": SimTypeInt(signed=False, label="UInt32")}, name="DEVMODEA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrinter", "pDevMode", "pResID"]),
        #
        'RouterFreeBidiResponseContainer': SimTypeFunction([SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "Count": SimTypeInt(signed=False, label="UInt32"), "aData": SimTypePointer(SimStruct({"dwResult": SimTypeInt(signed=False, label="UInt32"), "dwReqNumber": SimTypeInt(signed=False, label="UInt32"), "pSchema": SimTypePointer(SimTypeChar(label="Char"), offset=0), "data": SimStruct({"dwBidiType": SimTypeInt(signed=False, label="UInt32"), "u": SimUnion({"bData": SimTypeInt(signed=True, label="Int32"), "iData": SimTypeInt(signed=True, label="Int32"), "sData": SimTypePointer(SimTypeChar(label="Char"), offset=0), "fData": SimTypeFloat(size=32), "biData": SimStruct({"cbBuf": SimTypeInt(signed=False, label="UInt32"), "pData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="BINARY_CONTAINER", pack=False, align=None)}, name="<anon>", label="None")}, name="BIDI_DATA", pack=False, align=None)}, name="BIDI_RESPONSE_DATA", pack=False, align=None), offset=0)}, name="BIDI_RESPONSE_CONTAINER", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pData"]),
        #
        'DeviceCapabilitiesA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="DEVICE_CAPABILITIES"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"dmDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "dmSpecVersion": SimTypeShort(signed=False, label="UInt16"), "dmDriverVersion": SimTypeShort(signed=False, label="UInt16"), "dmSize": SimTypeShort(signed=False, label="UInt16"), "dmDriverExtra": SimTypeShort(signed=False, label="UInt16"), "dmFields": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"dmOrientation": SimTypeShort(signed=True, label="Int16"), "dmPaperSize": SimTypeShort(signed=True, label="Int16"), "dmPaperLength": SimTypeShort(signed=True, label="Int16"), "dmPaperWidth": SimTypeShort(signed=True, label="Int16"), "dmScale": SimTypeShort(signed=True, label="Int16"), "dmCopies": SimTypeShort(signed=True, label="Int16"), "dmDefaultSource": SimTypeShort(signed=True, label="Int16"), "dmPrintQuality": SimTypeShort(signed=True, label="Int16")}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"dmPosition": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "dmDisplayOrientation": SimTypeInt(signed=False, label="UInt32"), "dmDisplayFixedOutput": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "dmColor": SimTypeShort(signed=True, label="Int16"), "dmDuplex": SimTypeShort(signed=True, label="Int16"), "dmYResolution": SimTypeShort(signed=True, label="Int16"), "dmTTOption": SimTypeShort(signed=True, label="Int16"), "dmCollate": SimTypeShort(signed=True, label="Int16"), "dmFormName": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "dmLogPixels": SimTypeShort(signed=False, label="UInt16"), "dmBitsPerPel": SimTypeInt(signed=False, label="UInt32"), "dmPelsWidth": SimTypeInt(signed=False, label="UInt32"), "dmPelsHeight": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"dmDisplayFlags": SimTypeInt(signed=False, label="UInt32"), "dmNup": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "dmDisplayFrequency": SimTypeInt(signed=False, label="UInt32"), "dmICMMethod": SimTypeInt(signed=False, label="UInt32"), "dmICMIntent": SimTypeInt(signed=False, label="UInt32"), "dmMediaType": SimTypeInt(signed=False, label="UInt32"), "dmDitherType": SimTypeInt(signed=False, label="UInt32"), "dmReserved1": SimTypeInt(signed=False, label="UInt32"), "dmReserved2": SimTypeInt(signed=False, label="UInt32"), "dmPanningWidth": SimTypeInt(signed=False, label="UInt32"), "dmPanningHeight": SimTypeInt(signed=False, label="UInt32")}, name="DEVMODEA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pDevice", "pPort", "fwCapability", "pOutput", "pDevMode"]),
        #
        'DeviceCapabilitiesW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="DEVICE_CAPABILITIES"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dmDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dmSpecVersion": SimTypeShort(signed=False, label="UInt16"), "dmDriverVersion": SimTypeShort(signed=False, label="UInt16"), "dmSize": SimTypeShort(signed=False, label="UInt16"), "dmDriverExtra": SimTypeShort(signed=False, label="UInt16"), "dmFields": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"dmOrientation": SimTypeShort(signed=True, label="Int16"), "dmPaperSize": SimTypeShort(signed=True, label="Int16"), "dmPaperLength": SimTypeShort(signed=True, label="Int16"), "dmPaperWidth": SimTypeShort(signed=True, label="Int16"), "dmScale": SimTypeShort(signed=True, label="Int16"), "dmCopies": SimTypeShort(signed=True, label="Int16"), "dmDefaultSource": SimTypeShort(signed=True, label="Int16"), "dmPrintQuality": SimTypeShort(signed=True, label="Int16")}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"dmPosition": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "dmDisplayOrientation": SimTypeInt(signed=False, label="UInt32"), "dmDisplayFixedOutput": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "dmColor": SimTypeShort(signed=True, label="Int16"), "dmDuplex": SimTypeShort(signed=True, label="Int16"), "dmYResolution": SimTypeShort(signed=True, label="Int16"), "dmTTOption": SimTypeShort(signed=True, label="Int16"), "dmCollate": SimTypeShort(signed=True, label="Int16"), "dmFormName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dmLogPixels": SimTypeShort(signed=False, label="UInt16"), "dmBitsPerPel": SimTypeInt(signed=False, label="UInt32"), "dmPelsWidth": SimTypeInt(signed=False, label="UInt32"), "dmPelsHeight": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"dmDisplayFlags": SimTypeInt(signed=False, label="UInt32"), "dmNup": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "dmDisplayFrequency": SimTypeInt(signed=False, label="UInt32"), "dmICMMethod": SimTypeInt(signed=False, label="UInt32"), "dmICMIntent": SimTypeInt(signed=False, label="UInt32"), "dmMediaType": SimTypeInt(signed=False, label="UInt32"), "dmDitherType": SimTypeInt(signed=False, label="UInt32"), "dmReserved1": SimTypeInt(signed=False, label="UInt32"), "dmReserved2": SimTypeInt(signed=False, label="UInt32"), "dmPanningWidth": SimTypeInt(signed=False, label="UInt32"), "dmPanningHeight": SimTypeInt(signed=False, label="UInt32")}, name="DEVMODEW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pDevice", "pPort", "fwCapability", "pOutput", "pDevMode"]),
    }

lib.set_prototypes(prototypes)
