/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.json;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.CustomField;
import net.sf.mpxj.DataType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectField;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Relation;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.CharsetHelper;
import net.sf.mpxj.json.JsonStreamWriter;
import net.sf.mpxj.writer.AbstractProjectWriter;

public final class JsonWriter
extends AbstractProjectWriter {
    private ProjectFile m_projectFile;
    private JsonStreamWriter m_writer;
    private boolean m_pretty;
    private Charset m_encoding = DEFAULT_ENCODING;
    private static final Charset DEFAULT_ENCODING = CharsetHelper.UTF8;
    private static Map<String, DataType> TYPE_MAP = new HashMap<String, DataType>();

    public boolean getPretty() {
        return this.m_pretty;
    }

    public void setPretty(boolean bl) {
        this.m_pretty = bl;
    }

    public Charset getEncoding() {
        return this.m_encoding;
    }

    public void setEncoding(Charset charset) {
        this.m_encoding = charset;
    }

    @Override
    public void write(ProjectFile projectFile, OutputStream outputStream) throws IOException {
        try {
            this.m_projectFile = projectFile;
            this.m_writer = new JsonStreamWriter(outputStream, this.m_encoding);
            this.m_writer.setPretty(this.m_pretty);
            this.m_writer.writeStartObject(null);
            this.writeCustomFields();
            this.writeProperties();
            this.writeResources();
            this.writeTasks();
            this.writeAssignments();
            this.m_writer.writeEndObject();
            this.m_writer.flush();
        }
        finally {
            this.m_projectFile = null;
        }
    }

    private void writeCustomFields() throws IOException {
        this.m_writer.writeStartList("custom_fields");
        for (CustomField customField : this.m_projectFile.getCustomFields()) {
            this.writeCustomField(customField);
        }
        this.m_writer.writeEndList();
    }

    private void writeCustomField(CustomField customField) throws IOException {
        if (customField.getAlias() != null) {
            this.m_writer.writeStartObject(null);
            this.m_writer.writeNameValuePair("field_type_class", customField.getFieldType().getFieldTypeClass().name().toLowerCase());
            this.m_writer.writeNameValuePair("field_type", customField.getFieldType().name().toLowerCase());
            this.m_writer.writeNameValuePair("field_alias", customField.getAlias());
            this.m_writer.writeEndObject();
        }
    }

    private void writeProperties() throws IOException {
        this.writeAttributeTypes("property_types", ProjectField.values());
        this.writeFields("property_values", this.m_projectFile.getProjectProperties(), ProjectField.values());
    }

    private void writeResources() throws IOException {
        this.writeAttributeTypes("resource_types", ResourceField.values());
        this.m_writer.writeStartList("resources");
        for (Resource resource : this.m_projectFile.getResources()) {
            this.writeFields(null, resource, ResourceField.values());
        }
        this.m_writer.writeEndList();
    }

    private void writeTasks() throws IOException {
        this.writeAttributeTypes("task_types", TaskField.values());
        this.m_writer.writeStartList("tasks");
        for (Task task : this.m_projectFile.getChildTasks()) {
            this.writeTask(task);
        }
        this.m_writer.writeEndList();
    }

    private void writeTask(Task task) throws IOException {
        this.writeFields(null, task, TaskField.values());
        for (Task task2 : task.getChildTasks()) {
            this.writeTask(task2);
        }
    }

    private void writeAssignments() throws IOException {
        this.writeAttributeTypes("assignment_types", AssignmentField.values());
        this.m_writer.writeStartList("assignments");
        for (ResourceAssignment resourceAssignment : this.m_projectFile.getResourceAssignments()) {
            this.writeFields(null, resourceAssignment, AssignmentField.values());
        }
        this.m_writer.writeEndList();
    }

    private void writeAttributeTypes(String string, FieldType[] fieldTypeArray) throws IOException {
        this.m_writer.writeStartObject(string);
        for (FieldType fieldType : fieldTypeArray) {
            this.m_writer.writeNameValuePair(fieldType.name().toLowerCase(), fieldType.getDataType().getValue());
        }
        this.m_writer.writeEndObject();
    }

    private void writeFields(String string, FieldContainer fieldContainer, FieldType[] fieldTypeArray) throws IOException {
        this.m_writer.writeStartObject(string);
        for (FieldType fieldType : fieldTypeArray) {
            Object object = fieldContainer.getCurrentValue(fieldType);
            if (object == null) continue;
            this.writeField(fieldType, object);
        }
        this.m_writer.writeEndObject();
    }

    private void writeField(FieldType fieldType, Object object) throws IOException {
        String string = fieldType.name().toLowerCase();
        this.writeField(string, fieldType.getDataType(), object);
    }

    private void writeField(String string, DataType dataType, Object object) throws IOException {
        switch (dataType) {
            case INTEGER: {
                this.writeIntegerField(string, object);
                break;
            }
            case PERCENTAGE: 
            case CURRENCY: 
            case NUMERIC: 
            case UNITS: {
                this.writeDoubleField(string, object);
                break;
            }
            case BOOLEAN: {
                this.writeBooleanField(string, object);
                break;
            }
            case WORK: 
            case DURATION: {
                this.writeDurationField(string, object);
                break;
            }
            case DATE: {
                this.writeDateField(string, object);
                break;
            }
            case TIME_UNITS: {
                this.writeTimeUnitsField(string, object);
                break;
            }
            case PRIORITY: {
                this.writePriorityField(string, object);
                break;
            }
            case RELATION_LIST: {
                this.writeRelationList(string, object);
                break;
            }
            case MAP: {
                this.writeMap(string, object);
                break;
            }
            case BINARY: {
                break;
            }
            default: {
                this.writeStringField(string, object);
            }
        }
    }

    private void writeIntegerField(String string, Object object) throws IOException {
        int n = ((Number)object).intValue();
        if (n != 0) {
            this.m_writer.writeNameValuePair(string, n);
        }
    }

    private void writeDoubleField(String string, Object object) throws IOException {
        double d = ((Number)object).doubleValue();
        if (d != 0.0) {
            this.m_writer.writeNameValuePair(string, d);
        }
    }

    private void writeBooleanField(String string, Object object) throws IOException {
        boolean bl = (Boolean)object;
        if (bl) {
            this.m_writer.writeNameValuePair(string, bl);
        }
    }

    private void writeDurationField(String string, Object object) throws IOException {
        if (object instanceof String) {
            this.m_writer.writeNameValuePair(string + "_text", (String)object);
        } else {
            Duration duration = (Duration)object;
            if (duration.getDuration() != 0.0) {
                Duration duration2 = duration.convertUnits(TimeUnit.MINUTES, this.m_projectFile.getProjectProperties());
                long l = (long)(duration2.getDuration() * 60.0);
                this.m_writer.writeNameValuePair(string, l);
            }
        }
    }

    private void writeDateField(String string, Object object) throws IOException {
        if (object instanceof String) {
            this.m_writer.writeNameValuePair(string + "_text", (String)object);
        } else {
            Date date = (Date)object;
            this.m_writer.writeNameValuePair(string, date);
        }
    }

    private void writeTimeUnitsField(String string, Object object) throws IOException {
        TimeUnit timeUnit = (TimeUnit)object;
        if (timeUnit != this.m_projectFile.getProjectProperties().getDefaultDurationUnits()) {
            this.m_writer.writeNameValuePair(string, timeUnit.toString());
        }
    }

    private void writePriorityField(String string, Object object) throws IOException {
        this.m_writer.writeNameValuePair(string, ((Priority)object).getValue());
    }

    private void writeMap(String string, Object object) throws IOException {
        Map map = (Map)object;
        this.m_writer.writeStartObject(string);
        for (Map.Entry entry : map.entrySet()) {
            Object object2 = entry.getValue();
            if (object2 == null) continue;
            DataType dataType = TYPE_MAP.get(object2.getClass().getName());
            if (dataType == null) {
                dataType = DataType.STRING;
                object2 = object2.toString();
            }
            this.writeField((String)entry.getKey(), dataType, object2);
        }
        this.m_writer.writeEndObject();
    }

    private void writeStringField(String string, Object object) throws IOException {
        String string2 = object.toString();
        if (!string2.isEmpty()) {
            this.m_writer.writeNameValuePair(string, string2);
        }
    }

    private void writeRelationList(String string, Object object) throws IOException {
        List list = (List)object;
        if (!list.isEmpty()) {
            this.m_writer.writeStartList(string);
            for (Relation relation : list) {
                this.m_writer.writeStartObject(null);
                this.writeIntegerField("task_unique_id", relation.getTargetTask().getUniqueID());
                this.writeDurationField("lag", relation.getLag());
                this.writeStringField("type", relation.getType());
                this.m_writer.writeEndObject();
            }
            this.m_writer.writeEndList();
        }
    }

    static {
        TYPE_MAP.put(Boolean.class.getName(), DataType.BOOLEAN);
        TYPE_MAP.put(Date.class.getName(), DataType.DATE);
        TYPE_MAP.put(Double.class.getName(), DataType.NUMERIC);
        TYPE_MAP.put(Duration.class.getName(), DataType.DURATION);
        TYPE_MAP.put(Integer.class.getName(), DataType.INTEGER);
    }
}

