/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.explorer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class PoiTreeModel
implements TreeModel {
    private final EventListenerList m_listenerList = new EventListenerList();
    private POIFSFileSystem m_file;

    public void setFile(POIFSFileSystem pOIFSFileSystem) {
        this.m_file = pOIFSFileSystem;
        this.fireTreeStructureChanged();
    }

    @Override
    public Object getRoot() {
        DirectoryNode directoryNode = null;
        if (this.m_file != null) {
            directoryNode = this.m_file.getRoot();
        }
        return directoryNode;
    }

    @Override
    public Object getChild(Object object, int n) {
        List<Entry> list;
        Entry entry = null;
        if (object instanceof DirectoryEntry && (list = this.getChildNodes((DirectoryEntry)object)).size() > n) {
            entry = list.get(n);
        }
        return entry;
    }

    @Override
    public int getChildCount(Object object) {
        int n;
        if (object instanceof DirectoryEntry) {
            DirectoryEntry directoryEntry = (DirectoryEntry)object;
            n = directoryEntry.getEntryCount();
        } else {
            n = 0;
        }
        return n;
    }

    @Override
    public boolean isLeaf(Object object) {
        return !(object instanceof DirectoryEntry);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        int n = -1;
        if (object instanceof DirectoryEntry) {
            List<Entry> list = this.getChildNodes((DirectoryEntry)object);
            n = list.indexOf(object2);
        }
        return n;
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.m_listenerList.add(TreeModelListener.class, treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.m_listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    private List<Entry> getChildNodes(DirectoryEntry directoryEntry) {
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        Iterator<Entry> iterator = directoryEntry.getEntries();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    private void fireTreeStructureChanged() {
        Object[] objectArray = this.m_listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(this.getRoot(), new Object[]{this.getRoot()}, null, null);
            }
            ((TreeModelListener)objectArray[i + 1]).treeStructureChanged(treeModelEvent);
        }
    }
}

