<?php
/**
 * French language strings.
 *
 * This file is part of ADOdb, a Database Abstraction Layer library for PHP.
 *
 * @package ADOdb
 * @link https://adodb.org Project's web site and documentation
 * @link https://github.com/ADOdb/ADOdb Source code and issue tracker
 *
 * The ADOdb Library is dual-licensed, released under both the BSD 3-Clause
 * and the GNU Lesser General Public Licence (LGPL) v2.1 or, at your option,
 * any later version. This means you can use it in proprietary products.
 * See the LICENSE.md file distributed with this source code for details.
 * @license BSD-3-Clause
 * @license LGPL-2.1-or-later
 *
 * @copyright 2000-2013 John Lim
 * @copyright 2014 Damien Regad, Mark Newnham and the ADOdb community
 */

$ADODB_LANG_ARRAY = array (
	'LANG'                      => 'fr',
	DB_ERROR                    => 'erreur inconnue',
	DB_ERROR_ALREADY_EXISTS     => 'existe déjà',
	DB_ERROR_CANNOT_CREATE      => 'création impossible',
	DB_ERROR_CANNOT_DELETE      => 'effacement impossible',
	DB_ERROR_CANNOT_DROP        => 'suppression impossible',
	DB_ERROR_CONSTRAINT         => 'violation de contrainte',
	DB_ERROR_DIVZERO            => 'division par zéro',
	DB_ERROR_INVALID            => 'invalide',
	DB_ERROR_INVALID_DATE       => 'date ou heure invalide',
	DB_ERROR_INVALID_NUMBER     => 'nombre invalide',
	DB_ERROR_MISMATCH           => 'erreur de concordance',
	DB_ERROR_NODBSELECTED       => 'pas de base de données sélectionnée',
	DB_ERROR_NOSUCHFIELD        => 'nom de colonne invalide',
	DB_ERROR_NOSUCHTABLE        => 'table ou vue inexistante',
	DB_ERROR_NOT_CAPABLE        => 'fonction optionnelle non installée',
	DB_ERROR_NOT_FOUND          => 'pas trouvé',
	DB_ERROR_NOT_LOCKED         => 'non verrouillé',
	DB_ERROR_SYNTAX             => 'erreur de syntaxe',
	DB_ERROR_UNSUPPORTED        => 'non supporté',
	DB_ERROR_VALUE_COUNT_ON_ROW => 'valeur insérée trop grande pour colonne',
	DB_ERROR_INVALID_DSN        => 'DSN invalide',
	DB_ERROR_CONNECT_FAILED     => 'échec à la connexion',
	0                        => "pas d'erreur", // DB_OK
	DB_ERROR_NEED_MORE_DATA     => 'données fournies insuffisantes',
	DB_ERROR_EXTENSION_NOT_FOUND=> 'extension non trouvée',
	DB_ERROR_NOSUCHDB           => 'base de données inconnue',
	DB_ERROR_ACCESS_VIOLATION   => 'droits insuffisants'
);
