/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.transaction.backend.jta.internal;

import jakarta.transaction.NotSupportedException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.exception.internal.SQLStateConversionDelegate;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ExceptionHelper;
import org.hibernate.jdbc.WorkExecutor;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.hibernate.resource.jdbc.spi.JdbcSessionOwner;
import org.hibernate.resource.transaction.spi.IsolationDelegate;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorOwner;

public class JtaIsolationDelegate
implements IsolationDelegate {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(JtaIsolationDelegate.class);
    private final JdbcConnectionAccess connectionAccess;
    private final BiFunction<SQLException, String, JDBCException> sqlExceptionConverter;
    private final TransactionManager transactionManager;

    public JtaIsolationDelegate(TransactionCoordinatorOwner transactionCoordinatorOwner, TransactionManager transactionManager) {
        this(transactionCoordinatorOwner.getJdbcSessionOwner(), transactionManager);
    }

    public JtaIsolationDelegate(JdbcSessionOwner jdbcSessionOwner, TransactionManager transactionManager) {
        this(jdbcSessionOwner.getJdbcConnectionAccess(), jdbcSessionOwner.getSqlExceptionHelper(), transactionManager);
    }

    public JtaIsolationDelegate(JdbcConnectionAccess connectionAccess, SqlExceptionHelper sqlExceptionConverter, TransactionManager transactionManager) {
        this.connectionAccess = connectionAccess;
        this.transactionManager = transactionManager;
        if (sqlExceptionConverter != null) {
            this.sqlExceptionConverter = sqlExceptionConverter::convert;
        } else {
            SQLStateConversionDelegate delegate = new SQLStateConversionDelegate(() -> {
                throw new AssertionFailure("Unexpected call to ConversionContext.getViolatedConstraintNameExtractor");
            });
            this.sqlExceptionConverter = (sqlException, message) -> delegate.convert((SQLException)sqlException, (String)message, null);
        }
    }

    private JdbcConnectionAccess jdbcConnectionAccess() {
        return this.connectionAccess;
    }

    private BiFunction<SQLException, String, JDBCException> sqlExceptionConverter() {
        return this.sqlExceptionConverter;
    }

    @Override
    public <T> T delegateWork(WorkExecutorVisitable<T> work, boolean transacted) throws HibernateException {
        return (T)this.doInSuspendedTransaction(() -> transacted ? this.doInNewTransaction(() -> this.doTheWork(work), this.transactionManager) : this.doTheWork(work));
    }

    @Override
    public <T> T delegateCallable(Callable<T> callable, boolean transacted) throws HibernateException {
        return (T)this.doInSuspendedTransaction(() -> transacted ? this.doInNewTransaction(() -> JtaIsolationDelegate.call(callable), this.transactionManager) : JtaIsolationDelegate.call(callable));
    }

    private static <T> T call(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HibernateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T doInSuspendedTransaction(HibernateCallable<T> callable) {
        Object originalException = null;
        try {
            Transaction surroundingTransaction = this.transactionManager.suspend();
            if (surroundingTransaction != null) {
                LOG.debugf("Surrounding JTA transaction suspended [%s]", surroundingTransaction);
            }
            try {
                T t = callable.call();
                return t;
            }
            catch (Throwable t1) {
                originalException = t1;
            }
            finally {
                try {
                    if (surroundingTransaction != null) {
                        this.transactionManager.resume(surroundingTransaction);
                        LOG.debugf("Surrounding JTA transaction resumed [%s]", surroundingTransaction);
                    }
                }
                catch (Throwable t2) {
                    if (originalException == null) {
                        originalException = new HibernateException("Unable to resume previously suspended transaction", t2);
                    }
                    ((Throwable)originalException).addSuppressed(t2);
                }
            }
        }
        catch (SystemException e) {
            originalException = new HibernateException("Unable to suspend current JTA transaction", e);
        }
        ExceptionHelper.doThrow((Throwable)originalException);
        return null;
    }

    private <T> T doInNewTransaction(HibernateCallable<T> callable, TransactionManager transactionManager) {
        try {
            transactionManager.begin();
            try {
                T result = callable.call();
                transactionManager.commit();
                return result;
            }
            catch (Exception e) {
                try {
                    transactionManager.rollback();
                }
                catch (Exception exception) {
                    LOG.unableToRollbackIsolatedTransaction(e, exception);
                }
                throw new HibernateException("Could not apply work", e);
            }
        }
        catch (NotSupportedException | SystemException e) {
            throw new HibernateException("Unable to start isolated transaction", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T doTheWork(WorkExecutorVisitable<T> work) {
        try {
            Connection connection = this.jdbcConnectionAccess().obtainConnection();
            try {
                Object t = work.accept(new WorkExecutor(), connection);
                return t;
            }
            catch (HibernateException e) {
                throw e;
            }
            catch (Exception e) {
                throw new HibernateException("Unable to perform isolated work", e);
            }
            finally {
                try {
                    this.jdbcConnectionAccess().releaseConnection(connection);
                }
                catch (Throwable throwable) {
                    LOG.unableToReleaseIsolatedConnection(throwable);
                }
            }
        }
        catch (SQLException e) {
            throw this.sqlExceptionConverter().apply(e, "unable to obtain isolated JDBC connection");
        }
    }

    private static interface HibernateCallable<T> {
        public T call() throws HibernateException;
    }
}

