/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.processor.generation.filters;

import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.RestResponse;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.server.SimpleResourceInfo;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.filters.FilterUtil;
import org.jboss.resteasy.reactive.server.filters.PreventAbortResteasyReactiveContainerRequestContext;
import org.jboss.resteasy.reactive.server.jaxrs.HttpHeadersImpl;
import org.jboss.resteasy.reactive.server.mapping.RuntimeResource;
import org.jboss.resteasy.reactive.server.processor.generation.multipart.GeneratorUtils;
import org.jboss.resteasy.reactive.server.processor.util.KotlinUtils;
import org.jboss.resteasy.reactive.server.processor.util.ResteasyReactiveServerDotNames;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveContainerRequestContext;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveContainerRequestFilter;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveContainerResponseFilter;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

final class CustomFilterGenerator {
    private static final String ABSTRACT_SUSPENDED_REQ_FILTER = "org.jboss.resteasy.reactive.server.runtime.kotlin.AbstractSuspendedRequestFilter";
    private static final String ABSTRACT_SUSPENDED_RES_FILTER = "org.jboss.resteasy.reactive.server.runtime.kotlin.AbstractSuspendedResponseFilter";
    private final Set<DotName> unwrappableTypes;
    private final Set<String> additionalBeanAnnotations;
    private final Predicate<MethodInfo> isOptionalFilter;

    CustomFilterGenerator(Set<DotName> unwrappableTypes, Set<String> additionalBeanAnnotations, Predicate<MethodInfo> isOptionalFilter) {
        this.unwrappableTypes = unwrappableTypes;
        this.additionalBeanAnnotations = additionalBeanAnnotations;
        this.isOptionalFilter = isOptionalFilter;
    }

    String generateContainerRequestFilter(MethodInfo targetMethod, ClassOutput classOutput) {
        this.checkModifiers(targetMethod, ResteasyReactiveServerDotNames.SERVER_REQUEST_FILTER);
        if (KotlinUtils.isSuspendMethod(targetMethod)) {
            return this.generateRequestFilterForSuspendedMethod(targetMethod, classOutput, this.isOptionalFilter.test(targetMethod));
        }
        return this.generateStandardRequestFilter(targetMethod, classOutput, this.isOptionalFilter.test(targetMethod));
    }

    private String generateRequestFilterForSuspendedMethod(MethodInfo targetMethod, ClassOutput classOutput, boolean checkForOptionalBean) {
        ReturnType returnType;
        DotName returnDotName = this.determineReturnDotNameOfSuspendMethod(targetMethod);
        if (returnDotName.equals((Object)ResteasyReactiveDotNames.VOID)) {
            returnType = ReturnType.VOID;
        } else if (returnDotName.equals((Object)ResteasyReactiveDotNames.RESPONSE)) {
            returnType = ReturnType.RESPONSE;
        } else if (returnDotName.equals((Object)ResteasyReactiveDotNames.REST_RESPONSE)) {
            returnType = ReturnType.REST_RESPONSE;
        } else {
            throw new RuntimeException("Suspend method '" + targetMethod.name() + " of class '" + String.valueOf(targetMethod.declaringClass().name()) + "' cannot be used as a request filter as it does not declare 'void', 'Response', 'RestResponse' as its return type.");
        }
        String generatedClassName = this.getGeneratedClassName(targetMethod, ResteasyReactiveServerDotNames.SERVER_REQUEST_FILTER);
        ClassInfo declaringClass = targetMethod.declaringClass();
        DotName declaringClassName = declaringClass.name();
        try (ClassCreator cc = ClassCreator.builder().classOutput(classOutput).className(generatedClassName).superClass(ABSTRACT_SUSPENDED_REQ_FILTER).build();){
            FieldDescriptor delegateField = this.generateConstructorAndDelegateField(cc, declaringClass, ABSTRACT_SUSPENDED_REQ_FILTER, this.additionalBeanAnnotations, checkForOptionalBean);
            MethodCreator doFilterMethod = cc.getMethodCreator("doFilter", Object.class.getName(), new String[]{ResteasyReactiveContainerRequestContext.class.getName(), ResteasyReactiveDotNames.CONTINUATION.toString()});
            ResultHandle delegate = doFilterMethod.readInstanceField(delegateField, doFilterMethod.getThis());
            if (checkForOptionalBean) {
                doFilterMethod.ifNull(delegate).trueBranch().returnNull();
            }
            ResultHandle resultHandle = doFilterMethod.invokeVirtualMethod(targetMethod, delegate, this.getRequestFilterResultHandles(targetMethod, declaringClassName, doFilterMethod, 2, this.getRRReqCtxHandle(doFilterMethod, this.getRRContainerReqCtxHandle(doFilterMethod, 0))));
            doFilterMethod.returnValue(resultHandle);
            MethodCreator handleResultMethod = cc.getMethodCreator("handleResult", Void.TYPE, new Class[]{ResteasyReactiveContainerRequestContext.class, Uni.class});
            handleResultMethod.invokeStaticMethod(MethodDescriptor.ofMethod(FilterUtil.class, (String)(switch (returnType) {
                case ReturnType.VOID -> "handleUniVoid";
                case ReturnType.RESPONSE -> "handleUniResponse";
                case ReturnType.REST_RESPONSE -> "handleUniRestResponse";
                default -> throw new IllegalStateException("ReturnType: '" + String.valueOf((Object)returnType) + "' is not supported, in method " + String.valueOf(targetMethod.declaringClass()) + "." + targetMethod.name());
            }), Void.TYPE, (Class[])new Class[]{Uni.class, ResteasyReactiveContainerRequestContext.class}), new ResultHandle[]{handleResultMethod.getMethodParam(1), this.getRRContainerReqCtxHandle(handleResultMethod, 0)});
            handleResultMethod.returnNull();
        }
        return generatedClassName;
    }

    private String generateStandardRequestFilter(MethodInfo targetMethod, ClassOutput classOutput, boolean checkForOptionalBean) {
        String generatedClassName;
        block24: {
            ReturnType returnType = this.determineRequestFilterReturnType(targetMethod);
            generatedClassName = this.getGeneratedClassName(targetMethod, ResteasyReactiveServerDotNames.SERVER_REQUEST_FILTER);
            ClassInfo declaringClass = targetMethod.declaringClass();
            DotName declaringClassName = declaringClass.name();
            try (ClassCreator cc = ClassCreator.builder().classOutput(classOutput).className(generatedClassName).interfaces(new Class[]{this.determineRequestInterfaceType(returnType)}).build();){
                FieldDescriptor delegateField = this.generateConstructorAndDelegateField(cc, declaringClass, Object.class.getName(), this.additionalBeanAnnotations, checkForOptionalBean);
                if (returnType == ReturnType.VOID || returnType == ReturnType.OPTIONAL_RESPONSE || returnType == ReturnType.OPTIONAL_REST_RESPONSE || returnType == ReturnType.RESPONSE || returnType == ReturnType.REST_RESPONSE) {
                    MethodCreator filterMethod = cc.getMethodCreator("filter", Void.TYPE, new Class[]{ContainerRequestContext.class});
                    ResultHandle delegate = filterMethod.readInstanceField(delegateField, filterMethod.getThis());
                    if (checkForOptionalBean) {
                        BytecodeCreator delegateIsNull = filterMethod.ifNull(delegate).trueBranch();
                        if (returnType == ReturnType.VOID) {
                            delegateIsNull.returnVoid();
                        } else {
                            delegateIsNull.returnNull();
                        }
                    }
                    ResultHandle rrContainerReqCtxHandle = this.getRRContainerReqCtxHandle(filterMethod, 0);
                    ResultHandle resultHandle = filterMethod.invokeVirtualMethod(targetMethod, delegate, this.getRequestFilterResultHandles(targetMethod, declaringClassName, filterMethod, 1, this.getRRReqCtxHandle(filterMethod, rrContainerReqCtxHandle)));
                    if (returnType == ReturnType.OPTIONAL_RESPONSE) {
                        filterMethod.invokeStaticMethod(MethodDescriptor.ofMethod(FilterUtil.class, (String)"handleOptional", Void.TYPE, (Class[])new Class[]{Optional.class, ResteasyReactiveContainerRequestContext.class}), new ResultHandle[]{resultHandle, rrContainerReqCtxHandle});
                    } else if (returnType == ReturnType.OPTIONAL_REST_RESPONSE) {
                        filterMethod.invokeStaticMethod(MethodDescriptor.ofMethod(FilterUtil.class, (String)"handleOptionalRestResponse", Void.TYPE, (Class[])new Class[]{Optional.class, ResteasyReactiveContainerRequestContext.class}), new ResultHandle[]{resultHandle, rrContainerReqCtxHandle});
                    } else if (returnType == ReturnType.RESPONSE) {
                        filterMethod.invokeStaticMethod(MethodDescriptor.ofMethod(FilterUtil.class, (String)"handleResponse", Void.TYPE, (Class[])new Class[]{Response.class, ResteasyReactiveContainerRequestContext.class}), new ResultHandle[]{resultHandle, rrContainerReqCtxHandle});
                    } else if (returnType == ReturnType.REST_RESPONSE) {
                        filterMethod.invokeStaticMethod(MethodDescriptor.ofMethod(FilterUtil.class, (String)"handleRestResponse", Void.TYPE, (Class[])new Class[]{RestResponse.class, ResteasyReactiveContainerRequestContext.class}), new ResultHandle[]{resultHandle, rrContainerReqCtxHandle});
                    }
                    filterMethod.returnValue(null);
                    break block24;
                }
                if (returnType == ReturnType.UNI_VOID || returnType == ReturnType.UNI_RESPONSE || returnType == ReturnType.UNI_REST_RESPONSE) {
                    MethodCreator filterMethod = cc.getMethodCreator("filter", Void.TYPE, new Class[]{ResteasyReactiveContainerRequestContext.class});
                    if (checkForOptionalBean) {
                        filterMethod.ifNull(filterMethod.readInstanceField(delegateField, filterMethod.getThis())).trueBranch().returnNull();
                    }
                    ResultHandle rrContainerReqCtxHandle = this.getRRContainerReqCtxHandle(filterMethod, 0);
                    ResultHandle uniHandle = filterMethod.invokeVirtualMethod(targetMethod, filterMethod.readInstanceField(delegateField, filterMethod.getThis()), this.getRequestFilterResultHandles(targetMethod, declaringClassName, filterMethod, 1, this.getRRReqCtxHandle(filterMethod, rrContainerReqCtxHandle)));
                    filterMethod.invokeStaticMethod(MethodDescriptor.ofMethod(FilterUtil.class, (String)(switch (returnType) {
                        case ReturnType.UNI_VOID -> "handleUniVoid";
                        case ReturnType.UNI_RESPONSE -> "handleUniResponse";
                        case ReturnType.UNI_REST_RESPONSE -> "handleUniRestResponse";
                        default -> throw new IllegalStateException("ReturnType: '" + String.valueOf((Object)returnType) + "' is not supported, in method " + String.valueOf(targetMethod.declaringClass()) + "." + targetMethod.name());
                    }), Void.TYPE, (Class[])new Class[]{Uni.class, ResteasyReactiveContainerRequestContext.class}), new ResultHandle[]{uniHandle, rrContainerReqCtxHandle});
                    filterMethod.returnNull();
                    break block24;
                }
                throw new IllegalStateException("ReturnType: '" + String.valueOf((Object)returnType) + "' is not supported, in method " + String.valueOf(targetMethod.declaringClass()) + "." + targetMethod.name());
            }
        }
        return generatedClassName;
    }

    private ResultHandle[] getRequestFilterResultHandles(MethodInfo targetMethod, DotName declaringClassName, MethodCreator filterMethod, int filterMethodParamCount, ResultHandle rrReqCtxHandle) {
        ResultHandle[] targetMethodParamHandles = new ResultHandle[targetMethod.parametersCount()];
        for (int i = 0; i < targetMethod.parametersCount(); ++i) {
            Type param = targetMethod.parameterType(i);
            DotName paramDotName = param.name();
            if (ResteasyReactiveDotNames.CONTAINER_REQUEST_CONTEXT.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = filterMethod.newInstance(MethodDescriptor.ofConstructor(PreventAbortResteasyReactiveContainerRequestContext.class, (Class[])new Class[]{ContainerRequestContext.class}), new ResultHandle[]{filterMethod.getMethodParam(0)});
                continue;
            }
            if (ResteasyReactiveServerDotNames.QUARKUS_REST_CONTAINER_REQUEST_CONTEXT.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = filterMethod.checkCast(filterMethod.getMethodParam(0), ResteasyReactiveContainerRequestContext.class);
                continue;
            }
            if (ResteasyReactiveDotNames.URI_INFO.equals((Object)paramDotName)) {
                GeneratorUtils.paramHandleFromReqContextMethod(filterMethod, rrReqCtxHandle, targetMethodParamHandles, i, "getUriInfo", ResteasyReactiveDotNames.URI_INFO);
                continue;
            }
            if (ResteasyReactiveDotNames.HTTP_HEADERS.equals((Object)paramDotName)) {
                GeneratorUtils.paramHandleFromReqContextMethod(filterMethod, rrReqCtxHandle, targetMethodParamHandles, i, "getHttpHeaders", HttpHeadersImpl.class);
                continue;
            }
            if (ResteasyReactiveDotNames.REQUEST.equals((Object)paramDotName)) {
                GeneratorUtils.paramHandleFromReqContextMethod(filterMethod, rrReqCtxHandle, targetMethodParamHandles, i, "getRequest", ResteasyReactiveDotNames.REQUEST);
                continue;
            }
            if (ResteasyReactiveDotNames.RESOURCE_INFO.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = this.getResourceInfoHandle(filterMethod, rrReqCtxHandle);
                continue;
            }
            if (ResteasyReactiveServerDotNames.SIMPLIFIED_RESOURCE_INFO.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = this.getSimpleResourceInfoHandle(filterMethod, rrReqCtxHandle);
                continue;
            }
            if (ResteasyReactiveDotNames.CONTINUATION.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = filterMethod.getMethodParam(filterMethodParamCount - 1);
                continue;
            }
            if (this.unwrappableTypes.contains(paramDotName)) {
                targetMethodParamHandles[i] = GeneratorUtils.unwrapObject(filterMethod, rrReqCtxHandle, paramDotName);
                continue;
            }
            String parameterName = targetMethod.parameterName(i);
            throw new RuntimeException("Parameter '" + parameterName + "' of method '" + targetMethod.name() + " of class '" + String.valueOf(declaringClassName) + "' is not allowed");
        }
        return targetMethodParamHandles;
    }

    String generateContainerResponseFilter(MethodInfo targetMethod, ClassOutput classOutput) {
        this.checkModifiers(targetMethod, ResteasyReactiveServerDotNames.SERVER_RESPONSE_FILTER);
        if (KotlinUtils.isSuspendMethod(targetMethod)) {
            return this.generateResponseFilterForSuspendedMethod(targetMethod, classOutput, this.isOptionalFilter.test(targetMethod));
        }
        return this.generateStandardContainerResponseFilter(targetMethod, classOutput, this.isOptionalFilter.test(targetMethod));
    }

    private String generateResponseFilterForSuspendedMethod(MethodInfo targetMethod, ClassOutput classOutput, boolean checkForOptionalBean) {
        DotName returnDotName = this.determineReturnDotNameOfSuspendMethod(targetMethod);
        if (!returnDotName.equals((Object)ResteasyReactiveDotNames.VOID)) {
            throw new RuntimeException("Suspend method '" + targetMethod.name() + " of class '" + String.valueOf(targetMethod.declaringClass().name()) + "' cannot be used as a request filter as it does not declare 'void' as its return type.");
        }
        String generatedClassName = this.getGeneratedClassName(targetMethod, ResteasyReactiveServerDotNames.SERVER_RESPONSE_FILTER);
        ClassInfo declaringClass = targetMethod.declaringClass();
        DotName declaringClassName = declaringClass.name();
        try (ClassCreator cc = ClassCreator.builder().classOutput(classOutput).className(generatedClassName).superClass(ABSTRACT_SUSPENDED_RES_FILTER).build();){
            FieldDescriptor delegateField = this.generateConstructorAndDelegateField(cc, declaringClass, ABSTRACT_SUSPENDED_RES_FILTER, this.additionalBeanAnnotations, checkForOptionalBean);
            MethodCreator doFilterMethod = cc.getMethodCreator("doFilter", Object.class.getName(), new String[]{ResteasyReactiveContainerRequestContext.class.getName(), ContainerResponseContext.class.getName(), ResteasyReactiveDotNames.CONTINUATION.toString()});
            ResultHandle rrContainerReqCtxHandle = this.getRRContainerReqCtxHandle(doFilterMethod, 0);
            ResultHandle rrReqCtxHandle = this.getRRReqCtxHandle(doFilterMethod, rrContainerReqCtxHandle);
            ResultHandle resultHandle = doFilterMethod.invokeVirtualMethod(targetMethod, doFilterMethod.readInstanceField(delegateField, doFilterMethod.getThis()), this.getResponseFilterResultHandles(targetMethod, declaringClassName, doFilterMethod, 3, rrReqCtxHandle));
            doFilterMethod.returnValue(resultHandle);
        }
        return generatedClassName;
    }

    private String generateStandardContainerResponseFilter(MethodInfo targetMethod, ClassOutput classOutput, boolean checkForOptionalBean) {
        ReturnType returnType = this.determineResponseFilterReturnType(targetMethod);
        String generatedClassName = this.getGeneratedClassName(targetMethod, ResteasyReactiveServerDotNames.SERVER_RESPONSE_FILTER);
        ClassInfo declaringClassInfo = targetMethod.declaringClass();
        DotName declaringClassName = declaringClassInfo.name();
        try (ClassCreator cc = ClassCreator.builder().classOutput(classOutput).className(generatedClassName).interfaces(new Class[]{this.determineResponseInterfaceType(returnType)}).build();){
            FieldDescriptor delegateField = this.generateConstructorAndDelegateField(cc, declaringClassInfo, Object.class.getName(), this.additionalBeanAnnotations, checkForOptionalBean);
            if (returnType == ReturnType.VOID) {
                MethodCreator filterMethod = cc.getMethodCreator("filter", Void.TYPE, new Class[]{ContainerRequestContext.class, ContainerResponseContext.class});
                if (checkForOptionalBean) {
                    filterMethod.ifNull(filterMethod.readInstanceField(delegateField, filterMethod.getThis())).trueBranch().returnVoid();
                }
                ResultHandle rrContainerReqCtxHandle = this.getRRContainerReqCtxHandle(filterMethod, 0);
                ResultHandle rrReqCtxHandle = this.getRRReqCtxHandle(filterMethod, rrContainerReqCtxHandle);
                filterMethod.invokeVirtualMethod(targetMethod, filterMethod.readInstanceField(delegateField, filterMethod.getThis()), this.getResponseFilterResultHandles(targetMethod, declaringClassName, filterMethod, 2, rrReqCtxHandle));
                filterMethod.returnValue(null);
            } else if (returnType == ReturnType.UNI_VOID) {
                MethodCreator filterMethod = cc.getMethodCreator("filter", Void.TYPE, new Class[]{ResteasyReactiveContainerRequestContext.class, ContainerResponseContext.class});
                if (checkForOptionalBean) {
                    filterMethod.ifNull(filterMethod.readInstanceField(delegateField, filterMethod.getThis())).trueBranch().returnNull();
                }
                ResultHandle rrContainerReqCtxHandle = this.getRRContainerReqCtxHandle(filterMethod, 0);
                ResultHandle rrReqCtxHandle = this.getRRReqCtxHandle(filterMethod, rrContainerReqCtxHandle);
                ResultHandle uniHandle = filterMethod.invokeVirtualMethod(targetMethod, filterMethod.readInstanceField(delegateField, filterMethod.getThis()), this.getResponseFilterResultHandles(targetMethod, declaringClassName, filterMethod, 2, rrReqCtxHandle));
                filterMethod.invokeStaticMethod(MethodDescriptor.ofMethod(FilterUtil.class, (String)"handleUniVoid", Void.TYPE, (Class[])new Class[]{Uni.class, ResteasyReactiveContainerRequestContext.class}), new ResultHandle[]{uniHandle, rrContainerReqCtxHandle});
                filterMethod.returnValue(null);
            }
        }
        return generatedClassName;
    }

    private FieldDescriptor generateConstructorAndDelegateField(ClassCreator cc, ClassInfo declaringClass, String superClassName, Set<String> additionalBeanAnnotations, boolean checkForOptionalBean) {
        String declaringClassName = declaringClass.toString();
        ScopeInspectionResult scopeInspectionResult = this.inspectScope(declaringClass);
        if (scopeInspectionResult.scopeToAdd != null) {
            cc.addAnnotation(scopeInspectionResult.scopeToAdd);
        }
        for (String i : additionalBeanAnnotations) {
            cc.addAnnotation(i);
        }
        FieldDescriptor delegateField = ((FieldCreator)cc.getFieldCreator("delegate", declaringClassName).setModifiers(18)).getFieldDescriptor();
        MethodCreator ctor = checkForOptionalBean ? (MethodCreator)cc.getMethodCreator("<init>", Void.TYPE, new Class[]{Instance.class}).setSignature(String.format("(L%s<L%s;>;)V", Instance.class.getName().replace('.', '/'), declaringClassName.replace('.', '/'))) : cc.getMethodCreator("<init>", Void.TYPE, new Object[]{declaringClassName});
        ctor.setModifiers(1);
        ctor.addAnnotation(Inject.class);
        ctor.invokeSpecialMethod(MethodDescriptor.ofConstructor((String)superClassName, (String[])new String[0]), ctor.getThis(), new ResultHandle[0]);
        ResultHandle self = ctor.getThis();
        if (checkForOptionalBean) {
            ResultHandle instance = ctor.getMethodParam(0);
            ResultHandle isResolvable = ctor.invokeInterfaceMethod(MethodDescriptor.ofMethod(Instance.class, (String)"isResolvable", Boolean.TYPE, (Class[])new Class[0]), instance, new ResultHandle[0]);
            BranchResult isResolvableBranch = ctor.ifTrue(isResolvable);
            BytecodeCreator isResolvableTrue = isResolvableBranch.trueBranch();
            isResolvableTrue.writeInstanceField(delegateField, self, isResolvableTrue.invokeInterfaceMethod(MethodDescriptor.ofMethod(Instance.class, (String)"get", Object.class, (Class[])new Class[0]), instance, new ResultHandle[0]));
            BytecodeCreator isResolvableFalse = isResolvableBranch.falseBranch();
            isResolvableFalse.writeInstanceField(delegateField, self, isResolvableFalse.loadNull());
        } else {
            ctor.writeInstanceField(delegateField, self, ctor.getMethodParam(0));
        }
        ctor.returnValue(null);
        if (scopeInspectionResult.needsProxy) {
            MethodCreator noArgsCtor = cc.getMethodCreator("<init>", Void.TYPE, new Class[0]);
            noArgsCtor.setModifiers(1);
            noArgsCtor.invokeSpecialMethod(MethodDescriptor.ofConstructor((String)superClassName, (String[])new String[0]), noArgsCtor.getThis(), new ResultHandle[0]);
            noArgsCtor.writeInstanceField(delegateField, noArgsCtor.getThis(), noArgsCtor.loadNull());
            noArgsCtor.returnValue(null);
        }
        return delegateField;
    }

    private ScopeInspectionResult inspectScope(ClassInfo classInfo) {
        if (classInfo.hasDeclaredAnnotation(ApplicationScoped.class) || classInfo.hasDeclaredAnnotation(RequestScoped.class)) {
            return new ScopeInspectionResult(ApplicationScoped.class, true);
        }
        if (classInfo.hasDeclaredAnnotation(Singleton.class)) {
            return new ScopeInspectionResult(Singleton.class, false);
        }
        List fields = classInfo.fields();
        if (fields.isEmpty()) {
            return new ScopeInspectionResult(Singleton.class, false);
        }
        boolean hasFieldWithoutInject = false;
        for (FieldInfo field : fields) {
            if (field.hasAnnotation(Inject.class)) continue;
            hasFieldWithoutInject = true;
            break;
        }
        return new ScopeInspectionResult(hasFieldWithoutInject ? ApplicationScoped.class : Singleton.class, hasFieldWithoutInject);
    }

    private ResultHandle[] getResponseFilterResultHandles(MethodInfo targetMethod, DotName declaringClassName, MethodCreator filterMethod, int filterMethodParamCount, ResultHandle rrReqCtxHandle) {
        ResultHandle[] targetMethodParamHandles = new ResultHandle[targetMethod.parametersCount()];
        for (int i = 0; i < targetMethod.parametersCount(); ++i) {
            Type param = targetMethod.parameterType(i);
            DotName paramDotName = param.name();
            if (ResteasyReactiveDotNames.CONTAINER_REQUEST_CONTEXT.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = filterMethod.newInstance(MethodDescriptor.ofConstructor(PreventAbortResteasyReactiveContainerRequestContext.class, (Class[])new Class[]{ContainerRequestContext.class}), new ResultHandle[]{filterMethod.getMethodParam(0)});
                continue;
            }
            if (ResteasyReactiveServerDotNames.QUARKUS_REST_CONTAINER_REQUEST_CONTEXT.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = filterMethod.checkCast(filterMethod.getMethodParam(0), ResteasyReactiveContainerRequestContext.class);
                continue;
            }
            if (ResteasyReactiveDotNames.CONTAINER_RESPONSE_CONTEXT.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = filterMethod.getMethodParam(1);
                continue;
            }
            if (this.unwrappableTypes.contains(paramDotName)) {
                targetMethodParamHandles[i] = GeneratorUtils.unwrapObject(filterMethod, rrReqCtxHandle, paramDotName);
                continue;
            }
            if (ResteasyReactiveDotNames.URI_INFO.equals((Object)paramDotName)) {
                GeneratorUtils.paramHandleFromReqContextMethod(filterMethod, rrReqCtxHandle, targetMethodParamHandles, i, "getUriInfo", ResteasyReactiveDotNames.URI_INFO);
                continue;
            }
            if (ResteasyReactiveDotNames.RESOURCE_INFO.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = this.getResourceInfoHandle(filterMethod, rrReqCtxHandle);
                continue;
            }
            if (ResteasyReactiveServerDotNames.SIMPLIFIED_RESOURCE_INFO.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = this.getSimpleResourceInfoHandle(filterMethod, rrReqCtxHandle);
                continue;
            }
            if (ResteasyReactiveDotNames.THROWABLE.equals((Object)paramDotName)) {
                GeneratorUtils.paramHandleFromReqContextMethod(filterMethod, rrReqCtxHandle, targetMethodParamHandles, i, "getThrowable", ResteasyReactiveDotNames.THROWABLE);
                continue;
            }
            if (ResteasyReactiveDotNames.CONTINUATION.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = filterMethod.getMethodParam(filterMethodParamCount - 1);
                continue;
            }
            String parameterName = targetMethod.parameterName(i);
            throw new RuntimeException("Parameter '" + parameterName + "' of method '" + targetMethod.name() + " of class '" + String.valueOf(declaringClassName) + "' is not allowed");
        }
        return targetMethodParamHandles;
    }

    private ResultHandle getRRContainerReqCtxHandle(MethodCreator filter, int containerReqCtxParamIndex) {
        ResultHandle containerReqCtxHandle = filter.getMethodParam(containerReqCtxParamIndex);
        return filter.checkCast(containerReqCtxHandle, ResteasyReactiveContainerRequestContext.class);
    }

    private ResultHandle getRRReqCtxHandle(MethodCreator filter, ResultHandle rrContainerReqCtxHandle) {
        ResultHandle rrCtxHandle = filter.invokeInterfaceMethod(MethodDescriptor.ofMethod(ResteasyReactiveContainerRequestContext.class, (String)"getServerRequestContext", ServerRequestContext.class, (Class[])new Class[0]), rrContainerReqCtxHandle, new ResultHandle[0]);
        return filter.checkCast(rrCtxHandle, ResteasyReactiveRequestContext.class);
    }

    private AssignableResultHandle getResourceInfoHandle(MethodCreator filterMethod, ResultHandle rrReqCtxHandle) {
        ResultHandle runtimeResourceHandle = GeneratorUtils.runtimeResourceHandle(filterMethod, rrReqCtxHandle);
        AssignableResultHandle resourceInfo = filterMethod.createVariable(ResourceInfo.class);
        BranchResult ifNullBranch = filterMethod.ifNull(runtimeResourceHandle);
        ifNullBranch.trueBranch().assign(resourceInfo, ifNullBranch.trueBranch().readStaticField(FieldDescriptor.of(SimpleResourceInfo.NullValues.class, (String)"INSTANCE", SimpleResourceInfo.NullValues.class)));
        ifNullBranch.falseBranch().assign(resourceInfo, ifNullBranch.falseBranch().invokeVirtualMethod(MethodDescriptor.ofMethod(RuntimeResource.class, (String)"getLazyMethod", ResteasyReactiveResourceInfo.class, (Class[])new Class[0]), runtimeResourceHandle, new ResultHandle[0]));
        return resourceInfo;
    }

    private AssignableResultHandle getSimpleResourceInfoHandle(MethodCreator filterMethod, ResultHandle rrReqCtxHandle) {
        ResultHandle runtimeResourceHandle = GeneratorUtils.runtimeResourceHandle(filterMethod, rrReqCtxHandle);
        AssignableResultHandle resourceInfo = filterMethod.createVariable(SimpleResourceInfo.class);
        BranchResult ifNullBranch = filterMethod.ifNull(runtimeResourceHandle);
        ifNullBranch.trueBranch().assign(resourceInfo, ifNullBranch.trueBranch().readStaticField(FieldDescriptor.of(SimpleResourceInfo.NullValues.class, (String)"INSTANCE", SimpleResourceInfo.NullValues.class)));
        ifNullBranch.falseBranch().assign(resourceInfo, ifNullBranch.falseBranch().invokeVirtualMethod(MethodDescriptor.ofMethod(RuntimeResource.class, (String)"getSimplifiedResourceInfo", SimpleResourceInfo.class, (Class[])new Class[0]), runtimeResourceHandle, new ResultHandle[0]));
        return resourceInfo;
    }

    private String getGeneratedClassName(MethodInfo targetMethod, DotName annotationDotName) {
        DotName declaringClassName = targetMethod.declaringClass().name();
        return declaringClassName.toString() + "$Generated" + annotationDotName.withoutPackagePrefix() + "$" + targetMethod.name();
    }

    private void checkModifiers(MethodInfo info, DotName annotationDotName) {
        if ((info.flags() & 2) != 0) {
            throw new RuntimeException("Method '" + info.name() + " of class '" + String.valueOf(info.declaringClass().name()) + "' cannot be private as it is annotated with '@" + String.valueOf(annotationDotName) + "'");
        }
        if ((info.flags() & 8) != 0) {
            throw new RuntimeException("Method '" + info.name() + " of class '" + String.valueOf(info.declaringClass().name()) + "' cannot be static as it is annotated with '@" + String.valueOf(annotationDotName) + "'");
        }
    }

    private ReturnType determineRequestFilterReturnType(MethodInfo targetMethod) {
        if (targetMethod.returnType().kind() == Type.Kind.VOID) {
            return ReturnType.VOID;
        }
        if (targetMethod.returnType().kind() == Type.Kind.PARAMETERIZED_TYPE) {
            ParameterizedType parameterizedType = targetMethod.returnType().asParameterizedType();
            if (parameterizedType.name().equals((Object)ResteasyReactiveDotNames.UNI) && parameterizedType.arguments().size() == 1) {
                if (((Type)parameterizedType.arguments().get(0)).name().equals((Object)ResteasyReactiveDotNames.VOID)) {
                    return ReturnType.UNI_VOID;
                }
                if (((Type)parameterizedType.arguments().get(0)).name().equals((Object)ResteasyReactiveDotNames.RESPONSE)) {
                    return ReturnType.UNI_RESPONSE;
                }
                if (((Type)parameterizedType.arguments().get(0)).name().equals((Object)ResteasyReactiveDotNames.REST_RESPONSE)) {
                    return ReturnType.UNI_REST_RESPONSE;
                }
            } else if (parameterizedType.name().equals((Object)ResteasyReactiveDotNames.OPTIONAL) && parameterizedType.arguments().size() == 1) {
                if (((Type)parameterizedType.arguments().get(0)).name().equals((Object)ResteasyReactiveDotNames.RESPONSE)) {
                    return ReturnType.OPTIONAL_RESPONSE;
                }
                if (((Type)parameterizedType.arguments().get(0)).name().equals((Object)ResteasyReactiveDotNames.REST_RESPONSE)) {
                    return ReturnType.OPTIONAL_REST_RESPONSE;
                }
            } else if (parameterizedType.name().equals((Object)ResteasyReactiveDotNames.REST_RESPONSE)) {
                return ReturnType.REST_RESPONSE;
            }
        } else if (targetMethod.returnType().name().equals((Object)ResteasyReactiveDotNames.RESPONSE)) {
            return ReturnType.RESPONSE;
        }
        throw new RuntimeException("Method '" + targetMethod.name() + " of class '" + String.valueOf(targetMethod.declaringClass().name()) + "' cannot be used as a request filter as it does not declare 'void', Response, RestResponse, Optional<Response>, Optional<RestResponse>, 'Uni<Void>', 'Uni<RestResponse>' or 'Uni<Response>' as its return type");
    }

    private ReturnType determineResponseFilterReturnType(MethodInfo targetMethod) {
        ParameterizedType parameterizedType;
        if (targetMethod.returnType().kind() == Type.Kind.VOID) {
            return ReturnType.VOID;
        }
        if (targetMethod.returnType().kind() == Type.Kind.PARAMETERIZED_TYPE && (parameterizedType = targetMethod.returnType().asParameterizedType()).name().equals((Object)ResteasyReactiveDotNames.UNI) && parameterizedType.arguments().size() == 1 && ((Type)parameterizedType.arguments().get(0)).name().equals((Object)ResteasyReactiveDotNames.VOID)) {
            return ReturnType.UNI_VOID;
        }
        throw new RuntimeException("Method '" + targetMethod.name() + " of class '" + String.valueOf(targetMethod.declaringClass().name()) + "' cannot be used as a response filter as it does not declare 'void' or 'Uni<Void>' as its return type");
    }

    private Class<?> determineRequestInterfaceType(ReturnType returnType) {
        switch (returnType) {
            case VOID: 
            case RESPONSE: 
            case REST_RESPONSE: 
            case OPTIONAL_RESPONSE: 
            case OPTIONAL_REST_RESPONSE: {
                return ContainerRequestFilter.class;
            }
            case UNI_VOID: 
            case UNI_RESPONSE: 
            case UNI_REST_RESPONSE: {
                return ResteasyReactiveContainerRequestFilter.class;
            }
        }
        throw new IllegalStateException("ReturnType: '" + String.valueOf((Object)returnType) + "' is not supported");
    }

    private Class<?> determineResponseInterfaceType(ReturnType returnType) {
        if (returnType == ReturnType.VOID) {
            return ContainerResponseFilter.class;
        }
        if (returnType == ReturnType.UNI_VOID) {
            return ResteasyReactiveContainerResponseFilter.class;
        }
        throw new IllegalStateException("ReturnType: '" + String.valueOf((Object)returnType) + "' is not supported");
    }

    private DotName determineReturnDotNameOfSuspendMethod(MethodInfo methodInfo) {
        Type lastParamType = methodInfo.parameterType(methodInfo.parametersCount() - 1);
        if (lastParamType.kind() != Type.Kind.PARAMETERIZED_TYPE) {
            throw new IllegalStateException("Something went wrong during parameter type resolution - expected " + String.valueOf(lastParamType) + " to be a Continuation with a generic type");
        }
        if ((lastParamType = (Type)lastParamType.asParameterizedType().arguments().get(0)).kind() != Type.Kind.WILDCARD_TYPE) {
            throw new IllegalStateException("Something went wrong during parameter type resolution - expected " + String.valueOf(lastParamType) + " to be a Continuation with a generic type");
        }
        if ((lastParamType = lastParamType.asWildcardType().superBound()).name().equals((Object)ResteasyReactiveDotNames.KOTLIN_UNIT)) {
            return ResteasyReactiveDotNames.VOID;
        }
        return lastParamType.name();
    }

    private static enum ReturnType {
        VOID,
        RESPONSE,
        REST_RESPONSE,
        OPTIONAL_RESPONSE,
        OPTIONAL_REST_RESPONSE,
        UNI_VOID,
        UNI_RESPONSE,
        UNI_REST_RESPONSE;

    }

    private static class ScopeInspectionResult {
        private final Class<?> scopeToAdd;
        private final boolean needsProxy;

        public ScopeInspectionResult(Class<?> scopeToAdd, boolean needsProxy) {
            this.scopeToAdd = scopeToAdd;
            this.needsProxy = needsProxy;
        }
    }
}

