/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtcp;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.rtp.rtcp.RtcpHeaderBuilder;
import org.jitsi.rtp.rtcp.RtcpReportBlock;
import org.jitsi.rtp.rtcp.RtcpRrPacket;
import org.jitsi.rtp.util.BufferPool;
import org.jitsi.rtp.util.RtpUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0010J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006$"}, d2={"Lorg/jitsi/rtp/rtcp/RtcpRrPacketBuilder;", "", "rtcpHeader", "Lorg/jitsi/rtp/rtcp/RtcpHeaderBuilder;", "reportBlocks", "", "Lorg/jitsi/rtp/rtcp/RtcpReportBlock;", "<init>", "(Lorg/jitsi/rtp/rtcp/RtcpHeaderBuilder;Ljava/util/List;)V", "getRtcpHeader", "()Lorg/jitsi/rtp/rtcp/RtcpHeaderBuilder;", "setRtcpHeader", "(Lorg/jitsi/rtp/rtcp/RtcpHeaderBuilder;)V", "getReportBlocks", "()Ljava/util/List;", "getLengthValue", "", "sizeBytes", "getSizeBytes", "()I", "build", "Lorg/jitsi/rtp/rtcp/RtcpRrPacket;", "writeTo", "", "buf", "", "offset", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "rtp"})
@SourceDebugExtension(value={"SMAP\nRtcpRrPacket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RtcpRrPacket.kt\norg/jitsi/rtp/rtcp/RtcpRrPacketBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1#2:102\n1872#3,3:103\n*S KotlinDebug\n*F\n+ 1 RtcpRrPacket.kt\norg/jitsi/rtp/rtcp/RtcpRrPacketBuilder\n*L\n96#1:103,3\n*E\n"})
public final class RtcpRrPacketBuilder {
    @NotNull
    private RtcpHeaderBuilder rtcpHeader;
    @NotNull
    private final List<RtcpReportBlock> reportBlocks;

    public RtcpRrPacketBuilder(@NotNull RtcpHeaderBuilder rtcpHeader, @NotNull List<RtcpReportBlock> reportBlocks) {
        Intrinsics.checkNotNullParameter(rtcpHeader, "rtcpHeader");
        Intrinsics.checkNotNullParameter(reportBlocks, "reportBlocks");
        this.rtcpHeader = rtcpHeader;
        this.reportBlocks = reportBlocks;
        if (!(this.reportBlocks.size() <= 31)) {
            boolean bl = false;
            String string = "Too many report blocks " + this.reportBlocks.size() + ": RR can contain at most 31";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ RtcpRrPacketBuilder(RtcpHeaderBuilder rtcpHeaderBuilder, List list, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 1) != 0) {
            rtcpHeaderBuilder = new RtcpHeaderBuilder(0, false, 0, 0, 0, 0L, 63, null);
        }
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(rtcpHeaderBuilder, list);
    }

    @NotNull
    public final RtcpHeaderBuilder getRtcpHeader() {
        return this.rtcpHeader;
    }

    public final void setRtcpHeader(@NotNull RtcpHeaderBuilder rtcpHeaderBuilder) {
        Intrinsics.checkNotNullParameter(rtcpHeaderBuilder, "<set-?>");
        this.rtcpHeader = rtcpHeaderBuilder;
    }

    @NotNull
    public final List<RtcpReportBlock> getReportBlocks() {
        return this.reportBlocks;
    }

    private final int getLengthValue() {
        return RtpUtils.Companion.calculateRtcpLengthFieldValue(this.getSizeBytes());
    }

    private final int getSizeBytes() {
        return 8 + this.reportBlocks.size() * 24;
    }

    @NotNull
    public final RtcpRrPacket build() {
        byte[] buf = BufferPool.Companion.getGetArray().invoke(this.getSizeBytes());
        this.writeTo(buf, 0);
        return new RtcpRrPacket(buf, 0, this.getSizeBytes());
    }

    /*
     * WARNING - void declaration
     */
    public final void writeTo(@NotNull byte[] buf, int offset) {
        RtcpHeaderBuilder rtcpHeaderBuilder;
        Intrinsics.checkNotNullParameter(buf, "buf");
        RtcpHeaderBuilder $this$writeTo_u24lambda_u241 = rtcpHeaderBuilder = this.rtcpHeader;
        boolean bl = false;
        $this$writeTo_u24lambda_u241.setPacketType(201);
        $this$writeTo_u24lambda_u241.setReportCount(this.reportBlocks.size());
        $this$writeTo_u24lambda_u241.setLength(this.getLengthValue());
        rtcpHeaderBuilder.writeTo(buf, offset);
        Iterable $this$forEachIndexed$iv = this.reportBlocks;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void reportBlock;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            RtcpReportBlock rtcpReportBlock = (RtcpReportBlock)item$iv;
            int index = n;
            boolean bl2 = false;
            reportBlock.writeTo(buf, offset + 8 + index * 24);
        }
    }

    @NotNull
    public final RtcpHeaderBuilder component1() {
        return this.rtcpHeader;
    }

    @NotNull
    public final List<RtcpReportBlock> component2() {
        return this.reportBlocks;
    }

    @NotNull
    public final RtcpRrPacketBuilder copy(@NotNull RtcpHeaderBuilder rtcpHeader, @NotNull List<RtcpReportBlock> reportBlocks) {
        Intrinsics.checkNotNullParameter(rtcpHeader, "rtcpHeader");
        Intrinsics.checkNotNullParameter(reportBlocks, "reportBlocks");
        return new RtcpRrPacketBuilder(rtcpHeader, reportBlocks);
    }

    public static /* synthetic */ RtcpRrPacketBuilder copy$default(RtcpRrPacketBuilder rtcpRrPacketBuilder, RtcpHeaderBuilder rtcpHeaderBuilder, List list, int n, Object object) {
        if ((n & 1) != 0) {
            rtcpHeaderBuilder = rtcpRrPacketBuilder.rtcpHeader;
        }
        if ((n & 2) != 0) {
            list = rtcpRrPacketBuilder.reportBlocks;
        }
        return rtcpRrPacketBuilder.copy(rtcpHeaderBuilder, list);
    }

    @NotNull
    public String toString() {
        return "RtcpRrPacketBuilder(rtcpHeader=" + this.rtcpHeader + ", reportBlocks=" + this.reportBlocks + ")";
    }

    public int hashCode() {
        int result = this.rtcpHeader.hashCode();
        result = result * 31 + ((Object)this.reportBlocks).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RtcpRrPacketBuilder)) {
            return false;
        }
        RtcpRrPacketBuilder rtcpRrPacketBuilder = (RtcpRrPacketBuilder)other;
        if (!Intrinsics.areEqual(this.rtcpHeader, rtcpRrPacketBuilder.rtcpHeader)) {
            return false;
        }
        return Intrinsics.areEqual(this.reportBlocks, rtcpRrPacketBuilder.reportBlocks);
    }

    public RtcpRrPacketBuilder() {
        this(null, null, 3, null);
    }
}

