%%
%% %CopyrightBegin%
%%
%% Copyright Ericsson AB 2008-2024. All Rights Reserved.
%%
%% Licensed under the Apache License, Version 2.0 (the "License");
%% you may not use this file except in compliance with the License.
%% You may obtain a copy of the License at
%%
%%     http://www.apache.org/licenses/LICENSE-2.0
%%
%% Unless required by applicable law or agreed to in writing, software
%% distributed under the License is distributed on an "AS IS" BASIS,
%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%% See the License for the specific language governing permissions and
%% limitations under the License.
%%
%% %CopyrightEnd%
%% This file is generated DO NOT EDIT

-module(wxMenuEvent).
-moduledoc """
Functions for wxMenuEvent class

This class is used for a variety of menu-related events. Note that these do not
include menu command events, which are handled using `m:wxCommandEvent` objects.

Events of this class are generated by both menus that are part of a
`m:wxMenuBar`, attached to `m:wxFrame`, and popup menus shown by
`wxWindow:popupMenu/4`. They are sent to the following objects until one of them
handles the event:
`-# The menu object itself, as returned by GetMenu(), if any. -# The wxMenuBar to which this menu is attached, if any. -# The window associated with the menu, e.g. the one calling PopupMenu() for the popup menus. -# The top level parent of that window if it's different from the window itself.`

This is similar to command events generated by the menu items, but, unlike them,
`m:wxMenuEvent` are only sent to the window itself and its top level parent but
not any intermediate windows in the hierarchy.

The default handler for `wxEVT_MENU_HIGHLIGHT` in `m:wxFrame` displays help text
in the status bar, see `wxFrame:setStatusBarPane/2`.

See: `m:wxCommandEvent`,
[Overview events](https://docs.wxwidgets.org/3.1/overview_events.html#overview_events)

This class is derived (and can use functions) from: `m:wxEvent`

wxWidgets docs:
[wxMenuEvent](https://docs.wxwidgets.org/3.1/classwx_menu_event.html)

## Events

Use `wxEvtHandler:connect/3` with [`wxMenuEventType`](`t:wxMenuEventType/0`) to
subscribe to events of this type.
""".
-include("wxe.hrl").
-export([getMenu/1,getMenuId/1,isPopup/1]).

%% inherited exports
-export([getId/1,getSkipped/1,getTimestamp/1,isCommandEvent/1,parent_class/1,
  resumePropagation/2,shouldPropagate/1,skip/1,skip/2,stopPropagation/1]).

-type wxMenuEvent() :: wx:wx_object().
-include("wx.hrl").
-type wxMenuEventType() :: 'menu_open' | 'menu_close' | 'menu_highlight'.
-export_type([wxMenuEvent/0, wxMenu/0, wxMenuEventType/0]).
%% @hidden
-doc false.
parent_class(wxEvent) -> true;
parent_class(_Class) -> erlang:error({badtype, ?MODULE}).

%% @doc See <a href="http://www.wxwidgets.org/manuals/2.8.12/wx_wxmenuevent.html#wxmenueventgetmenu">external documentation</a>.
-doc """
Returns the menu which is being opened or closed, or the menu containing the
highlighted item.

Note that the returned value can be NULL if the menu being opened doesn't have a
corresponding `m:wxMenu`, e.g. this happens when opening the system menu in
wxMSW port.

Remark: Since 3.1.3 this function can be used with `OPEN`, `CLOSE` and
`HIGHLIGHT` events. Before 3.1.3, this method can only be used with the `OPEN`
and `CLOSE` events.
""".
-spec getMenu(This) -> wxMenu:wxMenu() when
	This::wxMenuEvent().
getMenu(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMenuEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMenuEvent_GetMenu),
  wxe_util:rec(?wxMenuEvent_GetMenu).

%% @doc See <a href="http://www.wxwidgets.org/manuals/2.8.12/wx_wxmenuevent.html#wxmenueventgetmenuid">external documentation</a>.
-doc """
Returns the menu identifier associated with the event.

This method should be only used with the `HIGHLIGHT` events.
""".
-spec getMenuId(This) -> integer() when
	This::wxMenuEvent().
getMenuId(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMenuEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMenuEvent_GetMenuId),
  wxe_util:rec(?wxMenuEvent_GetMenuId).

%% @doc See <a href="http://www.wxwidgets.org/manuals/2.8.12/wx_wxmenuevent.html#wxmenueventispopup">external documentation</a>.
-doc """
Returns true if the menu which is being opened or closed is a popup menu, false
if it is a normal one.

This method should only be used with the `OPEN` and `CLOSE` events.
""".
-spec isPopup(This) -> boolean() when
	This::wxMenuEvent().
isPopup(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMenuEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMenuEvent_IsPopup),
  wxe_util:rec(?wxMenuEvent_IsPopup).

 %% From wxEvent
%% @hidden
-doc false.
stopPropagation(This) -> wxEvent:stopPropagation(This).
%% @hidden
-doc false.
skip(This, Options) -> wxEvent:skip(This, Options).
%% @hidden
-doc false.
skip(This) -> wxEvent:skip(This).
%% @hidden
-doc false.
shouldPropagate(This) -> wxEvent:shouldPropagate(This).
%% @hidden
-doc false.
resumePropagation(This,PropagationLevel) -> wxEvent:resumePropagation(This,PropagationLevel).
%% @hidden
-doc false.
isCommandEvent(This) -> wxEvent:isCommandEvent(This).
%% @hidden
-doc false.
getTimestamp(This) -> wxEvent:getTimestamp(This).
%% @hidden
-doc false.
getSkipped(This) -> wxEvent:getSkipped(This).
%% @hidden
-doc false.
getId(This) -> wxEvent:getId(This).
