"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupThreatIntelRoutes = setupThreatIntelRoutes;
var _constants = require("../utils/constants");
var _configSchema = require("@osd/config-schema");
var _helpers = require("../utils/helpers");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function setupThreatIntelRoutes({
  threatIntelService
}, router) {
  router.post({
    path: `${_constants.API.THREAT_INTEL_BASE}/sources`,
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, threatIntelService.addThreatIntelSource);
  router.put({
    path: `${_constants.API.THREAT_INTEL_BASE}/sources/{sourceId}`,
    validate: {
      params: _configSchema.schema.object({
        sourceId: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any(),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, threatIntelService.updateThreatIntelSource);
  router.post({
    path: `${_constants.API.THREAT_INTEL_BASE}/sources/_search`,
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, threatIntelService.searchThreatIntelSources);
  router.get({
    path: `${_constants.API.THREAT_INTEL_BASE}/sources/{sourceId}`,
    validate: {
      params: _configSchema.schema.object({
        sourceId: _configSchema.schema.string()
      }),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, threatIntelService.getThreatIntelSource);
  router.post({
    path: `${_constants.API.THREAT_INTEL_BASE}/monitors`,
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, threatIntelService.createThreatIntelMonitor);
  router.put({
    path: `${_constants.API.THREAT_INTEL_BASE}/monitors/{monitorId}`,
    validate: {
      params: _configSchema.schema.object({
        monitorId: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any(),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, threatIntelService.updateThreatIntelMonitor);
  router.post({
    path: `${_constants.API.THREAT_INTEL_BASE}/monitors/_search`,
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, threatIntelService.searchThreatIntelMonitors);
  router.get({
    path: `${_constants.API.THREAT_INTEL_BASE}/iocs`,
    validate: {
      query: (0, _helpers.createQueryValidationSchema)({
        startIndex: _configSchema.schema.maybe(_configSchema.schema.number()),
        size: _configSchema.schema.maybe(_configSchema.schema.number()),
        feed_ids: _configSchema.schema.maybe(_configSchema.schema.string()),
        ioc_types: _configSchema.schema.maybe(_configSchema.schema.string()),
        searchString: _configSchema.schema.maybe(_configSchema.schema.string()),
        sortString: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, threatIntelService.getThreatIntelIocs);
  router.delete({
    path: `${_constants.API.THREAT_INTEL_BASE}/sources/{sourceId}`,
    validate: {
      params: _configSchema.schema.object({
        sourceId: _configSchema.schema.string()
      }),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, threatIntelService.deleteThreatIntelSource);
  router.post({
    path: `${_constants.API.THREAT_INTEL_BASE}/sources/{sourceId}/_refresh`,
    validate: {
      params: _configSchema.schema.object({
        sourceId: _configSchema.schema.string()
      }),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, threatIntelService.refreshThreatIntelSource);
  router.delete({
    path: `${_constants.API.THREAT_INTEL_BASE}/monitors/{monitorId}`,
    validate: {
      params: _configSchema.schema.object({
        monitorId: _configSchema.schema.string()
      }),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, threatIntelService.deleteThreatIntelMonitor);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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