"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addLogTypeMethods = addLogTypeMethods;
var _constants = require("../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function addLogTypeMethods(securityAnalytics, createAction) {
  securityAnalytics[_constants.METHOD_NAMES.SEARCH_LOGTYPES] = createAction({
    url: {
      fmt: `${_constants.API.LOGTYPE_BASE}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  securityAnalytics[_constants.METHOD_NAMES.CREATE_LOGTYPE] = createAction({
    url: {
      fmt: `${_constants.API.LOGTYPE_BASE}`
    },
    needBody: true,
    method: 'POST'
  });
  securityAnalytics[_constants.METHOD_NAMES.UPDATE_LOGTYPE] = createAction({
    url: {
      fmt: `${_constants.API.LOGTYPE_BASE}/<%=logTypeId%>`,
      req: {
        logTypeId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  securityAnalytics[_constants.METHOD_NAMES.DELETE_LOGTYPE] = createAction({
    url: {
      fmt: `${_constants.API.LOGTYPE_BASE}/<%=logTypeId%>`,
      req: {
        logTypeId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: false,
    method: 'DELETE'
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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