/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.type;

import java.util.Set;

public class Input {
    private String name;
    private String type;
    private String label;
    private String description;
    private boolean required = false;
    private Set<String> tags;
    private String reference;
    private String defaultValue;

    protected Input() {
    }

    public Input(String name, String type) {
        this(name, type, null, null, null, false, null, null);
    }

    public Input(String name, String type, String label, String description, Set<String> tags, boolean required, String reference, String defaultValue) {
        if (name == null) {
            throw new IllegalArgumentException("The name of the input must not be NULL!");
        }
        if (type == null) {
            throw new IllegalArgumentException("The type of the input must not be NULL!");
        }
        this.name = name;
        this.type = type;
        this.label = label;
        this.description = description;
        this.tags = tags;
        this.required = required;
        this.reference = reference;
        this.defaultValue = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getType() {
        return this.type;
    }

    public Set<String> getTags() {
        return this.tags != null ? this.tags : Set.of();
    }

    public String getReference() {
        return this.reference;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return "Input " + this.name;
    }
}

