/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.ManagedRuleProvider;
import org.openhab.core.automation.Module;
import org.openhab.core.automation.Rule;
import org.openhab.core.automation.RuleProvider;
import org.openhab.core.automation.RuleRegistry;
import org.openhab.core.automation.RuleStatus;
import org.openhab.core.automation.RuleStatusInfo;
import org.openhab.core.automation.internal.RuleEventFactory;
import org.openhab.core.automation.internal.RuleImpl;
import org.openhab.core.automation.internal.template.RuleTemplateRegistry;
import org.openhab.core.automation.template.RuleTemplate;
import org.openhab.core.automation.template.TemplateRegistry;
import org.openhab.core.automation.type.ModuleTypeRegistry;
import org.openhab.core.automation.util.ConfigurationNormalizer;
import org.openhab.core.automation.util.ReferenceResolver;
import org.openhab.core.automation.util.RuleBuilder;
import org.openhab.core.common.registry.AbstractRegistry;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.common.registry.ManagedProvider;
import org.openhab.core.common.registry.Provider;
import org.openhab.core.common.registry.RegistryChangeListener;
import org.openhab.core.config.core.ConfigDescriptionParameter;
import org.openhab.core.config.core.Configuration;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.service.ReadyService;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={RuleRegistry.class}, immediate=true)
public class RuleRegistryImpl
extends AbstractRegistry<Rule, String, RuleProvider>
implements RuleRegistry,
RegistryChangeListener<RuleTemplate> {
    private static final String SOURCE = RuleRegistryImpl.class.getSimpleName();
    private final Logger logger = LoggerFactory.getLogger((String)RuleRegistryImpl.class.getName());
    @NonNullByDefault(value={})
    private ModuleTypeRegistry moduleTypeRegistry;
    @NonNullByDefault(value={})
    private RuleTemplateRegistry templateRegistry;
    private final Map<String, Set<String>> mapTemplateToRules = new HashMap<String, Set<String>>();

    public RuleRegistryImpl() {
        super(RuleProvider.class);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        super.activate(bundleContext);
    }

    @Deactivate
    protected void deactivate() {
        super.deactivate();
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setEventPublisher(EventPublisher eventPublisher) {
        super.setEventPublisher(eventPublisher);
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        super.unsetEventPublisher(eventPublisher);
    }

    @Reference
    protected void setReadyService(ReadyService readyService) {
        super.setReadyService(readyService);
    }

    protected void unsetReadyService(ReadyService readyService) {
        super.unsetReadyService(readyService);
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, name="ManagedRuleProvider")
    protected void setManagedProvider(ManagedRuleProvider managedProvider) {
        super.setManagedProvider((ManagedProvider)managedProvider);
    }

    protected void unsetManagedProvider(ManagedRuleProvider managedProvider) {
        super.unsetManagedProvider((ManagedProvider)managedProvider);
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC)
    protected void setModuleTypeRegistry(ModuleTypeRegistry moduleTypeRegistry) {
        this.moduleTypeRegistry = moduleTypeRegistry;
    }

    protected void unsetModuleTypeRegistry(ModuleTypeRegistry moduleTypeRegistry) {
        this.moduleTypeRegistry = null;
    }

    /*
     * WARNING - void declaration
     */
    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC)
    protected void setTemplateRegistry(TemplateRegistry<RuleTemplate> templateRegistry) {
        TemplateRegistry<RuleTemplate> templateRegistry2 = templateRegistry;
        if (templateRegistry2 instanceof RuleTemplateRegistry) {
            void registry;
            RuleTemplateRegistry ruleTemplateRegistry = (RuleTemplateRegistry)templateRegistry2;
            RuleTemplateRegistry cfr_ignored_0 = (RuleTemplateRegistry)templateRegistry2;
            this.templateRegistry = registry;
            templateRegistry.addRegistryChangeListener(this);
        }
    }

    protected void unsetTemplateRegistry(TemplateRegistry<RuleTemplate> templateRegistry) {
        if (templateRegistry instanceof RuleTemplateRegistry) {
            this.templateRegistry = null;
            templateRegistry.removeRegistryChangeListener(this);
        }
    }

    @Override
    public Rule add(Rule rule) {
        super.add((Identifiable)rule);
        Rule ruleCopy = (Rule)this.get(rule.getUID());
        if (ruleCopy == null) {
            throw new IllegalStateException();
        }
        return ruleCopy;
    }

    protected void notifyListenersAboutAddedElement(Rule element) {
        this.postRuleAddedEvent(element);
        this.postRuleStatusInfoEvent(element.getUID(), new RuleStatusInfo(RuleStatus.UNINITIALIZED));
        super.notifyListenersAboutAddedElement((Identifiable)element);
    }

    protected void notifyListenersAboutUpdatedElement(Rule oldElement, Rule element) {
        this.postRuleUpdatedEvent(element, oldElement);
        super.notifyListenersAboutUpdatedElement((Identifiable)oldElement, (Identifiable)element);
    }

    protected void postRuleAddedEvent(Rule rule) {
        this.postEvent((Event)RuleEventFactory.createRuleAddedEvent(rule, SOURCE));
    }

    protected void postRuleRemovedEvent(Rule rule) {
        this.postEvent((Event)RuleEventFactory.createRuleRemovedEvent(rule, SOURCE));
    }

    protected void postRuleUpdatedEvent(Rule rule, Rule oldRule) {
        this.postEvent((Event)RuleEventFactory.createRuleUpdatedEvent(rule, oldRule, SOURCE));
    }

    protected void postRuleStatusInfoEvent(String ruleUID, RuleStatusInfo statusInfo) {
        this.postEvent((Event)RuleEventFactory.createRuleStatusInfoEvent(statusInfo, ruleUID, SOURCE));
    }

    protected void onRemoveElement(Rule rule) {
        String uid = rule.getUID();
        String templateUID = rule.getTemplateUID();
        if (templateUID != null) {
            this.updateRuleTemplateMapping(templateUID, uid, true);
        }
    }

    protected void notifyListenersAboutRemovedElement(Rule element) {
        super.notifyListenersAboutRemovedElement((Identifiable)element);
        this.postRuleRemovedEvent(element);
    }

    @Override
    public Collection<Rule> getByTag(@Nullable String tag) {
        LinkedList<Rule> result = new LinkedList<Rule>();
        if (tag == null) {
            this.forEach(result::add);
        } else {
            this.forEach(rule -> {
                if (rule.getTags().contains(tag)) {
                    result.add((Rule)rule);
                }
            });
        }
        return result;
    }

    @Override
    public Collection<Rule> getByTags(String ... tags) {
        HashSet<String> tagSet = new HashSet<String>(Arrays.asList(tags));
        LinkedList<Rule> result = new LinkedList<Rule>();
        if (tagSet.isEmpty()) {
            this.forEach(result::add);
        } else {
            this.forEach(rule -> {
                if (rule.getTags().containsAll(tagSet)) {
                    result.add((Rule)rule);
                }
            });
        }
        return result;
    }

    private Rule resolveRuleByTemplate(Rule rule) {
        String templateUID = rule.getTemplateUID();
        if (templateUID == null) {
            return rule;
        }
        RuleTemplate template = this.templateRegistry.get(templateUID);
        String uid = rule.getUID();
        if (template == null) {
            this.updateRuleTemplateMapping(templateUID, uid, false);
            this.logger.debug("Rule template {} does not exist.", (Object)templateUID);
            return rule;
        }
        RuleImpl resolvedRule = (RuleImpl)RuleBuilder.create(template, rule.getUID(), rule.getName(), rule.getConfiguration(), rule.getVisibility()).build();
        this.resolveConfigurations(resolvedRule);
        this.updateRuleTemplateMapping(templateUID, uid, true);
        return resolvedRule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRuleTemplateMapping(String templateUID, String ruleUID, boolean resolved) {
        RuleRegistryImpl ruleRegistryImpl = this;
        synchronized (ruleRegistryImpl) {
            Set ruleUIDs = Objects.requireNonNull(this.mapTemplateToRules.computeIfAbsent(templateUID, k -> new HashSet()));
            if (resolved) {
                ruleUIDs.remove(ruleUID);
            } else {
                ruleUIDs.add(ruleUID);
            }
        }
    }

    protected void addProvider(Provider<Rule> provider) {
        super.addProvider(provider);
        this.forEach(provider, rule -> {
            try {
                Rule resolvedRule = this.resolveRuleByTemplate((Rule)rule);
                if (rule != resolvedRule && provider instanceof ManagedRuleProvider) {
                    this.update(resolvedRule);
                }
            }
            catch (IllegalArgumentException e) {
                this.logger.error("Added rule '{}' is invalid", (Object)rule.getUID(), (Object)e);
            }
        });
    }

    public void added(Provider<Rule> provider, Rule element) {
        String ruleUID = element.getUID();
        Rule resolvedRule = element;
        try {
            resolvedRule = this.resolveRuleByTemplate(element);
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("Added rule '{}' is invalid", (Object)ruleUID, (Object)e);
        }
        super.added(provider, (Identifiable)element);
        if (element != resolvedRule) {
            if (provider instanceof ManagedRuleProvider) {
                this.update(resolvedRule);
            } else {
                super.updated(provider, (Identifiable)element, (Identifiable)resolvedRule);
            }
        }
    }

    public void updated(Provider<Rule> provider, Rule oldElement, Rule element) {
        String uid = element.getUID();
        if (oldElement != null && uid.equals(oldElement.getUID())) {
            Rule resolvedRule = element;
            try {
                resolvedRule = this.resolveRuleByTemplate(element);
            }
            catch (IllegalArgumentException e) {
                this.logger.error("The rule '{}' is not updated, the new version is invalid", (Object)uid, (Object)e);
            }
            if (element != resolvedRule && provider instanceof ManagedRuleProvider) {
                this.update(resolvedRule);
            } else {
                super.updated(provider, (Identifiable)oldElement, (Identifiable)resolvedRule);
            }
        } else {
            throw new IllegalArgumentException(String.format("The rule '%s' is not updated, not matching with any existing rule", uid));
        }
    }

    protected void onAddElement(Rule element) throws IllegalArgumentException {
        String uid = element.getUID();
        try {
            this.resolveConfigurations(element);
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("Added rule '{}' is invalid", (Object)uid, (Object)e);
        }
    }

    protected void onUpdateElement(Rule oldElement, Rule element) throws IllegalArgumentException {
        String uid = element.getUID();
        try {
            this.resolveConfigurations(element);
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("The new version of updated rule '{}' is invalid", (Object)uid, (Object)e);
        }
    }

    private void resolveConfigurations(Rule rule) {
        List<ConfigDescriptionParameter> configDescriptions = rule.getConfigurationDescriptions();
        Configuration configuration = rule.getConfiguration();
        ConfigurationNormalizer.normalizeConfiguration(configuration, ConfigurationNormalizer.getConfigDescriptionMap(configDescriptions));
        Map configurationProperties = configuration.getProperties();
        if (rule.getTemplateUID() == null) {
            String uid = rule.getUID();
            try {
                this.validateConfiguration(configDescriptions, new HashMap<String, Object>(configurationProperties));
                this.resolveModuleConfigReferences(rule.getModules(), configurationProperties);
                ConfigurationNormalizer.normalizeModuleConfigurations(rule.getModules(), this.moduleTypeRegistry);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("The rule '%s' has incorrect configurations", uid), e);
            }
        }
    }

    private void validateConfiguration(List<ConfigDescriptionParameter> configDescriptions, Map<String, Object> configurations) {
        if (configurations == null || configurations.isEmpty()) {
            if (this.isOptionalConfig(configDescriptions)) {
                return;
            }
            StringBuilder statusDescription = new StringBuilder();
            String msg = " '%s';";
            for (ConfigDescriptionParameter configParameter : configDescriptions) {
                if (!configParameter.isRequired()) continue;
                String name = configParameter.getName();
                statusDescription.append(String.format(msg, name));
            }
            throw new IllegalArgumentException("Missing required configuration properties: " + statusDescription.toString());
        }
        for (ConfigDescriptionParameter configParameter : configDescriptions) {
            String configParameterName = configParameter.getName();
            this.processValue(configurations.remove(configParameterName), configParameter);
        }
        if (!configurations.isEmpty()) {
            StringBuilder statusDescription = new StringBuilder();
            String msg = " '%s';";
            for (String name : configurations.keySet()) {
                statusDescription.append(String.format(msg, name));
            }
            throw new IllegalArgumentException("Extra configuration properties: " + statusDescription.toString());
        }
    }

    private boolean isOptionalConfig(List<ConfigDescriptionParameter> configDescriptions) {
        if (configDescriptions != null && !configDescriptions.isEmpty()) {
            boolean required = false;
            for (ConfigDescriptionParameter param : configDescriptions) {
                boolean bl = required = required || param.isRequired();
            }
            return !required;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void processValue(@Nullable Object configValue, ConfigDescriptionParameter configParameter) {
        void lConfigValues;
        if (configValue == null) {
            if (!configParameter.isRequired()) return;
            throw new IllegalArgumentException("Required configuration property missing: \"" + configParameter.getName() + "\"!");
        }
        ConfigDescriptionParameter.Type type = configParameter.getType();
        if (!configParameter.isMultiple().booleanValue()) {
            if (this.checkType(type, configValue)) return;
            throw new IllegalArgumentException("Unexpected value for configuration property \"" + configParameter.getName() + "\". Expected is " + type.toString() + "!");
        }
        Object object = configValue;
        if (!(object instanceof List)) throw new IllegalArgumentException("Unexpected value for configuration property \"" + configParameter.getName() + "\". Expected is Array with type for elements : " + type.toString() + "!");
        List list = (List)object;
        List cfr_ignored_0 = (List)object;
        for (Object value : lConfigValues) {
            if (this.checkType(type, value)) continue;
            throw new IllegalArgumentException("Unexpected value for configuration property \"" + configParameter.getName() + "\". Expected type: " + String.valueOf(type));
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkType(ConfigDescriptionParameter.Type type, Object configValue) {
        switch (type) {
            case TEXT: {
                return configValue instanceof String;
            }
            case BOOLEAN: {
                return configValue instanceof Boolean;
            }
            case INTEGER: {
                void doubleValue;
                if (configValue instanceof BigDecimal || configValue instanceof Integer) return true;
                Object object = configValue;
                if (!(object instanceof Double)) return false;
                Double d = (Double)object;
                Double cfr_ignored_0 = (Double)object;
                if ((double)doubleValue.intValue() == doubleValue.doubleValue()) return true;
                return false;
            }
            case DECIMAL: {
                return configValue instanceof BigDecimal || configValue instanceof Double;
            }
        }
        return false;
    }

    private void resolveModuleConfigReferences(List<? extends Module> modules, Map<String, ?> ruleConfiguration) {
        if (modules != null) {
            StringBuilder statusDescription = new StringBuilder();
            for (Module module : modules) {
                try {
                    ReferenceResolver.updateConfiguration(module.getConfiguration(), ruleConfiguration, this.logger);
                }
                catch (IllegalArgumentException e) {
                    statusDescription.append(" in module[" + module.getId() + "]: " + e.getLocalizedMessage() + ";");
                }
            }
            String string = statusDescription.toString();
            if (!string.isEmpty()) {
                throw new IllegalArgumentException(String.format("Incorrect configurations: %s", string));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void added(RuleTemplate element) {
        String templateUID = element.getUID();
        HashSet<String> rules = new HashSet<String>();
        RuleRegistryImpl ruleRegistryImpl = this;
        synchronized (ruleRegistryImpl) {
            Set<String> rulesForResolving = this.mapTemplateToRules.get(templateUID);
            if (rulesForResolving != null) {
                rules.addAll(rulesForResolving);
            }
        }
        for (String rUID : rules) {
            try {
                Rule unresolvedRule = (Rule)this.get(rUID);
                if (unresolvedRule != null) {
                    Rule resolvedRule = this.resolveRuleByTemplate(unresolvedRule);
                    Provider provider = this.getProvider(rUID);
                    if (provider instanceof ManagedRuleProvider) {
                        this.update(resolvedRule);
                        continue;
                    }
                    if (provider != null) {
                        this.updated((Provider<Rule>)provider, unresolvedRule, unresolvedRule);
                        continue;
                    }
                    this.logger.error("Resolving the rule '{}' by template '{}' failed because the provider is not known", (Object)rUID, (Object)templateUID);
                    continue;
                }
                this.logger.error("Resolving the rule '{}' by template '{}' failed because it is not known to the registry", (Object)rUID, (Object)templateUID);
            }
            catch (IllegalArgumentException e) {
                this.logger.error("Resolving the rule '{}' by template '{}' failed", new Object[]{rUID, templateUID, e});
            }
        }
    }

    public void removed(RuleTemplate element) {
    }

    public void updated(RuleTemplate oldElement, RuleTemplate element) {
    }
}

