/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl.sprites;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Random;
import javax.imageio.ImageIO;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.EXTTransformFeedback;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.Util;

public final class SpriteShootout2P {
    private static final int SCREEN_WIDTH = 800;
    private static final int SCREEN_HEIGHT = 600;
    private static final int ANIMATION_TICKS = 60;
    private boolean run = true;
    private boolean render = true;
    private boolean colorMask = true;
    private boolean animate = true;
    private boolean smooth;
    private boolean vsync;
    private int ballSize = 42;
    private int ballCount = 100000;
    private SpriteRenderer renderer;
    private int texID;
    private int texBigID;
    private int texSmallID;

    private SpriteShootout2P() {
    }

    public static void main(String[] args) {
        try {
            new SpriteShootout2P().start();
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
    }

    private void start() throws LWJGLException {
        try {
            this.initGL();
            this.renderer = new SpriteRendererTF();
            this.updateBalls(this.ballCount);
            this.run();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            this.destroy();
        }
    }

    private void initGL() throws LWJGLException {
        Display.setLocation((int)((Display.getDisplayMode().getWidth() - 800) / 2), (int)((Display.getDisplayMode().getHeight() - 600) / 2));
        Display.setDisplayMode((DisplayMode)new DisplayMode(800, 600));
        Display.setTitle((String)"Sprite Shootout 2-pass");
        Display.create((PixelFormat)new PixelFormat(0, 24, 0));
        ContextCapabilities caps = GLContext.getCapabilities();
        if (!(caps.OpenGL30 || caps.OpenGL20 && caps.GL_EXT_transform_feedback)) {
            throw new RuntimeException("OpenGL 3.0 or 2.0 + EXT_transform_feedback is required for this demo.");
        }
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)800.0, (double)0.0, (double)600.0, (double)-1.0, (double)1.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glViewport((int)0, (int)0, (int)800, (int)600);
        GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f);
        try {
            this.texSmallID = SpriteShootout2P.createTexture("res/ball_sm.png");
            this.texBigID = SpriteShootout2P.createTexture("res/ball.png");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        this.texID = this.texBigID;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)771);
        GL11.glEnable((int)3008);
        GL11.glColorMask((boolean)this.colorMask, (boolean)this.colorMask, (boolean)this.colorMask, (boolean)false);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)513);
        GL11.glClearDepth((double)1.0);
        if (caps.GL_ARB_compatibility || !caps.OpenGL31) {
            GL11.glEnable((int)34913);
        }
        GL11.glEnableClientState((int)32884);
        Util.checkGLError();
    }

    private static int createTexture(String path) throws IOException {
        BufferedImage img = ImageIO.read(SpriteShootout2P.class.getClassLoader().getResource(path));
        int w = img.getWidth();
        int h = img.getHeight();
        ByteBuffer buffer = SpriteShootout2P.readImage(img);
        int texID = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)texID);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)w, (int)h, (int)0, (int)32993, (int)5121, (ByteBuffer)buffer);
        return texID;
    }

    private static ByteBuffer readImage(BufferedImage img) throws IOException {
        WritableRaster raster = img.getRaster();
        int bands = raster.getNumBands();
        int w = img.getWidth();
        int h = img.getHeight();
        int size = w * h * bands;
        byte[] pixels = new byte[size];
        raster.getDataElements(0, 0, w, h, pixels);
        ByteBuffer pbuffer = BufferUtils.createByteBuffer((int)size);
        if (bands == 4) {
            for (int i = 0; i < w * h * 4; i += 4) {
                float a = SpriteShootout2P.unpackUByte01(pixels[i + 3]);
                pbuffer.put(SpriteShootout2P.packUByte01(SpriteShootout2P.unpackUByte01(pixels[i + 2]) * a));
                pbuffer.put(SpriteShootout2P.packUByte01(SpriteShootout2P.unpackUByte01(pixels[i + 1]) * a));
                pbuffer.put(SpriteShootout2P.packUByte01(SpriteShootout2P.unpackUByte01(pixels[i + 0]) * a));
                pbuffer.put(pixels[i + 3]);
            }
        } else if (bands == 3) {
            for (int i = 0; i < w * h * 3; i += 3) {
                pbuffer.put(pixels[i + 2]);
                pbuffer.put(pixels[i + 1]);
                pbuffer.put(pixels[i + 0]);
            }
        } else {
            pbuffer.put(pixels, 0, size);
        }
        pbuffer.flip();
        return pbuffer;
    }

    private static float unpackUByte01(byte x) {
        return (float)(x & 0xFF) / 255.0f;
    }

    private static byte packUByte01(float x) {
        return (byte)(x * 255.0f);
    }

    private void updateBalls(int count) {
        System.out.println("NUMBER OF BALLS: " + count);
        this.renderer.updateBalls(this.ballCount);
    }

    private void run() {
        long startTime = System.currentTimeMillis() + 5000L;
        long fps = 0L;
        long time = Sys.getTime();
        int ticksPerUpdate = (int)(Sys.getTimerResolution() / 60L);
        this.renderer.render(false, true, 0);
        while (this.run) {
            Display.processMessages();
            this.handleInput();
            GL11.glClear((int)16640);
            long currTime = Sys.getTime();
            int delta = (int)(currTime - time);
            if (this.smooth || delta >= ticksPerUpdate) {
                this.renderer.render(this.render, this.animate, delta);
                time = currTime;
            } else {
                this.renderer.render(this.render, false, 0);
            }
            Display.update((boolean)false);
            if (startTime > System.currentTimeMillis()) {
                ++fps;
                continue;
            }
            long timeUsed = 5000L + (startTime - System.currentTimeMillis());
            startTime = System.currentTimeMillis() + 5000L;
            System.out.println("FPS: " + (double)Math.round((double)fps / ((double)timeUsed / 1000.0) * 10.0) / 10.0 + ", Balls: " + this.ballCount);
            fps = 0L;
        }
    }

    private void handleInput() {
        if (Display.isCloseRequested()) {
            this.run = false;
        }
        while (Keyboard.next()) {
            if (Keyboard.getEventKeyState()) continue;
            switch (Keyboard.getEventKey()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    this.ballCount = 1 << Keyboard.getEventKey() - 2;
                    this.updateBalls(this.ballCount);
                    break;
                }
                case 74: 
                case 78: {
                    int mult;
                    if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                        mult = 1000;
                        if (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) {
                            mult *= 5;
                        }
                    } else {
                        mult = Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184) ? 100 : (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157) ? 10 : 1);
                    }
                    if (Keyboard.getEventKey() == 74) {
                        mult = -mult;
                    }
                    this.ballCount += mult * 100;
                    if (this.ballCount <= 0) {
                        this.ballCount = 1;
                    }
                    this.updateBalls(this.ballCount);
                    break;
                }
                case 1: {
                    this.run = false;
                    break;
                }
                case 30: {
                    this.animate = !this.animate;
                    System.out.println("Animation is now " + (this.animate ? "on" : "off") + ".");
                    break;
                }
                case 46: {
                    this.colorMask = !this.colorMask;
                    GL11.glColorMask((boolean)this.colorMask, (boolean)this.colorMask, (boolean)this.colorMask, (boolean)false);
                    System.out.println("Color mask is now " + (this.colorMask ? "on" : "off") + ".");
                    if (this.colorMask) {
                        GL11.glEnable((int)3042);
                        GL11.glEnable((int)3008);
                        break;
                    }
                    GL11.glDisable((int)3042);
                    GL11.glDisable((int)3008);
                    break;
                }
                case 19: {
                    this.render = !this.render;
                    System.out.println("Rendering is now " + (this.render ? "on" : "off") + ".");
                    break;
                }
                case 31: {
                    this.smooth = !this.smooth;
                    System.out.println("Smooth animation is now " + (this.smooth ? "on" : "off") + ".");
                    break;
                }
                case 20: {
                    if (this.texID == this.texBigID) {
                        this.texID = this.texSmallID;
                        this.ballSize = 16;
                    } else {
                        this.texID = this.texBigID;
                        this.ballSize = 42;
                    }
                    this.renderer.updateBallSize();
                    GL11.glBindTexture((int)3553, (int)this.texID);
                    System.out.println("Now using the " + (this.texID == this.texBigID ? "big" : "small") + " texture.");
                    break;
                }
                case 47: {
                    this.vsync = !this.vsync;
                    Display.setVSyncEnabled((boolean)this.vsync);
                    System.out.println("VSYNC is now " + (this.vsync ? "enabled" : "disabled") + ".");
                }
            }
        }
        while (Mouse.next()) {
        }
    }

    private void destroy() {
        Display.destroy();
    }

    private class SpriteRendererTF
    extends SpriteRenderer {
        private int progIDTF;
        private int ballSizeLoc;
        private int deltaLoc;
        private int[] tfVBO;
        private int currVBO;
        private int depthVBO;
        private int depthLoc;

        SpriteRendererTF() {
            this.tfVBO = new int[2];
            System.out.println("Shootout Implementation: TF GPU animation & 2-pass rendering");
            int vshID = GL20.glCreateShader((int)35633);
            GL20.glShaderSource((int)vshID, (CharSequence)"#version 130\nconst float WIDTH = 800;\nconst float HEIGHT = 600;\nuniform float ballSize;\nuniform float delta;\nvoid main(void) {\n     vec4 anim = gl_Vertex;\n     anim.xy = anim.xy + anim.zw * delta;\n     vec2 animC = clamp(anim.xy, vec2(ballSize), vec2(WIDTH - ballSize, HEIGHT - ballSize));\n     if ( anim.x != animC.x ) anim.z = -anim.z;\n     if ( anim.y != animC.y ) anim.w = -anim.w;\n     gl_Position = vec4(animC, anim.zw);\n}");
            GL20.glCompileShader((int)vshID);
            if (GL20.glGetShaderi((int)vshID, (int)35713) == 0) {
                System.out.println(GL20.glGetShaderInfoLog((int)vshID, (int)GL20.glGetShaderi((int)vshID, (int)35716)));
                throw new RuntimeException("Failed to compile vertex shader.");
            }
            this.progIDTF = GL20.glCreateProgram();
            GL20.glAttachShader((int)this.progIDTF, (int)vshID);
            GL30.glTransformFeedbackVaryings((int)this.progIDTF, (CharSequence[])new CharSequence[]{"gl_Position"}, (int)35981);
            GL20.glLinkProgram((int)this.progIDTF);
            if (GL20.glGetProgrami((int)this.progIDTF, (int)35714) == 0) {
                System.out.println(GL20.glGetProgramInfoLog((int)this.progIDTF, (int)GL20.glGetProgrami((int)this.progIDTF, (int)35716)));
                throw new RuntimeException("Failed to link shader program.");
            }
            GL20.glUseProgram((int)this.progIDTF);
            this.ballSizeLoc = GL20.glGetUniformLocation((int)this.progIDTF, (CharSequence)"ballSize");
            this.deltaLoc = GL20.glGetUniformLocation((int)this.progIDTF, (CharSequence)"delta");
            GL20.glUniform1f((int)this.ballSizeLoc, (float)((float)SpriteShootout2P.this.ballSize * 0.5f));
            vshID = GL20.glCreateShader((int)35633);
            GL20.glShaderSource((int)vshID, (CharSequence)"#version 130\nin float depth;\nvoid main(void) {\n     gl_Position = gl_ModelViewProjectionMatrix * vec4(gl_Vertex.xy, depth, gl_Vertex.w);\n}");
            GL20.glCompileShader((int)vshID);
            if (GL20.glGetShaderi((int)vshID, (int)35713) == 0) {
                System.out.println(GL20.glGetShaderInfoLog((int)vshID, (int)GL20.glGetShaderi((int)vshID, (int)35716)));
                throw new RuntimeException("Failed to compile vertex shader.");
            }
            this.createPrograms(vshID);
            this.depthLoc = GL20.glGetAttribLocation((int)this.progID, (CharSequence)"depth");
        }

        public void updateBallSize() {
            GL20.glUseProgram((int)this.progIDTF);
            GL20.glUniform1f((int)this.ballSizeLoc, (float)((float)SpriteShootout2P.this.ballSize * 0.5f));
            super.updateBallSize();
        }

        public void updateBalls(int count) {
            int i;
            int i2;
            FloatBuffer depths = BufferUtils.createFloatBuffer((int)(count * 2));
            float depthStep = 1.9f / (float)count;
            float depth = Float.parseFloat("0x1.fffffep-1");
            for (i2 = 0; i2 < count; ++i2) {
                depths.put(depth);
                depth -= depthStep;
            }
            for (i2 = 0; i2 < count; ++i2) {
                depths.put(depths.get(count - 1 - i2));
            }
            depths.flip();
            if (this.depthVBO != 0) {
                GL15.glDeleteBuffers((int)this.depthVBO);
            }
            this.depthVBO = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)this.depthVBO);
            GL15.glBufferData((int)34962, (FloatBuffer)depths, (int)35044);
            GL20.glEnableVertexAttribArray((int)this.depthLoc);
            GL20.glVertexAttribPointer((int)this.depthLoc, (int)1, (int)5126, (boolean)false, (int)0, (long)0L);
            FloatBuffer transform = BufferUtils.createFloatBuffer((int)(count * 2 * 4));
            Random random = new Random();
            for (i = 0; i < count; ++i) {
                transform.put((int)(random.nextFloat() * (float)(800 - SpriteShootout2P.this.ballSize) + (float)SpriteShootout2P.this.ballSize * 0.5f));
                transform.put((int)(random.nextFloat() * (float)(600 - SpriteShootout2P.this.ballSize) + (float)SpriteShootout2P.this.ballSize * 0.5f));
                transform.put(random.nextFloat() * 0.4f - 0.2f);
                transform.put(random.nextFloat() * 0.4f - 0.2f);
            }
            for (i = 0; i < count; ++i) {
                int offset = (count - 1 - i) * 4;
                transform.put(transform.get(offset + 0));
                transform.put(transform.get(offset + 1));
                transform.put(transform.get(offset + 2));
                transform.put(transform.get(offset + 3));
            }
            transform.flip();
            if (this.tfVBO[0] != 0) {
                for (i = 0; i < this.tfVBO.length; ++i) {
                    GL15.glDeleteBuffers((int)this.tfVBO[i]);
                }
            }
            for (i = 0; i < this.tfVBO.length; ++i) {
                this.tfVBO[i] = GL15.glGenBuffers();
                GL15.glBindBuffer((int)35982, (int)this.tfVBO[i]);
                GL15.glBufferData((int)35982, (FloatBuffer)transform, (int)35044);
            }
            GL15.glBindBuffer((int)34962, (int)this.tfVBO[0]);
            GL11.glVertexPointer((int)2, (int)5126, (int)16, (long)0L);
        }

        public void render(boolean render, boolean animate, int delta) {
            if (animate) {
                GL20.glDisableVertexAttribArray((int)this.depthLoc);
                int vbo = this.currVBO;
                this.currVBO = 1 - this.currVBO;
                GL20.glUseProgram((int)this.progIDTF);
                GL20.glUniform1f((int)this.deltaLoc, (float)delta);
                GL15.glBindBuffer((int)34962, (int)this.tfVBO[vbo]);
                GL11.glVertexPointer((int)4, (int)5126, (int)0, (long)0L);
                GL11.glEnable((int)35977);
                if (GLContext.getCapabilities().OpenGL30) {
                    GL30.glBindBufferBase((int)35982, (int)0, (int)this.tfVBO[1 - vbo]);
                    GL30.glBeginTransformFeedback((int)0);
                    GL11.glDrawArrays((int)0, (int)0, (int)(SpriteShootout2P.this.ballCount * 2));
                    GL30.glEndTransformFeedback();
                } else {
                    EXTTransformFeedback.glBindBufferBaseEXT((int)35982, (int)0, (int)this.tfVBO[1 - vbo]);
                    EXTTransformFeedback.glBeginTransformFeedbackEXT((int)0);
                    GL11.glDrawArrays((int)0, (int)0, (int)(SpriteShootout2P.this.ballCount * 2));
                    EXTTransformFeedback.glEndTransformFeedbackEXT();
                }
                GL11.glDisable((int)35977);
                GL20.glUseProgram((int)this.progID);
                GL11.glVertexPointer((int)2, (int)5126, (int)16, (long)0L);
                GL20.glEnableVertexAttribArray((int)this.depthLoc);
            }
            if (render) {
                GL11.glAlphaFunc((int)514, (float)1.0f);
                GL11.glDisable((int)3042);
                GL11.glDrawArrays((int)0, (int)0, (int)SpriteShootout2P.this.ballCount);
                GL11.glEnable((int)3042);
                GL11.glAlphaFunc((int)516, (float)0.0f);
                GL11.glDepthMask((boolean)false);
                GL11.glDrawArrays((int)0, (int)SpriteShootout2P.this.ballCount, (int)SpriteShootout2P.this.ballCount);
                GL11.glDepthMask((boolean)true);
            }
        }
    }

    private abstract class SpriteRenderer {
        protected int progID;

        private SpriteRenderer() {
        }

        protected void createPrograms(int vshID) {
            int fshID = GL20.glCreateShader((int)35632);
            GL20.glShaderSource((int)fshID, (CharSequence)"uniform sampler2D COLOR_MAP;\nvoid main(void) {\n     gl_FragColor = texture2D(COLOR_MAP, gl_PointCoord);\n}");
            GL20.glCompileShader((int)fshID);
            if (GL20.glGetShaderi((int)fshID, (int)35713) == 0) {
                System.out.println(GL20.glGetShaderInfoLog((int)fshID, (int)GL20.glGetShaderi((int)fshID, (int)35716)));
                throw new RuntimeException("Failed to compile fragment shader.");
            }
            this.progID = GL20.glCreateProgram();
            GL20.glAttachShader((int)this.progID, (int)vshID);
            GL20.glAttachShader((int)this.progID, (int)fshID);
            GL20.glLinkProgram((int)this.progID);
            if (GL20.glGetProgrami((int)this.progID, (int)35714) == 0) {
                System.out.println(GL20.glGetProgramInfoLog((int)this.progID, (int)GL20.glGetProgrami((int)this.progID, (int)35716)));
                throw new RuntimeException("Failed to link shader program.");
            }
            GL20.glUseProgram((int)this.progID);
            GL20.glUniform1i((int)GL20.glGetUniformLocation((int)this.progID, (CharSequence)"COLOR_MAP"), (int)0);
            this.updateBallSize();
            GL11.glEnableClientState((int)32884);
        }

        public void updateBallSize() {
            GL11.glPointSize((float)SpriteShootout2P.this.ballSize);
        }

        protected abstract void updateBalls(int var1);

        protected abstract void render(boolean var1, boolean var2, int var3);
    }
}

