/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.runtime.security;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class RolesAllowedConfigExpStorage {
    private final Map<String, Supplier<String[]>> configExpToAllowedRoles;
    private final Map<String, String[]> rolesAllowedExpCache;

    public RolesAllowedConfigExpStorage(Map<String, Supplier<String[]>> configExpToAllowedRoles) {
        this.configExpToAllowedRoles = Map.copyOf(configExpToAllowedRoles);
        this.rolesAllowedExpCache = new HashMap<String, String[]>();
    }

    public synchronized void resolveRolesAllowedConfigExp() {
        if (this.rolesAllowedExpCache.isEmpty()) {
            for (Map.Entry<String, Supplier<String[]>> e : this.configExpToAllowedRoles.entrySet()) {
                String roleConfigExp = e.getKey();
                Supplier<String[]> rolesSupplier = e.getValue();
                this.rolesAllowedExpCache.put(roleConfigExp, rolesSupplier.get());
            }
        }
    }

    String[] getRoles(String configExpression) {
        return this.rolesAllowedExpCache.get(configExpression);
    }
}

