/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi_modified.sctp4j;

import java.io.IOException;
import org.jitsi.utils.logging2.Logger;
import org.jitsi_modified.sctp4j.SctpJni;
import org.jitsi_modified.sctp4j.SctpSocket;

public class SctpServerSocket
extends SctpSocket {
    private boolean accepted = false;

    public SctpServerSocket(long ptr, long id, Logger parentLogger) {
        super(ptr, id, parentLogger);
    }

    public void listen() {
        try {
            this.lockPtr();
        }
        catch (IOException ioe) {
            this.logger.error("Server socket can't listen: ", ioe);
            return;
        }
        try {
            SctpJni.usrsctp_listen(this.ptr);
        }
        finally {
            this.unlockPtr();
        }
    }

    @Override
    protected boolean isReady() {
        return this.socketConnected() && this.accepted;
    }

    public boolean accept() {
        boolean ret = false;
        try {
            this.lockPtr();
        }
        catch (IOException ioe) {
            this.logger.error("Server can't accept: ", ioe);
            return ret;
        }
        try {
            if (SctpJni.usrsctp_accept(this.ptr)) {
                this.accepted = true;
                if (this.isReady()) {
                    this.eventHandler.onReady();
                }
                ret = true;
            }
        }
        finally {
            this.unlockPtr();
        }
        return ret;
    }
}

