/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.relay;

import java.nio.ByteBuffer;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.dcsctp4j.DcSctpMessage;
import org.jitsi.dcsctp4j.ErrorKind;
import org.jitsi.dcsctp4j.SendPacketStatus;
import org.jitsi.dcsctp4j.SendStatus;
import org.jitsi.metrics.CounterMetric;
import org.jitsi.metrics.MetricsContainer;
import org.jitsi.nlj.Features;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.PacketHandler;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.Transceiver;
import org.jitsi.nlj.TransceiverEventHandler;
import org.jitsi.nlj.VideoType;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.rtcp.RtcpEventNotifier;
import org.jitsi.nlj.rtcp.RtcpListener;
import org.jitsi.nlj.rtp.AudioRtpPacket;
import org.jitsi.nlj.rtp.RtpExtension;
import org.jitsi.nlj.rtp.RtpExtensionType;
import org.jitsi.nlj.rtp.SsrcAssociationType;
import org.jitsi.nlj.rtp.VideoRtpPacket;
import org.jitsi.nlj.srtp.SrtpProfileInformation;
import org.jitsi.nlj.srtp.SrtpTransformers;
import org.jitsi.nlj.srtp.SrtpUtil;
import org.jitsi.nlj.srtp.TlsRole;
import org.jitsi.nlj.stats.EndpointConnectionStats;
import org.jitsi.nlj.stats.PacketStreamStats;
import org.jitsi.nlj.stats.TransceiverStats;
import org.jitsi.nlj.transform.PipelineBuilder;
import org.jitsi.nlj.transform.PipelineDslKt;
import org.jitsi.nlj.transform.node.ConsumerNode;
import org.jitsi.nlj.transform.node.Node;
import org.jitsi.nlj.transform.node.ToggleablePcapWriter;
import org.jitsi.nlj.transform.node.incoming.IncomingSsrcStats;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.BufferPool;
import org.jitsi.nlj.util.ClockUtils;
import org.jitsi.nlj.util.LocalSsrcAssociation;
import org.jitsi.nlj.util.PacketInfoQueue;
import org.jitsi.nlj.util.RemoteSsrcAssociation;
import org.jitsi.rtp.Packet;
import org.jitsi.rtp.UnparsedPacket;
import org.jitsi.rtp.extensions.PacketExtensionsKt;
import org.jitsi.rtp.rtcp.CompoundRtcpPacket;
import org.jitsi.rtp.rtcp.RtcpByePacket;
import org.jitsi.rtp.rtcp.RtcpHeader;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.rtp.rtcp.RtcpReportBlock;
import org.jitsi.rtp.rtcp.RtcpRrPacket;
import org.jitsi.rtp.rtcp.RtcpSdesPacket;
import org.jitsi.rtp.rtcp.RtcpSrPacket;
import org.jitsi.rtp.rtcp.SdesChunk;
import org.jitsi.rtp.rtcp.rtcpfb.RtcpFbPacket;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.RtcpFbFirPacket;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.RtcpFbPliPacket;
import org.jitsi.rtp.rtp.RtpHeader;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.event.EventEmitter;
import org.jitsi.utils.event.SyncEventEmitter;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.utils.queue.CountingErrorHandler;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.CryptexConfig;
import org.jitsi.videobridge.EncodingsManager;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.PotentialPacketHandler;
import org.jitsi.videobridge.TransportConfig;
import org.jitsi.videobridge.datachannel.DataChannel;
import org.jitsi.videobridge.datachannel.DataChannelStack;
import org.jitsi.videobridge.datachannel.protocol.DataChannelPacket;
import org.jitsi.videobridge.dcsctp.DcSctpBaseCallbacks;
import org.jitsi.videobridge.dcsctp.DcSctpHandler;
import org.jitsi.videobridge.dcsctp.DcSctpTransport;
import org.jitsi.videobridge.message.BridgeChannelMessage;
import org.jitsi.videobridge.message.SourceVideoTypeMessage;
import org.jitsi.videobridge.metrics.QueueMetrics;
import org.jitsi.videobridge.metrics.VideobridgeMetrics;
import org.jitsi.videobridge.metrics.VideobridgeMetricsContainer;
import org.jitsi.videobridge.relay.AudioSourceDesc;
import org.jitsi.videobridge.relay.Relay;
import org.jitsi.videobridge.relay.RelayEndpointSender;
import org.jitsi.videobridge.relay.RelayMessageTransport;
import org.jitsi.videobridge.relay.RelayedEndpoint;
import org.jitsi.videobridge.relay.RelayedPacketInfo;
import org.jitsi.videobridge.rest.root.debug.EndpointDebugFeatures;
import org.jitsi.videobridge.sctp.DataChannelHandler;
import org.jitsi.videobridge.sctp.SctpConfig;
import org.jitsi.videobridge.sctp.SctpHandler;
import org.jitsi.videobridge.sctp.SctpManager;
import org.jitsi.videobridge.stats.PacketTransitStats;
import org.jitsi.videobridge.transport.dtls.DtlsTransport;
import org.jitsi.videobridge.transport.ice.IceTransport;
import org.jitsi.videobridge.util.ByteBufferPool;
import org.jitsi.videobridge.util.PacketUtils;
import org.jitsi.videobridge.util.TaskPools;
import org.jitsi.videobridge.websocket.ColibriWebSocketService;
import org.jitsi.videobridge.websocket.ColibriWebSocketServiceSupplierKt;
import org.jitsi.xmpp.extensions.colibri.WebSocketPacketExtension;
import org.jitsi.xmpp.extensions.colibri2.Sctp;
import org.jitsi.xmpp.extensions.jingle.DtlsFingerprintPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.util.XmlStringBuilderUtil;
import org.jitsi_modified.sctp4j.SctpClientSocket;
import org.jitsi_modified.sctp4j.SctpServerSocket;
import org.jitsi_modified.sctp4j.SctpSocket;
import org.json.simple.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0098\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0011\u0018\u0000 \u00c9\u00012\u00020\u00012\u00020\u0002:\n\u00c9\u0001\u00ca\u0001\u00cb\u0001\u00cc\u0001\u00cd\u0001BE\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0006\u0010Y\u001a\u00020XJ\b\u0010a\u001a\u00020bH\u0002J\b\u0010c\u001a\u00020bH\u0002J \u0010f\u001a\u00020b2\u0006\u0010g\u001a\u00020h2\u0006\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020lH\u0002J\u000e\u0010m\u001a\u00020b2\u0006\u0010n\u001a\u00020oJ\u0010\u0010p\u001a\u00020b2\u0006\u0010n\u001a\u00020oH\u0002J\u0010\u0010q\u001a\u00020b2\u0006\u0010n\u001a\u00020oH\u0002J\u000e\u0010r\u001a\u00020b2\u0006\u0010s\u001a\u00020tJ\u000e\u0010u\u001a\u00020b2\u0006\u0010v\u001a\u00020wJ\u000e\u0010x\u001a\u00020b2\u0006\u0010y\u001a\u00020zJ\u0006\u0010{\u001a\u00020zJ\u0016\u0010|\u001a\u00020b2\u0006\u0010}\u001a\u00020~2\u0006\u0010\u007f\u001a\u00020\u000bJ\u000f\u0010\u0080\u0001\u001a\u00020\u000b2\u0006\u0010}\u001a\u00020~J\u0013\u0010\u0081\u0001\u001a\u00020b2\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0002J\u0011\u0010\u0084\u0001\u001a\u00020b2\b\u0010\u0082\u0001\u001a\u00030\u0085\u0001J.\u0010\u0086\u0001\u001a\u00020b2\u0007\u0010\u0087\u0001\u001a\u00020\u00042\u0007\u0010\u0088\u0001\u001a\u00020G2\u0007\u0010\u0089\u0001\u001a\u00020G2\b\u0010\u008a\u0001\u001a\u00030\u008b\u0001H\u0016J\u0011\u0010\u008c\u0001\u001a\u00020\u000b2\b\u0010\u0082\u0001\u001a\u00030\u0085\u0001J\u0011\u0010\u008d\u0001\u001a\u00020b2\b\u0010\u008e\u0001\u001a\u00030\u008f\u0001J\u0007\u0010\u0090\u0001\u001a\u00020bJ\"\u0010\u0091\u0001\u001a\u00020b2\u0007\u0010\u0092\u0001\u001a\u00020l2\u0007\u0010\u0093\u0001\u001a\u00020h2\u0007\u0010\u0094\u0001\u001a\u00020hJ>\u0010\u0095\u0001\u001a\u0004\u0018\u00010E2\u0006\u0010\u0003\u001a\u00020\u00042\t\u0010\u0096\u0001\u001a\u0004\u0018\u00010\u00042\u000f\u0010\u0097\u0001\u001a\n\u0012\u0005\u0012\u00030\u0099\u00010\u0098\u00012\u000f\u0010\u009a\u0001\u001a\n\u0012\u0005\u0012\u00030\u009b\u00010\u0098\u0001J1\u0010\u009c\u0001\u001a\u00020b2\u0006\u0010\u0003\u001a\u00020\u00042\u000f\u0010\u0097\u0001\u001a\n\u0012\u0005\u0012\u00030\u0099\u00010\u0098\u00012\u000f\u0010\u009a\u0001\u001a\n\u0012\u0005\u0012\u00030\u009b\u00010\u0098\u0001J\u000f\u0010\u009d\u0001\u001a\u00020b2\u0006\u0010\u0003\u001a\u00020\u0004J\u0012\u0010\u009e\u0001\u001a\u00020L2\u0007\u0010\u0087\u0001\u001a\u00020\u0004H\u0002J\u0010\u0010\u009f\u0001\u001a\u00020b2\u0007\u0010\u00a0\u0001\u001a\u00020\u001cJ\u0010\u0010\u00a1\u0001\u001a\u00020b2\u0007\u0010\u00a2\u0001\u001a\u00020\u001eJ\u0010\u0010\u00a3\u0001\u001a\u00020b2\u0007\u0010\u00a4\u0001\u001a\u00020\u000bJ4\u0010\u00a5\u0001\u001a\u00020b2\u0007\u0010\u00a6\u0001\u001a\u00020E2\u000f\u0010\u0097\u0001\u001a\n\u0012\u0005\u0012\u00030\u0099\u00010\u0098\u00012\u000f\u0010\u009a\u0001\u001a\n\u0012\u0005\u0012\u00030\u009b\u00010\u0098\u0001H\u0002J\u0011\u0010\u00a7\u0001\u001a\u0004\u0018\u00010E2\u0006\u0010\u0003\u001a\u00020\u0004J\u0012\u0010\u00a8\u0001\u001a\u0004\u0018\u00010E2\u0007\u0010\u00a9\u0001\u001a\u00020GJ\u0007\u0010\u00aa\u0001\u001a\u00020bJ\u0010\u0010\u00ab\u0001\u001a\u00020\u000b2\u0007\u0010\u00ac\u0001\u001a\u00020\u0004J\u001a\u0010\u00ad\u0001\u001a\t\u0012\u0004\u0012\u00020G0\u0098\u00012\b\u0010\u00ae\u0001\u001a\u00030\u00af\u0001H\u0002J5\u0010\u00b0\u0001\u001a\u00020b2\b\u0010\u00ae\u0001\u001a\u00030\u00af\u00012\t\u0010\u0087\u0001\u001a\u0004\u0018\u00010\u00042\u0015\u0010\u00b1\u0001\u001a\u0010\u0012\u0005\u0012\u00030\u00b3\u0001\u0012\u0004\u0012\u00020b0\u00b2\u0001H\u0002J(\u0010\u00b4\u0001\u001a\u00020b2\b\u0010\u00ae\u0001\u001a\u00030\u00af\u00012\n\u0010\u00b5\u0001\u001a\u0005\u0018\u00010\u00b6\u00012\t\u0010\u0087\u0001\u001a\u0004\u0018\u00010\u0004J\u001c\u0010\u00b7\u0001\u001a\u00020b2\b\u0010\u00ae\u0001\u001a\u00030\u00af\u00012\t\u0010\u0087\u0001\u001a\u0004\u0018\u00010\u0004J\t\u0010\u00b8\u0001\u001a\u00020\u000bH\u0002J\u0013\u0010\u00b9\u0001\u001a\u00020\u000b2\b\u0010\u00ae\u0001\u001a\u00030\u0085\u0001H\u0016J\u0013\u0010\u00ba\u0001\u001a\u00020b2\b\u0010\u00ae\u0001\u001a\u00030\u0085\u0001H\u0016J\u000f\u0010\u00bb\u0001\u001a\u00020b2\u0006\u0010\u0003\u001a\u00020\u0004J\t\u0010\u00c7\u0001\u001a\u00020bH\u0002J\u0007\u0010\u00c8\u0001\u001a\u00020bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u00103\u001a\u000604R\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u00105\u001a\u000604R\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010=\u001a\n ?*\u0004\u0018\u00010>0>X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010@R\u0018\u0010A\u001a\n ?*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010BR\u001a\u0010C\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020E0DX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010F\u001a\u000e\u0012\u0004\u0012\u00020G\u0012\u0004\u0012\u00020E0DX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020IX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010J\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020L0KX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010M\u001a\u00020N\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010PR\u000e\u0010Q\u001a\u00020RX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010S\u001a\u00020T\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010VR\u000e\u0010W\u001a\u00020XX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010Z\u001a\u00020[X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\\\u001a\u00020[X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010]\u001a\u00020^8F\u00a2\u0006\u0006\u001a\u0004\b_\u0010`R\u0010\u0010d\u001a\u0004\u0018\u00010eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u00bc\u0001\u001a\u00030\u00bd\u00018F\u00a2\u0006\b\u001a\u0006\b\u00be\u0001\u0010\u00bf\u0001R\u0014\u0010\u00c0\u0001\u001a\u00020G8F\u00a2\u0006\b\u001a\u0006\b\u00c1\u0001\u0010\u00c2\u0001R\u0015\u0010\u00c3\u0001\u001a\u00030\u00bd\u00018F\u00a2\u0006\b\u001a\u0006\b\u00c4\u0001\u0010\u00bf\u0001R\u0014\u0010\u00c5\u0001\u001a\u00020G8F\u00a2\u0006\b\u001a\u0006\b\u00c6\u0001\u0010\u00c2\u0001\u00a8\u0006\u00ce\u0001"}, d2={"Lorg/jitsi/videobridge/relay/Relay;", "Lorg/jitsi/videobridge/EncodingsManager$EncodingsUpdateListener;", "Lorg/jitsi/videobridge/PotentialPacketHandler;", "id", "", "conference", "Lorg/jitsi/videobridge/Conference;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "meshId", "iceControlling", "", "useUniquePort", "clock", "Ljava/time/Clock;", "<init>", "(Ljava/lang/String;Lorg/jitsi/videobridge/Conference;Lorg/jitsi/utils/logging2/Logger;Ljava/lang/String;ZZLjava/time/Clock;)V", "getId", "()Ljava/lang/String;", "getConference", "()Lorg/jitsi/videobridge/Conference;", "getMeshId", "eventEmitter", "Lorg/jitsi/utils/event/EventEmitter;", "Lorg/jitsi/videobridge/AbstractEndpoint$EventHandler;", "logger", "payloadTypes", "", "Lorg/jitsi/nlj/format/PayloadType;", "rtpExtensions", "Lorg/jitsi/nlj/rtp/RtpExtension;", "extmapAllowMixed", "expired", "sctpHandler", "Lorg/jitsi/videobridge/dcsctp/DcSctpHandler;", "usrSctpHandler", "Lorg/jitsi/videobridge/sctp/SctpHandler;", "sctpTransport", "Lorg/jitsi/videobridge/dcsctp/DcSctpTransport;", "sctpRole", "Lorg/jitsi/xmpp/extensions/colibri2/Sctp$Role;", "sctpManager", "Lorg/jitsi/videobridge/sctp/SctpManager;", "sctpSocket", "Lorg/jitsi_modified/sctp4j/SctpSocket;", "dataChannelHandler", "Lorg/jitsi/videobridge/sctp/DataChannelHandler;", "dataChannelStack", "Lorg/jitsi/videobridge/datachannel/DataChannelStack;", "toggleablePcapWriter", "Lorg/jitsi/nlj/transform/node/ToggleablePcapWriter;", "sctpRecvPcap", "Lorg/jitsi/nlj/transform/node/ToggleablePcapWriter$PcapWriterNode;", "sctpSendPcap", "sctpPipeline", "Lorg/jitsi/nlj/transform/node/Node;", "iceTransport", "Lorg/jitsi/videobridge/transport/ice/IceTransport;", "dtlsTransport", "Lorg/jitsi/videobridge/transport/dtls/DtlsTransport;", "cryptex", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "kotlin.jvm.PlatformType", "Lorg/jitsi/utils/logging/DiagnosticContext;", "timelineLogger", "Lorg/jitsi/utils/logging2/Logger;", "relayedEndpoints", "Ljava/util/HashMap;", "Lorg/jitsi/videobridge/relay/RelayedEndpoint;", "endpointsBySsrc", "", "endpointsLock", "", "senders", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jitsi/videobridge/relay/RelayEndpointSender;", "statistics", "Lorg/jitsi/videobridge/relay/Relay$Statistics;", "getStatistics", "()Lorg/jitsi/videobridge/relay/Relay$Statistics;", "rttListener", "Lorg/jitsi/nlj/stats/EndpointConnectionStats$EndpointConnectionStatsListener;", "transceiver", "Lorg/jitsi/nlj/Transceiver;", "getTransceiver", "()Lorg/jitsi/nlj/Transceiver;", "messageTransport", "Lorg/jitsi/videobridge/relay/RelayMessageTransport;", "getMessageTransport", "outgoingSrtpPacketQueue", "Lorg/jitsi/nlj/util/PacketInfoQueue;", "incomingDataChannelMessagesQueue", "debugState", "Lorg/json/simple/JSONObject;", "getDebugState", "()Lorg/json/simple/JSONObject;", "setupIceTransport", "", "setupDtlsTransport", "srtpTransformers", "Lorg/jitsi/nlj/srtp/SrtpTransformers;", "setSrtpInformation", "chosenSrtpProtectionProfile", "", "tlsRole", "Lorg/jitsi/nlj/srtp/TlsRole;", "keyingMaterial", "", "createSctpConnection", "sctpDesc", "Lorg/jitsi/xmpp/extensions/colibri2/Sctp;", "createDcSctpConnection", "createUsrSctpConnection", "connectUsrSctpConnection", "sctpClientSocket", "Lorg/jitsi_modified/sctp4j/SctpClientSocket;", "acceptUsrSctpConnection", "sctpServerSocket", "Lorg/jitsi_modified/sctp4j/SctpServerSocket;", "setTransportInfo", "transportInfo", "Lorg/jitsi/xmpp/extensions/jingle/IceUdpTransportPacketExtension;", "describeTransport", "setFeature", "feature", "Lorg/jitsi/videobridge/rest/root/debug/EndpointDebugFeatures;", "enabled", "isFeatureEnabled", "handleMediaPacket", "packetInfo", "Lorg/jitsi/videobridge/relay/RelayedPacketInfo;", "handleIncomingPacket", "Lorg/jitsi/nlj/PacketInfo;", "onNewSsrcAssociation", "endpointId", "primarySsrc", "secondarySsrc", "type", "Lorg/jitsi/nlj/rtp/SsrcAssociationType;", "doSendSrtp", "sendMessage", "msg", "Lorg/jitsi/videobridge/message/BridgeChannelMessage;", "relayMessageTransportConnected", "dtlsAppPacketReceived", "data", "off", "len", "addRemoteEndpoint", "statsId", "audioSources", "", "Lorg/jitsi/videobridge/relay/AudioSourceDesc;", "videoSources", "Lorg/jitsi/nlj/MediaSourceDesc;", "updateRemoteEndpoint", "removeRemoteEndpoint", "getOrCreateRelaySender", "addPayloadType", "payloadType", "addRtpExtension", "rtpExtension", "setExtmapAllowMixed", "allow", "setEndpointMediaSources", "ep", "getEndpoint", "getEndpointBySsrc", "ssrc", "scheduleRelayMessageTransportTimeout", "acceptWebSocket", "password", "getRtcpSsrcs", "packet", "Lorg/jitsi/rtp/rtcp/RtcpPacket;", "doRtcpCallbacks", "callback", "Lkotlin/Function1;", "Lorg/jitsi/nlj/rtcp/RtcpEventNotifier;", "rtcpPacketReceived", "receivedTime", "Ljava/time/Instant;", "rtcpPacketSent", "isTransportConnected", "wants", "send", "endpointExpired", "incomingBitrateBps", "", "getIncomingBitrateBps", "()D", "incomingPacketRate", "getIncomingPacketRate", "()J", "outgoingBitrateBps", "getOutgoingBitrateBps", "outgoingPacketRate", "getOutgoingPacketRate", "updateStatsOnExpire", "expire", "Companion", "Statistics", "SctpCallbacks", "TransceiverEventHandlerImpl", "IncomingRelayPacketHandler", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nRelay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Relay.kt\norg/jitsi/videobridge/relay/Relay\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,1347:1\n1#2:1348\n63#3,4:1349\n63#3,4:1357\n63#3,4:1361\n63#3,4:1369\n63#3,4:1432\n63#3,4:1436\n63#3,4:1440\n63#3,4:1444\n1855#4,2:1353\n1855#4,2:1355\n1855#4,2:1365\n1855#4,2:1367\n1855#4,2:1373\n1855#4,2:1375\n1855#4,2:1377\n1855#4:1379\n1856#4:1382\n1855#4,2:1385\n1855#4,2:1387\n1855#4,2:1389\n1855#4,2:1393\n1855#4,2:1395\n1855#4,2:1397\n1855#4,2:1399\n1855#4,2:1401\n1855#4,2:1403\n1855#4,2:1405\n1855#4,2:1407\n1855#4,2:1409\n1855#4,2:1413\n1855#4,2:1415\n1855#4,2:1417\n1855#4,2:1419\n1855#4,2:1421\n1855#4,2:1423\n766#4:1425\n857#4,2:1426\n1855#4,2:1428\n1855#4,2:1430\n13309#5,2:1380\n37#6,2:1383\n37#6,2:1391\n37#6,2:1411\n*S KotlinDebug\n*F\n+ 1 Relay.kt\norg/jitsi/videobridge/relay/Relay\n*L\n454#1:1349,4\n496#1:1357,4\n509#1:1361,4\n679#1:1369,4\n1166#1:1432,4\n1167#1:1436,4\n1168#1:1440,4\n610#1:1444,4\n470#1:1353,2\n473#1:1355,2\n623#1:1365,2\n668#1:1367,2\n689#1:1373,2\n691#1:1375,2\n786#1:1377,2\n787#1:1379\n787#1:1382\n845#1:1385,2\n849#1:1387,2\n850#1:1389,2\n880#1:1393,2\n911#1:1395,2\n912#1:1397,2\n926#1:1399,2\n928#1:1401,2\n941#1:1403,2\n943#1:1405,2\n951#1:1407,2\n953#1:1409,2\n1012#1:1413,2\n1015#1:1415,2\n1016#1:1417,2\n1017#1:1419,2\n1032#1:1421,2\n1035#1:1423,2\n1147#1:1425\n1147#1:1426,2\n1157#1:1428,2\n1159#1:1430,2\n789#1:1380,2\n841#1:1383,2\n873#1:1391,2\n962#1:1411,2\n*E\n"})
public final class Relay
implements EncodingsManager.EncodingsUpdateListener,
PotentialPacketHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final Conference conference;
    @Nullable
    private final String meshId;
    @NotNull
    private final EventEmitter<AbstractEndpoint.EventHandler> eventEmitter;
    @NotNull
    private final Logger logger;
    @NotNull
    private final List<PayloadType> payloadTypes;
    @NotNull
    private final List<RtpExtension> rtpExtensions;
    private boolean extmapAllowMixed;
    private boolean expired;
    @Nullable
    private final DcSctpHandler sctpHandler;
    @Nullable
    private final SctpHandler usrSctpHandler;
    @Nullable
    private DcSctpTransport sctpTransport;
    @Nullable
    private Sctp.Role sctpRole;
    @Nullable
    private SctpManager sctpManager;
    @Nullable
    private SctpSocket sctpSocket;
    @NotNull
    private final DataChannelHandler dataChannelHandler;
    @Nullable
    private DataChannelStack dataChannelStack;
    @NotNull
    private final ToggleablePcapWriter toggleablePcapWriter;
    @NotNull
    private final ToggleablePcapWriter.PcapWriterNode sctpRecvPcap;
    @NotNull
    private final ToggleablePcapWriter.PcapWriterNode sctpSendPcap;
    @NotNull
    private final Node sctpPipeline;
    @NotNull
    private final IceTransport iceTransport;
    @NotNull
    private final DtlsTransport dtlsTransport;
    private boolean cryptex;
    private final DiagnosticContext diagnosticContext;
    private final Logger timelineLogger;
    @NotNull
    private final HashMap<String, RelayedEndpoint> relayedEndpoints;
    @NotNull
    private final HashMap<Long, RelayedEndpoint> endpointsBySsrc;
    @NotNull
    private final Object endpointsLock;
    @NotNull
    private final ConcurrentHashMap<String, RelayEndpointSender> senders;
    @NotNull
    private final Statistics statistics;
    @NotNull
    private final EndpointConnectionStats.EndpointConnectionStatsListener rttListener;
    @NotNull
    private final Transceiver transceiver;
    @NotNull
    private final RelayMessageTransport messageTransport;
    @NotNull
    private final PacketInfoQueue outgoingSrtpPacketQueue;
    @NotNull
    private final PacketInfoQueue incomingDataChannelMessagesQueue;
    @Nullable
    private SrtpTransformers srtpTransformers;
    @NotNull
    private static final CounterMetric droppedPacketsMetric = MetricsContainer.registerCounter$default(VideobridgeMetricsContainer.Companion.getInstance(), "relay_srtp_send_queue_dropped_packets", "Number of packets dropped out of the Relay SRTP send queue.", 0L, 4, null);
    @NotNull
    private static final CounterMetric exceptionsMetric = MetricsContainer.registerCounter$default(VideobridgeMetricsContainer.Companion.getInstance(), "relay_srtp_send_queue_exceptions", "Number of exceptions from the Relay SRTP send queue.", 0L, 4, null);
    @JvmField
    @NotNull
    public static final CountingErrorHandler queueErrorCounter = new CountingErrorHandler(){

        public void packetDropped() {
            Unit unit;
            super.packetDropped();
            Unit it = unit = Unit.INSTANCE;
            boolean bl = false;
            Relay.access$getDroppedPacketsMetric$cp().inc();
            QueueMetrics.INSTANCE.getDroppedPackets().inc();
        }

        public void packetHandlingFailed(Throwable t2) {
            Unit unit;
            super.packetHandlingFailed(t2);
            Unit it = unit = Unit.INSTANCE;
            boolean bl = false;
            Relay.access$getExceptionsMetric$cp().inc();
            QueueMetrics.INSTANCE.getExceptions().inc();
        }
    };
    @NotNull
    private static final String SRTP_QUEUE_ENTRY_EVENT = "Entered Relay SRTP sender outgoing queue";
    @NotNull
    private static final String SRTP_QUEUE_EXIT_EVENT = "Exited Relay SRTP sender outgoing queue";

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public Relay(@NotNull String id, @NotNull Conference conference, @NotNull Logger parentLogger, @Nullable String meshId, boolean iceControlling, boolean useUniquePort, @NotNull Clock clock) {
        void $this$outgoingSrtpPacketQueue_u24lambda_u247;
        Object $this$transceiver_u24lambda_u246;
        Object $this$diagnosticContext_u24lambda_u245;
        Object it;
        Object $this$logger_u24lambda_u240;
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(conference, "conference");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.id = id;
        this.conference = conference;
        this.meshId = meshId;
        this.eventEmitter = new SyncEventEmitter();
        Object object = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        Logger logger = object;
        Relay relay = this;
        boolean bl = false;
        $this$logger_u24lambda_u240.addContext("relayId", this.id);
        relay.logger = object;
        this.payloadTypes = new ArrayList();
        this.rtpExtensions = new ArrayList();
        this.sctpHandler = SctpConfig.config.getEnabled() && !SctpConfig.config.getUseUsrSctp() ? new DcSctpHandler() : null;
        this.usrSctpHandler = SctpConfig.config.getEnabled() && SctpConfig.config.getUseUsrSctp() ? new SctpHandler() : null;
        this.dataChannelHandler = new DataChannelHandler();
        this.toggleablePcapWriter = new ToggleablePcapWriter(this.logger, this.id + "-sctp");
        this.sctpRecvPcap = this.toggleablePcapWriter.newObserverNode(false);
        this.sctpSendPcap = this.toggleablePcapWriter.newObserverNode(true);
        this.sctpPipeline = PipelineDslKt.pipeline(arg_0 -> Relay.sctpPipeline$lambda$3(this, arg_0));
        this.iceTransport = new IceTransport(this.id, iceControlling, useUniquePort, true, this.logger, clock);
        $this$logger_u24lambda_u240 = object = new DtlsTransport(this.logger);
        relay = this;
        boolean bl2 = false;
        ((DtlsTransport)it).setCryptex(CryptexConfig.Companion.getRelay());
        relay.dtlsTransport = object;
        this.cryptex = CryptexConfig.Companion.getRelay();
        it = object = this.conference.newDiagnosticContext();
        relay = this;
        boolean bl3 = false;
        ((ConcurrentHashMap)$this$diagnosticContext_u24lambda_u245).put("relay_id", this.id);
        relay.diagnosticContext = object;
        this.timelineLogger = this.logger.createChildLogger("timeline." + this.getClass().getName());
        this.relayedEndpoints = new HashMap();
        this.endpointsBySsrc = new HashMap();
        this.endpointsLock = new Object();
        this.senders = new ConcurrentHashMap();
        this.statistics = new Statistics();
        this.rttListener = new EndpointConnectionStats.EndpointConnectionStatsListener(this){
            final /* synthetic */ Relay this$0;
            {
                this.this$0 = $receiver;
            }

            public void onRttUpdate(double newRttMs) {
                if (newRttMs > 0.0) {
                    this.this$0.getTransceiver().removeEndpointConnectionStatsListener(this);
                    Relay.access$getIceTransport$p(this.this$0).updateStatsOnInitialRtt(newRttMs);
                }
            }
        };
        ExecutorService executorService = TaskPools.CPU_POOL;
        Intrinsics.checkNotNullExpressionValue(executorService, "CPU_POOL");
        ExecutorService executorService2 = TaskPools.CPU_POOL;
        Intrinsics.checkNotNullExpressionValue(executorService2, "CPU_POOL");
        ScheduledExecutorService scheduledExecutorService = TaskPools.SCHEDULED_POOL;
        Intrinsics.checkNotNullExpressionValue(scheduledExecutorService, "SCHEDULED_POOL");
        DiagnosticContext diagnosticContext = this.diagnosticContext;
        Intrinsics.checkNotNullExpressionValue(diagnosticContext, "diagnosticContext");
        $this$diagnosticContext_u24lambda_u245 = object = new Transceiver(this.id, executorService, executorService2, scheduledExecutorService, diagnosticContext, this.logger, new TransceiverEventHandlerImpl(), clock);
        relay = this;
        boolean bl4 = false;
        ((Transceiver)$this$transceiver_u24lambda_u246).setIncomingPacketHandler(new ConsumerNode(this){
            final /* synthetic */ Relay this$0;
            {
                this.this$0 = $receiver;
                super("receiver chain handler");
            }

            protected void consume(PacketInfo packetInfo) {
                Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
                this.this$0.handleIncomingPacket(packetInfo);
            }

            public void trace(Function0<Unit> f) {
                Intrinsics.checkNotNullParameter(f, "f");
                f.invoke();
            }
        });
        ((Transceiver)$this$transceiver_u24lambda_u246).addEndpointConnectionStatsListener(this.rttListener);
        ((Transceiver)$this$transceiver_u24lambda_u246).setLocalSsrc(MediaType.AUDIO, this.conference.getLocalAudioSsrc());
        ((Transceiver)$this$transceiver_u24lambda_u246).setLocalSsrc(MediaType.VIDEO, this.conference.getLocalVideoSsrc());
        ((Transceiver)$this$transceiver_u24lambda_u246).getRtcpEventNotifier().addRtcpEventListener(new RtcpListener(this){
            final /* synthetic */ Relay this$0;
            {
                this.this$0 = $receiver;
            }

            public void rtcpPacketReceived(RtcpPacket packet, Instant receivedTime) {
                Intrinsics.checkNotNullParameter(packet, "packet");
                this.this$0.rtcpPacketReceived(packet, receivedTime, null);
            }

            public void rtcpPacketSent(RtcpPacket packet) {
                Intrinsics.checkNotNullParameter(packet, "packet");
                this.this$0.rtcpPacketSent(packet, null);
            }
        }, true);
        relay.transceiver = object;
        this.messageTransport = new RelayMessageTransport(this, this.conference, this.logger);
        this.conference.getEncodingsManager().subscribe(this);
        this.setupIceTransport();
        this.setupDtlsTransport();
        VideobridgeMetrics.totalRelays.inc();
        String string = this.getClass().getSimpleName() + "-outgoing-packet-queue";
        ExecutorService executorService3 = TaskPools.IO_POOL;
        Intrinsics.checkNotNullExpressionValue(executorService3, "IO_POOL");
        $this$transceiver_u24lambda_u246 = object = new PacketInfoQueue(string, executorService3, (Function1<? super PacketInfo, Boolean>)new Function1<PacketInfo, Boolean>((Object)this){

            public final Boolean invoke(PacketInfo p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((Relay)this.receiver).doSendSrtp(p0);
            }
        }, TransportConfig.Companion.getQueueSize());
        relay = this;
        boolean bl5 = false;
        $this$outgoingSrtpPacketQueue_u24lambda_u247.setErrorHandler(queueErrorCounter);
        relay.outgoingSrtpPacketQueue = object;
        String string2 = this.getClass().getSimpleName() + "-incoming-data-channel-queue";
        ExecutorService executorService4 = TaskPools.IO_POOL;
        Intrinsics.checkNotNullExpressionValue(executorService4, "IO_POOL");
        this.incomingDataChannelMessagesQueue = new PacketInfoQueue(string2, executorService4, arg_0 -> Relay.incomingDataChannelMessagesQueue$lambda$8(this, arg_0), TransportConfig.Companion.getQueueSize());
    }

    public /* synthetic */ Relay(String string, Conference conference, Logger logger, String string2, boolean bl, boolean bl2, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 0x40) != 0) {
            clock = Clock.systemUTC();
        }
        this(string, conference, logger, string2, bl, bl2, clock);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final Conference getConference() {
        return this.conference;
    }

    @Nullable
    public final String getMeshId() {
        return this.meshId;
    }

    @NotNull
    public final Statistics getStatistics() {
        return this.statistics;
    }

    @NotNull
    public final Transceiver getTransceiver() {
        return this.transceiver;
    }

    @NotNull
    public final RelayMessageTransport getMessageTransport() {
        return this.messageTransport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final JSONObject getDebugState() {
        JSONObject jSONObject;
        block6: {
            JSONObject $this$_get_debugState__u24lambda_u2411 = jSONObject = new JSONObject();
            boolean bl = false;
            $this$_get_debugState__u24lambda_u2411.put("iceTransport", this.iceTransport.getDebugState());
            $this$_get_debugState__u24lambda_u2411.put("dtlsTransport", this.dtlsTransport.getDebugState());
            $this$_get_debugState__u24lambda_u2411.put("transceiver", this.transceiver.getNodeStats().toJson());
            $this$_get_debugState__u24lambda_u2411.put("meshId", this.meshId);
            $this$_get_debugState__u24lambda_u2411.put("messageTransport", this.messageTransport.getDebugState());
            JSONObject remoteEndpoints = new JSONObject();
            JSONObject endpointsBySsrcMap = new JSONObject();
            Iterator<RelayEndpointSender> iterator2 = this.endpointsLock;
            synchronized (iterator2) {
                boolean $i$a$-synchronized-Relay$debugState$1$232 = false;
                Iterator<Object> iterator3 = this.relayedEndpoints.values().iterator();
                while (iterator3.hasNext()) {
                    RelayedEndpoint relayedEndpoint;
                    Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
                    ((Map)remoteEndpoints).put(relayedEndpoint.getId(), relayedEndpoint.getDebugState());
                }
                for (Map.Entry entry : ((Map)this.endpointsBySsrc).entrySet()) {
                    long s2 = ((Number)entry.getKey()).longValue();
                    RelayedEndpoint e = (RelayedEndpoint)entry.getValue();
                    Long l = s2;
                    ((Map)endpointsBySsrcMap).put(l, e.getId());
                }
                Unit $i$a$-synchronized-Relay$debugState$1$232 = Unit.INSTANCE;
            }
            $this$_get_debugState__u24lambda_u2411.put("remoteEndpoints", remoteEndpoints);
            $this$_get_debugState__u24lambda_u2411.put("endpointsBySsrc", endpointsBySsrcMap);
            JSONObject endpointSenders = new JSONObject();
            iterator2 = this.senders.values().iterator();
            while (iterator2.hasNext()) {
                RelayEndpointSender s3;
                Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
                ((Map)endpointSenders).put(s3.getId(), s3.getDebugState());
            }
            $this$_get_debugState__u24lambda_u2411.put("senders", endpointSenders);
            DcSctpTransport dcSctpTransport = this.sctpTransport;
            if (dcSctpTransport == null) break block6;
            DcSctpTransport it = dcSctpTransport;
            boolean bl2 = false;
            $this$_get_debugState__u24lambda_u2411.put("sctp", it.getDebugState());
        }
        return jSONObject;
    }

    private final void setupIceTransport() {
        this.iceTransport.incomingDataHandler = new IceTransport.IncomingDataHandler(this){
            final /* synthetic */ Relay this$0;
            {
                this.this$0 = $receiver;
            }

            public void dataReceived(byte[] data, int offset, int length, Instant receivedTime) {
                Intrinsics.checkNotNullParameter(data, "data");
                Intrinsics.checkNotNullParameter(receivedTime, "receivedTime");
                if (PacketUtils.looksLikeDtls(data, offset, length)) {
                    Relay.access$getDtlsTransport$p(this.this$0).dtlsDataReceived(data, offset, length);
                } else {
                    RelayedPacketInfo relayedPacketInfo;
                    byte[] copy = ByteBufferPool.getBuffer(length + 10 + 20);
                    System.arraycopy(data, offset, copy, 10, length);
                    Intrinsics.checkNotNull(copy);
                    RelayedPacketInfo $this$dataReceived_u24lambda_u240 = relayedPacketInfo = new RelayedPacketInfo((Packet)new UnparsedPacket(copy, 10, length), this.this$0.getMeshId());
                    boolean bl = false;
                    $this$dataReceived_u24lambda_u240.setReceivedTime(receivedTime);
                    RelayedPacketInfo pktInfo = relayedPacketInfo;
                    Relay.access$handleMediaPacket(this.this$0, pktInfo);
                }
            }
        };
        this.iceTransport.eventHandler = new IceTransport.EventHandler(this){
            final /* synthetic */ Relay this$0;
            {
                this.this$0 = $receiver;
            }

            public void connected() {
                Relay.access$getLogger$p(this.this$0).info("ICE connected");
                this.this$0.getTransceiver().setOutgoingPacketHandler(new PacketHandler(this.this$0){
                    final /* synthetic */ Relay this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void processPacket(PacketInfo packetInfo) {
                        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
                        packetInfo.addEvent("Entered Relay SRTP sender outgoing queue");
                        Relay.access$getOutgoingSrtpPacketQueue$p(this.this$0).add(packetInfo);
                    }
                });
                TaskPools.IO_POOL.execute(Relay.access$getIceTransport$p(this.this$0)::startReadingData);
                TaskPools.IO_POOL.execute(Relay.access$getDtlsTransport$p(this.this$0)::startDtlsHandshake);
            }

            public void failed() {
            }

            public void consentUpdated(Instant time) {
                Intrinsics.checkNotNullParameter(time, "time");
                this.this$0.getTransceiver().getPacketIOActivity().setLastIceActivityInstant(time);
            }
        };
    }

    private final void setupDtlsTransport() {
        this.dtlsTransport.incomingDataHandler = new DtlsTransport.IncomingDataHandler(this){
            final /* synthetic */ Relay this$0;
            {
                this.this$0 = $receiver;
            }

            public void dtlsAppDataReceived(byte[] buf, int off, int len) {
                Intrinsics.checkNotNullParameter(buf, "buf");
                this.this$0.dtlsAppPacketReceived(buf, off, len);
            }
        };
        this.dtlsTransport.outgoingDataHandler = new DtlsTransport.OutgoingDataHandler(this){
            final /* synthetic */ Relay this$0;
            {
                this.this$0 = $receiver;
            }

            public void sendData(byte[] buf, int off, int len) {
                Intrinsics.checkNotNullParameter(buf, "buf");
                Relay.access$getIceTransport$p(this.this$0).send(buf, off, len);
            }
        };
        this.dtlsTransport.eventHandler = new DtlsTransport.EventHandler(this){
            final /* synthetic */ Relay this$0;
            {
                this.this$0 = $receiver;
            }

            public void handshakeComplete(int chosenSrtpProtectionProfile, TlsRole tlsRole, byte[] keyingMaterial) {
                Intrinsics.checkNotNullParameter((Object)((Object)tlsRole), "tlsRole");
                Intrinsics.checkNotNullParameter(keyingMaterial, "keyingMaterial");
                Relay.access$getLogger$p(this.this$0).info("DTLS handshake complete");
                Relay.access$setSrtpInformation(this.this$0, chosenSrtpProtectionProfile, tlsRole, keyingMaterial);
                if (SctpConfig.config.getEnabled() && SctpConfig.config.getUseUsrSctp()) {
                    SctpSocket socket = Relay.access$getSctpSocket$p(this.this$0);
                    if (socket instanceof SctpClientSocket) {
                        this.this$0.connectUsrSctpConnection((SctpClientSocket)socket);
                    } else if (socket instanceof SctpServerSocket) {
                        this.this$0.acceptUsrSctpConnection((SctpServerSocket)socket);
                    }
                    this.this$0.scheduleRelayMessageTransportTimeout();
                } else if (SctpConfig.config.getEnabled() && Relay.access$getSctpRole$p(this.this$0) == Sctp.Role.CLIENT) {
                    DcSctpTransport dcSctpTransport = Relay.access$getSctpTransport$p(this.this$0);
                    Intrinsics.checkNotNull(dcSctpTransport);
                    dcSctpTransport.getSocket().connect();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setSrtpInformation(int chosenSrtpProtectionProfile, TlsRole tlsRole, byte[] keyingMaterial) {
        SrtpTransformers srtpTransformers;
        SrtpProfileInformation srtpProfileInfo = SrtpUtil.Companion.getSrtpProfileInformationFromSrtpProtectionProfile(chosenSrtpProtectionProfile);
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug("Transceiver " + this.id + " creating transformers with:\nprofile info:\n" + srtpProfileInfo + "\ntls role: " + tlsRole);
        }
        this.srtpTransformers = srtpTransformers = SrtpUtil.Companion.initializeTransformer(srtpProfileInfo, keyingMaterial, tlsRole, this.cryptex, this.logger);
        this.transceiver.setSrtpInformation(srtpTransformers);
        Object bl = this.endpointsLock;
        synchronized (bl) {
            boolean bl2 = false;
            Collection<RelayedEndpoint> collection = this.relayedEndpoints.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RelayedEndpoint it = (RelayedEndpoint)element$iv;
                boolean bl3 = false;
                it.setSrtpInformation(srtpTransformers);
            }
            Unit unit = Unit.INSTANCE;
        }
        Collection<RelayEndpointSender> collection = this.senders.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RelayEndpointSender it = (RelayEndpointSender)element$iv;
            boolean bl4 = false;
            it.setSrtpInformation(srtpTransformers);
        }
    }

    public final void createSctpConnection(@NotNull Sctp sctpDesc) {
        Intrinsics.checkNotNullParameter(sctpDesc, "sctpDesc");
        if (SctpConfig.config.getEnabled()) {
            if (SctpConfig.config.getUseUsrSctp()) {
                this.createUsrSctpConnection(sctpDesc);
            } else {
                this.createDcSctpConnection(sctpDesc);
            }
        } else {
            this.logger.error("Not creating SCTP connection, SCTP is disabled in configuration.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createDcSctpConnection(Sctp sctpDesc) {
        void it;
        DcSctpTransport dcSctpTransport;
        Object object;
        this.sctpRole = sctpDesc.getRole();
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug22 = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            object = $this$cdebug$iv;
            boolean bl = false;
            object.debug("Creating SCTP transport");
        }
        DcSctpTransport $i$f$cdebug22 = dcSctpTransport = new DcSctpTransport(this.id, this.logger);
        object = this;
        boolean bl = false;
        DcSctpTransport.start$default((DcSctpTransport)it, new SctpCallbacks((DcSctpTransport)it), null, 2, null);
        DcSctpHandler dcSctpHandler = this.sctpHandler;
        Intrinsics.checkNotNull(dcSctpHandler);
        dcSctpHandler.setSctpTransport((DcSctpTransport)it);
        if (this.dtlsTransport.isConnected() && sctpDesc.getRole() == Sctp.Role.CLIENT) {
            it.getSocket().connect();
        }
        ((Relay)object).sctpTransport = dcSctpTransport;
    }

    private final void createUsrSctpConnection(Sctp sctpDesc) {
        SctpManager sctpManager;
        boolean openDataChannelLocally = sctpDesc.getRole() == Sctp.Role.CLIENT;
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug("Creating SCTP manager");
        }
        this.sctpManager = sctpManager = new SctpManager((arg_0, arg_1, arg_2) -> Relay.createUsrSctpConnection$lambda$19(this, arg_0, arg_1, arg_2), this.logger);
        SctpHandler sctpHandler = this.usrSctpHandler;
        Intrinsics.checkNotNull(sctpHandler);
        sctpHandler.setSctpManager(sctpManager);
        SctpSocket socket = sctpDesc.getRole() == Sctp.Role.CLIENT ? (SctpSocket)sctpManager.createClientSocket(this.logger) : (SctpSocket)sctpManager.createServerSocket(this.logger);
        socket.eventHandler = new SctpSocket.SctpSocketEventHandler(this, openDataChannelLocally, socket){
            final /* synthetic */ Relay this$0;
            final /* synthetic */ boolean $openDataChannelLocally;
            final /* synthetic */ SctpSocket $socket;
            {
                this.this$0 = $receiver;
                this.$openDataChannelLocally = $openDataChannelLocally;
                this.$socket = $socket;
            }

            public void onReady() {
                Relay.access$getLogger$p(this.this$0).info("SCTP connection is ready, creating the Data channel stack");
                DataChannelStack dataChannelStack = new DataChannelStack((arg_0, arg_1, arg_2) -> createUsrSctpConnection.2.onReady$lambda$0(this.$socket, arg_0, arg_1, arg_2), Relay.access$getLogger$p(this.this$0));
                Relay.access$setDataChannelStack$p(this.this$0, dataChannelStack);
                dataChannelStack.onDataChannelStackEvents(arg_0 -> createUsrSctpConnection.2.onReady$lambda$1(this.this$0, arg_0));
                Relay.access$getDataChannelHandler$p(this.this$0).setDataChannelStack(dataChannelStack);
                if (this.$openDataChannelLocally) {
                    Relay.access$getLogger$p(this.this$0).info("Will open the data channel.");
                    DataChannel dataChannel = dataChannelStack.createDataChannel(0, 0, 0L, 0, "default");
                    RelayMessageTransport relayMessageTransport = Relay.access$getMessageTransport$p(this.this$0);
                    Intrinsics.checkNotNull(dataChannel);
                    relayMessageTransport.setDataChannel(dataChannel);
                    dataChannel.open();
                } else {
                    Relay.access$getLogger$p(this.this$0).info("Will wait for the remote side to open the data channel.");
                }
            }

            public void onDisconnected() {
                Relay.access$getLogger$p(this.this$0).info("SCTP connection is disconnected");
            }

            private static final int onReady$lambda$0(SctpSocket $socket, ByteBuffer data, int sid, int ppid) {
                return $socket.send(data, true, sid, ppid);
            }

            private static final void onReady$lambda$1(Relay this$0, DataChannel dataChannel) {
                Intrinsics.checkNotNullParameter(this$0, "this$0");
                Relay.access$getLogger$p(this$0).info("Remote side opened a data channel.");
                RelayMessageTransport relayMessageTransport = Relay.access$getMessageTransport$p(this$0);
                Intrinsics.checkNotNull(dataChannel);
                relayMessageTransport.setDataChannel(dataChannel);
            }
        };
        socket.dataCallback = (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> Relay.createUsrSctpConnection$lambda$20(this, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6);
        if (socket instanceof SctpServerSocket) {
            ((SctpServerSocket)socket).listen();
        }
        this.sctpSocket = socket;
    }

    public final void connectUsrSctpConnection(@NotNull SctpClientSocket sctpClientSocket) {
        Intrinsics.checkNotNullParameter(sctpClientSocket, "sctpClientSocket");
        TaskPools.IO_POOL.execute(() -> Relay.connectUsrSctpConnection$lambda$21(this, sctpClientSocket));
    }

    public final void acceptUsrSctpConnection(@NotNull SctpServerSocket sctpServerSocket) {
        Intrinsics.checkNotNullParameter(sctpServerSocket, "sctpServerSocket");
        TaskPools.IO_POOL.execute(() -> Relay.acceptUsrSctpConnection$lambda$23(this, sctpServerSocket));
    }

    public final void setTransportInfo(@NotNull IceUdpTransportPacketExtension transportInfo) {
        block4: {
            Intrinsics.checkNotNullParameter(transportInfo, "transportInfo");
            Map remoteFingerprints = new LinkedHashMap();
            List<DtlsFingerprintPacketExtension> fingerprintExtensions = transportInfo.getChildExtensionsOfType(DtlsFingerprintPacketExtension.class);
            Intrinsics.checkNotNull(fingerprintExtensions);
            Iterable $this$forEach$iv = fingerprintExtensions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DtlsFingerprintPacketExtension fingerprintExtension = (DtlsFingerprintPacketExtension)element$iv;
                boolean bl = false;
                if (fingerprintExtension.getHash() != null && fingerprintExtension.getFingerprint() != null) {
                    remoteFingerprints.put(fingerprintExtension.getHash(), fingerprintExtension.getFingerprint());
                } else {
                    this.logger.info("Ignoring empty DtlsFingerprint extension: " + XmlStringBuilderUtil.Companion.toStringOpt(transportInfo));
                }
                if (!CryptexConfig.Companion.getRelay()) continue;
                this.cryptex = this.cryptex && fingerprintExtension.getCryptex();
            }
            this.dtlsTransport.setRemoteFingerprints(remoteFingerprints);
            if (!((Collection)fingerprintExtensions).isEmpty()) {
                String setup = CollectionsKt.first(fingerprintExtensions).getSetup();
                this.dtlsTransport.setSetupAttribute(setup);
            }
            this.iceTransport.startConnectivityEstablishment(transportInfo);
            WebSocketPacketExtension websocketExtension = transportInfo.getFirstChildOfType(WebSocketPacketExtension.class);
            Object object = websocketExtension;
            if (object == null || (object = ((WebSocketPacketExtension)object).getUrl()) == null) break block4;
            Object it = object;
            boolean bl = false;
            this.messageTransport.connectToWebsocket((String)it);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IceUdpTransportPacketExtension describeTransport() {
        Object object;
        IceUdpTransportPacketExtension iceUdpTransportPacketExtension = new IceUdpTransportPacketExtension();
        this.iceTransport.describe(iceUdpTransportPacketExtension);
        this.dtlsTransport.describe(iceUdpTransportPacketExtension);
        if (this.sctpTransport == null && this.sctpSocket == null) {
            if (this.messageTransport.isActive()) {
                void $this$describeTransport_u24lambda_u2426;
                WebSocketPacketExtension webSocketPacketExtension;
                WebSocketPacketExtension webSocketPacketExtension2 = webSocketPacketExtension = new WebSocketPacketExtension();
                object = iceUdpTransportPacketExtension;
                boolean bl = false;
                $this$describeTransport_u24lambda_u2426.setActive(true);
                ((IceUdpTransportPacketExtension)object).addChildExtension(webSocketPacketExtension);
            } else {
                ColibriWebSocketService colibriWebSocketService = ColibriWebSocketServiceSupplierKt.getColibriWebSocketServiceSupplier().get();
                if (colibriWebSocketService != null) {
                    ColibriWebSocketService colibriWebsocketService = colibriWebSocketService;
                    boolean bl = false;
                    String string = this.conference.getID();
                    Intrinsics.checkNotNullExpressionValue(string, "getID(...)");
                    List<String> urls = colibriWebsocketService.getColibriRelayWebSocketUrls(string, this.id, this.iceTransport.getIcePassword());
                    if (urls.isEmpty()) {
                        this.logger.warn("No colibri relay URLs configured");
                    }
                    Iterable $this$forEach$iv = urls;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        void $this$describeTransport_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427;
                        WebSocketPacketExtension webSocketPacketExtension;
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        WebSocketPacketExtension webSocketPacketExtension3 = webSocketPacketExtension = new WebSocketPacketExtension();
                        IceUdpTransportPacketExtension iceUdpTransportPacketExtension2 = iceUdpTransportPacketExtension;
                        boolean bl3 = false;
                        $this$describeTransport_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427.setUrl(it);
                        iceUdpTransportPacketExtension2.addChildExtension(webSocketPacketExtension);
                    }
                }
            }
        }
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            object = $this$cdebug$iv;
            boolean bl = false;
            object.debug("Transport description:\n" + XmlStringBuilderUtil.Companion.toStringOpt(iceUdpTransportPacketExtension));
        }
        return iceUdpTransportPacketExtension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setFeature(@NotNull EndpointDebugFeatures feature, boolean enabled2) {
        Intrinsics.checkNotNullParameter((Object)feature, "feature");
        switch (WhenMappings.$EnumSwitchMapping$0[feature.ordinal()]) {
            case 1: {
                this.transceiver.setFeature(Features.TRANSCEIVER_PCAP_DUMP, enabled2);
                Object object = this.endpointsLock;
                synchronized (object) {
                    boolean bl = false;
                    Collection<RelayedEndpoint> collection = this.relayedEndpoints.values();
                    Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
                    Iterable $this$forEach$iv = collection;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        RelayedEndpoint e = (RelayedEndpoint)element$iv;
                        boolean bl2 = false;
                        e.setFeature(Features.TRANSCEIVER_PCAP_DUMP, enabled2);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                Collection<RelayEndpointSender> collection = this.senders.values();
                Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RelayEndpointSender s2 = (RelayEndpointSender)element$iv;
                    boolean bl = false;
                    s2.setFeature(Features.TRANSCEIVER_PCAP_DUMP, enabled2);
                }
                break;
            }
            case 2: {
                if (enabled2) {
                    this.toggleablePcapWriter.enable();
                    break;
                }
                this.toggleablePcapWriter.disable();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final boolean isFeatureEnabled(@NotNull EndpointDebugFeatures feature) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)feature, "feature");
        switch (WhenMappings.$EnumSwitchMapping$0[feature.ordinal()]) {
            case 1: {
                bl = this.transceiver.isFeatureEnabled(Features.TRANSCEIVER_PCAP_DUMP);
                break;
            }
            case 2: {
                bl = this.toggleablePcapWriter.isEnabled();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final void handleMediaPacket(RelayedPacketInfo packetInfo) {
        if (PacketExtensionsKt.looksLikeRtp(packetInfo.getPacket())) {
            Intrinsics.checkNotNullExpressionValue(packetInfo.getPacket().buffer, "buffer");
            long ssrc = RtpHeader.Companion.getSsrc(packetInfo.getPacket().buffer, packetInfo.getPacket().offset);
            RelayedEndpoint ep = this.getEndpointBySsrc(ssrc);
            if (ep != null) {
                ep.handleIncomingPacket(packetInfo);
                return;
            }
            this.logger.warn(() -> Relay.handleMediaPacket$lambda$34(ssrc));
            Function1<byte[], Unit> function1 = BufferPool.Companion.getReturnBuffer();
            Intrinsics.checkNotNullExpressionValue(packetInfo.getPacket().buffer, "buffer");
            function1.invoke(packetInfo.getPacket().buffer);
        } else if (PacketExtensionsKt.looksLikeRtcp(packetInfo.getPacket())) {
            Intrinsics.checkNotNullExpressionValue(packetInfo.getPacket().buffer, "buffer");
            long ssrc = RtcpHeader.Companion.getSenderSsrc(packetInfo.getPacket().buffer, packetInfo.getPacket().offset);
            RelayedEndpoint ep = this.getEndpointBySsrc(ssrc);
            if (ep != null) {
                ep.handleIncomingPacket(packetInfo);
                return;
            }
            this.transceiver.handleIncomingPacket(packetInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleIncomingPacket(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        Packet packet = packetInfo.getPacket();
        if (packet instanceof RtpPacket) {
            RelayedEndpoint relayedEndpoint;
            Object object = this.endpointsLock;
            synchronized (object) {
                boolean bl = false;
                relayedEndpoint = this.endpointsBySsrc.get(((RtpPacket)packet).getSsrc());
            }
            RelayedEndpoint ep = relayedEndpoint;
            if (ep != null) {
                packetInfo.setEndpointId(ep.getId());
            }
        }
        this.conference.handleIncomingPacket(packetInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNewSsrcAssociation(@NotNull String endpointId, long primarySsrc, long secondarySsrc, @NotNull SsrcAssociationType type) {
        boolean bl;
        Intrinsics.checkNotNullParameter(endpointId, "endpointId");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Object object = this.endpointsLock;
        synchronized (object) {
            boolean bl2 = false;
            bl = this.relayedEndpoints.containsKey(endpointId);
        }
        if (bl) {
            this.transceiver.addSsrcAssociation(new LocalSsrcAssociation(primarySsrc, secondarySsrc, type));
        } else {
            this.transceiver.addSsrcAssociation(new RemoteSsrcAssociation(primarySsrc, secondarySsrc, type));
        }
    }

    public final boolean doSendSrtp(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        packetInfo.addEvent(SRTP_QUEUE_EXIT_EVENT);
        Intrinsics.checkNotNullExpressionValue(packetInfo.getPacket().buffer, "buffer");
        this.iceTransport.send(packetInfo.getPacket().buffer, packetInfo.getPacket().offset, packetInfo.getPacket().length);
        PacketTransitStats.packetSent(packetInfo);
        ByteBufferPool.returnBuffer(packetInfo.getPacket().buffer);
        packetInfo.sent();
        if (this.timelineLogger.isTraceEnabled() && Endpoint.Companion.logTimeline()) {
            this.timelineLogger.trace(() -> Relay.doSendSrtp$lambda$37(packetInfo));
        }
        return true;
    }

    public final void sendMessage(@NotNull BridgeChannelMessage msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        this.messageTransport.sendMessage(msg);
    }

    public final void relayMessageTransportConnected() {
        AbstractEndpoint e;
        Collection<RelayedEndpoint> collection = this.relayedEndpoints.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            e = (RelayedEndpoint)element$iv;
            boolean bl = false;
            ((RelayedEndpoint)e).relayMessageTransportConnected();
        }
        List<AbstractEndpoint> list = this.conference.getEndpoints();
        Intrinsics.checkNotNullExpressionValue(list, "getEndpoints(...)");
        $this$forEach$iv = list;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            e = (AbstractEndpoint)element$iv;
            boolean bl = false;
            if (!(e instanceof Endpoint) && (!(e instanceof RelayedEndpoint) || Intrinsics.areEqual(((RelayedEndpoint)e).getRelay().meshId, this.meshId))) continue;
            MediaSourceDesc[] $this$forEach$iv2 = e.getMediaSources();
            boolean $i$f$forEach2 = false;
            int n = $this$forEach$iv2.length;
            for (int i = 0; i < n; ++i) {
                MediaSourceDesc element$iv2;
                MediaSourceDesc msd = element$iv2 = $this$forEach$iv2[i];
                boolean bl2 = false;
                if (msd.getVideoType() == VideoType.CAMERA) continue;
                SourceVideoTypeMessage videoTypeMsg = new SourceVideoTypeMessage(msd.getVideoType(), msd.getSourceName(), e.getId());
                this.sendMessage(videoTypeMsg);
            }
        }
    }

    public final void dtlsAppPacketReceived(@NotNull byte[] data, int off, int len) {
        Intrinsics.checkNotNullParameter(data, "data");
        this.sctpPipeline.processPacket(new PacketInfo(new UnparsedPacket(data, off, len), 0, null, 6, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final RelayedEndpoint addRemoteEndpoint(@NotNull String id, @Nullable String statsId, @NotNull Collection<AudioSourceDesc> audioSources, @NotNull Collection<MediaSourceDesc> videoSources) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(audioSources, "audioSources");
        Intrinsics.checkNotNullParameter(videoSources, "videoSources");
        RelayedEndpoint ep = null;
        Object object = this.endpointsLock;
        synchronized (object) {
            void $this$addRemoteEndpoint_u24lambda_u2443_u24lambda_u2441;
            DiagnosticContext diagnosticContext;
            block8: {
                boolean bl = false;
                if (!this.relayedEndpoints.containsKey(id)) break block8;
                this.logger.warn("Relay already contains remote endpoint with ID " + id);
                this.updateRemoteEndpoint(id, audioSources, videoSources);
                RelayedEndpoint relayedEndpoint = null;
                return relayedEndpoint;
            }
            DiagnosticContext diagnosticContext2 = diagnosticContext = this.conference.newDiagnosticContext();
            Logger logger = this.logger;
            String string = id;
            Relay relay = this;
            Conference conference = this.conference;
            boolean bl = false;
            $this$addRemoteEndpoint_u24lambda_u2443_u24lambda_u2441.put("relay_id", this.id);
            $this$addRemoteEndpoint_u24lambda_u2443_u24lambda_u2441.put("endpoint_id", id);
            Unit unit = Unit.INSTANCE;
            DiagnosticContext diagnosticContext3 = diagnosticContext;
            Intrinsics.checkNotNullExpressionValue(diagnosticContext3, "apply(...)");
            DiagnosticContext diagnosticContext4 = diagnosticContext3;
            Logger logger2 = logger;
            String string2 = string;
            Relay relay2 = relay;
            Conference conference2 = conference;
            ep = new RelayedEndpoint(conference2, relay2, string2, logger2, diagnosticContext4);
            ep.setStatsId(statsId);
            ep.setAudioSources(CollectionsKt.toList((Iterable)audioSources));
            Collection<MediaSourceDesc> $this$toTypedArray$iv = videoSources;
            boolean $i$f$toTypedArray = false;
            Collection<MediaSourceDesc> thisCollection$iv = $this$toTypedArray$iv;
            ep.setMediaSources(thisCollection$iv.toArray(new MediaSourceDesc[0]));
            ((Map)this.relayedEndpoints).put(id, ep);
            Iterable $this$forEach$iv = ep.getSsrcs();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Long ssrc = (Long)element$iv;
                boolean bl2 = false;
                ((Map)this.endpointsBySsrc).put(ssrc, ep);
            }
            Unit unit2 = Unit.INSTANCE;
        }
        SrtpTransformers srtpTransformers = this.srtpTransformers;
        if (srtpTransformers != null) {
            SrtpTransformers it = srtpTransformers;
            boolean bl = false;
            ep.setSrtpInformation(it);
        }
        Iterable $this$forEach$iv = this.payloadTypes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PayloadType payloadType = (PayloadType)element$iv;
            boolean bl = false;
            ep.addPayloadType(payloadType);
        }
        $this$forEach$iv = this.rtpExtensions;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RtpExtension rtpExtension = (RtpExtension)element$iv;
            boolean bl = false;
            ep.addRtpExtension(rtpExtension);
        }
        ep.setExtmapAllowMixed(this.extmapAllowMixed);
        this.setEndpointMediaSources(ep, audioSources, videoSources);
        ep.setFeature(Features.TRANSCEIVER_PCAP_DUMP, this.transceiver.isFeatureEnabled(Features.TRANSCEIVER_PCAP_DUMP));
        return ep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateRemoteEndpoint(@NotNull String id, @NotNull Collection<AudioSourceDesc> audioSources, @NotNull Collection<MediaSourceDesc> videoSources) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(audioSources, "audioSources");
        Intrinsics.checkNotNullParameter(videoSources, "videoSources");
        RelayedEndpoint ep = null;
        Object object = this.endpointsLock;
        synchronized (object) {
            boolean bl = false;
            RelayedEndpoint relayedEndpoint = this.relayedEndpoints.get(id);
            if (relayedEndpoint == null) {
                Relay $this$updateRemoteEndpoint_u24lambda_u2449_u24lambda_u2447 = this;
                boolean bl2 = false;
                $this$updateRemoteEndpoint_u24lambda_u2449_u24lambda_u2447.logger.warn("Endpoint with ID " + id + " not found in relay");
                return;
            }
            ep = relayedEndpoint;
            Set oldSsrcs = ep.getSsrcs();
            ep.setAudioSources(CollectionsKt.toList((Iterable)audioSources));
            Collection<MediaSourceDesc> $this$toTypedArray$iv = videoSources;
            boolean $i$f$toTypedArray = false;
            Collection<MediaSourceDesc> thisCollection$iv = $this$toTypedArray$iv;
            ep.setMediaSources(thisCollection$iv.toArray(new MediaSourceDesc[0]));
            Set newSsrcs = ep.getSsrcs();
            Set removedSsrcs = SetsKt.minus(oldSsrcs, newSsrcs);
            Set addedSsrcs = SetsKt.minus(newSsrcs, oldSsrcs);
            this.endpointsBySsrc.keySet().removeAll(removedSsrcs);
            Iterable $this$forEach$iv = addedSsrcs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Long ssrc = (Long)element$iv;
                boolean bl3 = false;
                ((Map)this.endpointsBySsrc).put(ssrc, ep);
            }
            Unit unit = Unit.INSTANCE;
        }
        this.setEndpointMediaSources(ep, audioSources, videoSources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeRemoteEndpoint(@NotNull String id) {
        block4: {
            Intrinsics.checkNotNullParameter(id, "id");
            RelayedEndpoint ep = null;
            Object object = this.endpointsLock;
            synchronized (object) {
                boolean bl = false;
                ep = this.relayedEndpoints.remove(id);
                if (ep != null) {
                    this.endpointsBySsrc.keySet().removeAll(ep.getSsrcs());
                }
                Unit unit = Unit.INSTANCE;
            }
            RelayedEndpoint relayedEndpoint = ep;
            if (relayedEndpoint == null) break block4;
            relayedEndpoint.expire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final RelayEndpointSender getOrCreateRelaySender(String endpointId) {
        ConcurrentHashMap<String, RelayEndpointSender> concurrentHashMap = this.senders;
        synchronized (concurrentHashMap) {
            void $this$getOrCreateRelaySender_u24lambda_u2456_u24lambda_u2452;
            DiagnosticContext it2;
            block7: {
                boolean bl = false;
                RelayEndpointSender relayEndpointSender = this.senders.get(endpointId);
                if (relayEndpointSender == null) break block7;
                RelayEndpointSender it2 = relayEndpointSender;
                boolean bl2 = false;
                RelayEndpointSender relayEndpointSender2 = it2;
                return relayEndpointSender2;
            }
            DiagnosticContext bl2 = it2 = this.conference.newDiagnosticContext();
            Logger logger = this.logger;
            String string = endpointId;
            Relay relay = this;
            boolean bl = false;
            $this$getOrCreateRelaySender_u24lambda_u2456_u24lambda_u2452.put("relay_id", this.id);
            $this$getOrCreateRelaySender_u24lambda_u2456_u24lambda_u2452.put("endpoint_id", endpointId);
            Unit unit = Unit.INSTANCE;
            DiagnosticContext diagnosticContext = it2;
            Intrinsics.checkNotNullExpressionValue(diagnosticContext, "apply(...)");
            DiagnosticContext diagnosticContext2 = diagnosticContext;
            Logger logger2 = logger;
            String string2 = string;
            Relay relay2 = relay;
            RelayEndpointSender s2 = new RelayEndpointSender(relay2, string2, logger2, diagnosticContext2);
            SrtpTransformers srtpTransformers = this.srtpTransformers;
            if (srtpTransformers != null) {
                SrtpTransformers it3 = srtpTransformers;
                boolean bl3 = false;
                s2.setSrtpInformation(it3);
            }
            Iterable $this$forEach$iv = this.payloadTypes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PayloadType payloadType = (PayloadType)element$iv;
                boolean bl4 = false;
                s2.addPayloadType(payloadType);
            }
            $this$forEach$iv = this.rtpExtensions;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RtpExtension rtpExtension = (RtpExtension)element$iv;
                boolean bl5 = false;
                s2.addRtpExtension(rtpExtension);
            }
            s2.setExtmapAllowMixed(this.extmapAllowMixed);
            s2.setFeature(Features.TRANSCEIVER_PCAP_DUMP, this.transceiver.isFeatureEnabled(Features.TRANSCEIVER_PCAP_DUMP));
            ((Map)this.senders).put(endpointId, s2);
            RelayEndpointSender relayEndpointSender = s2;
            return relayEndpointSender;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPayloadType(@NotNull PayloadType payloadType) {
        Intrinsics.checkNotNullParameter(payloadType, "payloadType");
        this.transceiver.addPayloadType(payloadType);
        this.payloadTypes.add(payloadType);
        Object object = this.endpointsLock;
        synchronized (object) {
            boolean bl = false;
            Collection<RelayedEndpoint> collection = this.relayedEndpoints.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RelayedEndpoint ep = (RelayedEndpoint)element$iv;
                boolean bl2 = false;
                ep.addPayloadType(payloadType);
            }
            Unit unit = Unit.INSTANCE;
        }
        Collection<RelayEndpointSender> collection = this.senders.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RelayEndpointSender s2 = (RelayEndpointSender)element$iv;
            boolean bl = false;
            s2.addPayloadType(payloadType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addRtpExtension(@NotNull RtpExtension rtpExtension) {
        Intrinsics.checkNotNullParameter(rtpExtension, "rtpExtension");
        if (rtpExtension.getType() == RtpExtensionType.TRANSPORT_CC || rtpExtension.getType() == RtpExtensionType.ABS_SEND_TIME) {
            return;
        }
        this.transceiver.addRtpExtension(rtpExtension);
        this.rtpExtensions.add(rtpExtension);
        Object object = this.endpointsLock;
        synchronized (object) {
            boolean bl = false;
            Collection<RelayedEndpoint> collection = this.relayedEndpoints.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RelayedEndpoint ep = (RelayedEndpoint)element$iv;
                boolean bl2 = false;
                ep.addRtpExtension(rtpExtension);
            }
            Unit unit = Unit.INSTANCE;
        }
        Collection<RelayEndpointSender> collection = this.senders.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RelayEndpointSender s2 = (RelayEndpointSender)element$iv;
            boolean bl = false;
            s2.addRtpExtension(rtpExtension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setExtmapAllowMixed(boolean allow) {
        this.transceiver.setExtmapAllowMixed(allow);
        this.extmapAllowMixed = allow;
        Object object = this.endpointsLock;
        synchronized (object) {
            boolean bl = false;
            Collection<RelayedEndpoint> collection = this.relayedEndpoints.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RelayedEndpoint ep = (RelayedEndpoint)element$iv;
                boolean bl2 = false;
                ep.setExtmapAllowMixed(allow);
            }
            Unit unit = Unit.INSTANCE;
        }
        Collection<RelayEndpointSender> collection = this.senders.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RelayEndpointSender s2 = (RelayEndpointSender)element$iv;
            boolean bl = false;
            s2.setExtmapAllowMixed(allow);
        }
    }

    private final void setEndpointMediaSources(RelayedEndpoint ep, Collection<AudioSourceDesc> audioSources, Collection<MediaSourceDesc> videoSources) {
        ep.setAudioSources(CollectionsKt.toList((Iterable)audioSources));
        Collection<MediaSourceDesc> $this$toTypedArray$iv = videoSources;
        boolean $i$f$toTypedArray = false;
        Collection<MediaSourceDesc> thisCollection$iv = $this$toTypedArray$iv;
        ep.setMediaSources(thisCollection$iv.toArray(new MediaSourceDesc[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final RelayedEndpoint getEndpoint(@NotNull String id) {
        RelayedEndpoint relayedEndpoint;
        Intrinsics.checkNotNullParameter(id, "id");
        Object object = this.endpointsLock;
        synchronized (object) {
            boolean bl = false;
            relayedEndpoint = this.relayedEndpoints.get(id);
        }
        return relayedEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final RelayedEndpoint getEndpointBySsrc(long ssrc) {
        RelayedEndpoint relayedEndpoint;
        Object object = this.endpointsLock;
        synchronized (object) {
            boolean bl = false;
            relayedEndpoint = this.endpointsBySsrc.get(ssrc);
        }
        return relayedEndpoint;
    }

    public final void scheduleRelayMessageTransportTimeout() {
        TaskPools.SCHEDULED_POOL.schedule(() -> Relay.scheduleRelayMessageTransportTimeout$lambda$68(this), 30L, TimeUnit.SECONDS);
    }

    public final boolean acceptWebSocket(@NotNull String password) {
        Intrinsics.checkNotNullParameter(password, "password");
        if (!Intrinsics.areEqual(this.iceTransport.getIcePassword(), password)) {
            this.logger.warn("Incoming web socket request with an invalid password. Expected: " + this.iceTransport.getIcePassword() + " received " + password);
            return false;
        }
        return true;
    }

    private final Collection<Long> getRtcpSsrcs(RtcpPacket packet) {
        HashSet<Long> ssrcs = new HashSet<Long>();
        ssrcs.add(packet.getSenderSsrc());
        RtcpPacket rtcpPacket = packet;
        if (rtcpPacket instanceof CompoundRtcpPacket) {
            Iterable $this$forEach$iv = ((CompoundRtcpPacket)packet).getPackets();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RtcpPacket it = (RtcpPacket)element$iv;
                boolean bl = false;
                ssrcs.addAll(this.getRtcpSsrcs(it));
            }
        } else if (rtcpPacket instanceof RtcpFbFirPacket) {
            ssrcs.add(((RtcpFbFirPacket)packet).getMediaSenderSsrc());
        } else if (rtcpPacket instanceof RtcpFbPacket) {
            ssrcs.add(((RtcpFbPacket)packet).getMediaSourceSsrc());
        } else if (rtcpPacket instanceof RtcpSrPacket) {
            Iterable $this$forEach$iv = ((RtcpSrPacket)packet).getReportBlocks();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RtcpReportBlock it = (RtcpReportBlock)element$iv;
                boolean bl = false;
                ssrcs.add(it.getSsrc());
            }
        } else if (rtcpPacket instanceof RtcpRrPacket) {
            Iterable $this$forEach$iv = ((RtcpRrPacket)packet).getReportBlocks();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RtcpReportBlock it = (RtcpReportBlock)element$iv;
                boolean bl = false;
                ssrcs.add(it.getSsrc());
            }
        } else if (rtcpPacket instanceof RtcpSdesPacket) {
            Iterable $this$forEach$iv = ((RtcpSdesPacket)packet).getSdesChunks();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SdesChunk it = (SdesChunk)element$iv;
                boolean bl = false;
                ssrcs.add(it.getSsrc());
            }
        } else if (rtcpPacket instanceof RtcpByePacket) {
            ssrcs.addAll((Collection)((RtcpByePacket)packet).getSsrcs());
        }
        return ssrcs;
    }

    private final void doRtcpCallbacks(RtcpPacket packet, String endpointId, Function1<? super RtcpEventNotifier, Unit> callback) {
        Collection<Long> ssrcs = this.getRtcpSsrcs(packet);
        HashSet<String> eps = new HashSet<String>();
        Iterable $this$forEach$iv = ssrcs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractEndpoint it;
            long it2 = ((Number)element$iv).longValue();
            boolean bl = false;
            if (this.conference.getEndpointBySsrc(it2) == null) continue;
            boolean bl2 = false;
            eps.add(it.getId());
        }
        String string = endpointId;
        if (string != null) {
            String it = string;
            boolean bl = false;
            eps.remove(it);
        }
        $this$forEach$iv = eps;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object it;
            String epId = (String)element$iv;
            boolean bl = false;
            if (this.getEndpoint(epId) != null) {
                boolean bl3 = false;
                callback.invoke(((RelayedEndpoint)it).getRtcpEventNotifier());
            }
            if (this.senders.get(epId) == null) continue;
            boolean bl4 = false;
            callback.invoke(((RelayEndpointSender)it).getRtcpEventNotifier());
        }
        if (endpointId != null) {
            callback.invoke(this.transceiver.getRtcpEventNotifier());
        }
    }

    public final void rtcpPacketReceived(@NotNull RtcpPacket packet, @Nullable Instant receivedTime, @Nullable String endpointId) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        this.doRtcpCallbacks(packet, endpointId, arg_0 -> Relay.rtcpPacketReceived$lambda$79(packet, receivedTime, arg_0));
    }

    public final void rtcpPacketSent(@NotNull RtcpPacket packet, @Nullable String endpointId) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        this.doRtcpCallbacks(packet, endpointId, arg_0 -> Relay.rtcpPacketSent$lambda$80(packet, arg_0));
    }

    private final boolean isTransportConnected() {
        return this.iceTransport.isConnected() && this.dtlsTransport.isConnected();
    }

    @Override
    public boolean wants(@NotNull PacketInfo packet) {
        boolean bl;
        Intrinsics.checkNotNullParameter(packet, "packet");
        if (!this.isTransportConnected()) {
            return false;
        }
        if (packet instanceof RelayedPacketInfo && Intrinsics.areEqual(((RelayedPacketInfo)packet).getMeshId(), this.meshId)) {
            return false;
        }
        Packet packet2 = packet.getPacket();
        if (packet2 instanceof VideoRtpPacket || packet2 instanceof AudioRtpPacket || packet2 instanceof RtcpSrPacket || packet2 instanceof RtcpFbPliPacket || packet2 instanceof RtcpFbFirPacket) {
            bl = true;
        } else {
            this.logger.warn("Ignoring an unknown packet type:" + packet.getPacket().getClass().getSimpleName());
            bl = false;
        }
        return bl;
    }

    @Override
    public void send(@NotNull PacketInfo packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        String string = packet.getEndpointId();
        if (string != null) {
            String it = string;
            boolean bl = false;
            this.getOrCreateRelaySender(it).sendPacket(packet);
        } else {
            Relay $this$send_u24lambda_u2482 = this;
            boolean bl = false;
            $this$send_u24lambda_u2482.transceiver.sendPacket(packet);
        }
    }

    public final void endpointExpired(@NotNull String id) {
        block0: {
            RelayEndpointSender s2;
            Intrinsics.checkNotNullParameter(id, "id");
            RelayEndpointSender relayEndpointSender = s2 = this.senders.remove(id);
            if (relayEndpointSender == null) break block0;
            relayEndpointSender.expire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final double getIncomingBitrateBps() {
        double d;
        Object object = this.endpointsLock;
        double d2 = this.transceiver.getTransceiverStats().getRtpReceiverStats().getPacketStreamStats().getBitrateBps();
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            Collection<RelayedEndpoint> collection = this.relayedEndpoints.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable iterable = collection;
            double d3 = 0.0;
            for (Object t2 : iterable) {
                void it;
                RelayedEndpoint relayedEndpoint = (RelayedEndpoint)t2;
                double d4 = d3;
                boolean bl2 = false;
                double d5 = it.getIncomingStats().getBitrateBps();
                d3 = d4 + d5;
            }
            d = d3;
        }
        double d6 = d;
        return d2 + d6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final long getIncomingPacketRate() {
        long l;
        Object object = this.endpointsLock;
        long l2 = this.transceiver.getTransceiverStats().getRtpReceiverStats().getPacketStreamStats().getPacketRate();
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            Collection<RelayedEndpoint> collection = this.relayedEndpoints.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable iterable = collection;
            long l3 = 0L;
            for (Object t2 : iterable) {
                void it;
                RelayedEndpoint relayedEndpoint = (RelayedEndpoint)t2;
                long l4 = l3;
                boolean bl2 = false;
                long l5 = it.getIncomingStats().getPacketRate();
                l3 = l4 + l5;
            }
            l = l3;
        }
        long l6 = l;
        return l2 + l6;
    }

    /*
     * WARNING - void declaration
     */
    public final double getOutgoingBitrateBps() {
        double d;
        double d2 = this.transceiver.getTransceiverStats().getOutgoingPacketStreamStats().getBitrateBps();
        Collection<RelayEndpointSender> collection = this.senders.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable iterable = collection;
        double d3 = d2;
        double d4 = 0.0;
        for (Object t2 : iterable) {
            void it;
            RelayEndpointSender relayEndpointSender = (RelayEndpointSender)t2;
            d = d4;
            boolean bl = false;
            double d5 = it.getOutgoingStats().getBitrateBps();
            d4 = d + d5;
        }
        d = d4;
        return d3 + d;
    }

    /*
     * WARNING - void declaration
     */
    public final long getOutgoingPacketRate() {
        long l;
        long l2 = this.transceiver.getTransceiverStats().getOutgoingPacketStreamStats().getPacketRate();
        Collection<RelayEndpointSender> collection = this.senders.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable iterable = collection;
        long l3 = l2;
        long l4 = 0L;
        for (Object t2 : iterable) {
            void it;
            RelayEndpointSender relayEndpointSender = (RelayEndpointSender)t2;
            l = l4;
            boolean bl = false;
            long l5 = it.getOutgoingStats().getPacketRate();
            l4 = l + l5;
        }
        l = l4;
        return l3 + l;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateStatsOnExpire() {
        void $this$filterTo$iv$iv;
        TransceiverStats transceiverStats = this.transceiver.getTransceiverStats();
        PacketStreamStats.Snapshot incomingStats = transceiverStats.getRtpReceiverStats().getPacketStreamStats();
        PacketStreamStats.Snapshot outgoingStats = transceiverStats.getOutgoingPacketStreamStats();
        this.statistics.getBytesReceived().getAndAdd(incomingStats.getBytes());
        this.statistics.getPacketsReceived().getAndAdd(incomingStats.getPackets());
        this.statistics.getBytesSent().getAndAdd(outgoingStats.getBytes());
        this.statistics.getPacketsSent().getAndAdd(outgoingStats.getPackets());
        VideobridgeMetrics.totalRelayBytesReceived.add(this.statistics.getBytesReceived().get());
        VideobridgeMetrics.totalRelayBytesSent.add(this.statistics.getBytesSent().get());
        VideobridgeMetrics.relayPacketsReceived.add(this.statistics.getPacketsReceived().get());
        VideobridgeMetrics.relayPacketsSent.add(this.statistics.getPacketsSent().get());
        VideobridgeMetrics.keyframesReceived.addAndGet(transceiverStats.getRtpReceiverStats().getVideoParserStats().getNumKeyframes());
        VideobridgeMetrics.layeringChangesReceived.addAndGet(transceiverStats.getRtpReceiverStats().getVideoParserStats().getNumLayeringChanges());
        Iterable $this$filter$iv = transceiverStats.getRtpReceiverStats().getIncomingStats().getSsrcStats().values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IncomingSsrcStats.Snapshot it = (IncomingSsrcStats.Snapshot)element$iv$iv;
            boolean bl = false;
            if (!(it.getMediaType() == MediaType.VIDEO)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Duration durationActiveVideo = ClockUtils.sumOf((List)destination$iv$iv, Relay::updateStatsOnExpire$lambda$90);
        VideobridgeMetrics.totalVideoStreamMillisecondsReceived.add(durationActiveVideo.toMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void expire() {
        this.expired = true;
        this.logger.info("Expiring.");
        Object object = this.endpointsLock;
        synchronized (object) {
            boolean $i$a$-synchronized-Relay$expire$22 = false;
            Collection<RelayedEndpoint> collection = this.relayedEndpoints.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RelayedEndpoint it = (RelayedEndpoint)element$iv;
                boolean bl = false;
                it.expire();
            }
            Unit $i$a$-synchronized-Relay$expire$22 = Unit.INSTANCE;
        }
        Collection<RelayEndpointSender> collection = this.senders.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RelayEndpointSender it = (RelayEndpointSender)element$iv;
            boolean bl = false;
            it.expire();
        }
        this.conference.relayExpired(this);
        try {
            Object object2;
            Logger logger;
            this.updateStatsOnExpire();
            this.transceiver.stop();
            SrtpTransformers srtpTransformers = this.srtpTransformers;
            if (srtpTransformers != null) {
                srtpTransformers.close();
            }
            Logger $this$cdebug$iv = this.logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug(this.transceiver.getNodeStats().prettyPrint(0));
            }
            $this$cdebug$iv = this.logger;
            $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug(this.iceTransport.getDebugState().toJSONString());
            }
            $this$cdebug$iv = this.logger;
            $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug(this.dtlsTransport.getDebugState().toJSONString());
            }
            this.transceiver.teardown();
            this.messageTransport.close();
            DcSctpHandler dcSctpHandler = this.sctpHandler;
            if (dcSctpHandler != null) {
                dcSctpHandler.stop();
            }
            SctpHandler sctpHandler = this.usrSctpHandler;
            if (sctpHandler != null) {
                sctpHandler.stop();
            }
            SctpManager sctpManager = this.sctpManager;
            if (sctpManager != null) {
                sctpManager.closeConnection();
            }
            if ((object2 = this.sctpTransport) != null && (object2 = ((DcSctpTransport)object2).getSocket()) != null) {
                object2.close();
            }
        }
        catch (Throwable t2) {
            this.logger.error("Exception while expiring: ", t2);
        }
        this.conference.getEncodingsManager().unsubscribe(this);
        this.dtlsTransport.stop();
        this.iceTransport.stop();
        this.outgoingSrtpPacketQueue.close();
        this.logger.info("Expired.");
    }

    @JvmOverloads
    public Relay(@NotNull String id, @NotNull Conference conference, @NotNull Logger parentLogger, @Nullable String meshId, boolean iceControlling, boolean useUniquePort) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(conference, "conference");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        this(id, conference, parentLogger, meshId, iceControlling, useUniquePort, null, 64, null);
    }

    private static final Unit sctpPipeline$lambda$3(Relay this$0, PipelineBuilder $this$pipeline) {
        block1: {
            ConsumerNode it;
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            Intrinsics.checkNotNullParameter($this$pipeline, "$this$pipeline");
            PipelineBuilder.node$default($this$pipeline, this$0.sctpRecvPcap, null, 2, null);
            DcSctpHandler dcSctpHandler = this$0.sctpHandler;
            if (dcSctpHandler != null) {
                it = dcSctpHandler;
                boolean bl = false;
                PipelineBuilder.node$default($this$pipeline, it, null, 2, null);
            }
            SctpHandler sctpHandler = this$0.usrSctpHandler;
            if (sctpHandler == null) break block1;
            it = sctpHandler;
            boolean bl = false;
            PipelineBuilder.node$default($this$pipeline, it, null, 2, null);
        }
        return Unit.INSTANCE;
    }

    private static final boolean incomingDataChannelMessagesQueue$lambda$8(Relay this$0, PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        this$0.dataChannelHandler.consume(packetInfo);
        return true;
    }

    private static final int createUsrSctpConnection$lambda$19(Relay this$0, byte[] data, int offset, int length) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        ToggleablePcapWriter.PcapWriterNode pcapWriterNode = this$0.sctpSendPcap;
        Intrinsics.checkNotNull(data);
        pcapWriterNode.observe(data, offset, length);
        this$0.dtlsTransport.sendDtlsData(data, offset, length);
        return 0;
    }

    private static final void createUsrSctpConnection$lambda$20(Relay this$0, byte[] data, int sid, int ssn, int tsn, long ppid, int context, int flags) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        DataChannelPacket dataChannelPacket = new DataChannelPacket(data, 0, data.length, sid, (int)ppid);
        this$0.incomingDataChannelMessagesQueue.add(new PacketInfo(dataChannelPacket, 0, null, 6, null));
    }

    private static final void connectUsrSctpConnection$lambda$21(Relay this$0, SctpClientSocket $sctpClientSocket) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($sctpClientSocket, "$sctpClientSocket");
        this$0.logger.info("Attempting to establish SCTP socket connection");
        if (!$sctpClientSocket.connect(SctpManager.DEFAULT_SCTP_PORT)) {
            this$0.logger.error("Failed to establish SCTP connection to remote side");
        }
    }

    private static final void acceptUsrSctpConnection$lambda$23(Relay this$0, SctpServerSocket $sctpServerSocket) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($sctpServerSocket, "$sctpServerSocket");
        this$0.logger.info("Attempting to establish SCTP socket connection");
        int attempts = 0;
        while (!$sctpServerSocket.accept()) {
            ++attempts;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                break;
            }
            if (attempts <= 100) continue;
            this$0.logger.error("Timed out waiting for SCTP connection from remote side");
            break;
        }
        Logger $this$cdebug$iv = this$0.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug("SCTP socket " + $sctpServerSocket.hashCode() + " accepted connection");
        }
    }

    private static final String handleMediaPacket$lambda$34(long $ssrc) {
        return "RTP Packet received for unknown endpoint SSRC " + $ssrc;
    }

    private static final String doSendSrtp$lambda$37(PacketInfo $packetInfo) {
        Intrinsics.checkNotNullParameter($packetInfo, "$packetInfo");
        return String.valueOf($packetInfo.getTimeline());
    }

    private static final void scheduleRelayMessageTransportTimeout$lambda$68(Relay this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        if (!this$0.expired && !this$0.messageTransport.isConnected()) {
            this$0.logger.error("RelayMessageTransport still not connected.");
            VideobridgeMetrics.numRelaysNoMessageTransportAfterDelay.inc();
        }
    }

    private static final Unit rtcpPacketReceived$lambda$79(RtcpPacket $packet, Instant $receivedTime, RtcpEventNotifier it) {
        Intrinsics.checkNotNullParameter($packet, "$packet");
        Intrinsics.checkNotNullParameter(it, "it");
        it.notifyRtcpReceived($packet, $receivedTime, true);
        return Unit.INSTANCE;
    }

    private static final Unit rtcpPacketSent$lambda$80(RtcpPacket $packet, RtcpEventNotifier it) {
        Intrinsics.checkNotNullParameter($packet, "$packet");
        Intrinsics.checkNotNullParameter(it, "it");
        it.notifyRtcpSent($packet, true);
        return Unit.INSTANCE;
    }

    private static final Duration updateStatsOnExpire$lambda$90(IncomingSsrcStats.Snapshot it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getDurationActive();
    }

    public static final /* synthetic */ void access$handleMediaPacket(Relay $this, RelayedPacketInfo packetInfo) {
        $this.handleMediaPacket(packetInfo);
    }

    public static final /* synthetic */ PacketInfoQueue access$getOutgoingSrtpPacketQueue$p(Relay $this) {
        return $this.outgoingSrtpPacketQueue;
    }

    public static final /* synthetic */ IceTransport access$getIceTransport$p(Relay $this) {
        return $this.iceTransport;
    }

    public static final /* synthetic */ void access$setSrtpInformation(Relay $this, int chosenSrtpProtectionProfile, TlsRole tlsRole, byte[] keyingMaterial) {
        $this.setSrtpInformation(chosenSrtpProtectionProfile, tlsRole, keyingMaterial);
    }

    public static final /* synthetic */ SctpSocket access$getSctpSocket$p(Relay $this) {
        return $this.sctpSocket;
    }

    public static final /* synthetic */ CounterMetric access$getDroppedPacketsMetric$cp() {
        return droppedPacketsMetric;
    }

    public static final /* synthetic */ CounterMetric access$getExceptionsMetric$cp() {
        return exceptionsMetric;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jitsi/videobridge/relay/Relay$Companion;", "", "<init>", "()V", "droppedPacketsMetric", "Lorg/jitsi/metrics/CounterMetric;", "exceptionsMetric", "queueErrorCounter", "Lorg/jitsi/utils/queue/CountingErrorHandler;", "SRTP_QUEUE_ENTRY_EVENT", "", "SRTP_QUEUE_EXIT_EVENT", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lorg/jitsi/videobridge/relay/Relay$IncomingRelayPacketHandler;", "", "handleIncomingPacket", "", "packetInfo", "Lorg/jitsi/videobridge/relay/RelayedPacketInfo;", "jitsi-videobridge"})
    public static interface IncomingRelayPacketHandler {
        public void handleIncomingPacket(@NotNull RelayedPacketInfo var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u000bH\u0016J\b\u0010\u0014\u001a\u00020\u000bH\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jitsi/videobridge/relay/Relay$SctpCallbacks;", "Lorg/jitsi/videobridge/dcsctp/DcSctpBaseCallbacks;", "transport", "Lorg/jitsi/videobridge/dcsctp/DcSctpTransport;", "<init>", "(Lorg/jitsi/videobridge/relay/Relay;Lorg/jitsi/videobridge/dcsctp/DcSctpTransport;)V", "sendPacketWithStatus", "Lorg/jitsi/dcsctp4j/SendPacketStatus;", "packet", "", "OnMessageReceived", "", "message", "Lorg/jitsi/dcsctp4j/DcSctpMessage;", "OnError", "error", "Lorg/jitsi/dcsctp4j/ErrorKind;", "", "OnAborted", "OnConnected", "OnClosed", "jitsi-videobridge"})
    private final class SctpCallbacks
    extends DcSctpBaseCallbacks {
        public SctpCallbacks(DcSctpTransport transport) {
            Intrinsics.checkNotNullParameter(transport, "transport");
            super(transport, null, 2, null);
        }

        @Override
        @NotNull
        public SendPacketStatus sendPacketWithStatus(@NotNull byte[] packet) {
            Intrinsics.checkNotNullParameter(packet, "packet");
            try {
                byte[] newBuf = ByteBufferPool.getBuffer(packet.length);
                System.arraycopy(packet, 0, newBuf, 0, packet.length);
                ToggleablePcapWriter.PcapWriterNode pcapWriterNode = Relay.this.sctpSendPcap;
                Intrinsics.checkNotNull(newBuf);
                pcapWriterNode.observe(newBuf, 0, packet.length);
                Relay.this.dtlsTransport.sendDtlsData(newBuf, 0, packet.length);
                return SendPacketStatus.kSuccess;
            }
            catch (Throwable e) {
                Relay.this.logger.warn("Exception sending SCTP packet", e);
                return SendPacketStatus.kError;
            }
        }

        @Override
        public void OnMessageReceived(@NotNull DcSctpMessage message) {
            Intrinsics.checkNotNullParameter(message, "message");
            try {
                DataChannelPacket dataChannelPacket = new DataChannelPacket(message);
                Relay.this.incomingDataChannelMessagesQueue.add(new PacketInfo(dataChannelPacket, 0, null, 6, null));
            }
            catch (Throwable e) {
                Relay.this.logger.warn("Exception processing SCTP message", e);
            }
        }

        @Override
        public void OnError(@NotNull ErrorKind error, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)error, "error");
            Intrinsics.checkNotNullParameter(message, "message");
            Relay.this.logger.warn("SCTP error " + error + ": " + message);
        }

        @Override
        public void OnAborted(@NotNull ErrorKind error, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)error, "error");
            Intrinsics.checkNotNullParameter(message, "message");
            Relay.this.logger.warn("SCTP aborted with error " + error + ": " + message);
        }

        @Override
        public void OnConnected() {
            try {
                Relay.this.logger.info("SCTP connection is ready, creating the Data channel stack");
                DataChannelStack dataChannelStack = new DataChannelStack((arg_0, arg_1, arg_2) -> SctpCallbacks.OnConnected$lambda$0(Relay.this, arg_0, arg_1, arg_2), Relay.this.logger);
                Relay.this.dataChannelStack = dataChannelStack;
                dataChannelStack.onDataChannelStackEvents(arg_0 -> SctpCallbacks.OnConnected$lambda$1(Relay.this, arg_0));
                Relay.this.dataChannelHandler.setDataChannelStack(dataChannelStack);
                if (Relay.this.sctpRole == Sctp.Role.CLIENT) {
                    Relay.this.logger.info("Will open the data channel.");
                    DataChannel dataChannel = dataChannelStack.createDataChannel(0, 0, 0L, 0, "default");
                    RelayMessageTransport relayMessageTransport = Relay.this.messageTransport;
                    Intrinsics.checkNotNull(dataChannel);
                    relayMessageTransport.setDataChannel(dataChannel);
                    dataChannel.open();
                } else {
                    Relay.this.logger.info("Will wait for the remote side to open the data channel.");
                }
            }
            catch (Throwable e) {
                Relay.this.logger.warn("Exception processing SCTP connected event", e);
            }
        }

        @Override
        public void OnClosed() {
            Relay.this.logger.info("SCTP connection closed");
        }

        private static final int OnConnected$lambda$0(Relay this$0, ByteBuffer data, int sid, int ppid) {
            int n;
            SendStatus status;
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            DcSctpMessage message = new DcSctpMessage((short)sid, ppid, data.array());
            Object object = this$0.sctpTransport;
            SendStatus sendStatus = object != null && (object = ((DcSctpTransport)object).getSocket()) != null ? object.send(message, DcSctpTransport.Companion.getDEFAULT_SEND_OPTIONS()) : (status = null);
            if (status == SendStatus.kSuccess) {
                n = 0;
            } else {
                this$0.logger.error("Error sending to SCTP: " + status);
                n = -1;
            }
            return n;
        }

        private static final void OnConnected$lambda$1(Relay this$0, DataChannel dataChannel) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            this$0.logger.info("Remote side opened a data channel.");
            RelayMessageTransport relayMessageTransport = this$0.messageTransport;
            Intrinsics.checkNotNull(dataChannel);
            relayMessageTransport.setDataChannel(dataChannel);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jitsi/videobridge/relay/Relay$Statistics;", "", "<init>", "()V", "bytesReceived", "Ljava/util/concurrent/atomic/AtomicLong;", "getBytesReceived", "()Ljava/util/concurrent/atomic/AtomicLong;", "packetsReceived", "getPacketsReceived", "bytesSent", "getBytesSent", "packetsSent", "getPacketsSent", "getJson", "Lorg/json/simple/JSONObject;", "jitsi-videobridge"})
    public static final class Statistics {
        @NotNull
        private final AtomicLong bytesReceived = new AtomicLong(0L);
        @NotNull
        private final AtomicLong packetsReceived = new AtomicLong(0L);
        @NotNull
        private final AtomicLong bytesSent = new AtomicLong(0L);
        @NotNull
        private final AtomicLong packetsSent = new AtomicLong(0L);

        @NotNull
        public final AtomicLong getBytesReceived() {
            return this.bytesReceived;
        }

        @NotNull
        public final AtomicLong getPacketsReceived() {
            return this.packetsReceived;
        }

        @NotNull
        public final AtomicLong getBytesSent() {
            return this.bytesSent;
        }

        @NotNull
        public final AtomicLong getPacketsSent() {
            return this.packetsSent;
        }

        private final JSONObject getJson() {
            JSONObject jsonObject = new JSONObject();
            ((Map)jsonObject).put("bytes_received", this.bytesReceived.get());
            ((Map)jsonObject).put("bytes_sent", this.bytesSent.get());
            ((Map)jsonObject).put("packets_received", this.packetsReceived.get());
            ((Map)jsonObject).put("packets_sent", this.packetsSent.get());
            return jsonObject;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0017\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jitsi/videobridge/relay/Relay$TransceiverEventHandlerImpl;", "Lorg/jitsi/nlj/TransceiverEventHandler;", "<init>", "(Lorg/jitsi/videobridge/relay/Relay;)V", "audioLevelReceived", "", "sourceSsrc", "", "level", "bandwidthEstimationChanged", "", "newValue", "Lorg/jitsi/nlj/util/Bandwidth;", "bandwidthEstimationChanged-_2icLw0", "(D)V", "jitsi-videobridge"})
    @SourceDebugExtension(value={"SMAP\nRelay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Relay.kt\norg/jitsi/videobridge/relay/Relay$TransceiverEventHandlerImpl\n+ 2 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n*L\n1#1,1347:1\n63#2,4:1348\n*S KotlinDebug\n*F\n+ 1 Relay.kt\norg/jitsi/videobridge/relay/Relay$TransceiverEventHandlerImpl\n*L\n1338#1:1348,4\n*E\n"})
    private final class TransceiverEventHandlerImpl
    implements TransceiverEventHandler {
        @Override
        public boolean audioLevelReceived(long sourceSsrc, long level) {
            Relay.this.logger.warn(() -> TransceiverEventHandlerImpl.audioLevelReceived$lambda$0(sourceSsrc));
            return false;
        }

        @Override
        public void bandwidthEstimationChanged-_2icLw0(double newValue) {
            Logger $this$cdebug$iv = Relay.this.logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug("Estimated bandwidth is now " + Bandwidth.toString-impl(newValue));
            }
        }

        private static final String audioLevelReceived$lambda$0(long $sourceSsrc) {
            return "Audio level reported by relay transceiver for source " + $sourceSsrc;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EndpointDebugFeatures.values().length];
            try {
                nArray[EndpointDebugFeatures.PCAP_DUMP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EndpointDebugFeatures.SCTP_PCAP_DUMP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

