/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc;

import java.util.Collection;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtp.bandwidthestimation.BandwidthEstimator;
import org.jitsi.rtp.extensions.unsigned.UnsignedKt;
import org.jitsi.utils.concurrent.PeriodicRunnable;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;
import org.jitsi.videobridge.cc.allocation.BitrateControllerStatusSnapshot;
import org.jitsi.videobridge.cc.config.BandwidthProbingConfig;
import org.json.simple.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %2\u00020\u00012\u00020\u0002:\u0002%&B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b \u0010!J\b\u0010\"\u001a\u00020\u001dH\u0016J\u0006\u0010#\u001a\u00020$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006'"}, d2={"Lorg/jitsi/videobridge/cc/BandwidthProbing;", "Lorg/jitsi/utils/concurrent/PeriodicRunnable;", "Lorg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator$Listener;", "probingDataSender", "Lorg/jitsi/videobridge/cc/BandwidthProbing$ProbingDataSender;", "statusSnapshotSupplier", "Ljava/util/function/Supplier;", "Lorg/jitsi/videobridge/cc/allocation/BitrateControllerStatusSnapshot;", "<init>", "(Lorg/jitsi/videobridge/cc/BandwidthProbing$ProbingDataSender;Ljava/util/function/Supplier;)V", "seqNum", "", "ts", "", "enabled", "", "getEnabled", "()Z", "setEnabled", "(Z)V", "bytesLeftOver", "latestBwe", "diagnosticsContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "getDiagnosticsContext", "()Lorg/jitsi/utils/logging/DiagnosticContext;", "setDiagnosticsContext", "(Lorg/jitsi/utils/logging/DiagnosticContext;)V", "bandwidthEstimationChanged", "", "newValue", "Lorg/jitsi/nlj/util/Bandwidth;", "bandwidthEstimationChanged-_2icLw0", "(D)V", "run", "getDebugState", "Lorg/json/simple/JSONObject;", "Companion", "ProbingDataSender", "jitsi-videobridge"})
public final class BandwidthProbing
extends PeriodicRunnable
implements BandwidthEstimator.Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProbingDataSender probingDataSender;
    @NotNull
    private final Supplier<BitrateControllerStatusSnapshot> statusSnapshotSupplier;
    private int seqNum;
    private long ts;
    private boolean enabled;
    private int bytesLeftOver;
    private long latestBwe;
    @Nullable
    private DiagnosticContext diagnosticsContext;
    private static final TimeSeriesLogger timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(BandwidthProbing.class);

    public BandwidthProbing(@NotNull ProbingDataSender probingDataSender, @NotNull Supplier<BitrateControllerStatusSnapshot> statusSnapshotSupplier) {
        Intrinsics.checkNotNullParameter(probingDataSender, "probingDataSender");
        Intrinsics.checkNotNullParameter(statusSnapshotSupplier, "statusSnapshotSupplier");
        super(BandwidthProbingConfig.config.getPaddingPeriodMs());
        this.probingDataSender = probingDataSender;
        this.statusSnapshotSupplier = statusSnapshotSupplier;
        this.seqNum = Random.Default.nextInt(65535);
        this.ts = UnsignedKt.toPositiveLong(Random.Default.nextInt());
        this.latestBwe = -1L;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Nullable
    public final DiagnosticContext getDiagnosticsContext() {
        return this.diagnosticsContext;
    }

    public final void setDiagnosticsContext(@Nullable DiagnosticContext diagnosticContext) {
        this.diagnosticsContext = diagnosticContext;
    }

    @Override
    public void bandwidthEstimationChanged-_2icLw0(double newValue) {
        this.latestBwe = (long)newValue;
    }

    @Override
    public void run() {
        block9: {
            super.run();
            if (!this.enabled) {
                return;
            }
            BitrateControllerStatusSnapshot bitrateControllerStatusSnapshot = this.statusSnapshotSupplier.get();
            Intrinsics.checkNotNullExpressionValue(bitrateControllerStatusSnapshot, "get(...)");
            BitrateControllerStatusSnapshot bitrateControllerStatus = bitrateControllerStatusSnapshot;
            long totalNeededBps = bitrateControllerStatus.getCurrentIdealBps() - bitrateControllerStatus.getCurrentTargetBps();
            if (totalNeededBps < 1L) {
                this.bytesLeftOver = 0;
                return;
            }
            long latestBweCopy = this.latestBwe;
            if (bitrateControllerStatus.getCurrentIdealBps() <= latestBweCopy) {
                return;
            }
            long maxPaddingBps = latestBweCopy - bitrateControllerStatus.getCurrentTargetBps();
            long paddingBps = RangesKt.coerceAtMost(totalNeededBps, maxPaddingBps);
            DiagnosticContext.TimeSeriesPoint timeSeriesPoint = null;
            double newBytesNeeded = (double)(BandwidthProbingConfig.config.getPaddingPeriodMs() * paddingBps) / 1000.0 / 8.0;
            double bytesNeeded = newBytesNeeded + (double)this.bytesLeftOver;
            if (timeSeriesLogger.isTraceEnabled()) {
                DiagnosticContext diagnosticContext = this.diagnosticsContext;
                if (diagnosticContext != null) {
                    DiagnosticContext diagnosticsContext = diagnosticContext;
                    boolean bl = false;
                    timeSeriesPoint = diagnosticsContext.makeTimeSeriesPoint("sent_padding").addField("padding_bps", paddingBps).addField("total_ideal_bps", bitrateControllerStatus.getCurrentIdealBps()).addField("total_target_bps", bitrateControllerStatus.getCurrentTargetBps()).addField("needed_bps", totalNeededBps).addField("max_padding_bps", maxPaddingBps).addField("bwe_bps", latestBweCopy).addField("bytes_needed", bytesNeeded).addField("prev_bytes_left_over", this.bytesLeftOver);
                }
            }
            if (bytesNeeded >= 1.0) {
                int bytesSent = this.probingDataSender.sendProbing(bitrateControllerStatus.getActiveSsrcs(), (int)bytesNeeded);
                this.bytesLeftOver = (int)RangesKt.coerceAtLeast(bytesNeeded - (double)bytesSent, 0.0);
                DiagnosticContext.TimeSeriesPoint timeSeriesPoint2 = timeSeriesPoint;
                if (timeSeriesPoint2 != null && (timeSeriesPoint2 = timeSeriesPoint2.addField("bytes_sent", bytesSent)) != null) {
                    timeSeriesPoint2.addField("new_bytes_left_over", this.bytesLeftOver);
                }
            } else {
                this.bytesLeftOver = (int)RangesKt.coerceAtLeast(bytesNeeded, 0.0);
            }
            if (!timeSeriesLogger.isTraceEnabled()) break block9;
            TimeSeriesLogger timeSeriesLogger = BandwidthProbing.timeSeriesLogger;
            if (timeSeriesLogger != null) {
                timeSeriesLogger.trace(timeSeriesPoint);
            }
        }
    }

    @NotNull
    public final JSONObject getDebugState() {
        JSONObject jSONObject;
        JSONObject $this$getDebugState_u24lambda_u241 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$getDebugState_u24lambda_u241.put("seqNum", this.seqNum);
        $this$getDebugState_u24lambda_u241.put("ts", this.ts);
        $this$getDebugState_u24lambda_u241.put("enabled", this.enabled);
        $this$getDebugState_u24lambda_u241.put("latestBwe", this.latestBwe);
        return jSONObject;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jitsi/videobridge/cc/BandwidthProbing$Companion;", "", "<init>", "()V", "timeSeriesLogger", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "kotlin.jvm.PlatformType", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\t\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u001e\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0003H&\u00a8\u0006\b"}, d2={"Lorg/jitsi/videobridge/cc/BandwidthProbing$ProbingDataSender;", "", "sendProbing", "", "mediaSsrcs", "", "", "numBytes", "jitsi-videobridge"})
    public static interface ProbingDataSender {
        public int sendProbing(@NotNull Collection<Long> var1, int var2);
    }
}

