/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.util;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0005J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0005J\u000e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005J\u0006\u0010\u0017\u001a\u00020\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jitsi/rtp/util/BitReader;", "", "buf", "", "byteOffset", "", "byteLength", "<init>", "([BII)V", "getBuf", "()[B", "offset", "byteBound", "bitAsBoolean", "", "bit", "bits", "n", "bitsLong", "", "skipBits", "", "ns", "reset", "rtp"})
public final class BitReader {
    @NotNull
    private final byte[] buf;
    private final int byteOffset;
    private final int byteLength;
    private int offset;
    private final int byteBound;

    public BitReader(@NotNull byte[] buf, int byteOffset, int byteLength) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        this.buf = buf;
        this.byteOffset = byteOffset;
        this.byteLength = byteLength;
        this.offset = this.byteOffset * 8;
        this.byteBound = this.byteOffset + this.byteLength;
    }

    public /* synthetic */ BitReader(byte[] byArray, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        this(byArray, n, n2);
    }

    @NotNull
    public final byte[] getBuf() {
        return this.buf;
    }

    public final boolean bitAsBoolean() {
        int byteIdx = this.offset / 8;
        int bitIdx = this.offset % 8;
        if (!(byteIdx < this.byteBound)) {
            boolean $i$a$-check-BitReader$bitAsBoolean$22 = false;
            String $i$a$-check-BitReader$bitAsBoolean$22 = "offset " + this.offset + " (" + byteIdx + "/" + bitIdx + ") invalid in buffer of length " + this.byteLength + " after offset " + this.byteOffset;
            throw new IllegalStateException($i$a$-check-BitReader$bitAsBoolean$22.toString());
        }
        byte by = this.buf[byteIdx];
        byte mask = (byte)(1 << 7 - bitIdx);
        int n = this.offset;
        this.offset = n + 1;
        return (byte)(by & mask) != 0;
    }

    public final int bit() {
        return this.bitAsBoolean() ? 1 : 0;
    }

    public final int bits(int n) {
        if (!(n < 32)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int ret = 0;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            ret <<= 1;
            ret |= this.bit();
        }
        return ret;
    }

    public final long bitsLong(int n) {
        if (!(n < 64)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        long ret = 0L;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            ret <<= 1;
            ret |= (long)this.bit();
        }
        return ret;
    }

    public final void skipBits(int n) {
        this.offset += n;
    }

    public final int ns(int n) {
        int w = 0;
        int x = n;
        while (x != 0) {
            x >>= 1;
            ++w;
        }
        int m4 = (1 << w) - n;
        int v = this.bits(w - 1);
        if (v < m4) {
            return v;
        }
        int extraBit = this.bit();
        return (v << 1) - m4 + extraBit;
    }

    public final void reset() {
        this.offset = this.byteOffset * 8;
    }
}

