"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkbenchPlugin = void 0;

var _routes = _interopRequireDefault(require("./routes"));

var _sqlPlugin = _interopRequireDefault(require("./clusters/sql/sqlPlugin"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } /*
                                                                                                                                                                                                                   * Copyright OpenSearch Contributors
                                                                                                                                                                                                                   * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                   */

class WorkbenchPlugin {
  constructor(initializerContext) {
    _defineProperty(this, "logger", void 0);

    this.logger = initializerContext.logger.get();
  }

  setup(core) {
    this.logger.debug('queryWorkbenchDashboards: Setup');
    const router = core.http.createRouter();
    const client = core.opensearch.legacy.createClient('query_workbench', {
      plugins: [_sqlPlugin.default]
    }); // Register server side APIs

    (0, _routes.default)(router, client);
    return {};
  }

  start(core) {
    this.logger.debug('queryWorkbenchDashboards: Started');
    return {};
  }

  stop() {}

}

exports.WorkbenchPlugin = WorkbenchPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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