"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RepositoryReader = void 0;

var path = _interopRequireWildcard(require("path"));

var _integration = require("./integration");

var _fs_data_adaptor = require("./fs_data_adaptor");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } /*
                                                                                                                                                                                                                   * Copyright OpenSearch Contributors
                                                                                                                                                                                                                   * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                   */

class RepositoryReader {
  constructor(directory, reader) {
    _defineProperty(this, "reader", void 0);

    _defineProperty(this, "directory", void 0);

    this.directory = directory;
    this.reader = reader !== null && reader !== void 0 ? reader : new _fs_data_adaptor.FileSystemCatalogDataAdaptor(directory);
  }

  async getIntegrationList() {
    // TODO in the future, we want to support traversing nested directory structures.
    const folders = await this.reader.findIntegrations();

    if (!folders.ok) {
      console.error(`Error reading integration directories in: ${this.directory}`, folders.error);
      return [];
    }

    const integrations = await Promise.all(folders.value.map(i => this.getIntegration(path.basename(i))));
    return integrations.filter(x => x !== null);
  }

  async getIntegration(name) {
    if ((await this.reader.getDirectoryType(name)) !== 'integration') {
      console.error(`Requested integration '${name}' does not exist`);
      return null;
    }

    const integ = new _integration.IntegrationReader(name, this.reader.join(name));
    const checkResult = await integ.getConfig();

    if (!checkResult.ok) {
      console.error(`Integration '${name}' is invalid:`, checkResult.error);
      return null;
    }

    return integ;
  }

}

exports.RepositoryReader = RepositoryReader;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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