"use strict";
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.registerLexerRules = void 0;
const tslib_1 = require("tslib");
const xJson = tslib_1.__importStar(require("./xjson"));
const opensearchql = tslib_1.__importStar(require("./opensearchql"));
const painless = tslib_1.__importStar(require("./painless"));
exports.registerLexerRules = (m) => {
    m.languages.register({ id: xJson.ID });
    m.languages.setMonarchTokensProvider(xJson.ID, xJson.lexerRules);
    m.languages.register({ id: painless.ID });
    m.languages.setMonarchTokensProvider(painless.ID, painless.lexerRules);
    m.languages.register({ id: opensearchql.ID });
    m.languages.setMonarchTokensProvider(opensearchql.ID, opensearchql.lexerRules);
};
//# sourceMappingURL=index.js.map