/*
 * Decompiled with CFR 0.152.
 */
package values;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import values.GameType;

public final class Settings {
    public static final String HOME = System.getProperty("user.home") + "/.jbrickshooter/";
    public static final int LEVEL_UP_SCORES = 100;
    private static final int GRADE = 34;
    public static final Color BACKGROUND = new Color(34, 34, 34);
    private static final String DELAY_MOVE = "5";
    private static final String DELAY_FIRE = "100";
    private static final String THEME_INDEX = "1";
    public static final int DEFAULT_BRICK_SIZE = 30;
    private static int brickSize = 30;
    private Integer scores;
    private Integer scoresBackup;
    private Integer level;
    private Integer difficulty;
    private GameType gameType;
    private Font font;
    private Font bigFont;
    private Boolean gameOver;
    private final float fontSize = 18.0f;
    private final float bigFontSize = 60.0f;
    private ResourceBundle resources;
    private JMenuBar menu;
    private JMenuItem undo = null;
    private Properties highscores = new Properties();
    private Properties configuration = new Properties();

    public void saveToStream(OutputStream outputStream) throws IOException {
        for (int i = 0; i < 4; ++i) {
            outputStream.write(this.scores >> i * 8);
        }
        outputStream.write(this.level);
        outputStream.write(this.difficulty);
        outputStream.write(this.gameOver != false ? 1 : 0);
        outputStream.write(this.gameType.toInt());
    }

    public void loadFromStream(InputStream inputStream) throws IOException {
        this.scores = 0;
        for (int i = 0; i < 4; ++i) {
            this.scores = this.scores + (inputStream.read() << i * 8);
        }
        this.level = inputStream.read();
        this.difficulty = inputStream.read();
        this.gameOver = inputStream.read() == 1;
        this.gameType = GameType.fromInt(inputStream.read());
    }

    public void loadHighScores() {
        Object object;
        Comparable<File> comparable;
        block5: {
            try {
                comparable = new File(HOME + "highscores");
                if (!((File)comparable).exists()) break block5;
                if (((File)comparable).isFile() && ((File)comparable).canRead()) {
                    object = new FileInputStream((File)comparable);
                    this.highscores.load((InputStream)object);
                    ((InputStream)object).close();
                    break block5;
                }
                throw new IOException();
            }
            catch (IOException iOException) {
                System.out.println(this.getString("ERROR_HIGHSCORES_LOAD") + " (" + iOException.getMessage() + ")");
            }
        }
        if (this.highscores.size() < 180) {
            this.highscores.clear();
            comparable = 50;
            while ((Integer)comparable < 110) {
                this.highscores.setProperty(((Integer)comparable).toString() + GameType.STRATEGY.toString(), "0,Unknown");
                this.highscores.setProperty(((Integer)comparable).toString() + GameType.ARCADE.toString(), "0,Unknown");
                this.highscores.setProperty(((Integer)comparable).toString() + GameType.PUZZLE.toString(), "0,Unknown");
                object = comparable;
                comparable = (Integer)comparable + 1;
                Integer n = comparable;
            }
        }
    }

    public void saveHighScores() {
        try {
            File file = new File(HOME);
            file.mkdir();
            File file2 = new File(HOME + "highscores");
            file2.createNewFile();
            if (!file2.isFile() || !file2.canWrite()) {
                throw new IOException();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(HOME + "highscores");
            this.highscores.store(fileOutputStream, this.getString("TITLE"));
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println(this.getString("ERROR_HIGHSCORES_SAVE") + " (" + iOException.getMessage() + ")");
        }
    }

    public void loadConfiguration() {
        block3: {
            try {
                File file = new File(HOME + "configuration");
                if (!file.exists()) break block3;
                if (file.isFile() && file.canRead()) {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    this.configuration.load(fileInputStream);
                    ((InputStream)fileInputStream).close();
                    break block3;
                }
                throw new IOException();
            }
            catch (IOException iOException) {
                System.out.println(this.getString("ERROR_CONF_LOAD") + " (" + iOException.getMessage() + ")");
            }
        }
    }

    public void saveConfiguration() {
        try {
            this.configuration.setProperty("BRICK_SIZE", "" + brickSize);
            File file = new File(HOME);
            file.mkdir();
            File file2 = new File(HOME + "configuration");
            file2.createNewFile();
            if (!file2.isFile() || !file2.canWrite()) {
                throw new IOException();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(HOME + "configuration");
            this.configuration.store(fileOutputStream, this.getString("TITLE"));
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println(this.getString("ERROR_CONF_SAVE") + " (" + iOException.getMessage() + ")");
        }
    }

    public Settings() {
        Locale locale;
        this.setScores(0);
        this.setLevel(1);
        this.setDifficulty(7);
        this.setMenu(new JMenuBar());
        this.setGameOver(false);
        this.setGameType(GameType.STRATEGY);
        this.loadHighScores();
        this.loadConfiguration();
        String[] stringArray = this.getLocale().split("_");
        switch (stringArray.length) {
            default: {
                locale = new Locale(stringArray[0]);
                break;
            }
            case 2: {
                locale = new Locale(stringArray[0], stringArray[1]);
                break;
            }
            case 3: {
                locale = new Locale(stringArray[0], stringArray[1], stringArray[2]);
            }
        }
        this.resources = ResourceBundle.getBundle("i18n.Messages", locale);
        UIManager.put("OptionPane.yesButtonText", this.getString("YES"));
        UIManager.put("OptionPane.noButtonText", this.getString("NO"));
        UIManager.put("OptionPane.cancelButtonText", this.getString("CANCEL"));
        try {
            String string = "images/" + locale.getLanguage() + "_" + locale.getCountry() + ".ttf";
            URL uRL = this.getClass().getClassLoader().getResource(string);
            if (uRL == null) {
                uRL = this.getClass().getClassLoader().getResource("images/font.ttf");
            }
            InputStream inputStream = uRL.openStream();
            this.font = Font.createFont(0, inputStream);
            this.font = this.font.deriveFont(18.0f);
            inputStream.close();
            inputStream = uRL.openStream();
            this.bigFont = Font.createFont(0, inputStream);
            this.bigFont = this.bigFont.deriveFont(60.0f);
            inputStream.close();
        }
        catch (Exception exception) {
            System.out.println(this.getString("ERROR_FONT"));
        }
    }

    public String getString(String string) {
        return this.resources.getString(string);
    }

    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer n) {
        this.level = n;
    }

    public void upLevel() {
        this.level = this.level + 1;
    }

    public void saveScores() {
        this.scoresBackup = this.scores;
    }

    public void restoreScores() {
        this.scores = this.scoresBackup;
    }

    public Integer getScores() {
        return this.scores;
    }

    public void setScores(Integer n) {
        this.scores = n;
    }

    public void addScores(Integer n) {
        this.scores = this.scores + n;
    }

    public Integer getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(Integer n) {
        this.difficulty = n;
    }

    public Font getFont(boolean bl) {
        float f;
        Font font;
        if (bl) {
            font = this.bigFont;
            f = 60.0f;
        } else {
            font = this.font;
            f = 18.0f;
        }
        float f2 = f * (float)Settings.getBrickSizeRatio();
        if ((float)font.getSize() < f2) {
            font = font.deriveFont(f2);
        }
        return font;
    }

    public Font getFont() {
        return this.getFont(false);
    }

    public JMenuBar getMenu() {
        return this.menu;
    }

    public void setMenu(JMenuBar jMenuBar) {
        this.menu = jMenuBar;
    }

    public JMenuItem getUndo() {
        return this.undo;
    }

    public void setUndo(JMenuItem jMenuItem) {
        this.undo = jMenuItem;
    }

    public GameType getGameType() {
        return this.gameType;
    }

    public void setGameType(GameType gameType) {
        this.gameType = gameType;
    }

    public Boolean isGameOver() {
        return this.gameOver;
    }

    public void setGameOver(Boolean bl) {
        this.gameOver = bl;
    }

    public String getHighScores() {
        String string = "";
        Integer n = 0;
        while (n < 10) {
            Integer n2 = n + this.difficulty * 10;
            Object object = this.highscores.getProperty(n2.toString() + this.getGameType().toString()).split(",");
            string = string + (n + 1) + ". " + object[1] + "   -   " + object[0] + "\n";
            n2 = n;
            n = n + 1;
            object = n;
        }
        return string;
    }

    public Integer checkHighScores() {
        Integer n = 0;
        while (n < 10) {
            Integer n2 = n + this.difficulty * 10;
            Object object = this.highscores.getProperty(n2.toString() + this.getGameType().toString()).split(",");
            int n3 = Integer.parseInt(object[0]);
            if (this.scores >= n3) {
                return n;
            }
            n2 = n;
            n = n + 1;
            object = n;
        }
        return -1;
    }

    public void setHighScores(Integer n, String string) {
        Integer n2 = 9;
        Integer n3 = 8;
        while (n2 > n) {
            Integer n4 = n2 + this.difficulty * 10;
            Integer n5 = n3 + this.difficulty * 10;
            this.highscores.setProperty(n4.toString() + this.getGameType().toString(), this.highscores.getProperty(n5.toString() + this.getGameType().toString()));
            n4 = n2;
            n5 = n2 = Integer.valueOf(n2 - 1);
            n4 = n3;
            n5 = n3 = Integer.valueOf(n3 - 1);
        }
        n2 = n + this.difficulty * 10;
        this.highscores.setProperty(n2.toString() + this.getGameType().toString(), this.scores.toString() + "," + string);
    }

    public int getFireDelay() {
        return Integer.parseInt(this.configuration.getProperty("DELAY_FIRE", DELAY_FIRE));
    }

    public int getMoveDelay() {
        return Integer.parseInt(this.configuration.getProperty("DELAY_MOVE", DELAY_MOVE));
    }

    public int getThemeIndex() {
        return Integer.parseInt(this.configuration.getProperty("THEME_INDEX", THEME_INDEX));
    }

    public static void setBrickSize(int n) {
        brickSize = n;
    }

    public static int getBrickSize() {
        return brickSize;
    }

    public int getSavedBrickSize() {
        return Integer.valueOf(this.configuration.getProperty("BRICK_SIZE", "" + brickSize));
    }

    public static double getBrickSizeRatio() {
        return (double)brickSize / 30.0;
    }

    public String getLocale() {
        return this.configuration.getProperty("LOCALE", Locale.getDefault().toString());
    }

    public void setFireDelay(int n) {
        this.configuration.setProperty("DELAY_FIRE", "" + n);
    }

    public void setMoveDelay(int n) {
        this.configuration.setProperty("DELAY_MOVE", "" + n);
    }

    public void setThemeIndex(int n) {
        this.configuration.setProperty("THEME_INDEX", "" + n);
    }

    public void setLocale(String string) {
        this.configuration.setProperty("LOCALE", string);
    }

    public void cleanLocale() {
        this.configuration.remove("LOCALE");
    }

    public String getLaF() {
        return this.configuration.getProperty("LAF", this.getDefaultLaF());
    }

    public String getDefaultLaF() {
        String string = UIManager.getSystemLookAndFeelClassName();
        String string2 = System.getProperty("os.name");
        if (string2.contains("Linux")) {
            string = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
        }
        if (string2.contains("Windows")) {
            string = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
        }
        return string;
    }

    public void setLaF(String string) {
        this.configuration.setProperty("LAF", string);
    }

    public void cleanLaF() {
        this.configuration.remove("LAF");
    }

    public static Image getScaledImage(Image image, int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.drawImage(image, 0, 0, n, n2, null);
        graphics2D.dispose();
        return bufferedImage;
    }
}

