/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec;

import java.io.IOException;
import java.nio.CharBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jparsec.DelimitedParser;
import org.jparsec.EmptyListParser;
import org.jparsec.InternalFunctors;
import org.jparsec.ListFactory;
import org.jparsec.ParseContext;
import org.jparsec.ParseTree;
import org.jparsec.Parsers;
import org.jparsec.ReluctantBetweenParser;
import org.jparsec.RepeatAtLeastParser;
import org.jparsec.RepeatTimesParser;
import org.jparsec.ScannerState;
import org.jparsec.SkipAtLeastParser;
import org.jparsec.SkipTimesParser;
import org.jparsec.SourceLocator;
import org.jparsec.Token;
import org.jparsec.WithSource;
import org.jparsec.internal.annotations.Private;
import org.jparsec.internal.util.Checks;

public abstract class Parser<T> {
    Parser() {
    }

    public static <T> Reference<T> newReference() {
        return new Reference();
    }

    public final <R> Parser<R> retn(R value) {
        return this.next(Parsers.constant(value));
    }

    public final <R> Parser<R> next(Parser<R> parser) {
        return Parsers.sequence(this, parser);
    }

    public final <To> Parser<To> next(final Function<? super T, ? extends Parser<? extends To>> map) {
        return new Parser<To>(){

            @Override
            boolean apply(ParseContext ctxt) {
                return Parser.this.apply(ctxt) && this.runNext(ctxt);
            }

            public String toString() {
                return map.toString();
            }

            private boolean runNext(ParseContext state) {
                Object from = Parser.this.getReturn(state);
                return ((Parser)map.apply(from)).apply(state);
            }
        };
    }

    public final Parser<List<T>> until(Parser<?> parser) {
        return parser.not().next(this).many().followedBy(parser.peek());
    }

    public final Parser<T> followedBy(Parser<?> parser) {
        return Parsers.sequence(this, parser, InternalFunctors.firstOfTwo());
    }

    public final Parser<T> notFollowedBy(Parser<?> parser) {
        return this.followedBy(parser.not());
    }

    public final Parser<List<T>> many() {
        return this.atLeast(0);
    }

    public final Parser<Void> skipMany() {
        return this.skipAtLeast(0);
    }

    public final Parser<List<T>> many1() {
        return this.atLeast(1);
    }

    public final Parser<Void> skipMany1() {
        return this.skipAtLeast(1);
    }

    public final Parser<List<T>> atLeast(int min) {
        return new RepeatAtLeastParser(this, Checks.checkMin(min));
    }

    public final Parser<Void> skipAtLeast(int min) {
        return new SkipAtLeastParser(this, Checks.checkMin(min));
    }

    public final Parser<Void> skipTimes(int n) {
        return this.skipTimes(n, n);
    }

    public final Parser<List<T>> times(int n) {
        return this.times(n, n);
    }

    public final Parser<List<T>> times(int min, int max) {
        Checks.checkMinMax(min, max);
        return new RepeatTimesParser(this, min, max);
    }

    public final Parser<Void> skipTimes(int min, int max) {
        Checks.checkMinMax(min, max);
        return new SkipTimesParser(this, min, max);
    }

    public final <R> Parser<R> map(final Function<? super T, ? extends R> map) {
        return new Parser<R>(){

            @Override
            boolean apply(ParseContext ctxt) {
                boolean r = Parser.this.apply(ctxt);
                if (r) {
                    ctxt.result = map.apply(Parser.this.getReturn(ctxt));
                }
                return r;
            }

            public String toString() {
                return map.toString();
            }
        };
    }

    public final Parser<T> or(Parser<? extends T> alternative) {
        return Parsers.or(this, alternative);
    }

    public final Parser<T> otherwise(final Parser<? extends T> fallback) {
        return new Parser<T>(){

            @Override
            boolean apply(ParseContext ctxt) {
                Object result = ctxt.result;
                int at = ctxt.at;
                int step = ctxt.step;
                int errorIndex = ctxt.errorIndex();
                if (Parser.this.apply(ctxt)) {
                    return true;
                }
                if (ctxt.errorIndex() != errorIndex) {
                    return false;
                }
                ctxt.set(step, at, result);
                return fallback.apply(ctxt);
            }

            public String toString() {
                return "otherwise";
            }
        };
    }

    @Deprecated
    public final Parser<T> optional() {
        return Parsers.or(this, Parsers.always());
    }

    public final Parser<Optional<T>> asOptional() {
        return this.map(Optional::of).optional(Optional.empty());
    }

    public final Parser<T> optional(T defaultValue) {
        return Parsers.or(this, Parsers.constant(defaultValue));
    }

    public final Parser<?> not() {
        return this.not(this.toString());
    }

    public final Parser<?> not(String unexpected) {
        return this.peek().ifelse(Parsers.unexpected(unexpected), Parsers.always());
    }

    public final Parser<T> peek() {
        return new Parser<T>(){

            @Override
            public Parser<T> label(String name) {
                return Parser.this.label(name).peek();
            }

            @Override
            boolean apply(ParseContext ctxt) {
                int step = ctxt.step;
                int at = ctxt.at;
                boolean ok = Parser.this.apply(ctxt);
                if (ok) {
                    ctxt.setAt(step, at);
                }
                return ok;
            }

            public String toString() {
                return "peek";
            }
        };
    }

    public final Parser<T> atomic() {
        return new Parser<T>(){

            @Override
            public Parser<T> label(String name) {
                return Parser.this.label(name).atomic();
            }

            @Override
            boolean apply(ParseContext ctxt) {
                int at = ctxt.at;
                int step = ctxt.step;
                boolean r = Parser.this.apply(ctxt);
                if (r) {
                    ctxt.step = step + 1;
                } else {
                    ctxt.setAt(step, at);
                }
                return r;
            }

            public String toString() {
                return Parser.this.toString();
            }
        };
    }

    public final Parser<Boolean> succeeds() {
        return this.ifelse(Parsers.TRUE, Parsers.FALSE);
    }

    public final Parser<Boolean> fails() {
        return this.ifelse(Parsers.FALSE, Parsers.TRUE);
    }

    public final <R> Parser<R> ifelse(Parser<? extends R> consequence, Parser<? extends R> alternative) {
        return this.ifelse((? super T __) -> consequence, alternative);
    }

    public final <R> Parser<R> ifelse(final Function<? super T, ? extends Parser<? extends R>> consequence, final Parser<? extends R> alternative) {
        return new Parser<R>(){

            @Override
            boolean apply(ParseContext ctxt) {
                Object ret = ctxt.result;
                int step = ctxt.step;
                int at = ctxt.at;
                if (ctxt.withErrorSuppressed(Parser.this)) {
                    Parser parser = (Parser)consequence.apply(Parser.this.getReturn(ctxt));
                    return parser.apply(ctxt);
                }
                ctxt.set(step, at, ret);
                return alternative.apply(ctxt);
            }

            public String toString() {
                return "ifelse";
            }
        };
    }

    public Parser<T> label(final String name) {
        return new Parser<T>(){

            @Override
            public Parser<T> label(String overrideName) {
                return Parser.this.label(overrideName);
            }

            @Override
            boolean apply(ParseContext ctxt) {
                return ctxt.applyNewNode(Parser.this, name);
            }

            public String toString() {
                return name;
            }
        };
    }

    public final <R> Parser<R> cast() {
        return this;
    }

    public final Parser<T> between(Parser<?> before, Parser<?> after) {
        return before.next(this.followedBy(after));
    }

    @Deprecated
    public final Parser<T> reluctantBetween(Parser<?> before, Parser<?> after) {
        return new ReluctantBetweenParser(before, this, after);
    }

    public final Parser<List<T>> sepBy1(Parser<?> delim) {
        Parser afterFirst = delim.asDelimiter().next(this);
        return this.next((? super T firstValue) -> new RepeatAtLeastParser<Object>(afterFirst, 0, ListFactory.arrayListFactoryWithFirstElement(firstValue)));
    }

    public final Parser<List<T>> sepBy(Parser<?> delim) {
        return Parsers.or(this.sepBy1(delim), EmptyListParser.instance());
    }

    public final Parser<List<T>> endBy(Parser<?> delim) {
        return this.followedBy(delim).many();
    }

    public final Parser<List<T>> endBy1(Parser<?> delim) {
        return this.followedBy(delim).many1();
    }

    public final Parser<List<T>> sepEndBy1(Parser<?> delim) {
        return this.next((? super T first) -> new DelimitedParser<Object>(this, delim, ListFactory.arrayListFactoryWithFirstElement(first)));
    }

    public final Parser<List<T>> sepEndBy(Parser<?> delim) {
        return Parsers.or(this.sepEndBy1(delim), EmptyListParser.instance());
    }

    public final Parser<T> prefix(Parser<? extends Function<? super T, ? extends T>> op) {
        return Parsers.sequence(op.many(), this, Parser::applyPrefixOperators);
    }

    public final Parser<T> postfix(Parser<? extends Function<? super T, ? extends T>> op) {
        return Parsers.sequence(this, op.many(), Parser::applyPostfixOperators);
    }

    public final Parser<T> infixn(Parser<? extends BiFunction<? super T, ? super T, ? extends T>> op) {
        return this.next((? super T a) -> {
            Parser<Object> shift = Parsers.sequence(op, this, (m2, b) -> m2.apply(a, b));
            return shift.or(Parsers.constant(a));
        });
    }

    public final Parser<T> infixl(Parser<? extends BiFunction<? super T, ? super T, ? extends T>> operator) {
        BiFunction<BiFunction, Object, Function> rightToLeft = (op, r) -> l -> op.apply(l, r);
        return this.next((? super T first) -> Parsers.sequence(operator, this, rightToLeft).many().map(maps -> Parser.applyInfixOperators(first, maps)));
    }

    public final Parser<T> infixr(Parser<? extends BiFunction<? super T, ? super T, ? extends T>> op) {
        Parser<Rhs> rhs = Parsers.sequence(op, this, Rhs::new);
        return Parsers.sequence(this, rhs.many(), Parser::applyInfixrOperators);
    }

    public final Parser<Token> token() {
        return new Parser<Token>(){

            @Override
            boolean apply(ParseContext ctxt) {
                int begin = ctxt.getIndex();
                if (!Parser.this.apply(ctxt)) {
                    return false;
                }
                int len = ctxt.getIndex() - begin;
                Token token = new Token(begin, len, ctxt.result);
                ctxt.result = token;
                return true;
            }

            public String toString() {
                return Parser.this.toString();
            }
        };
    }

    public final Parser<String> source() {
        return new Parser<String>(){

            @Override
            boolean apply(ParseContext ctxt) {
                int begin = ctxt.getIndex();
                if (!Parser.this.apply(ctxt)) {
                    return false;
                }
                ctxt.result = ctxt.source.subSequence(begin, ctxt.getIndex()).toString();
                return true;
            }

            public String toString() {
                return "source";
            }
        };
    }

    public final Parser<WithSource<T>> withSource() {
        return new Parser<WithSource<T>>(){

            @Override
            boolean apply(ParseContext ctxt) {
                WithSource<Object> withSource;
                int begin = ctxt.getIndex();
                if (!Parser.this.apply(ctxt)) {
                    return false;
                }
                String source = ctxt.source.subSequence(begin, ctxt.getIndex()).toString();
                ctxt.result = withSource = new WithSource<Object>(ctxt.result, source);
                return true;
            }

            public String toString() {
                return Parser.this.toString();
            }
        };
    }

    public final Parser<T> from(Parser<? extends Collection<Token>> lexer) {
        return Parsers.nested(Parsers.tokens(lexer), this.followedBy(Parsers.EOF));
    }

    public final Parser<T> from(Parser<?> tokenizer, Parser<Void> delim) {
        return this.from(tokenizer.lexer(delim));
    }

    public Parser<List<Token>> lexer(Parser<?> delim) {
        return delim.optional(null).next(this.token().sepEndBy(delim));
    }

    final Parser<T> asDelimiter() {
        return new Parser<T>(){

            @Override
            boolean apply(ParseContext ctxt) {
                return ctxt.applyAsDelimiter(Parser.this);
            }

            public String toString() {
                return Parser.this.toString();
            }
        };
    }

    public final T parse(CharSequence source) {
        return this.parse(source, Mode.PRODUCTION);
    }

    public final T parse(Readable readable) throws IOException {
        return this.parse(Parser.read(readable));
    }

    public final T parse(CharSequence source, Mode mode) {
        return mode.run(this, source);
    }

    public final ParseTree parseTree(CharSequence source) {
        ScannerState state = new ScannerState(source);
        state.enableTrace("root");
        state.run(this.followedBy(Parsers.EOF));
        return state.buildParseTree();
    }

    @Deprecated
    public final T parse(CharSequence source, String moduleName) {
        return new ScannerState(moduleName, source, 0, new SourceLocator(source)).run(this.followedBy(Parsers.EOF));
    }

    @Deprecated
    public final T parse(Readable readable, String moduleName) throws IOException {
        return this.parse((CharSequence)Parser.read(readable), moduleName);
    }

    abstract boolean apply(ParseContext var1);

    @Private
    static StringBuilder read(Readable from) throws IOException {
        int r;
        StringBuilder builder = new StringBuilder();
        CharBuffer buf = CharBuffer.allocate(2048);
        while ((r = from.read(buf)) != -1) {
            buf.flip();
            builder.append(buf, 0, r);
        }
        return builder;
    }

    final T getReturn(ParseContext ctxt) {
        return (T)ctxt.result;
    }

    private static <T> T applyPrefixOperators(List<? extends Function<? super T, ? extends T>> ms, T a) {
        for (int i = ms.size() - 1; i >= 0; --i) {
            Function<T, T> m = ms.get(i);
            a = m.apply(a);
        }
        return a;
    }

    private static <T> T applyPostfixOperators(T a, Iterable<? extends Function<? super T, ? extends T>> ms) {
        for (Function<T, T> m : ms) {
            a = m.apply(a);
        }
        return a;
    }

    private static <T> T applyInfixOperators(T initialValue, List<? extends Function<? super T, ? extends T>> functions) {
        T result = initialValue;
        for (Function<T, T> function : functions) {
            result = function.apply(result);
        }
        return result;
    }

    private static <T> T applyInfixrOperators(T first, List<Rhs<T>> rhss) {
        if (rhss.isEmpty()) {
            return first;
        }
        int lastIndex = rhss.size() - 1;
        Object o2 = rhss.get((int)lastIndex).rhs;
        for (int i = lastIndex; i > 0; --i) {
            Object o1 = rhss.get((int)(i - 1)).rhs;
            o2 = rhss.get((int)i).op.apply(o1, o2);
        }
        return rhss.get((int)0).op.apply(first, o2);
    }

    private static final class Rhs<T> {
        final BiFunction<? super T, ? super T, ? extends T> op;
        final T rhs;

        Rhs(BiFunction<? super T, ? super T, ? extends T> op, T rhs) {
            this.op = op;
            this.rhs = rhs;
        }

        public String toString() {
            return this.op + " " + this.rhs;
        }
    }

    public static enum Mode {
        PRODUCTION{

            @Override
            <T> T run(Parser<T> parser, CharSequence source) {
                return new ScannerState(source).run(parser.followedBy(Parsers.EOF));
            }
        }
        ,
        DEBUG{

            @Override
            <T> T run(Parser<T> parser, CharSequence source) {
                ScannerState state = new ScannerState(source);
                state.enableTrace("root");
                return state.run(parser.followedBy(Parsers.EOF));
            }
        };


        abstract <T> T run(Parser<T> var1, CharSequence var2);
    }

    public static final class Reference<T>
    extends AtomicReference<Parser<T>> {
        private final Parser<T> lazy = new Parser<T>(){

            @Override
            boolean apply(ParseContext ctxt) {
                return this.deref().apply(ctxt);
            }

            private Parser<T> deref() {
                Parser p = (Parser)this.get();
                Checks.checkNotNullState(p, "Uninitialized lazy parser reference. Did you forget to call set() on the reference?");
                return p;
            }

            public String toString() {
                return "lazy";
            }
        };

        public Parser<T> lazy() {
            return this.lazy;
        }
    }
}

