/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Date;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.protobuf.omnicomm.OmnicommMessageOuterClass;
import org.traccar.session.DeviceSession;

public class OmnicommProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_IDENTIFICATION = 128;
    public static final int MSG_ARCHIVE_INQUIRY = 133;
    public static final int MSG_ARCHIVE_DATA = 134;
    public static final int MSG_REMOVE_ARCHIVE_INQUIRY = 135;

    public OmnicommProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private OmnicommMessageOuterClass.OmnicommMessage parseProto(ByteBuf buf, int length) throws InvalidProtocolBufferException {
        int offset;
        byte[] array;
        if (buf.hasArray()) {
            array = buf.array();
            offset = buf.arrayOffset() + buf.readerIndex();
        } else {
            array = ByteBufUtil.getBytes((ByteBuf)buf, (int)buf.readerIndex(), (int)length, (boolean)false);
            offset = 0;
        }
        buf.skipBytes(length);
        return (OmnicommMessageOuterClass.OmnicommMessage)OmnicommMessageOuterClass.OmnicommMessage.getDefaultInstance().getParserForType().parseFrom(array, offset, length);
    }

    private void sendResponse(Channel channel, int type, long index) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeByte(192);
            response.writeByte(type);
            response.writeShortLE(4);
            response.writeIntLE((int)index);
            response.writeShortLE(Checksum.crc16(Checksum.CRC16_CCITT_FALSE, response.nioBuffer(1, response.writerIndex() - 1)));
            channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.readUnsignedByte();
        short type = buf.readUnsignedByte();
        buf.readUnsignedShortLE();
        if (type == 128) {
            this.getDeviceSession(channel, remoteAddress, String.valueOf(buf.readUnsignedIntLE()));
            this.sendResponse(channel, 133, 0L);
        } else if (type == 134) {
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            long index = buf.readUnsignedIntLE();
            buf.readUnsignedIntLE();
            buf.readUnsignedByte();
            LinkedList<Position> positions = new LinkedList<Position>();
            while (buf.readableBytes() > 2) {
                GeneratedMessageV3 data;
                OmnicommMessageOuterClass.OmnicommMessage message = this.parseProto(buf, buf.readUnsignedShortLE());
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                if (message.hasGeneral()) {
                    data = message.getGeneral();
                    position.set("power", (double)data.getUboard() * 0.1);
                    position.set("batteryLevel", data.getBatLife());
                    position.set("ignition", BitUtil.check(data.getFLG(), 0));
                    position.set("rpm", data.getTImp());
                }
                if (message.hasNAV()) {
                    data = message.getNAV();
                    position.setValid(true);
                    position.setTime(new Date((long)(data.getGPSTime() + 1230768000) * 1000L));
                    position.setLatitude((double)data.getLAT() * 1.0E-7);
                    position.setLongitude((double)data.getLON() * 1.0E-7);
                    position.setSpeed(UnitsConverter.knotsFromKph((double)data.getGPSVel() * 0.1));
                    position.setCourse(data.getGPSDir());
                    position.setAltitude((double)data.getGPSAlt() * 0.1);
                    position.set("sat", data.getGPSNSat());
                }
                if (message.hasLLSDt()) {
                    data = message.getLLSDt();
                    position.set("fuel1Temp", data.getTLLS1());
                    position.set("fuel1", data.getCLLS1());
                    position.set("fuel1State", data.getFLLS1());
                }
                if (position.getFixTime() == null) continue;
                positions.add(position);
            }
            if (positions.isEmpty()) {
                this.sendResponse(channel, 135, index + 1L);
                return null;
            }
            return positions;
        }
        return null;
    }
}

