/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.text.ParseException;
import org.traccar.geofence.GeofenceCircle;
import org.traccar.geofence.GeofenceGeometry;
import org.traccar.geofence.GeofencePolygon;
import org.traccar.geofence.GeofencePolyline;
import org.traccar.model.ExtendedModel;
import org.traccar.model.Schedulable;
import org.traccar.storage.QueryIgnore;
import org.traccar.storage.StorageName;

@StorageName(value="tc_geofences")
public class Geofence
extends ExtendedModel
implements Schedulable {
    private long calendarId;
    private String name;
    private String description;
    private String area;
    private GeofenceGeometry geometry;

    @Override
    public long getCalendarId() {
        return this.calendarId;
    }

    @Override
    public void setCalendarId(long calendarId) {
        this.calendarId = calendarId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getArea() {
        return this.area;
    }

    public void setArea(String area) throws ParseException {
        if (area.startsWith("CIRCLE")) {
            this.geometry = new GeofenceCircle(area);
        } else if (area.startsWith("POLYGON")) {
            this.geometry = new GeofencePolygon(area);
        } else if (area.startsWith("LINESTRING")) {
            this.geometry = new GeofencePolyline(area);
        } else {
            throw new ParseException("Unknown geometry type", 0);
        }
        this.area = area;
    }

    @QueryIgnore
    @JsonIgnore
    public GeofenceGeometry getGeometry() {
        return this.geometry;
    }

    @QueryIgnore
    @JsonIgnore
    public void setGeometry(GeofenceGeometry geometry) {
        this.area = geometry.toWkt();
        this.geometry = geometry;
    }
}

