/*
 * Decompiled with CFR 0.152.
 */
package org.projectlibre.core.dictionary;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.projectlibre.core.dictionary.DictionaryCategory;
import org.projectlibre.core.dictionary.HasCategories;
import org.projectlibre.core.dictionary.HasStringId;

public class Dictionary
implements Iterable<HasStringId> {
    protected Map<DictionaryCategory, Map<String, HasStringId>> dictionary = new HashMap<DictionaryCategory, Map<String, HasStringId>>();
    protected Map<Class<?>, Set<String>> categories = new HashMap();

    public void add(HasStringId hasStringId) {
        Set<String> set;
        if (hasStringId instanceof HasCategories && (set = ((HasCategories)((Object)hasStringId)).getCategories()) != null && set.size() > 0) {
            for (String string : set) {
                this.put(new DictionaryCategory(hasStringId.getClass(), string), hasStringId);
            }
        }
        this.put(new DictionaryCategory(hasStringId.getClass()), hasStringId);
    }

    private HasStringId put(DictionaryCategory dictionaryCategory, HasStringId hasStringId) {
        Set<String> set = this.categories.get(dictionaryCategory.getClasse());
        if (set == null) {
            set = new HashSet<String>();
            this.categories.put(dictionaryCategory.getClasse(), set);
        }
        set.add(dictionaryCategory.getCategory());
        Map<String, HasStringId> map = this.dictionary.get(dictionaryCategory);
        if (map == null) {
            map = new HashMap<String, HasStringId>();
            this.dictionary.put(dictionaryCategory, map);
        }
        return map.put(hasStringId.getId(), hasStringId);
    }

    public HasStringId get(Class<?> clazz, String string) {
        return this.get(new DictionaryCategory(clazz), string);
    }

    public HasStringId get(DictionaryCategory dictionaryCategory, String string) {
        Map<String, HasStringId> map = this.dictionary.get(dictionaryCategory);
        if (map == null) {
            return null;
        }
        return map.get(string);
    }

    public Map<String, HasStringId> get(DictionaryCategory dictionaryCategory) {
        return this.dictionary.get(dictionaryCategory);
    }

    public Map<String, HasStringId> get(Class<?> clazz) {
        return this.dictionary.get(new DictionaryCategory(clazz));
    }

    public Set<String> getCategories(Class<?> clazz) {
        return this.categories.get(clazz);
    }

    public int size() {
        return this.dictionary.size();
    }

    public boolean isEmpty() {
        return this.dictionary.isEmpty();
    }

    public boolean containsKey(DictionaryCategory dictionaryCategory) {
        return this.dictionary.containsKey(dictionaryCategory);
    }

    public void clear() {
        this.categories.clear();
        this.dictionary.clear();
    }

    public Set<DictionaryCategory> keySet() {
        return this.dictionary.keySet();
    }

    public Set<Class<?>> getClasses() {
        return this.categories.keySet();
    }

    public Class<?>[] getClassesAsArray() {
        Set<Class<?>> set = this.getClasses();
        return set.toArray(new Class[set.size()]);
    }

    public Iterator<HasStringId> iterator(DictionaryCategory dictionaryCategory) {
        Map<String, HasStringId> map = this.dictionary.get(dictionaryCategory);
        if (map == null) {
            return new Iterator<HasStringId>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public HasStringId next() {
                    return null;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return map.values().iterator();
    }

    @Override
    public Iterator<HasStringId> iterator() {
        return new Iterator<HasStringId>(){
            private Iterator<Map<String, HasStringId>> iterator1;
            private Iterator<HasStringId> iterator2;
            {
                this.iterator1 = Dictionary.this.dictionary.values().iterator();
                this.iterator2 = null;
            }

            @Override
            public boolean hasNext() {
                return this.iterator1.hasNext() || this.iterator2 != null && this.iterator2.hasNext();
            }

            @Override
            public HasStringId next() {
                if (this.iterator2 == null || !this.iterator2.hasNext()) {
                    Map<String, HasStringId> map = this.iterator1.next();
                    if (map == null) {
                        throw new NoSuchElementException();
                    }
                    this.iterator2 = map.values().iterator();
                }
                return this.iterator2.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

