/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.fill;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.fill.JRFillCategorySeries;
import net.sf.jasperreports.charts.util.CategoryLabelGenerator;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;

public class JRFillCategoryDataset
extends JRFillChartDataset
implements JRCategoryDataset {
    protected JRFillCategorySeries[] categorySeries = null;
    private DefaultCategoryDataset dataset = null;
    private Map labelsMap = null;

    public JRFillCategoryDataset(JRCategoryDataset categoryDataset, JRFillObjectFactory factory) {
        super(categoryDataset, factory);
        JRCategorySeries[] srcCategorySeries = categoryDataset.getSeries();
        if (srcCategorySeries != null && srcCategorySeries.length > 0) {
            this.categorySeries = new JRFillCategorySeries[srcCategorySeries.length];
            for (int i = 0; i < this.categorySeries.length; ++i) {
                this.categorySeries[i] = (JRFillCategorySeries)factory.getCategorySeries(srcCategorySeries[i]);
            }
        }
    }

    public JRCategorySeries[] getSeries() {
        return this.categorySeries;
    }

    protected void customInitialize() {
        this.dataset = null;
        this.labelsMap = null;
    }

    protected void customEvaluate(JRCalculator calculator) throws JRExpressionEvalException {
        if (this.categorySeries != null && this.categorySeries.length > 0) {
            for (int i = 0; i < this.categorySeries.length; ++i) {
                this.categorySeries[i].evaluate(calculator);
            }
        }
    }

    protected void customIncrement() {
        if (this.categorySeries != null && this.categorySeries.length > 0) {
            if (this.dataset == null) {
                this.dataset = new DefaultCategoryDataset();
                this.labelsMap = new HashMap();
            }
            for (int i = 0; i < this.categorySeries.length; ++i) {
                JRFillCategorySeries crtCategorySeries = this.categorySeries[i];
                Comparable seriesName = crtCategorySeries.getSeries();
                seriesName.toString();
                this.dataset.addValue(crtCategorySeries.getValue(), crtCategorySeries.getSeries(), crtCategorySeries.getCategory());
                if (crtCategorySeries.getLabelExpression() == null) continue;
                HashMap<Comparable, String> seriesLabels = (HashMap<Comparable, String>)this.labelsMap.get(seriesName);
                if (seriesLabels == null) {
                    seriesLabels = new HashMap<Comparable, String>();
                    this.labelsMap.put(seriesName, seriesLabels);
                }
                seriesLabels.put(crtCategorySeries.getCategory(), crtCategorySeries.getLabel());
            }
        }
    }

    public Dataset getCustomDataset() {
        return this.dataset;
    }

    public byte getDatasetType() {
        return 2;
    }

    public CategoryLabelGenerator getLabelGenerator() {
        return new CategoryLabelGenerator(this.labelsMap);
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }
}

