/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.idm.ComponentTypeRepresentation;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicyFactory;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

@Extension(name="x-smallrye-profile-admin", value="")
public class ClientRegistrationPolicyResource {
    private final AdminPermissionEvaluator auth;
    private final RealmModel realm;
    private final AdminEventBuilder adminEvent;
    protected final KeycloakSession session;

    public ClientRegistrationPolicyResource(KeycloakSession session, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.session = session;
        this.auth = auth;
        this.realm = session.getContext().getRealm();
        this.adminEvent = adminEvent.resource(ResourceType.CLIENT_INITIAL_ACCESS_MODEL);
    }

    @Path(value="providers")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Client Registration Policy")
    @Operation(summary="Base path for retrieve providers with the configProperties properly filled")
    public Stream<ComponentTypeRepresentation> getProviders() {
        return this.session.getKeycloakSessionFactory().getProviderFactoriesStream(ClientRegistrationPolicy.class).map(factory -> {
            ClientRegistrationPolicyFactory clientRegFactory = (ClientRegistrationPolicyFactory)factory;
            List<ProviderConfigProperty> configProps = clientRegFactory.getConfigProperties(this.session);
            ComponentTypeRepresentation rep = new ComponentTypeRepresentation();
            rep.setId(clientRegFactory.getId());
            rep.setHelpText(clientRegFactory.getHelpText());
            rep.setProperties(ModelToRepresentation.toRepresentation(configProps));
            return rep;
        });
    }
}

