/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.driver.AbstractShardingConnection;
import oracle.jdbc.driver.AbstractShardingPreparedStatement;
import oracle.jdbc.driver.AbstractShardingStatement;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleCallableStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

@ProxyFor(value={OracleCallableStatement.class})
@ProxyResult(value=ProxyResultPolicy.MANUAL)
public abstract class AbstractShardingCallableStatement
extends AbstractShardingPreparedStatement {
    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    @GetDelegate
    protected abstract Statement getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Statement var1);

    @Override
    void initialize(AbstractShardingConnection connection, String sql, OracleResultSet.ResultSetType resultSetType) {
        super.initialize(connection, sql, resultSetType);
        this.statementType = 2;
    }

    public void setArray(String parameterName, Array x) throws SQLException {
        this.setArrayAtName(parameterName, x);
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.setBigDecimalAtName(parameterName, x);
    }

    public void setBlob(String parameterName, Blob x) throws SQLException {
        this.setBlobAtName(parameterName, x);
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.setBooleanAtName(parameterName, x);
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        this.setByteAtName(parameterName, x);
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.setBytesAtName(parameterName, x);
    }

    public void setClob(String parameterName, Clob x) throws SQLException {
        this.setClobAtName(parameterName, x);
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        this.setDateAtName(parameterName, x);
    }

    public void setDate(String parameterName, Date x, Calendar y) throws SQLException {
        this.setDateAtName(parameterName, x, y);
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        this.setDoubleAtName(parameterName, x);
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        this.setFloatAtName(parameterName, x);
    }

    public void setInt(String parameterName, int x) throws SQLException {
        this.setIntAtName(parameterName, x);
    }

    public void setLong(String parameterName, long x) throws SQLException {
        this.setLongAtName(parameterName, x);
    }

    public void setNClob(String parameterName, NClob x) throws SQLException {
        this.setNClobAtName(parameterName, x);
    }

    public void setNString(String parameterName, String x) throws SQLException {
        this.setNStringAtName(parameterName, x);
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        this.setObjectAtName(parameterName, x);
    }

    public void setObject(String parameterName, Object x, int y) throws SQLException {
        this.setObjectAtName(parameterName, x, y);
    }

    public void setRef(String parameterName, Ref x) throws SQLException {
        this.setRefAtName(parameterName, x);
    }

    public void setRowId(String parameterName, RowId x) throws SQLException {
        this.setRowIdAtName(parameterName, x);
    }

    public void setShort(String parameterName, short x) throws SQLException {
        this.setShortAtName(parameterName, x);
    }

    public void setSQLXML(String parameterName, SQLXML x) throws SQLException {
        this.setSQLXMLAtName(parameterName, x);
    }

    public void setString(String parameterName, String x) throws SQLException {
        this.setStringAtName(parameterName, x);
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        this.setTimeAtName(parameterName, x);
    }

    public void setTime(String parameterName, Time x, Calendar y) throws SQLException {
        this.setTimeAtName(parameterName, x, y);
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.setTimestampAtName(parameterName, x);
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar y) throws SQLException {
        this.setTimestampAtName(parameterName, x, y);
    }

    public void setURL(String parameterName, URL x) throws SQLException {
        this.setURLAtName(parameterName, x);
    }

    public void setARRAY(String parameterName, ARRAY x) throws SQLException {
        this.setARRAYAtName(parameterName, x);
    }

    public void setBFILE(String parameterName, BFILE x) throws SQLException {
        this.setBFILEAtName(parameterName, x);
    }

    public void setBfile(String parameterName, BFILE x) throws SQLException {
        this.setBfileAtName(parameterName, x);
    }

    public void setBinaryFloat(String parameterName, float x) throws SQLException {
        this.setBinaryFloatAtName(parameterName, x);
    }

    public void setBinaryFloat(String parameterName, BINARY_FLOAT x) throws SQLException {
        this.setBinaryFloatAtName(parameterName, x);
    }

    public void setBinaryDouble(String parameterName, double x) throws SQLException {
        this.setBinaryDoubleAtName(parameterName, x);
    }

    public void setBinaryDouble(String parameterName, BINARY_DOUBLE x) throws SQLException {
        this.setBinaryDoubleAtName(parameterName, x);
    }

    public void setBLOB(String parameterName, BLOB x) throws SQLException {
        this.setBLOBAtName(parameterName, x);
    }

    public void setCHAR(String parameterName, CHAR x) throws SQLException {
        this.setCHARAtName(parameterName, x);
    }

    public void setCLOB(String parameterName, CLOB x) throws SQLException {
        this.setCLOBAtName(parameterName, x);
    }

    public void setCursor(String parameterName, ResultSet x) throws SQLException {
        this.setCursorAtName(parameterName, x);
    }

    public void setDATE(String parameterName, DATE x) throws SQLException {
        this.setDATEAtName(parameterName, x);
    }

    public void setFixedCHAR(String parameterName, String x) throws SQLException {
        this.setFixedCHARAtName(parameterName, x);
    }

    public void setINTERVALDS(String parameterName, INTERVALDS x) throws SQLException {
        this.setINTERVALDSAtName(parameterName, x);
    }

    public void setINTERVALYM(String parameterName, INTERVALYM x) throws SQLException {
        this.setINTERVALYMAtName(parameterName, x);
    }

    public void setNUMBER(String parameterName, NUMBER x) throws SQLException {
        this.setNUMBERAtName(parameterName, x);
    }

    public void setOPAQUE(String parameterName, OPAQUE x) throws SQLException {
        this.setOPAQUEAtName(parameterName, x);
    }

    public void setOracleObject(String parameterName, Datum x) throws SQLException {
        this.setOracleObjectAtName(parameterName, x);
    }

    public void setORAData(String parameterName, ORAData x) throws SQLException {
        this.setORADataAtName(parameterName, x);
    }

    public void setRAW(String parameterName, RAW x) throws SQLException {
        this.setRAWAtName(parameterName, x);
    }

    public void setREF(String parameterName, REF x) throws SQLException {
        this.setREFAtName(parameterName, x);
    }

    public void setRefType(String parameterName, REF x) throws SQLException {
        this.setRefTypeAtName(parameterName, x);
    }

    public void setROWID(String parameterName, ROWID x) throws SQLException {
        this.setROWIDAtName(parameterName, x);
    }

    public void setSTRUCT(String parameterName, STRUCT x) throws SQLException {
        this.setSTRUCTAtName(parameterName, x);
    }

    public void setTIMESTAMPLTZ(String parameterName, TIMESTAMPLTZ x) throws SQLException {
        this.setTIMESTAMPLTZAtName(parameterName, x);
    }

    public void setTIMESTAMPTZ(String parameterName, TIMESTAMPTZ x) throws SQLException {
        this.setTIMESTAMPTZAtName(parameterName, x);
    }

    public void setTIMESTAMP(String parameterName, TIMESTAMP x) throws SQLException {
        this.setTIMESTAMPAtName(parameterName, x);
    }

    public void setCustomDatum(String parameterName, CustomDatum x) throws SQLException {
        this.setCustomDatumAtName(parameterName, x);
    }

    public void setBlob(String parameterName, InputStream x) throws SQLException {
        this.setBlobAtName(parameterName, x);
    }

    public void setBlob(String parameterName, InputStream x, long y) throws SQLException {
        this.setBlobAtName(parameterName, x, y);
    }

    public void setClob(String parameterName, Reader x) throws SQLException {
        this.setClobAtName(parameterName, x);
    }

    public void setClob(String parameterName, Reader x, long y) throws SQLException {
        this.setClobAtName(parameterName, x, y);
    }

    public void setNClob(String parameterName, Reader x) throws SQLException {
        this.setNClobAtName(parameterName, x);
    }

    public void setNClob(String parameterName, Reader x, long y) throws SQLException {
        this.setNClobAtName(parameterName, x, y);
    }

    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        this.setAsciiStreamAtName(parameterName, x);
    }

    public void setAsciiStream(String parameterName, InputStream x, int y) throws SQLException {
        this.setAsciiStreamAtName(parameterName, x, y);
    }

    public void setAsciiStream(String parameterName, InputStream x, long y) throws SQLException {
        this.setAsciiStreamAtName(parameterName, x, y);
    }

    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        this.setBinaryStreamAtName(parameterName, x);
    }

    public void setBinaryStream(String parameterName, InputStream x, int y) throws SQLException {
        this.setBinaryStreamAtName(parameterName, x, y);
    }

    public void setBinaryStream(String parameterName, InputStream x, long y) throws SQLException {
        this.setBinaryStreamAtName(parameterName, x, y);
    }

    public void setCharacterStream(String parameterName, Reader x) throws SQLException {
        this.setCharacterStreamAtName(parameterName, x);
    }

    public void setCharacterStream(String parameterName, Reader x, int y) throws SQLException {
        this.setCharacterStreamAtName(parameterName, x, y);
    }

    public void setCharacterStream(String parameterName, Reader x, long y) throws SQLException {
        this.setCharacterStreamAtName(parameterName, x, y);
    }

    public void setNCharacterStream(String parameterName, Reader x) throws SQLException {
        this.setNCharacterStreamAtName(parameterName, x);
    }

    public void setNCharacterStream(String parameterName, Reader x, long y) throws SQLException {
        this.setNCharacterStreamAtName(parameterName, x, y);
    }

    public void setUnicodeStream(String parameterName, InputStream x, int y) throws SQLException {
        this.setUnicodeStreamAtName(parameterName, x, y);
    }

    public void setNull(String parameterName, int x, String y) throws SQLException {
        this.setNullAtName(parameterName, x, y);
    }

    public void setNull(String parameterName, int x) throws SQLException {
        this.setNullAtName(parameterName, x);
    }

    public void setStructDescriptor(String parameterName, StructDescriptor x) throws SQLException {
        this.setStructDescriptorAtName(parameterName, x);
    }

    public void setStringForClob(String parameterName, String x) throws SQLException {
        this.setStringForClobAtName(parameterName, x);
    }

    public void setBytesForBlob(String parameterName, byte[] x) throws SQLException {
        this.setBytesForBlobAtName(parameterName, x);
    }

    public void registerOutParameter(int paramIndex, int x, int y, int z) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerOutParameter";
            Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
            Object[] args = new Object[]{paramIndex, x, y, z};
            AbstractShardingStatement.CallHistoryEntry entry = new AbstractShardingStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void registerOutParameterBytes(int paramIndex, int x, int y, int z) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerOutParameterBytes";
            Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
            Object[] args = new Object[]{paramIndex, x, y, z};
            AbstractShardingStatement.CallHistoryEntry entry = new AbstractShardingStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void registerOutParameterChars(int paramIndex, int x, int y, int z) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerOutParameterChars";
            Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
            Object[] args = new Object[]{paramIndex, x, y, z};
            AbstractShardingStatement.CallHistoryEntry entry = new AbstractShardingStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void registerOutParameter(int paramIndex, int x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerOutParameter";
            Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE};
            Object[] args = new Object[]{paramIndex, x};
            AbstractShardingStatement.CallHistoryEntry entry = new AbstractShardingStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void registerOutParameter(int paramIndex, int x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerOutParameter";
            Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE};
            Object[] args = new Object[]{paramIndex, x, y};
            AbstractShardingStatement.CallHistoryEntry entry = new AbstractShardingStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void registerOutParameter(int paramIndex, int x, String y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerOutParameter";
            Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE, String.class};
            Object[] args = new Object[]{paramIndex, x, y};
            AbstractShardingStatement.CallHistoryEntry entry = new AbstractShardingStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void registerIndexTableOutParameter(int paramIndex, int x, int y, int z) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerIndexTableOutParameter";
            Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
            Object[] args = new Object[]{paramIndex, x, y, z};
            AbstractShardingStatement.CallHistoryEntry entry = new AbstractShardingStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void registerOutParameter(String parameterName, int x, int y, int z) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerOutParameter";
            Class[] argsType = new Class[]{String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE};
            Object[] args = new Object[]{parameterName, x, y, z};
            AbstractShardingStatement.CallHistoryEntry entry = new AbstractShardingStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void registerOutParameterAtName(String parameterName, int x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerOutParameterAtName";
            Class[] argsType = new Class[]{String.class, Integer.TYPE};
            Object[] args = new Object[]{parameterName, x};
            AbstractShardingStatement.CallHistoryEntry entry = new AbstractShardingStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void registerOutParameterAtName(String parameterName, int x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerOutParameterAtName";
            Class[] argsType = new Class[]{String.class, Integer.TYPE, Integer.TYPE};
            Object[] args = new Object[]{parameterName, x, y};
            AbstractShardingStatement.CallHistoryEntry entry = new AbstractShardingStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void registerOutParameterAtName(String parameterName, int x, String y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerOutParameterAtName";
            Class[] argsType = new Class[]{String.class, Integer.TYPE, String.class};
            Object[] args = new Object[]{parameterName, x, y};
            AbstractShardingStatement.CallHistoryEntry entry = new AbstractShardingStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void registerOutParameter(String parameterName, int x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerOutParameter";
            Class[] argsType = new Class[]{String.class, Integer.TYPE};
            Object[] args = new Object[]{parameterName, x};
            AbstractShardingStatement.CallHistoryEntry entry = new AbstractShardingStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void registerOutParameter(String parameterName, int x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerOutParameter";
            Class[] argsType = new Class[]{String.class, Integer.TYPE, Integer.TYPE};
            Object[] args = new Object[]{parameterName, x, y};
            AbstractShardingStatement.CallHistoryEntry entry = new AbstractShardingStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void registerOutParameter(String parameterName, int x, String y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerOutParameter";
            Class[] argsType = new Class[]{String.class, Integer.TYPE, String.class};
            Object[] args = new Object[]{parameterName, x, y};
            AbstractShardingStatement.CallHistoryEntry entry = new AbstractShardingStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public ARRAY getARRAY(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                ARRAY aRRAY = databaseStatement.getARRAY(paramIndex);
                return aRRAY;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public InputStream getAsciiStream(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                InputStream inputStream = databaseStatement.getAsciiStream(paramIndex);
                return inputStream;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public BFILE getBFILE(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                BFILE bFILE = databaseStatement.getBFILE(paramIndex);
                return bFILE;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public BFILE getBfile(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                BFILE bFILE = databaseStatement.getBfile(paramIndex);
                return bFILE;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public InputStream getBinaryStream(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                InputStream inputStream = databaseStatement.getBinaryStream(paramIndex);
                return inputStream;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public BLOB getBLOB(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                BLOB bLOB = databaseStatement.getBLOB(paramIndex);
                return bLOB;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public CHAR getCHAR(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                CHAR cHAR = databaseStatement.getCHAR(paramIndex);
                return cHAR;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Reader getCharacterStream(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Reader reader = databaseStatement.getCharacterStream(paramIndex);
                return reader;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public CLOB getCLOB(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                CLOB cLOB = databaseStatement.getCLOB(paramIndex);
                return cLOB;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Object getCustomDatum(int paramIndex, CustomDatumFactory y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Object object = databaseStatement.getCustomDatum(paramIndex, y);
                return object;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Object getORAData(int paramIndex, ORADataFactory y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Object object = databaseStatement.getORAData(paramIndex, y);
                return object;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Object getObject(int paramIndex, OracleDataFactory y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Object object = databaseStatement.getObject(paramIndex, y);
                return object;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Object getAnyDataEmbeddedObject(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Object object = databaseStatement.getAnyDataEmbeddedObject(paramIndex);
                return object;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public DATE getDATE(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                DATE dATE = databaseStatement.getDATE(paramIndex);
                return dATE;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public NUMBER getNUMBER(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                NUMBER nUMBER = databaseStatement.getNUMBER(paramIndex);
                return nUMBER;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public OPAQUE getOPAQUE(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                OPAQUE oPAQUE = databaseStatement.getOPAQUE(paramIndex);
                return oPAQUE;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Datum getOracleObject(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Datum datum = databaseStatement.getOracleObject(paramIndex);
                return datum;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public RAW getRAW(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                RAW rAW = databaseStatement.getRAW(paramIndex);
                return rAW;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public REF getREF(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                REF rEF = databaseStatement.getREF(paramIndex);
                return rEF;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public ROWID getROWID(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                ROWID rOWID = databaseStatement.getROWID(paramIndex);
                return rOWID;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public STRUCT getSTRUCT(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                STRUCT sTRUCT = databaseStatement.getSTRUCT(paramIndex);
                return sTRUCT;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public INTERVALYM getINTERVALYM(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                INTERVALYM iNTERVALYM = databaseStatement.getINTERVALYM(paramIndex);
                return iNTERVALYM;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public INTERVALDS getINTERVALDS(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                INTERVALDS iNTERVALDS = databaseStatement.getINTERVALDS(paramIndex);
                return iNTERVALDS;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public TIMESTAMP getTIMESTAMP(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                TIMESTAMP tIMESTAMP = databaseStatement.getTIMESTAMP(paramIndex);
                return tIMESTAMP;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public TIMESTAMPTZ getTIMESTAMPTZ(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                TIMESTAMPTZ tIMESTAMPTZ = databaseStatement.getTIMESTAMPTZ(paramIndex);
                return tIMESTAMPTZ;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public TIMESTAMPLTZ getTIMESTAMPLTZ(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                TIMESTAMPLTZ tIMESTAMPLTZ = databaseStatement.getTIMESTAMPLTZ(paramIndex);
                return tIMESTAMPLTZ;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public InputStream getUnicodeStream(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                InputStream inputStream = databaseStatement.getUnicodeStream(paramIndex);
                return inputStream;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Object getPlsqlIndexTable(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Object object = databaseStatement.getPlsqlIndexTable(paramIndex);
                return object;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Object getPlsqlIndexTable(int paramIndex, Class<?> y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Object object = databaseStatement.getPlsqlIndexTable(paramIndex, y);
                return object;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Datum[] getOraclePlsqlIndexTable(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Datum[] datumArray = databaseStatement.getOraclePlsqlIndexTable(paramIndex);
                return datumArray;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Array getArray(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Array array = databaseStatement.getArray(paramIndex);
                return array;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public BigDecimal getBigDecimal(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                BigDecimal bigDecimal = databaseStatement.getBigDecimal(paramIndex);
                return bigDecimal;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public BigDecimal getBigDecimal(int paramIndex, int y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                BigDecimal bigDecimal = databaseStatement.getBigDecimal(paramIndex, y);
                return bigDecimal;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Blob getBlob(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Blob blob = databaseStatement.getBlob(paramIndex);
                return blob;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public boolean getBoolean(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                boolean bl = databaseStatement.getBoolean(paramIndex);
                return bl;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public byte getByte(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                byte by = databaseStatement.getByte(paramIndex);
                return by;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public byte[] getBytes(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                byte[] byArray = databaseStatement.getBytes(paramIndex);
                return byArray;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Clob getClob(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Clob clob = databaseStatement.getClob(paramIndex);
                return clob;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Date getDate(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Date date = databaseStatement.getDate(paramIndex);
                return date;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Date getDate(int paramIndex, Calendar y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Date date = databaseStatement.getDate(paramIndex, y);
                return date;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public double getDouble(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                double d = databaseStatement.getDouble(paramIndex);
                return d;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public float getFloat(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                float f = databaseStatement.getFloat(paramIndex);
                return f;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public int getInt(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                int n = databaseStatement.getInt(paramIndex);
                return n;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public long getLong(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                long l = databaseStatement.getLong(paramIndex);
                return l;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Reader getNCharacterStream(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Reader reader = databaseStatement.getNCharacterStream(paramIndex);
                return reader;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public NClob getNClob(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                NClob nClob = databaseStatement.getNClob(paramIndex);
                return nClob;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public String getNString(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                String string = databaseStatement.getNString(paramIndex);
                return string;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Object getObject(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Object object = databaseStatement.getObject(paramIndex);
                return object;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Object getObject(int paramIndex, Map<String, Class<?>> y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Object object = databaseStatement.getObject(paramIndex, y);
                return object;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Ref getRef(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Ref ref = databaseStatement.getRef(paramIndex);
                return ref;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public RowId getRowId(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                RowId rowId = databaseStatement.getRowId(paramIndex);
                return rowId;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public SQLXML getSQLXML(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                SQLXML sQLXML = databaseStatement.getSQLXML(paramIndex);
                return sQLXML;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public short getShort(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                short s = databaseStatement.getShort(paramIndex);
                return s;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public String getString(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                String string = databaseStatement.getString(paramIndex);
                return string;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Time getTime(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Time time = databaseStatement.getTime(paramIndex);
                return time;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Time getTime(int paramIndex, Calendar y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Time time = databaseStatement.getTime(paramIndex, y);
                return time;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Timestamp getTimestamp(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Timestamp timestamp = databaseStatement.getTimestamp(paramIndex);
                return timestamp;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Timestamp getTimestamp(int paramIndex, Calendar y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Timestamp timestamp = databaseStatement.getTimestamp(paramIndex, y);
                return timestamp;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public URL getURL(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                URL uRL = databaseStatement.getURL(paramIndex);
                return uRL;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public InputStream getAsciiStream(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                InputStream inputStream = databaseStatement.getAsciiStream(parameterName);
                return inputStream;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public InputStream getBinaryStream(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                InputStream inputStream = databaseStatement.getBinaryStream(parameterName);
                return inputStream;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Reader getCharacterStream(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Reader reader = databaseStatement.getCharacterStream(parameterName);
                return reader;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public InputStream getUnicodeStream(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                InputStream inputStream = databaseStatement.getUnicodeStream(parameterName);
                return inputStream;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Array getArray(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Array array = databaseStatement.getArray(parameterName);
                return array;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                BigDecimal bigDecimal = databaseStatement.getBigDecimal(parameterName);
                return bigDecimal;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public BigDecimal getBigDecimal(String parameterName, int y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                BigDecimal bigDecimal = databaseStatement.getBigDecimal(parameterName, y);
                return bigDecimal;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Blob getBlob(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Blob blob = databaseStatement.getBlob(parameterName);
                return blob;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                boolean bl = databaseStatement.getBoolean(parameterName);
                return bl;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public byte getByte(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                byte by = databaseStatement.getByte(parameterName);
                return by;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                byte[] byArray = databaseStatement.getBytes(parameterName);
                return byArray;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Clob getClob(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Clob clob = databaseStatement.getClob(parameterName);
                return clob;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Date getDate(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Date date = databaseStatement.getDate(parameterName);
                return date;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Date getDate(String parameterName, Calendar y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Date date = databaseStatement.getDate(parameterName, y);
                return date;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public double getDouble(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                double d = databaseStatement.getDouble(parameterName);
                return d;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public float getFloat(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                float f = databaseStatement.getFloat(parameterName);
                return f;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public int getInt(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                int n = databaseStatement.getInt(parameterName);
                return n;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public long getLong(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                long l = databaseStatement.getLong(parameterName);
                return l;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Reader getNCharacterStream(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Reader reader = databaseStatement.getNCharacterStream(parameterName);
                return reader;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public NClob getNClob(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                NClob nClob = databaseStatement.getNClob(parameterName);
                return nClob;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public String getNString(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                String string = databaseStatement.getNString(parameterName);
                return string;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Object getObject(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Object object = databaseStatement.getObject(parameterName);
                return object;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Object getObject(String parameterName, Map<String, Class<?>> y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Object object = databaseStatement.getObject(parameterName, y);
                return object;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Ref getRef(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Ref ref = databaseStatement.getRef(parameterName);
                return ref;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public RowId getRowId(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                RowId rowId = databaseStatement.getRowId(parameterName);
                return rowId;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public SQLXML getSQLXML(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                SQLXML sQLXML = databaseStatement.getSQLXML(parameterName);
                return sQLXML;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public short getShort(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                short s = databaseStatement.getShort(parameterName);
                return s;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public String getString(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                String string = databaseStatement.getString(parameterName);
                return string;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Time getTime(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Time time = databaseStatement.getTime(parameterName);
                return time;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Time getTime(String parameterName, Calendar y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Time time = databaseStatement.getTime(parameterName, y);
                return time;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Timestamp timestamp = databaseStatement.getTimestamp(parameterName);
                return timestamp;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public Timestamp getTimestamp(String parameterName, Calendar y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                Timestamp timestamp = databaseStatement.getTimestamp(parameterName, y);
                return timestamp;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public URL getURL(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                URL uRL = databaseStatement.getURL(parameterName);
                return uRL;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public byte[] privateGetBytes(int parameterIndex) throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                byte[] byArray = databaseStatement.privateGetBytes(parameterIndex);
                return byArray;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public boolean wasNull() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                boolean bl = databaseStatement.wasNull();
                return bl;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.setObjectAtName(parameterName, x, targetSqlType, scale);
    }

    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                T t = databaseStatement.getObject(parameterIndex, type);
                return t;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
            if (databaseStatement != null) {
                T t = databaseStatement.getObject(parameterName, type);
                return t;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public ResultSet getCursor(int parameterIndex) throws SQLException {
        ResultSet result;
        block8: {
            result = null;
            try (Monitor.CloseableLock lock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
                OracleCallableStatement databaseStatement = (OracleCallableStatement)this.getDelegate();
                if (databaseStatement != null) {
                    result = databaseStatement.getCursor(parameterIndex);
                    if (result != null) {
                        result = this.createResultSetProxy(result);
                    }
                    break block8;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
        }
        return result;
    }

    @Override
    @Pre
    @Methods(signatures={@Signature(name="executeQuery", args={}), @Signature(name="execute", args={}), @Signature(name="executeUpdate", args={})})
    protected void prePstmtExecuteQuery(Method m, Object receiver, Object ... args) {
        super.prePstmtExecuteQuery(m, receiver, args);
    }

    @Override
    @Post
    @Methods(signatures={@Signature(name="executeQuery", args={})})
    protected ResultSet postPstmtExecuteQuery(Method m, ResultSet result) {
        return super.postPstmtExecuteQuery(m, result);
    }

    @Override
    @Post
    @Methods(signatures={@Signature(name="execute", args={}), @Signature(name="executeUpdate", args={})})
    protected Object postPstmtExecuteUpdate(Method m, Object result) {
        return super.postPstmtExecuteUpdate(m, result);
    }

    @OnError(value=SQLException.class)
    protected Object onErrorCstmt(Method m, SQLException e) throws SQLException {
        return super.onErrorPstmt(m, e);
    }

    @Override
    @Pre
    @Methods(signatures={@Signature(name="executeQuery", args={String.class}), @Signature(name="execute", args={String.class}), @Signature(name="execute", args={String.class, int.class}), @Signature(name="execute", args={String.class, int[].class}), @Signature(name="execute", args={String.class, String[].class}), @Signature(name="executeUpdate", args={String.class}), @Signature(name="executeUpdate", args={String.class, int.class}), @Signature(name="executeUpdate", args={String.class, int[].class}), @Signature(name="executeUpdate", args={String.class, String[].class})})
    protected void preStmtExecuteQuery(Method m, Object receiver, Object ... args) {
        super.preStmtExecuteQuery(m, receiver, args);
    }

    @Override
    @Post
    @Methods(signatures={@Signature(name="executeQuery", args={String.class})})
    protected ResultSet postStmtExecuteQuery(Method m, ResultSet result) {
        return super.postStmtExecuteQuery(m, result);
    }

    @Override
    @Post
    @Methods(signatures={@Signature(name="execute", args={String.class}), @Signature(name="execute", args={String.class, int.class}), @Signature(name="execute", args={String.class, int[].class}), @Signature(name="execute", args={String.class, String[].class}), @Signature(name="executeUpdate", args={String.class}), @Signature(name="executeUpdate", args={String.class, int.class}), @Signature(name="executeUpdate", args={String.class, int[].class}), @Signature(name="executeUpdate", args={String.class, String[].class})})
    protected Object postStmtExecuteUpdate(Method m, Object result) {
        return super.postStmtExecuteUpdate(m, result);
    }

    @Override
    @Pre
    @Methods(signatures={@Signature(name="creationState", args={}), @Signature(name="setACProxy", args={Object.class}), @Signature(name="getACProxy", args={}), @Signature(name="setShardingKeyRpnTokens", args={byte[].class}), @Signature(name="getShardingKeyRpnTokens", args={}), @Signature(name="setCursorName", args={String.class}), @Signature(name="getserverCursor", args={})})
    protected void preUnsupportedStatementMethods(Method m, Object receiver, Object ... args) {
        super.preUnsupportedStatementMethods(m, receiver, args);
    }

    @Override
    protected OracleStatement createDatabaseStatement(OracleConnection databaseConnection, String sql) throws SQLException {
        return (OracleStatement)((Object)databaseConnection.prepareCall(sql, this.resultSetType.getType(), this.resultSetType.getConcur()));
    }
}

