/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.services.health;

import io.agroal.api.AgroalDataSource;
import io.quarkus.agroal.runtime.health.DataSourceHealthCheck;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
public class KeycloakReadyHealthCheck
extends DataSourceHealthCheck {
    static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss,SSS").withZone(ZoneId.systemDefault());
    @Inject
    AgroalDataSource agroalDataSource;
    AtomicReference<Instant> failingSince = new AtomicReference();

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"Keycloak database connections health check").up();
        long activeCount = this.agroalDataSource.getMetrics().activeCount();
        long invalidCount = this.agroalDataSource.getMetrics().invalidCount();
        if (activeCount < 1L || invalidCount > 0L) {
            HealthCheckResponse activeCheckResult = super.call();
            if (activeCheckResult.getStatus() == HealthCheckResponse.Status.DOWN) {
                builder.down();
                Instant failingTime = this.failingSince.updateAndGet(this::createInstanceIfNeeded);
                builder.withData("Failing since", DATE_FORMATTER.format(failingTime));
            }
        } else {
            this.failingSince.set(null);
        }
        return builder.build();
    }

    Instant createInstanceIfNeeded(Instant instant) {
        if (instant == null) {
            return Instant.now();
        }
        return instant;
    }
}

