///////////////////////////////////////////////////////////////////////////////
// $Id: UIApplication.hxx,v 1.1 1995/01/08 06:52:42 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// UIApplication.hxx - User Interface application class
//
//
// Bradford W. Mott
// Copyright (C) 1994
// December 12,1994
//
///////////////////////////////////////////////////////////////////////////////
// $Log: UIApplication.hxx,v $
// Revision 1.1  1995/01/08  06:52:42  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#ifndef UIAPPLICATION_HXX
#define UIAPPLICATION_HXX

#include <X11/Xlib.h>
#include "LinkedList.hxx"
#include "BasicWidget.hxx"
#include "TopLevel.hxx"
#include "Sound.hxx"

class UIApplication {
  private:
    // Display associated with the application
    Display* myDisplay;

    // Root window of the display associated with the application
    Window myRootWindow;

    // Screen associated with the application
    int myScreen;

    // Sound system for the application
    Sound* mySoundSystem;

    // Default font for application
    XFontStruct* myDefaultFont;

    // Linked list of toplevel widgets
    LinkedList<TopLevel> listOfTopLevelWidgets;

    // Flag to see if the application should stop
    int done;

  public:
    // Constructor
    UIApplication(int* argc, char** argv, char* name, Sound* sound);

    // Destructor
    ~UIApplication();

    // Dispatch the event to the correct widget
    void dispatchEvent(XEvent* event);

    // Add widget to list of toplevel widgets in the application
    void addTopLevel(TopLevel* widget);

    // Remove widget from list of toplevel widgets in the application
    void removeTopLevel(TopLevel* widget);


    // Event loop for the application
    void eventLoop();

    // Answer the sound system associated with myself
    Sound* soundSystem() const { return mySoundSystem; }

    // Answer the display associated with myself
    Display* display() const { return myDisplay; }

    // Answer the root window associated with myself
    Window rootWindow() const { return myRootWindow; }

    // Answer the screen associated with myself
    int screen() const { return myScreen; }

    // Answer the colormap associated with myself
    Colormap colormap() const { return DefaultColormap(myDisplay, myScreen); }

    // Answer the default GC associated with myself
    GC gc() const { return DefaultGC(myDisplay, myScreen); }

    // Answer the default visual associated with myself
    Visual* visual() const { return DefaultVisual(myDisplay, myScreen); }

    // Answer the black pixel associated with myself
    unsigned long blackPixel() const { return BlackPixel(myDisplay, myScreen); }

    // Answer the white pixel associated with myself
    unsigned long whitePixel() const { return WhitePixel(myDisplay, myScreen); }

    // Answer the default font
    XFontStruct* font() const { return myDefaultFont; }
    
    // Terminate the application
    void terminate() { done = 1; }
};

extern UIApplication* application;
#endif

