///////////////////////////////////////////////////////////////////////////////
// $Id: UIApplication.cxx,v 1.1 1995/01/08 06:52:35 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// UIApplication.cxx - User Interface application class
//
//
// Bradford W. Mott
// Copyright (C) 1994
// December 12,1994
//
///////////////////////////////////////////////////////////////////////////////
// $Log: UIApplication.cxx,v $
// Revision 1.1  1995/01/08  06:52:35  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include "UIApplication.hxx"

///////////////////////////////////////////////////////////////////////////////
// Global UIApplication object
///////////////////////////////////////////////////////////////////////////////
UIApplication* application;


///////////////////////////////////////////////////////////////////////////////
// Default fonts to try and load
///////////////////////////////////////////////////////////////////////////////
static char* defaultFontList[] = {
  "-*-helvetica-medium-r-normal-*-14-*",
  "-*-lucida-medium-r-*-*-14-*",
  "6x13",
  "fixed",
  (char*)0
};


///////////////////////////////////////////////////////////////////////////////
// Constructor
///////////////////////////////////////////////////////////////////////////////
UIApplication::UIApplication(int* argc, char** argv, char* name, Sound* sound)
    : mySoundSystem(sound)
{
  myDisplay = XOpenDisplay(NULL);

  if(!myDisplay)
  {
    fprintf(stderr, "Can't open display.\n");
    exit(1);
  }

  myScreen = DefaultScreen(myDisplay);
  myRootWindow = RootWindow(myDisplay, myScreen);  

  done = 0; 

  // Load a default font for the application
  myDefaultFont = NULL;
  for(int t = 0; defaultFontList[t] != NULL; ++t)
  {
    myDefaultFont = XLoadQueryFont(myDisplay, defaultFontList[t]);
    if(myDefaultFont != NULL)
      break; 
  }

  // Make sure a font was loaded
  if(myDefaultFont == NULL)
  {
    fprintf(stderr, "Couldn't load a usable font!\n");
    exit(1);
  }
}

///////////////////////////////////////////////////////////////////////////////
// Destructor
///////////////////////////////////////////////////////////////////////////////
UIApplication::~UIApplication()
{
  // Destroy any remaining toplevel widgets
  for(TopLevel* top = listOfTopLevelWidgets.first();
      top != (TopLevel*)0; top = listOfTopLevelWidgets.next())
  {
    delete top;
  }

  // If the display connection is open then close it
  if(myDisplay)
  {
    XCloseDisplay(myDisplay);
  }

  // Tell the X Server that I'm finished with my font
  if(myDefaultFont != NULL)
  {
    XUnloadFont(myDisplay, myDefaultFont->fid);
  }
}

///////////////////////////////////////////////////////////////////////////////
// Add widget to list of toplevel widgets in the application
///////////////////////////////////////////////////////////////////////////////
void UIApplication::addTopLevel(TopLevel* widget)
{
  listOfTopLevelWidgets.append(widget);
}

///////////////////////////////////////////////////////////////////////////////
// Remove widget from list of toplevel widgets in the application
///////////////////////////////////////////////////////////////////////////////
void UIApplication::removeTopLevel(TopLevel* widget)
{
  listOfTopLevelWidgets.remove(widget);
}

///////////////////////////////////////////////////////////////////////////////
// Dispatch the event to the correct widget
///////////////////////////////////////////////////////////////////////////////
void UIApplication::dispatchEvent(XEvent* event)
{
  BasicWidget* widget;

  // Dispatch the event to the correct widget
  for(BasicWidget* t = listOfTopLevelWidgets.first();
      t != (BasicWidget*) 0; t = listOfTopLevelWidgets.next())
  {
    widget = t->findWidget(event->xany.window);
    if(widget != NULL)
      break;
  } 

  // Send the event to the widget
  if(widget != NULL)
    widget->handleEvent(event);
}

///////////////////////////////////////////////////////////////////////////////
// Event loop for the application
///////////////////////////////////////////////////////////////////////////////
void UIApplication::eventLoop()
{
  while((!done) && (listOfTopLevelWidgets.size() != 0) )
  {
    XEvent event;

    XNextEvent(myDisplay, &event);

    dispatchEvent(&event);
  }
}

