///////////////////////////////////////////////////////////////////////////////
// $Id: Sample.cxx,v 1.1 1995/01/12 02:11:35 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// Sample.hxx - Sample class
//
//
// Bradford W. Mott
// Copyright (C) 1995
// January 4,1995
//
///////////////////////////////////////////////////////////////////////////////
// $Log: Sample.cxx,v $
// Revision 1.1  1995/01/12  02:11:35  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#include "Sample.hxx"

// Raw sample header
typedef struct {
  unsigned char lengthHB;
  unsigned char lengthMB;
  unsigned char lengthLB;
  unsigned char hertzMSB;
  unsigned char hertzLSB;
  unsigned char lengthOfName;
} RawSample;

///////////////////////////////////////////////////////////////////////////////
// Constructor
///////////////////////////////////////////////////////////////////////////////
Sample::Sample(unsigned char* sampleData) 
{
  RawSample rawSample;

  // get the sample's header
  memcpy(&rawSample, sampleData, sizeof(rawSample));
  sampleData += sizeof(rawSample);

  // Get the length of the sample
  myLength = (((int)rawSample.lengthHB) << 16) +
      (((int)rawSample.lengthMB) << 8) + (int)rawSample.lengthLB;

  // Allocate space for the sample data
  myData = new unsigned char[myLength]; 

  memcpy(myData, sampleData, myLength);
  sampleData += myLength;

  // Get my name
  myName = new char[rawSample.lengthOfName + 1];
  memcpy(myName, sampleData, rawSample.lengthOfName);
  sampleData += rawSample.lengthOfName;
  myName[rawSample.lengthOfName] = '\0';
}

///////////////////////////////////////////////////////////////////////////////
// Destructor
///////////////////////////////////////////////////////////////////////////////
Sample::~Sample()
{
  // Free memory that holds my name
  delete[] myName;

  // Free image data
  delete[] myData;
}

