///////////////////////////////////////////////////////////////////////////////
// $Id: Help.cxx,v 1.1 1995/01/08 06:44:27 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// Help.cxx - Help on oonsoo class
//
//
// Bradford W. Mott
// Copyright (C) 1994
// December 14,1994
//
///////////////////////////////////////////////////////////////////////////////
// $Log: Help.cxx,v $
// Revision 1.1  1995/01/08  06:44:27  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#include "UIApplication.hxx"
#include "Frame.hxx"
#include "PushButton.hxx"
#include "DrawingArea.hxx"
#include "Text.hxx"
#include "Sprite.hxx"

#include "Card.hxx"
#include "MainDeck.hxx"
#include "PlainDeck.hxx"

#include "HelpOkOrCloseCommand.hxx"

#include "LinkedList.hxx"

#include "Help.hxx"


///////////////////////////////////////////////////////////////////////////////
// Constructor 
///////////////////////////////////////////////////////////////////////////////
Help::Help(SpriteCollection* spriteCollection)
    : mySpriteCollection(spriteCollection)
{
  // Find the Oonsoo sprite
  Sprite* oonsoo = mySpriteCollection->getByName("Oonsoo");

  // Determine width and height of the help window
  int height = 10 + 85 + 10 + 412 + 10 + 30 + 10;
  int width = 914;

  // Build the about oonsoo window
  myToplevel = new TopLevel("Help", 200, 200, width, height,
      new HelpOkOrCloseCommand(this));
  myToplevel->background("Gray65");

    // Put a frame in the window to make it look neat!
    Frame* frame = new Frame(myToplevel, "frame", 0, 0,
        width, height, Raised);
    frame->background("Gray65");

      // Build drawing area for Oonsoo title
      DrawingArea* drawingArea = new DrawingArea(frame, "oonsoo",
          10, 10 + (85 - oonsoo->height()) / 2, 
          oonsoo->width(), oonsoo->height());
      drawingArea->background(oonsoo);

      // Build Text widget for helpful information
      Text* text = new Text(frame, "information",
          10 + oonsoo->width() + 10,  10, 
          width - (10 + oonsoo->width() + 10 + 10), 85,
          "Oonsoo is a solitaire card game.  The "
          "goal of the game is to arrange\n"
          "the twelve suits of cards, in order, "
          "onto the twelve playing decks.\n"
          "When the game starts, one card face "
          "down and one card face up is dealt\n"
          "to each of the playing decks.  Twelve "
          "more cards can be dealt by\n"
          "clicking on the dealing deck.  The "
          "twelve suits are shown below in order.");
      text->background("Gray65");

      // Frame to hold all of the suits
      Frame* table = new Frame(frame, "table", 
          10, 10 + 85 + 10,
          width-20, 416, Sunken);
      table->background("Gray65");

        // Create a main deck with all of the oonsoo cards in it
        MainDeck* mainDeck = new MainDeck(table, "tmpMain", 0, 0, 64, 96, 
            mySpriteCollection, (Command*)0);

        // Build a plain deck for each of the cards
        int x, y;
        x = 8;
        for(int suit = 0; suit < 12; ++suit, x=x+74)
        {
          y = 8;
          for(int t = 0; t < 4; ++t, y=y+100)
          {
            Card* card = mainDeck->remove();
            card->orientation(FaceUp);

            LinkedList<Card> cards;
            cards.append(card);

            // Create a plain deck to hold this card
            PlainDeck* plainDeck = new PlainDeck(table, "card",
                x, y, 64, 96, mySpriteCollection, &cards);
          }
        }

        // Kill the main deck
        delete mainDeck;      

      // Build ok push button
      PushButton* pushButton = new PushButton(frame, "ok",
           (width - 70) / 2, height-10-30,
           70, 30, "Ok", new HelpOkOrCloseCommand(this));
      pushButton->background("Gray65");

  // Manage the about window
  myToplevel->manage();
}

///////////////////////////////////////////////////////////////////////////////
// Destructor 
///////////////////////////////////////////////////////////////////////////////
Help::~Help()
{
  // Destroy the toplevel widget
  delete myToplevel;
}

