///////////////////////////////////////////////////////////////////////////////
//
// Card.hxx - Card class
//
//
// Bradford W. Mott
// Copyright (C) 1994
// November 3,1994
//
///////////////////////////////////////////////////////////////////////////////

#ifndef CARD_HXX
#define CARD_HXX

#include "Sprite.hxx"

// Card orientations
enum CardOrientation { FaceUp, FaceDown };


class Card {
  private:
    Sprite* myFace;
    int mySuite;
    int myPriority;
    CardOrientation myOrientation;
 
  public:
    // Constructor 
    Card(Sprite* face, int suite, int priority, CardOrientation orientation);

    // Destructor
    virtual ~Card();

    // Answer my face
    Sprite* face() const { return(myFace); }

    // Answer my suite
    int suite() const { return(mySuite); }

    // Answer my suite priority
    int priority() const { return(myPriority); }

    // Answer my orientation
    CardOrientation orientation() const { return(myOrientation); }

    // Set my orientation
    CardOrientation orientation(CardOrientation orientation)
    { myOrientation = orientation; }
};
#endif

