/*
**                      Softwarepraktikum iMaze
**                              1993/94
**                Joerg Czeranski    Hans-Ulrich Kiel
**
** Datei: gentrigtab.c
**
** Kommentar:
**  Berechnet die Sinus-, Cosinus- und Arcustangens-Tabellen
**  und schreibt sie in trigtab.c
*/


#include <stdio.h>
#include <math.h>

#include "global.h"

static char sccsid[] = "@(#)gentrigtab.c	1.5 17 May 1994";


#define N (TRIGANZ / 4)  /* N = 90 Grad */

#define M (TRIGANZ / 2)  /* M entspricht tan = 1 */

static int tab[N + 1];   /* fuer Cosinuswerte von 0 bis 90 Grad (incl.) */
static int tab2[M + 1];  /* fuer Arctustangenswerte von 0 bis 1 (incl.) */


/*
** main
**  die Hauptroutine
**
** Seiteneffekte:
**  Die Datei 'trigtab.c' wird geschrieben
*/
int main()
{
	int i;

	/* Cosinuswerte bis 90 Grad berechnen (-TRIGFAKTOR ... TRIGFAKTOR) */
	for (i = 0; i < N; i++)
	{
		tab[i] = cos(3.1415926536 / 2.0 * i / N) * TRIGFAKTOR;
	}
	tab[N] = 0;  /* 90 Grad */

	/* Arcustangenswerte von 0 bis 1 mittels Sinus/Cosinus-Tabelle
	   berechnen (0 ... TRIGANZ/8) */
	{
		int winkel;
		int j, k; /* Tangens von winkel - 1 und winkel */

		j = -1;
		for (winkel = 1; winkel <= N / 2; winkel++)
		{
			k = (M * tab[N - winkel] + tab[winkel] / 2) / tab[winkel];
			for (i = j + 1; i <= k; i++)
				tab2[i] = i <= (j + k) / 2 ? winkel - 1 : winkel;
			j = k;
		}
	}

	/* Dateikopf schreiben */
	puts("/*");
	puts("** iMaze: Sinus-, Cosinus- und Arcustangens-Tabelle");
	puts("** Diese Datei wird automatisch erstellt!");
	puts("*/");
	putchar('\n');
	puts("#include \"global.h\"");
	putchar('\n');
	printf("static char sccsid[] = \"%s\";\n\n", sccsid);

	/* Cosinus-Tabelle ausgeben */
	puts("int costab[TRIGANZ] =");
	putchar('{');
	for (i = 0; i < TRIGANZ; i++)
	{
		/* 8 Werte pro Zeile */
		if (i % 8)
			putchar(' ');
		else
			putchar('\n'), putchar('\t');

		printf("%d,", i < N ? tab[i] : i < 2 * N ? -tab[2 * N - i] :
			i < 3 * N ? -tab[i - 2 * N] : tab[4 * N - i]);
	}
	putchar('\n');
	puts("};");
	putchar('\n');

	/* Sinus-Tabelle ausgeben */
	puts("int sintab[TRIGANZ] =");
	putchar('{');
	for (i = 0; i < TRIGANZ; i++)
	{
		/* 8 Werte pro Zeile */
		if (i % 8)
			putchar(' ');
		else
			putchar('\n'), putchar('\t');

		printf("%d,", i < N ? tab[N - i] : i < 2 * N ? tab[i - N] :
			i < 3 * N ? -tab[3 * N - i] : -tab[i - 3 * N]);
	}
	putchar('\n');
	puts("};");
	putchar('\n');

	/* Arcustangens-Tabelle ausgeben */
	puts("int atantab[TRIGANZ + 1] =");
	putchar('{');
	for (i = 0; i <= TRIGANZ; i++)
	{
		/* 8 Werte pro Zeile */
		if (i % 8)
			putchar(' ');
		else
			putchar('\n'), putchar('\t');

		printf("%d,", i < M ?
			(TRIGANZ - tab2[M - i]) % TRIGANZ : tab2[i - M]);
	}
	putchar('\n');
	puts("};");
	return 0;
}
