/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 1993, 1994, Elan Feingold (feingold@zko.dec.com)           *
 *                                                                           *
 *     PERMISSION TO USE, COPY, MODIFY, AND TO DISTRIBUTE THIS SOFTWARE      *
 *     AND ITS DOCUMENTATION FOR ANY PURPOSE IS HEREBY GRANTED WITHOUT       *
 *     FEE, PROVIDED THAT THE ABOVE COPYRIGHT NOTICE APPEAR IN ALL           *
 *     COPIES AND MODIFIED COPIES AND THAT BOTH THAT COPYRIGHT NOTICE AND    *
 *     THIS PERMISSION NOTICE APPEAR IN SUPPORTING DOCUMENTATION.  THERE     *
 *     IS NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR      *
 *     ANY PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS       *
 *     OR IMPLIED WARRANTY.                                                  *
 *                                                                           *
 *****************************************************************************/

#include <X11/X.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include "colormap.h"
#include "riskgame.h"
#include "gui.h"

unsigned long   plCountryToColor[MAX_COLORS];
Int             piColorToCountry[MAX_COLORS];
Colormap        cmapColormap;
Color           pWorldColors[MAX_COLORS];
Int             iNumColors;


/************************************************************************ 
 *  FUNCTION: COLOR_
 *  HISTORY: 
 *     05.12.94  ESF  Created.
 *  PURPOSE: 
 *  NOTES: 
 ************************************************************************/
void COLOR_SetWorldColormap(Color *cmap)
{
  memcpy(pWorldColors, cmap, sizeof(Color)*iNumColors);
}


/************************************************************************ 
 *  FUNCTION: COLOR_
 *  HISTORY: 
 *     05.12.94  ESF  Created.
 *  PURPOSE: 
 *  NOTES: 
 ************************************************************************/
void COLOR_SetWorldColors(void)
{
  XColor   xColor;
  Int      i;

  /* Now read in the colormap, store it, and setup the screen */
  for (i=0; i!=iNumColors; i++)
    {
      xColor.flags = DoRed | DoGreen | DoBlue;
      xColor.pixel = COLOR_CountryToColor(i);
      xColor.red   = pWorldColors[i].r << 8;
      xColor.green = pWorldColors[i].g << 8;
      xColor.blue  = pWorldColors[i].b << 8;
      XStoreColor(hDisplay, cmapColormap, &xColor);
    }
  XFlush(hDisplay);
}


/************************************************************************ 
 *  FUNCTION: COLOR_DieToColor 
 *  HISTORY: 
 *     03.04.94  ESF  Created.
 *     03.05.94  ESF  Fixed bug, wrong offset.
 *  PURPOSE: 
 *  NOTES: 
 ************************************************************************/
Int COLOR_DieToColor(Int iDie)
{
  return (COLOR_CountryToColor(0)+iNumColors+MAX_PLAYERS+iDie);
}


/************************************************************************ 
 *  FUNCTION: COLOR_ColorCountry
 *  HISTORY: 
 *     02.05.94  ESF  Created.
 *     02.05.94  ESF  Factored out color changing code.
 *  PURPOSE: 
 *  NOTES: 
 ************************************************************************/
void COLOR_ColorCountry(Int iCountry, Int iPlayer)
{
  COLOR_CopyColor(COLOR_PlayerToColor(iPlayer), 
		  COLOR_CountryToColor(iCountry));
}


/************************************************************************ 
 *  FUNCTION: 
 *  HISTORY: 
 *     02.05.94  ESF  Created.
 *     05.05.94  ESF  Fixed for new colormap scheme.
 *  PURPOSE: 
 *  NOTES: 
 ************************************************************************/
Int COLOR_ColorToCountry(Int iColor)
{
  return(piColorToCountry[iColor]);
}


/************************************************************************ 
 *  FUNCTION: 
 *  HISTORY: 
 *     02.05.94  ESF  Created.
 *     05.05.94  ESF  Fixed for new colormap scheme.
 *  PURPOSE: 
 *  NOTES: 
 ************************************************************************/
Int COLOR_CountryToColor(Int iCountry)
{
  return(plCountryToColor[iCountry]);
}


/************************************************************************ 
 *  FUNCTION: 
 *  HISTORY: 
 *     02.05.94  ESF  Created.
 *  PURPOSE: 
 *  NOTES: 
 ************************************************************************/
Int COLOR_PlayerToColor(Int iPlayer)
{
  return (RISK_GetColorIndexOfPlayer(iPlayer));
}


/************************************************************************ 
 *  FUNCTION: COLOR_CopyColor
 *  HISTORY: 
 *     02.05.94  ESF  Created.
 *  PURPOSE: 
 *  NOTES: 
 ************************************************************************/
void COLOR_CopyColor(Int iSrc, Int iDst)
{
  XColor  xColor;
  
  xColor.flags = DoRed | DoGreen | DoBlue;
  xColor.pixel = iSrc;
  XQueryColor(hDisplay, cmapColormap, &xColor);
  xColor.pixel = iDst;
  XStoreColor(hDisplay, cmapColormap, &xColor);
  
  XFlush(hDisplay);
}


/************************************************************************ 
 *  FUNCTION: COLOR_StorePlayerColor
 *  HISTORY: 
 *     05.03.94  ESF  Created.
 *  PURPOSE: 
 *  NOTES: 
 ************************************************************************/
void COLOR_StoreNamedColor(String strPlayerColor, Int iPlayer) 
{
  XStoreNamedColor(hDisplay, cmapColormap, strPlayerColor,  
		   RISK_GetColorIndexOfPlayer(iPlayer), 
		   DoRed | DoGreen | DoBlue);
}








