#include "net.h"
#include "debug.h"
#include "display.h"

class Graphics;

Graphics *screen;
int numPlayers;
char *myName;
char *serverName; // only used in windows

#ifdef FOR_X11

#include "X11Screen.h"
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

main(int argc, char **argv)
{
  extern int distanceBetweenConts, contChunkSize;
  extern int numberOfChunksPerCont;
  numPlayers = 0;
  myName = NULL;
  opterr = 0;
  int opt;
  while ((opt = getopt(argc, argv, "d:w:")) != -1) {
    if (opt == 'd') debugFlags = optarg;
    if (opt == 'w') {
      distanceBetweenConts = atoi(optarg);
      contChunkSize = atoi(argv[optind++]);
      numberOfChunksPerCont = atoi(argv[optind++]);
      printf("dist %d, chunk size %d, number of chunks %d\n",
	     distanceBetweenConts,
	     contChunkSize, numberOfChunksPerCont);
    }
  }

  screen = new X11Screen(argc, argv, HandleKey);

  return screen->MainLoop();
}

#else

#include <fcntl.h>
#include <stdlib.h>
#include "WScreen.h"
#include "server.h"
#include "defs.h"

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdLine,
  int nCmdShow)
{
  _fmode = O_BINARY;
  // registers class, displays civ window, asks for default server,
  // player name and num players
  screen = new WScreen(HandleKey, hInstance, hPrevInstance, nCmdShow);
  CivInit(savedGame ? RestoreSaveFile : StartNewGame, serverName);
  return screen->MainLoop();
}

#endif
