#ifndef _X11_SCREEN
#define _X11_SCREEN

#include "graph.h"

#include <X11/Xlib.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/font.h>
#include <X11/xpm.h>

class MsgQ;

class X11Screen : public Graphics
{
public:
  X11Screen(int argc, char **argv, void (*key)(int, int, int, char *));
  virtual~ X11Screen();

  int AllocColor(char *name);

  void Refresh();

  void DisplayMessage(char *str, int color);

  void WriteStr(int x, int y, char *str, int color);
  void WriteChar(int x, int y, int ch, int color);

  void Clear();

  void FillRect(int x, int y, int width, int ht, int col);

  void Rect(int x, int y, int width, int ht, int col);

  void BitBlt(int sx, int sy, int w, int h, int dx, int dy);

  long CompilePixmap(char **pixmap);

  void FreePixmap(long handle);

  void DrawPixmap(int xc, int yc, long handle);

  void GetPixmapInfo(long handle, int &w, int &h);

  void StartTimer(int which, int milli, HandlerFunc func);
  void StopTimer(int which);

  int MainLoop();

  void AddReadNotify(int fd, void (*func)(MsgQ *, int, int), int info = 0,
		     int q = 1);

  void CreateChoiceFrame(char *mesg, List<charp> choices);

  void MessageBox(char *mesg);

private:
  struct PixmapInfo {
    Pixmap pixmap;
    Pixmap mask;
    int w, h;
  };

  Display *dpy;
  GC gc;
  Window mapWin;
  Panel_item accept;
  Panel_item mesg;
  Colormap colormap;
};

#endif
