/*
**  wt -- a 3d game engine
**
**  Copyright (C) 1994 by Chris Laurel
**  email:  claurel@mr.net
**  snail mail:  Chris Laurel, 5700 W Lake St #208,  St. Louis Park, MN  55416
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdlib.h>
#include <string.h>
#include <tcl/tcl.h>
#include "wt.h"
#include "error.h"
#include "wtmem.h"
#include "list.h"
#define TCLUPDATE_C_
#include "tclupdate.h"


Updater *updater_create(Tcl_Interp *interp)
{
     Updater *u;

     u = wtmalloc(sizeof(Updater));
     u->event_list = new_list();
     u->event_num = 1;
     u->interp = interp;

     return u;
}


int updater_add_event(Updater *u, char *event)
{
     Update_event *new_event;

     new_event = wtmalloc(sizeof(Update_event));
     new_event->event_number = u->event_num++;
     new_event->tclproc = wtmalloc(strlen(event) + 1);
     strcpy(new_event->tclproc, event);
     add_node(u->event_list, new_event);
     
     return new_event->event_number;
}


void updater_run(Updater *u)
{
     List *l;

     for (l = u->event_list; l->next != NULL; l = l->next) {
	  if (Tcl_Eval(u->interp,
		       ((Update_event *) l->next->node)->tclproc) != TCL_OK)
	       fatal_error("Tcl error in update: %s\n", u->interp->result);
     }
}


void updater_close(Updater *u)
{
     /* memory leak here -- don't forget! */
     delete_list(u->event_list);
     wtfree(u);
}



