#ifndef __RAWKS_DEFINES__
#define __RAWKS_DEFINES__

#define INIT_SPEED		100.0
#define GIVEN_LIVES		5 /* Number of lives for first level of miss */
#define DEAD_TIME		400.0
#define START_SND_QUEUESIZE	8
#define SHIP1_SIZE		5
#define SHIP1_T_SIZE		3
#define MAX_PLAYERS		4
#define MAX_SCORENAME		12
#define BULLETARRAYSIZE		(10 * MAX_PLAYERS)
#define STUFFARRAYSIZE		4096
#define INC_BULLET(i) ( (i) >= (BULLETARRAYSIZE - 1) ) ? (0) : ( (i) + 1 )
#define INC_STUFF(i)  ( (i) >= (STUFFARRAYSIZE  - 1) ) ? (0) : ( (i) + 1 )

#if DBG 
#define DEBUG(x) { printf("%s\n",x);fflush(stdout); }
#else
#define DEBUG(x)
#endif

#ifndef ABS
#define ABS(x) (((x)>=0)?(x):(-(x)))
#endif
#ifndef MAX
#define MAX(x,y) (((x)>(y))?(x):(y))
#endif
#ifndef MIN
#define MIN(x,y) (((x)<(y))?(x):(y))
#endif

#define _BSD_SIGNALS /* For signal.h */

#define SFX_ONCE		0
#define SFX_REPEAT		1

#define NUM_EXPL_SFX		3 /* EXPL_[123..] must be sequential */

enum sound_fx {
SFX_NONE=0,
SFX_EXPL_1,
SFX_EXPL_2,
SFX_EXPL_3,
SFX_1,
SFX_2,
SFX_3,
SFX_4,
SFX_ALIVE,
SFX_FIRE,
SFX_BELL,
SFX_CONGRAT,
SFX_GAME_OVER,
SFX_SAD,
SFX_THRUST,
SFX_MYSTIC,
SFX_INTRO,
SFX_LAUGH,
SFX_N_SOUNDS
};

#define OLAY_TEXT		1
#define OLAY_IMAGE		2
#define OLAY_SOUND		4
#define OLAY_CLEAR		8
#define OLAY_SCORES		16
#define OLAY_HIGHSCORES		32

#define SFX_PRI_BACKGROUND	3
#define SFX_PRI_ROCK		0
#define SFX_PRI_THRUST		1
#define SFX_PRI_FIRE		1

#define SCORE_WIDTH		0 /* used to be (Sizex-Sizey) */

#define VERTEX_NODRAW		1
#define VERTEX_HARMLESS		2
#define VERTEX_BULLETPROOF	4

#define WIN_DBUFF		1
#define WIN_SBUFF		2

#define C_BLACK		cpack(0)
#define C_RED		cpack(0xff)
#define C_GREEN		cpack(0xff00)
#define C_YELLOW	cpack(0xffff)
#define C_BLUE		cpack(0xff0000)
#define C_MAGENTA	cpack(0xff00ff)
#define C_CYAN		cpack(0xffff00)
#define C_WHITE		cpack(0xffffff)
/*---------------------------------------------------------------------------*/
#endif
