/* $Id: main.c,v 30000.23 1993/05/25 00:57:58 kkeys Exp $ */
/******************************************************************
 * Copyright 1993 by Ken Keys.
 * Permission is granted to obtain and redistribute this code freely.
 * All redistributions must contain this header.  You may modify this
 * software, but any redistributions of modified code must be clearly
 * marked as having been modified.
 ******************************************************************/


/***********************************************
 * Fugue main routine                          *
 *                                             *
 * Initializes many internal global variables, *
 * determines initial world (if any), reads    *
 * configuration file, and calls main loop in  *
 * socket.c                                    *
 ***********************************************/

#include <ctype.h>
#include "port.h"
#include "dstring.h"
#include "tf.h"
#include "util.h"
#include "history.h"
#include "world.h"
#include "socket.h"
#include "macro.h"
#include "output.h"
#include "signal.h"
#include "keyboard.h"
#include "command1.h"
#include "command2.h"
#include "expand.h"

char version[] = "TinyFugue version 3.0 alpha 21";

int configured = FALSE;

int FDECL(main,(int argc, char **argv));

static void FDECL(read_configuration,(char *fname));
static void FDECL(boot_world,(int argc, char *argv[], int autologin));

int main(argc, argv)
    int argc;
    char *argv[];
{
    char *opt, *argv0 = argv[0], *configfile = NULL;
    int opterror = FALSE;
    int worldflag = TRUE;
    int autologin = TRUE;

    while (--argc > 0 && (*++argv)[0] == '-') {
        for (opt = *argv + 1; *opt; )
            switch (*opt++) {
            case 'l':
                autologin = FALSE;
                break;
            case 'n':
                worldflag = FALSE;
                break;
            case 'f':
                if (configfile) FREE(configfile);
                configfile = STRDUP(opt);
                while (*opt) opt++;
                break;
            default:
                opterror = TRUE;
                break;
            }
    }
    if (opterror || argc > 2) {
        char usage[256];
        sprintf(usage,
            "Usage: %s %s [-ln] [<world>]\n       %s %s <host> <port>\n",
            argv0, "[-f<file>]", argv0, "[-f<file>]");
        die(usage);
    }

    SRANDOM(getpid());                       /* seed random generator */
    init_sock();                             /* socket.c   */
    init_table();                            /* util.c     */
    init_signals();                          /* signal.c   */
    init_variables();                        /* variable.c */
    init_expand();                           /* expand.c   */
    init_macros();                           /* macro.c    */
    init_histories();                        /* history.c  */
    init_prefixes();                         /* command2.c */
    init_term();                             /* output.c   */
    init_keyboard();                         /* keyboard.c */
    init_values();                           /* variable.c */

    oprintf("Welcome to %s", version);
    oputs("Type \"/help\" for help.");
    read_configuration(configfile);
    if (worldflag) boot_world(argc, argv, autologin);
    main_loop();
    return 0;
}

static void boot_world(argc, argv, autologin)
    register int argc;
    register char *argv[];
    int autologin;
{
    World *world;

    if (argc == 0)
        world = get_world_header();
    else if (argc == 1) {
        if ((world = find_world(argv[0])) == NULL)
            tfprintf(tferr, "%% The world %s is unknown.",argv[0]);
    } else { /* (argc <= 2) guaranteed by main() */
#ifdef RESTRICT_WORLD
        tfputs("% Connecting to undefined worlds is restricted.", tferr);
#else
        world = new_world(NULL, "", "", argv[0], argv[1], "");
        world->flags |= WORLD_TEMP;
#endif
    }
    if (world) connect_to(world, autologin);
}

static void read_configuration(fname)
    char *fname;
{
    Stringp filename;
    TFILE *file;

    do_file_load(TFLIBRARY);
    configured = TRUE;

    if (fname) {
        if (*fname) do_file_load(fname);
        return;
    }

    do_file_load(PRIVATEINIT);

    if (!(fname = getvar("TINYTALK"))) fname = CONFIGFILE;
    expand_filename(Stringcpy(Stringinit(filename), fname));
    if ((file = tfopen(filename->s, "r"))) {
        do_hook(H_LOAD, "%% Loading commands from %S.", "%S", filename);
        read_file_commands(file, TRUE);
        tfclose(file);
    }
    Stringfree(filename);
}

